/***************************************************************************
 *   Copyright (C) 2008 by normal   *
 *   normal@Desktop2   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "Core.h"
#include "FileTransferRecive.h"



cFileTransferRecive::cFileTransferRecive(cCore * Core, qint32 StreamID, QString FileName, quint64 FileSize,QString Destination)
:StreamID(StreamID),FileName(FileName),FileSize(FileSize),Destination(Destination)
{
	this->Core=Core;
	allreadyRecivedSize=0;
	haveAllreadyAWindow=false;
	RequestAccepted=false;

	Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem(" Incoming Filetransfer<br>Filename: "+FileName+
				"<br>please accept or  don't accepted it (you can do it at the Userlist)");
}

cFileTransferRecive::~ cFileTransferRecive()
{
	delete FileForRecive;
}

void cFileTransferRecive::StreamStatus(const SAM_Message_Types::RESULT result, const qint32 ID, QString Message)
{
	if(result==SAM_Message_Types::OK){
		
	}
	else{
		FileForRecive->close();
		FileForRecive->remove();
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem(" FileRecive Error(connection Broke)<br>FileName: "+FileName+"<br>incomplead File deleted");
		
		emit event_FileReciveError();
	}

}

void cFileTransferRecive::StreamClosed(const SAM_Message_Types::RESULT result, qint32 ID, QString Message)
{
	if(allreadyRecivedSize==FileSize){
		QString SizeName;
		QString SSize;

		FileForRecive->close();	

		if(FileSize>=(1024*1024)){
		//MB
			QString MB;
			QString KB;
	
			qint32 tmp= FileSize/(1024*1024);
			qint32 tmp2=FileSize-(tmp*(1024*1024));
			tmp2 =qRound(tmp2/1024);
			
			MB.setNum(tmp,10);
			KB.setNum(tmp2,10);
			
			SSize=MB+"."+KB;
			SizeName="MB";
		}
		else if(FileSize>=1024){
		//KB
			QString KB;
			QString Bytes;
	
			qint32 tmp= FileSize/(1024);
			qint32 tmp2=FileSize-(tmp*(1024));
			tmp2 =qRound(tmp2/1024);
	
			KB.setNum(tmp,10);
			Bytes.setNum(tmp2,10);
	
			SSize=KB+"."+Bytes;
			SizeName="KB";
		}
		else{
		//Byte
			SSize.setNum(FileSize,10);
			SizeName="Bytes";
	
		}
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem(" Filetransfer finished (OK)<br>Filename: "+FileName+"<br>Filesize: "+SSize+" "+SizeName);

		emit event_FileRecivedFinishedOK();
	}
	else{
		FileForRecive->close();
		FileForRecive->remove();
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem(" The Sender abort the Filetransfer<br>FileName: "+FileName +"<br>incomplead File deleted");

		emit event_FileReciveAbort();
	}	
}

void cFileTransferRecive::operator <<(QByteArray t)
{

	allreadyRecivedSize+=t.length();
	FileForRecive->write(t);
	FileForRecive->flush();

	emit event_allreadyRecivedSizeChanged(allreadyRecivedSize);

	if(allreadyRecivedSize==FileSize)
	{
		Core->StreamClose(StreamID);
		FileForRecive->close();
		emit event_FileRecivedFinishedOK();	
		QString SizeName;
		QString SSize;

		FileForRecive->close();	

		if(FileSize>=(1024*1024)){
		//MB
			QString MB;
			QString KB;
	
			qint32 tmp= FileSize/(1024*1024);
			qint32 tmp2=FileSize-(tmp*(1024*1024));
			tmp2 =qRound(tmp2/1024);
			
			MB.setNum(tmp,10);
			KB.setNum(tmp2,10);
			
			SSize=MB+"."+KB;
			SizeName="MB";
		}
		else if(FileSize>=1024){
		//KB
			QString KB;
			QString Bytes;
	
			qint32 tmp= FileSize/(1024);
			qint32 tmp2=FileSize-(tmp*(1024));
			tmp2 =qRound(tmp2/1024);
	
			KB.setNum(tmp,10);
			Bytes.setNum(tmp2,10);
	
			SSize=KB+"."+Bytes;
			SizeName="KB";
		}
		else{
		//Byte
			SSize.setNum(FileSize,10);
			SizeName="Bytes";
	
		}
		Core->get_UserByI2P_Destination(Destination)->
			IncomingMessageFromSystem("<br>Filetransfer finished (OK)<br>Filename: "+FileName+"<br>Filesize: "+SSize+" "+SizeName);

	}
}

void cFileTransferRecive::abbortFileRecive()
{
	FileForRecive->close();
	FileForRecive->remove();

	Core->StreamClose(StreamID);
	
}

void cFileTransferRecive::start(QString FilePath,bool Accepted)
{	
	if(Accepted==true){	
		FileForRecive= new QFile(FilePath);
		FileForRecive->open(QIODevice::WriteOnly);

		Core->StreamSendData(StreamID,QString("0"));//true
		RequestAccepted=true;
	}
	else{
		Core->StreamSendData(StreamID,QString("1"));//false
		Core->StreamClose(StreamID);
		RequestAccepted=false;
	}
}

void cFileTransferRecive::start_withAutoAccept(QString Path)
{
	
	QString SFileSize;
	SFileSize.setNum(FileSize);

		QString FilePath=Path+="/"+FileName;

		if(!FilePath.isEmpty()){
			FileForRecive= new QFile(FilePath);
			FileForRecive->open(QIODevice::WriteOnly);
			Core->StreamSendData(StreamID,QString("0"));//true
		}
}


