/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;

public class TunnelId
extends DataStructureImpl {
    private long _tunnelId;
    public static final long MAX_ID_VALUE = 0xFFFFFFFEL;

    public TunnelId() {
        this._tunnelId = -1L;
    }

    public TunnelId(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("wtf, tunnelId " + id);
        }
        this._tunnelId = id;
    }

    public long getTunnelId() {
        return this._tunnelId;
    }

    public void setTunnelId(long id) {
        this._tunnelId = id;
        if (id <= 0L) {
            throw new IllegalArgumentException("wtf, tunnelId " + id);
        }
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        this._tunnelId = DataHelper.readLong(in, 4);
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._tunnelId < 0L) {
            throw new DataFormatException("Invalid tunnel ID: " + this._tunnelId);
        }
        DataHelper.writeLong(out, 4, this._tunnelId);
    }

    public byte[] toByteArray() {
        return DataHelper.toLong(4, this._tunnelId);
    }

    public void fromByteArray(byte[] data) throws DataFormatException {
        if (data == null) {
            throw new DataFormatException("Null data passed in");
        }
        if (data.length != 4) {
            throw new DataFormatException("Bad data length");
        }
        this._tunnelId = (int)DataHelper.fromLong(data, 0, 4);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof TunnelId)) {
            return false;
        }
        return this._tunnelId == ((TunnelId)obj)._tunnelId;
    }

    public int hashCode() {
        return (int)this._tunnelId;
    }

    public String toString() {
        return String.valueOf(this._tunnelId);
    }
}

