/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.SDSCache;
import net.i2p.data.SimpleDataStructure;

public class SigningPublicKey
extends SimpleDataStructure {
    private static final SigType DEF_TYPE = SigType.DSA_SHA1;
    public static final int KEYSIZE_BYTES = DEF_TYPE.getPubkeyLen();
    private static final int CACHE_SIZE = 1024;
    private static final SDSCache<SigningPublicKey> _cache = new SDSCache<SigningPublicKey>(SigningPublicKey.class, KEYSIZE_BYTES, 1024);
    private final SigType _type;

    public static SigningPublicKey create(byte[] data, int off) {
        return _cache.get(data, off);
    }

    public static SigningPublicKey create(InputStream in) throws IOException {
        return _cache.get(in);
    }

    public SigningPublicKey() {
        this(DEF_TYPE);
    }

    public SigningPublicKey(SigType type) {
        this._type = type;
    }

    public SigningPublicKey(byte[] data) {
        this(DEF_TYPE, data);
    }

    public SigningPublicKey(SigType type, byte[] data) {
        this._type = type;
        this.setData(data);
    }

    public SigningPublicKey(String base64Data) throws DataFormatException {
        this();
        this.fromBase64(base64Data);
    }

    public int length() {
        return this._type.getPubkeyLen();
    }

    public SigType getType() {
        return this._type;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append('[').append(this.getClass().getSimpleName()).append(' ').append((Object)this._type).append(": ");
        if (this._data == null) {
            buf.append("null");
        } else {
            buf.append("size: ").append(Integer.toString(this.length()));
        }
        buf.append(']');
        return buf.toString();
    }
}

