/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPublicKey;

public class KeysAndCert
extends DataStructureImpl {
    protected PublicKey _publicKey;
    protected SigningPublicKey _signingKey;
    protected Certificate _certificate;
    protected Hash __calculatedHash;

    public Certificate getCertificate() {
        return this._certificate;
    }

    public void setCertificate(Certificate cert) {
        if (this._certificate != null) {
            throw new IllegalStateException();
        }
        this._certificate = cert;
        this.__calculatedHash = null;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public void setPublicKey(PublicKey key) {
        if (this._publicKey != null) {
            throw new IllegalStateException();
        }
        this._publicKey = key;
        this.__calculatedHash = null;
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    public void setSigningPublicKey(SigningPublicKey key) {
        if (this._signingKey != null) {
            throw new IllegalStateException();
        }
        this._signingKey = key;
        this.__calculatedHash = null;
    }

    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._publicKey != null || this._signingKey != null || this._certificate != null) {
            throw new IllegalStateException();
        }
        this._publicKey = PublicKey.create(in);
        this._signingKey = SigningPublicKey.create(in);
        this._certificate = Certificate.create(in);
        this.__calculatedHash = null;
    }

    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._certificate == null || this._publicKey == null || this._signingKey == null) {
            throw new DataFormatException("Not enough data to format the router identity");
        }
        this._publicKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        this._certificate.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof KeysAndCert)) {
            return false;
        }
        KeysAndCert ident = (KeysAndCert)object;
        return DataHelper.eq(this._signingKey, ident._signingKey) && DataHelper.eq(this._publicKey, ident._publicKey) && DataHelper.eq(this._certificate, ident._certificate);
    }

    public int hashCode() {
        if (this._publicKey == null) {
            return 0;
        }
        return this._publicKey.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append('[').append(this.getClass().getSimpleName()).append(": ");
        buf.append("\n\tHash: ").append(this.getHash().toBase64());
        buf.append("\n\tCertificate: ").append(this._certificate);
        buf.append("\n\tPublicKey: ").append(this._publicKey);
        buf.append("\n\tSigningPublicKey: ").append(this._signingKey);
        buf.append(']');
        return buf.toString();
    }

    public Hash calculateHash() {
        return this.getHash();
    }

    public Hash getHash() {
        byte[] identBytes;
        if (this.__calculatedHash != null) {
            return this.__calculatedHash;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeBytes(baos);
            identBytes = baos.toByteArray();
        }
        catch (Throwable t) {
            return null;
        }
        this.__calculatedHash = SHA256Generator.getInstance().calculateHash(identBytes);
        return this.__calculatedHash;
    }
}

