/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import net.i2p.crypto.DSAEngine;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Hash;
import net.i2p.data.KeysAndCert;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

public abstract class DatabaseEntry
extends DataStructureImpl {
    public static final int KEY_TYPE_ROUTERINFO = 0;
    public static final int KEY_TYPE_LEASESET = 1;
    protected volatile Signature _signature;
    protected volatile Hash _currentRoutingKey;
    protected volatile byte[] _routingKeyGenMod;

    public abstract long getDate();

    protected abstract KeysAndCert getKeysAndCert();

    public Hash getHash() {
        KeysAndCert kac = this.getKeysAndCert();
        if (kac == null) {
            return null;
        }
        return kac.getHash();
    }

    public abstract int getType();

    protected abstract byte[] getBytes() throws DataFormatException;

    public Hash getRoutingKey() {
        RoutingKeyGenerator gen = RoutingKeyGenerator.getInstance();
        if (gen.getModData() == null || this._routingKeyGenMod == null || !DataHelper.eq(gen.getModData(), this._routingKeyGenMod)) {
            this._currentRoutingKey = gen.getRoutingKey(this.getHash());
            this._routingKeyGenMod = gen.getModData();
        }
        return this._currentRoutingKey;
    }

    public void setRoutingKey(Hash key) {
        this._currentRoutingKey = key;
    }

    public boolean validateRoutingKey() {
        Hash destKey = this.getHash();
        Hash rk = RoutingKeyGenerator.getInstance().getRoutingKey(destKey);
        return rk.equals(this.getRoutingKey());
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature signature) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._signature = signature;
    }

    public void sign(SigningPrivateKey key) throws DataFormatException {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            throw new DataFormatException("Not enough data to sign");
        }
        this._signature = DSAEngine.getInstance().sign(bytes, key);
    }

    protected SigningPublicKey getSigningPublicKey() {
        KeysAndCert kac = this.getKeysAndCert();
        if (kac == null) {
            return null;
        }
        return kac.getSigningPublicKey();
    }

    protected boolean verifySignature() {
        byte[] data;
        if (this._signature == null) {
            return false;
        }
        try {
            data = this.getBytes();
        }
        catch (DataFormatException dfe) {
            return false;
        }
        if (data == null) {
            return false;
        }
        return DSAEngine.getInstance().verifySignature(this._signature, data, this.getSigningPublicKey());
    }
}

