/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.DummyNamingService;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.data.Destination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaNamingService
extends DummyNamingService {
    private static final String PROP_NAME_SERVICES = "i2p.nameservicelist";
    private static final String DEFAULT_NAME_SERVICES = "net.i2p.client.naming.HostsTxtNamingService";
    protected final List<NamingService> _services;

    public MetaNamingService(I2PAppContext context) {
        super(context);
        String list = this._context.getProperty(PROP_NAME_SERVICES, DEFAULT_NAME_SERVICES);
        StringTokenizer tok = new StringTokenizer(list, ",");
        this._services = new CopyOnWriteArrayList<NamingService>();
        while (tok.hasMoreTokens()) {
            try {
                Class<?> cls = Class.forName(tok.nextToken());
                Constructor<?> con = cls.getConstructor(I2PAppContext.class);
                this.addNamingService((NamingService)con.newInstance(context), false);
            }
            catch (Exception ex) {}
        }
    }

    public MetaNamingService(I2PAppContext context, List<NamingService> services) {
        super(context);
        this._services = new CopyOnWriteArrayList<NamingService>();
        if (services != null) {
            for (NamingService ns : services) {
                this.addNamingService(ns, false);
            }
        }
    }

    @Override
    public boolean addNamingService(NamingService ns, boolean head) {
        if (head) {
            this._services.add(0, ns);
        } else {
            this._services.add(ns);
        }
        return true;
    }

    @Override
    public List<NamingService> getNamingServices() {
        return Collections.unmodifiableList(this._services);
    }

    @Override
    public boolean removeNamingService(NamingService ns) {
        return this._services.remove(ns);
    }

    @Override
    public void registerListener(NamingServiceListener nsl) {
        for (NamingService ns : this._services) {
            ns.registerListener(nsl);
        }
    }

    @Override
    public void unregisterListener(NamingServiceListener nsl) {
        for (NamingService ns : this._services) {
            ns.unregisterListener(nsl);
        }
    }

    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        Destination d = super.lookup(hostname, null, null);
        if (d != null) {
            return d;
        }
        if (hostname.length() == 60 && hostname.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
            return null;
        }
        for (NamingService ns : this._services) {
            d = ns.lookup(hostname, lookupOptions, storedOptions);
            if (d == null) continue;
            MetaNamingService.putCache(hostname, d);
            return d;
        }
        return null;
    }

    @Override
    public String reverseLookup(Destination dest, Properties options) {
        for (NamingService ns : this._services) {
            String host = ns.reverseLookup(dest, options);
            if (host == null) continue;
            return host;
        }
        return null;
    }

    @Override
    public boolean put(String hostname, Destination d, Properties options) {
        if (this._services.isEmpty()) {
            return false;
        }
        boolean rv = this._services.get(this._services.size() - 1).put(hostname, d, options);
        if (rv) {
            MetaNamingService.putCache(hostname, d);
        }
        return rv;
    }

    @Override
    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        if (this._services.isEmpty()) {
            return false;
        }
        boolean rv = this._services.get(this._services.size() - 1).putIfAbsent(hostname, d, options);
        if (rv) {
            MetaNamingService.putCache(hostname, d);
        }
        return rv;
    }

    @Override
    public boolean remove(String hostname, Properties options) {
        boolean rv = false;
        for (NamingService ns : this._services) {
            if (!ns.remove(hostname, options)) continue;
            rv = true;
        }
        if (rv) {
            MetaNamingService.removeCache(hostname);
        }
        return rv;
    }

    @Override
    public Map<String, Destination> getEntries(Properties options) {
        HashMap<String, Destination> rv = new HashMap<String, Destination>();
        for (NamingService ns : this._services) {
            rv.putAll(ns.getEntries(options));
        }
        return rv;
    }

    @Override
    public Set<String> getNames(Properties options) {
        HashSet<String> rv = new HashSet<String>();
        for (NamingService ns : this._services) {
            rv.addAll(ns.getNames(options));
        }
        return rv;
    }

    @Override
    public int size(Properties options) {
        int rv = 0;
        for (NamingService ns : this._services) {
            int s = ns.size(options);
            if (s <= 0) continue;
            rv += s;
        }
        return rv;
    }

    @Override
    public void shutdown() {
        for (NamingService ns : this._services) {
            ns.shutdown();
        }
    }
}

