/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ourfilesystem.utilities.ByteCounter;
import org.ourfilesystem.utilities.FileUtils;

public abstract class FileIndex {
    private HashMap<Object, String> Index;
    private String IndexFile;
    private String DataDir;
    private FileOutputStream FOS;

    public FileIndex(String datadir, String indexfile) {
        this.DataDir = datadir;
        this.IndexFile = indexfile;
        this.loadIndex();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (FileIndex.this.FOS != null) {
                    try {
                        FileIndex.this.FOS.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private synchronized void loadIndex() {
        ByteCounter c = new ByteCounter();
        this.Index = new HashMap();
        File f = new File(this.IndexFile);
        boolean overwrite = true;
        if (f.exists()) {
            long position = 0L;
            try {
                FileInputStream fis = new FileInputStream(f);
                while (position < f.length()) {
                    Object o = this.readObject(fis);
                    String str = FileUtils.readString(fis, c);
                    if (o != null && str != null) {
                        this.Index.put(o, str);
                    }
                    position = fis.getChannel().position();
                }
                fis.close();
                overwrite = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (overwrite) {
                this.overWriteIndex();
            }
        } else {
            File p = f.getParentFile();
            if (p != null && !p.exists()) {
                p.mkdirs();
            }
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.openFile();
    }

    private synchronized void overWriteIndex() {
        try {
            ByteCounter c = new ByteCounter();
            File f = new File(this.IndexFile);
            FileOutputStream fos = new FileOutputStream(f);
            for (Map.Entry<Object, String> e : this.Index.entrySet()) {
                this.writeObject(fos, e.getKey());
                FileUtils.writeString(e.getValue(), fos, c);
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void openFile() {
        if (this.FOS != null) {
            try {
                this.FOS.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        File f = new File(this.IndexFile);
        try {
            this.FOS = new FileOutputStream(f, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void put(Object b, String s) {
        if (this.FOS == null) {
            this.openFile();
        }
        try {
            ByteCounter c = new ByteCounter();
            this.writeObject(this.FOS, b);
            FileUtils.writeString(s, this.FOS, c);
            this.FOS.flush();
            this.Index.put(b, s);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Sorry, we failed to append to the index.");
        }
    }

    private synchronized String getStr(Object b) {
        String rs = this.Index.get(b);
        return rs;
    }

    public void put(Object b, File f) {
        if (f.exists()) {
            String ps = f.getPath();
            if (ps.startsWith(this.DataDir)) {
                ps = ps.substring(this.DataDir.length());
                this.put(b, ps);
            } else {
                throw new RuntimeException("File is not under the data dir! datadir: " + this.DataDir + " File: " + f.getPath());
            }
        }
    }

    public File get(Object b) {
        File f = null;
        String str = this.getStr(b);
        if (str != null && !(f = new File(String.valueOf(this.DataDir) + File.separator + str)).exists()) {
            f = null;
            System.out.println("File does not exist! " + this.DataDir + " :: " + str);
        }
        return f;
    }

    public synchronized Set<Object> list() {
        HashSet<Object> s = new HashSet<Object>();
        s.addAll(this.Index.keySet());
        return s;
    }

    public synchronized void close() {
        if (this.FOS != null) {
            try {
                this.FOS.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.FOS = null;
        }
    }

    public synchronized int getSize() {
        return this.Index.size();
    }

    public abstract Object readObject(InputStream var1) throws IOException;

    public abstract void writeObject(OutputStream var1, Object var2) throws IOException;
}

