/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalSubscribe;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.OpenedInterface;

public class SubscriptionTableModel
extends AbstractTableModel
implements OpenedInterface {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Subscriptions;
    private String[] Columnnames = new String[]{"Group", "Peer", "Subscribed", "Peer Rank", "Status", "Date Created", "Date Received"};

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 5 || col == 6) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        DateRenderer.insertDateIntoTable(t, 5, this);
        DateRenderer.insertDateIntoTable(t, 6, this);
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Subscriptions != null) {
            return this.Subscriptions.size();
        }
        return 0;
    }

    public synchronized LocalSubscribe getSubscription(int r) {
        if (this.Subscriptions != null && r < this.Subscriptions.size()) {
            return (LocalSubscribe)this.Subscriptions.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalSubscribe ls = this.getSubscription(r);
        if (ls != null) {
            if (c == 0) {
                return ls.getNetworkName();
            }
            if (c == 1) {
                return ls.getCreator();
            }
            if (c == 2) {
                return ls.getSubscription().isSubscribe() ? "SUBSCRIBED" : "";
            }
            if (c == 3) {
                return "" + ls.getPeerRank();
            }
            if (c == 4) {
                return ls.isMarkedBad() ? "BAD" : "Ok";
            }
            if (c == 5) {
                return ls.getSubscription().getRDate();
            }
            if (c == 6) {
                return ls.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setSubscriptions(QueryResultsInterface lst) {
        if (this.Subscriptions != null) {
            this.Subscriptions.Close();
        }
        this.Subscriptions = lst;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isOpened(int row) {
        return true;
    }
}

