/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.OpenedCellRenderer;
import org.ourfilesystem.ui.OpenedInterface;
import org.ourfilesystem.ui.SubjectCellRenderer;

public class PrivateMessageTableModel
extends AbstractTableModel
implements OpenedInterface {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface PublicPosts;
    private HashSet<Integer> Opened;
    private String[] Columnnames = new String[]{"From", "Peer Rank", "To", "Subject", "Group", "Date Created", "Date Received"};

    public String getSortKey(int col) {
        if (col == 0) {
            return DataBaseLuceneIndexer.PUBLIC_POST_CREATOR_STR;
        }
        if (col == 1) {
            return DataBaseLuceneIndexer.PUBLIC_POST_PEERRANK;
        }
        if (col == 2) {
            return DataBaseLuceneIndexer.PUBLIC_POST_TOPEER_STR;
        }
        if (col == 3) {
            return DataBaseLuceneIndexer.PUBLIC_POST_SUBJECT_STR;
        }
        if (col == 4) {
            return DataBaseLuceneIndexer.PUBLIC_POST_GROUP_STR;
        }
        if (col == 5) {
            return DataBaseLuceneIndexer.PUBLIC_POST_CDATE;
        }
        if (col == 6) {
            return DataBaseLuceneIndexer.PUBLIC_POST_DATE;
        }
        return null;
    }

    public PrivateMessageTableModel() {
        this.Opened = new HashSet();
    }

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 1) {
            return Integer.class;
        }
        if (col == 5 || col == 6) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        OpenedCellRenderer.insertOpenedIntoTable(t, 0, this);
        OpenedCellRenderer.insertOpenedIntoTable(t, 1, this);
        OpenedCellRenderer.insertOpenedIntoTable(t, 2, this);
        SubjectCellRenderer.insertSubjectIntoTable(t, 3, this);
        OpenedCellRenderer.insertOpenedIntoTable(t, 4, this);
        DateRenderer.insertDateIntoTable(t, 5, this);
        DateRenderer.insertDateIntoTable(t, 6, this);
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.PublicPosts != null) {
            return this.PublicPosts.size();
        }
        return 0;
    }

    public synchronized LocalPublicPost getPrivateMessage(int r) {
        if (this.PublicPosts != null && r < this.PublicPosts.size()) {
            return (LocalPublicPost)this.PublicPosts.get(r);
        }
        return null;
    }

    public synchronized Map<String, Object> getTableFields(int r) {
        if (this.PublicPosts != null && r < this.PublicPosts.size()) {
            return this.PublicPosts.getTableFields(r);
        }
        return null;
    }

    public synchronized void setOpened(int r) {
        this.Opened.add(r);
        this.fireTableRowsUpdated(r, r);
    }

    @Override
    public Object getValueAt(int r, int c) {
        Map<String, Object> m = this.getTableFields(r);
        if (m != null) {
            if (((Boolean)m.get(DataBaseLuceneIndexer.PUBLIC_POST_OPENED)).booleanValue()) {
                this.Opened.add(r);
            }
            if (c == 0) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_CREATOR_STR);
            }
            if (c == 1) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_PEERRANK);
            }
            if (c == 2) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_TOPEER_STR);
            }
            if (c == 3) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_SUBJECT_STR);
            }
            if (c == 4) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_GROUP_STR);
            }
            if (c == 5) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_CDATE);
            }
            if (c == 6) {
                return m.get(DataBaseLuceneIndexer.PUBLIC_POST_DATE);
            }
        }
        return null;
    }

    public synchronized void setPrivateMessages(QueryResultsInterface l) {
        if (this.PublicPosts != null) {
            this.PublicPosts.Close();
        }
        this.Opened.clear();
        this.PublicPosts = l;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isOpened(int row) {
        return this.Opened.contains(row);
    }
}

