/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.OpenedInterface;

public class NetworkAuthTableModel
extends AbstractTableModel
implements OpenedInterface {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface NetworkAuths;
    private DataBaseCoreInterface CoreDB;
    private boolean Simple;
    private String[] Columnnames = new String[]{"Group", "Peer", "Authority", "Granted by", "Date Created", "Date Received"};

    public NetworkAuthTableModel(DataBaseCoreInterface db) {
        this.CoreDB = db;
    }

    @Override
    public String getColumnName(int col) {
        if (this.Simple) {
            if (col == 0) {
                return "Creator";
            }
            if (col == 1) {
                return "Your Groups";
            }
        }
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 4 || col == 5) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        DateRenderer.insertDateIntoTable(t, 4, this);
        DateRenderer.insertDateIntoTable(t, 5, this);
    }

    @Override
    public int getColumnCount() {
        if (this.Simple) {
            return 2;
        }
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.NetworkAuths != null) {
            return this.NetworkAuths.size();
        }
        return 0;
    }

    public synchronized LocalNetworkAuthorization getNetworkAuth(int r) {
        if (this.NetworkAuths != null && r < this.NetworkAuths.size()) {
            return (LocalNetworkAuthorization)this.NetworkAuths.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalNetworkAuthorization ln = this.getNetworkAuth(r);
        if (ln != null) {
            if (this.Simple) {
                if (c == 0) {
                    LocalNetwork net = this.CoreDB.getLocalNetwork(ln.getNetworkAuthorization().getNetworkId());
                    return net.getCreator();
                }
                if (c == 1) {
                    return ln.getNetworkTitle();
                }
            }
            if (c == 0) {
                return ln.getNetworkTitle();
            }
            if (c == 1) {
                return ln.getPeerNickSig();
            }
            if (c == 2) {
                int auth = ln.getNetworkAuthorization().getSignAuthority();
                if (auth == NetworkAuthorization.NOSIGN) {
                    return "Cannot sign";
                }
                if (auth == NetworkAuthorization.CANSIGN) {
                    return "Can sign";
                }
                if (auth == NetworkAuthorization.CANGIVESIGNAUTH) {
                    return "Can give signing auth";
                }
            }
            if (c == 3) {
                return ln.getSignerNickSig();
            }
            if (c == 4) {
                return ln.getNetworkAuthorization().getRDate();
            }
            if (c == 5) {
                return ln.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setNetworkAuths(QueryResultsInterface l) {
        if (this.NetworkAuths != null) {
            this.NetworkAuths.Close();
        }
        this.NetworkAuths = l;
        this.fireTableDataChanged();
    }

    public boolean isSimple() {
        return this.Simple;
    }

    public void setSimple(boolean simple) {
        this.Simple = simple;
    }

    @Override
    public boolean isOpened(int row) {
        return true;
    }
}

