/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.filehandler.FileStatusEventInterface;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.FileSizeRenderer;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.OpenedInterface;

public class FileStatusTableModel
extends AbstractTableModel
implements FileStatusEventInterface,
OpenedInterface {
    private static final long serialVersionUID = 1L;
    public static final Logger Log = Logger.getLogger(FileStatusTableModel.class.getName());
    private HashMap<File, FileStatus> StatusList;
    private List<File> Files;
    private Main Mn;
    private String[] Columnnames = new String[]{"File", "Digest", "Progress", "Pieces downloaded", "Pieces known", "Total pieces", "Size", "Priority", "Date Started"};

    public FileStatusTableModel(Main m) {
        this.Mn = m;
        this.StatusList = new HashMap();
        this.Files = new LinkedList<File>();
        List<FileStatus> fl = this.Mn.getCoreDB().getFileStatusList();
        for (FileStatus f : fl) {
            this.fireStatusEvent(f);
        }
    }

    public void insertProgressIntoTable(JTable t) {
        TableColumn col = t.getColumnModel().getColumn(2);
        col.setCellRenderer(new ProgressCellRenderer());
    }

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 2) {
            return FileStatus.class;
        }
        if (col == 3 || col == 4 || col == 5 || col == 6) {
            return Long.class;
        }
        if (col == 8) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        DateRenderer.insertDateIntoTable(t, 8, this);
        FileSizeRenderer.insertFileSizeIntoTable(t, 6, this);
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    public synchronized void removeFile(File f) {
        this.Files.remove(f);
        this.StatusList.remove(f);
        this.Mn.getFileHandler().removeFile(f);
        this.fireTableDataChanged();
    }

    public synchronized void removeStatus(File f) {
        this.Files.remove(f);
        this.StatusList.remove(f);
        this.Mn.getFileHandler().clearFileStatus(f);
        this.fireTableDataChanged();
    }

    @Override
    public synchronized int getRowCount() {
        return this.Files.size();
    }

    public synchronized FileStatus getFileStatus(int r) {
        if (r < this.Files.size()) {
            File f = this.Files.get(r);
            return this.StatusList.get(f);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        FileStatus s = this.getFileStatus(r);
        if (s != null) {
            if (c == 0) {
                return s.getFile().getPath();
            }
            if (c == 1) {
                return s.getCompleteDigest().toString().substring(0, 10);
            }
            if (c == 2) {
                return s;
            }
            if (c == 3) {
                return s.getNumberPartsPresent();
            }
            if (c == 4) {
                return s.getPiecePostsFound();
            }
            if (c == 5) {
                return s.getNumberParts();
            }
            if (c == 6) {
                return s.getTotalFileSize();
            }
            if (c == 7) {
                return Long.toString(s.getPriority());
            }
            if (c == 8) {
                return s.getRequestDate();
            }
        }
        return null;
    }

    private int findCurrentIndex(File fs) {
        int idx = this.Files.indexOf(fs);
        if (idx != -1) {
            return idx;
        }
        return -1;
    }

    private synchronized void handleStatusEvent(FileStatus fs) {
        this.StatusList.put(fs.getFile(), fs);
        int oldidx = this.findCurrentIndex(fs.getFile());
        int oldsize = this.getRowCount();
        if (!this.Files.contains(fs.getFile())) {
            this.Files.add(fs.getFile());
        }
        int newidx = this.findCurrentIndex(fs.getFile());
        int newsize = this.getRowCount();
        if (oldidx == newidx && oldsize == newsize) {
            if (newidx < newsize) {
                this.fireTableRowsUpdated(newidx, newidx);
            }
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    public synchronized void fireStatusEvent(FileStatus nfs) {
        final FileStatus fs = nfs;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileStatusTableModel.this.handleStatusEvent(fs);
            }
        });
    }

    public synchronized void removeCompleted() {
        Iterator<File> i = this.Files.iterator();
        while (i.hasNext()) {
            File f = i.next();
            FileStatus fs = this.StatusList.get(f);
            if (fs == null || fs.getNumberParts() > fs.getNumberPartsPresent()) continue;
            this.StatusList.remove(f);
            i.remove();
        }
        this.fireTableDataChanged();
    }

    @Override
    public boolean isOpened(int row) {
        return true;
    }

    public class ProgressCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            if (arg1 instanceof FileStatus) {
                FileStatus dl = (FileStatus)arg1;
                Log.info("File status: " + dl.getNumberPartsPresent() + " / " + dl.getNumberParts());
                if (dl.getNumberParts() == 0L) {
                    this.setIndeterminate(true);
                } else {
                    int tot = (int)Math.min(dl.getNumberParts(), Integer.MAX_VALUE);
                    int prg = (int)Math.min(dl.getNumberPartsPresent(), Integer.MAX_VALUE);
                    this.setMaximum(tot);
                    this.setValue(Math.min(prg, tot));
                    this.setIndeterminate(false);
                }
                return this;
            }
            return null;
        }
    }
}

