/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.EventQueue;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.ui.FileSizeRenderer;
import org.ourfilesystem.ui.OpenedInterface;

public class ConnectionTableModel
extends AbstractTableModel
implements EventInterface,
OpenedInterface {
    private static final long serialVersionUID = 1L;
    private List<ConnectionUpdateInterface> ConnectionList;
    private String[] Columnnames = new String[]{"Nickname", "Bytes In", "Bytes Out"};

    public ConnectionTableModel() {
        this.ConnectionList = new LinkedList<ConnectionUpdateInterface>();
    }

    public void insertRenderer(JTable t) {
        FileSizeRenderer.insertFileSizeIntoTable(t, 1, this);
        FileSizeRenderer.insertFileSizeIntoTable(t, 2, this);
    }

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 1 || col == 2) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        return this.ConnectionList.size();
    }

    @Override
    public synchronized Object getValueAt(int r, int c) {
        ConnectionUpdateInterface cu = this.ConnectionList.get(r);
        if (cu != null) {
            if (c == 0) {
                return cu.getPeer().getNickSig();
            }
            if (c == 1) {
                return cu.getBytesReceived();
            }
            if (c == 2) {
                return cu.getBytesSent();
            }
        }
        return null;
    }

    @Override
    public void newPostReceived(LocalPost post) {
    }

    @Override
    public void newPublicPostReceived(LocalPublicPost post) {
    }

    @Override
    public void newNetworkReceived(LocalNetwork network) {
    }

    @Override
    public void newNetworkAuthReceived(LocalNetworkAuthorization auth) {
    }

    @Override
    public void newPeerReceived(LocalPeer peer) {
    }

    @Override
    public void newFileDownloaded(FileReference filelist) {
    }

    @Override
    public void downloadFailed(Object dig) {
    }

    @Override
    public synchronized void connectionEvent(ConnectionUpdateInterface con0) {
        final ConnectionUpdateInterface con = con0;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ConnectionTableModel.this.ConnectionList.contains(con)) {
                    ConnectionTableModel.this.ConnectionList.add(con);
                }
                if (!con.isOk()) {
                    ConnectionTableModel.this.ConnectionList.remove(con);
                }
                ConnectionTableModel.this.fireTableDataChanged();
            }
        });
    }

    @Override
    public void connectionFailure(Peer p) {
    }

    @Override
    public boolean isOpened(int row) {
        return true;
    }
}

