/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.QueryResultsInterface;

public abstract class TopDocsCacheQueryResultsAbstract
implements QueryResultsInterface {
    private TopDocs CurDocs;
    private IndexSearcher Searcher;
    private DirectoryReader Reader;
    private Map<Integer, SoftReference<Object>> Cache;

    public TopDocsCacheQueryResultsAbstract(TopDocs t, IndexSearcher s, DirectoryReader reader) {
        this.CurDocs = t;
        this.Searcher = s;
        this.Reader = reader;
        this.Cache = new HashMap<Integer, SoftReference<Object>>();
    }

    @Override
    public void Close() {
        try {
            this.Reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int size() {
        return this.CurDocs.scoreDocs.length;
    }

    public abstract Object getHits(int var1);

    public abstract Map<String, Object> getMap(int var1);

    @Override
    public Object get(int i) {
        if (i < this.CurDocs.scoreDocs.length) {
            Object obj = null;
            SoftReference<Object> sr = this.Cache.get(i);
            if (sr != null) {
                obj = sr.get();
            }
            if (obj == null) {
                obj = this.getHits(i);
                this.Cache.put(i, new SoftReference<Object>(obj));
            }
            return obj;
        }
        return null;
    }

    @Override
    public Map<String, Object> getTableFields(int i) {
        if (i < this.CurDocs.scoreDocs.length) {
            return this.getMap(i);
        }
        return null;
    }

    @Override
    public synchronized void remove(int i) {
        throw new RuntimeException("Use ExtendedQueryResults.  Remove not supported.");
    }

    public TopDocs getCurDocs() {
        return this.CurDocs;
    }

    public IndexSearcher getSearcher() {
        return this.Searcher;
    }

    public DirectoryReader getReader() {
        return this.Reader;
    }

    @Override
    public void add(Object obj) {
        throw new RuntimeException("Use ExtendedQueryResults.  Add not supported.");
    }
}

