/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.TopDocsCacheQueryResultsAbstract;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.utilities.BBytes;

public class NetworkAuthQueryResultsH2
extends TopDocsCacheQueryResultsAbstract {
    private DataBaseCoreImplH2 DB;

    public NetworkAuthQueryResultsH2(TopDocs t, IndexSearcher s, DirectoryReader reader, DataBaseCoreImplH2 db) {
        super(t, s, reader);
        this.DB = db;
    }

    @Override
    public Object getHits(int i) {
        MyPeerDataSO me = this.DB.getMyPeerData();
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                StoredField lf = (StoredField)d.getField(DataBaseLuceneIndexer.NETWORK_ID_STR);
                if (lf != null) {
                    BBytes lfb = new BBytes(lf.binaryValue().bytes);
                    LocalNetworkAuthorization lna = this.DB.getNetworkAuth(lfb, me.getPeer().getPeer().getIdentity());
                    return lna;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getMap(int i) {
        return null;
    }

    @Override
    public Map<String, Object> obj2Fields(Object obj) {
        return null;
    }
}

