/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.ourfilesystem.db.ConnectionStatements;

public class ConnectionPool {
    public static int MAXCONS = 5;
    private String DBURL;
    private ConcurrentLinkedQueue<ConnectionStatements> ConList;
    private long NumCons;
    private List<ConnectionTime> TimeOutList = new LinkedList<ConnectionTime>();
    private boolean Closed = false;

    public ConnectionPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionOut(ConnectionStatements con) {
        StackTraceElement[] stl;
        ConnectionTime t = new ConnectionTime();
        t.Con = con;
        t.TimeGot = new Date().getTime();
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = stl = Thread.currentThread().getStackTrace();
        int n = stl.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement se = stackTraceElementArray[n2];
            sb.append(se.toString());
            sb.append("\n");
            ++n2;
        }
        t.StackTrace = sb.toString();
        List<ConnectionTime> list = this.TimeOutList;
        synchronized (list) {
            this.TimeOutList.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionBack(ConnectionStatements con) {
        List<ConnectionTime> list = this.TimeOutList;
        synchronized (list) {
            Iterator<ConnectionTime> i = this.TimeOutList.iterator();
            while (i.hasNext()) {
                ConnectionTime t = i.next();
                if (t.Con != con) continue;
                i.remove();
            }
        }
    }

    public ConnectionPool(String url) {
        this.DBURL = url;
        this.ConList = new ConcurrentLinkedQueue();
        this.NumCons = 0L;
    }

    private synchronized ConnectionStatements getNewCon() throws SQLException {
        ++this.NumCons;
        Connection c = DriverManager.getConnection(this.DBURL, "sa", "");
        ConnectionStatements cs = new ConnectionStatements();
        cs.Con = c;
        return cs;
    }

    public synchronized ConnectionStatements getCon() throws SQLException {
        ConnectionStatements con = this.ConList.poll();
        if (con == null) {
            if (this.NumCons >= (long)MAXCONS) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                con = this.ConList.poll();
            } else {
                con = this.getNewCon();
            }
        }
        this.connectionOut(con);
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printState() {
        long curtime = new Date().getTime();
        long cuttime = curtime - 5000L;
        List<ConnectionTime> list = this.TimeOutList;
        synchronized (list) {
            for (ConnectionTime t : this.TimeOutList) {
                if (t.TimeGot > cuttime) continue;
                System.out.println("000000000000000000000000000000000000000000000000000000000000");
                System.out.println(t.StackTrace);
                System.out.println("000000000000000000000000000000000000000000000000000000000000");
            }
        }
    }

    public synchronized void done(ConnectionStatements c) {
        try {
            c.Con.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.ConList.size() > MAXCONS) {
            throw new RuntimeException("This should not happen!");
        }
        this.ConList.add(c);
        this.connectionBack(c);
        this.notifyAll();
    }

    public synchronized void close() {
        this.Closed = true;
        ConnectionStatements c = this.ConList.poll();
        while (c != null) {
            try {
                c.Con.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = this.ConList.poll();
        }
        this.notifyAll();
    }

    private class ConnectionTime {
        public long TimeGot;
        public ConnectionStatements Con;
        public Object StackTrace;

        private ConnectionTime() {
        }
    }

    class StatusPrint
    implements Runnable {
        StatusPrint() {
        }

        @Override
        public void run() {
            while (!ConnectionPool.this.Closed) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ConnectionPool.this.printState();
            }
        }
    }
}

