/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import net.i2p.I2PException;
import net.i2p.client.streaming.ConnectionOptions;
import net.i2p.client.streaming.I2PServerSocketFull;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManagerFull;
import net.i2p.client.streaming.StandardSocket;

class StandardServerSocket
extends ServerSocket {
    private final I2PServerSocketFull _socket;

    StandardServerSocket(I2PServerSocketFull socket) throws IOException {
        this._socket = socket;
    }

    public Socket accept() throws IOException {
        try {
            I2PSocket sock = this._socket.accept();
            if (sock == null) {
                throw new IOException("No socket");
            }
            return new StandardSocket(sock);
        }
        catch (I2PException i2pe) {
            throw new IOException(i2pe.toString());
        }
    }

    public void bind(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    public void bind(SocketAddress endpoint, int backlog) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Already closed");
        }
        this._socket.close();
    }

    public ServerSocketChannel getChannel() {
        return null;
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public int getLocalPort() {
        return -1;
    }

    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    public int getReceiveBufferSize() {
        ConnectionOptions opts = (ConnectionOptions)((I2PSocketManagerFull)this._socket.getManager()).getDefaultOptions();
        if (opts == null) {
            return 65536;
        }
        return opts.getInboundBufferSize();
    }

    public boolean getReuseAddress() {
        return false;
    }

    public int getSoTimeout() {
        return (int)this._socket.getSoTimeout();
    }

    public boolean isBound() {
        return true;
    }

    public boolean isClosed() {
        return ((I2PSocketManagerFull)this._socket.getManager()).getConnectionManager().getAllowIncomingConnections();
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }

    public void setReceiveBufferSize(int size) {
    }

    public void setReuseAddress(boolean on) {
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this._socket.setSoTimeout(timeout);
    }

    public String toString() {
        return this._socket.toString();
    }
}

