/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.util.Log;

class MessageInputStream
extends InputStream {
    private final Log _log;
    private final List<ByteArray> _readyDataBlocks;
    private int _readyDataBlockIndex;
    private long _highestReadyBlockId;
    private long _highestBlockId;
    private final Map<Long, ByteArray> _notYetReadyBlocks;
    private boolean _closeReceived;
    private boolean _locallyClosed;
    private int _readTimeout;
    private IOException _streamError;
    private long _readTotal;
    private final byte[] _oneByte = new byte[1];
    private final Object _dataLock;

    public MessageInputStream(I2PAppContext ctx) {
        this._log = ctx.logManager().getLog(MessageInputStream.class);
        this._readyDataBlocks = new ArrayList<ByteArray>(4);
        this._highestReadyBlockId = -1L;
        this._highestBlockId = -1L;
        this._readTimeout = -1;
        this._notYetReadyBlocks = new HashMap<Long, ByteArray>(4);
        this._dataLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestReadyBockId() {
        Object object = this._dataLock;
        synchronized (object) {
            return this._highestReadyBlockId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHighestBlockId() {
        Object object = this._dataLock;
        synchronized (object) {
            return this._highestBlockId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNacks() {
        Object object = this._dataLock;
        synchronized (object) {
            return this.locked_getNacks();
        }
    }

    private long[] locked_getNacks() {
        ArrayList<Long> ids = null;
        for (long i = this._highestReadyBlockId + 1L; i < this._highestBlockId; ++i) {
            Long l = i;
            if (this._notYetReadyBlocks.containsKey(l)) continue;
            if (ids == null) {
                ids = new ArrayList<Long>(4);
            }
            ids.add(l);
        }
        if (ids != null) {
            long[] rv = new long[ids.size()];
            for (int i = 0; i < rv.length; ++i) {
                rv[i] = (Long)ids.get(i);
            }
            return rv;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAcks(PacketLocal packet) {
        Object object = this._dataLock;
        synchronized (object) {
            packet.setAckThrough(this._highestBlockId);
            packet.setNacks(this.locked_getNacks());
        }
    }

    public int getReadTimeout() {
        return this._readTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Changing read timeout from " + this._readTimeout + " to " + timeout);
        }
        this._readTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReceived() {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._log.shouldLog(10)) {
                StringBuilder buf = new StringBuilder(128);
                buf.append("Close received, ready bytes: ");
                long available = 0L;
                for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                    available += (long)this._readyDataBlocks.get(i).getValid();
                }
                buf.append(available -= (long)this._readyDataBlockIndex);
                buf.append(" blocks: ").append(this._readyDataBlocks.size());
                buf.append(" not ready blocks: ");
                long notAvailable = 0L;
                for (Long id : this._notYetReadyBlocks.keySet()) {
                    ByteArray ba = this._notYetReadyBlocks.get(id);
                    buf.append(id).append(" ");
                    if (ba == null) continue;
                    notAvailable += (long)ba.getValid();
                }
                buf.append("not ready bytes: ").append(notAvailable);
                buf.append(" highest ready block: ").append(this._highestReadyBlockId);
                this._log.debug(buf.toString(), (Throwable)new Exception("closed"));
            }
            this._closeReceived = true;
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActivity() {
        Object object = this._dataLock;
        synchronized (object) {
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean messageReceived(long messageId, ByteArray payload) {
        if (this._log.shouldLog(10)) {
            this._log.debug("received " + messageId + " with " + (payload != null ? payload.getValid() + "" : "no payload"));
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (messageId <= this._highestReadyBlockId) {
                if (this._log.shouldLog(20)) {
                    this._log.info("ignoring dup message " + messageId);
                }
                this._dataLock.notifyAll();
                return false;
            }
            if (messageId > this._highestBlockId) {
                this._highestBlockId = messageId;
            }
            if (this._highestReadyBlockId + 1L == messageId) {
                if (!this._locallyClosed && payload.getValid() > 0) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("accepting bytes as ready: " + payload.getValid());
                    }
                    this._readyDataBlocks.add(payload);
                }
                this._highestReadyBlockId = messageId;
                long cur = this._highestReadyBlockId + 1L;
                while (this._notYetReadyBlocks.containsKey(cur)) {
                    ByteArray ba = this._notYetReadyBlocks.remove(cur);
                    if (ba != null && ba.getData() != null && ba.getValid() > 0) {
                        this._readyDataBlocks.add(ba);
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("making ready the block " + cur);
                    }
                    ++cur;
                    ++this._highestReadyBlockId;
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("Message is out of order: " + messageId);
                }
                if (this._locallyClosed) {
                    this._notYetReadyBlocks.put(messageId, new ByteArray(null));
                } else {
                    this._notYetReadyBlocks.put(messageId, payload);
                }
            }
            this._dataLock.notifyAll();
        }
        return true;
    }

    public int read() throws IOException {
        int read = this.read(this._oneByte, 0, 1);
        if (read < 0) {
            return -1;
        }
        return this._oneByte[0] & 0xFF;
    }

    public int read(byte[] target) throws IOException {
        return this.read(target, 0, target.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] target, int offset, int length) throws IOException {
        long expiration = -1L;
        if (this._readTimeout > 0) {
            expiration = (long)this._readTimeout + System.currentTimeMillis();
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (this._locallyClosed) {
                throw new IOException("Already locally closed");
            }
            this.throwAnyError();
            for (int i = 0; i < length; ++i) {
                if (this._readyDataBlocks.isEmpty() && i == 0) {
                    while (this._readyDataBlocks.isEmpty()) {
                        if (this._locallyClosed) {
                            throw new IOException("Already closed");
                        }
                        if (this._notYetReadyBlocks.isEmpty() && this._closeReceived) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("read(...," + offset + ", " + length + ")[" + i + "] got EOF after " + this._readTotal + " " + this.toString());
                            }
                            return -1;
                        }
                        if (this._readTimeout < 0) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + ") with no timeout: " + this.toString());
                            }
                            try {
                                this._dataLock.wait();
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException ioe2 = new InterruptedIOException("Interrupted read");
                                ioe2.initCause(ie);
                                throw ioe2;
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + ") with no timeout complete: " + this.toString());
                            }
                            this.throwAnyError();
                        } else if (this._readTimeout > 0) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + ") with timeout: " + this._readTimeout + ": " + this.toString());
                            }
                            try {
                                this._dataLock.wait(this._readTimeout);
                            }
                            catch (InterruptedException ie) {
                                InterruptedIOException ioe2 = new InterruptedIOException("Interrupted read");
                                ioe2.initCause(ie);
                                throw ioe2;
                            }
                            if (this._log.shouldLog(10)) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + ") with timeout complete: " + this._readTimeout + ": " + this.toString());
                            }
                            this.throwAnyError();
                        } else {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("read(...," + offset + ", " + length + ")[" + i + ") with nonblocking setup: " + this.toString());
                            }
                            return i;
                        }
                        if (!this._readyDataBlocks.isEmpty() || this._readTimeout <= 0 || expiration >= System.currentTimeMillis()) continue;
                        if (this._log.shouldLog(20)) {
                            this._log.info("read(...," + offset + ", " + length + ")[" + i + ") expired: " + this.toString());
                        }
                        return i;
                    }
                    --i;
                    continue;
                }
                if (this._readyDataBlocks.isEmpty()) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] no more ready blocks, returning");
                    }
                    return i;
                }
                ByteArray cur = this._readyDataBlocks.get(0);
                byte rv = cur.getData()[cur.getOffset() + this._readyDataBlockIndex];
                ++this._readyDataBlockIndex;
                if (cur.getValid() <= this._readyDataBlockIndex) {
                    this._readyDataBlockIndex = 0;
                    this._readyDataBlocks.remove(0);
                }
                ++this._readTotal;
                target[offset + i] = rv;
                if (this._readyDataBlockIndex > 3 && this._readyDataBlockIndex < cur.getValid() - 5 || !this._log.shouldLog(10)) continue;
                this._log.debug("read(...," + offset + ", " + length + ")[" + i + "] after ready data: readyDataBlockIndex=" + this._readyDataBlockIndex + " readyBlocks=" + this._readyDataBlocks.size() + " readTotal=" + this._readTotal);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("read(byte[]," + offset + ',' + length + ") read fully; total read: " + this._readTotal);
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        int numBytes = 0;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._locallyClosed) {
                throw new IOException("Already closed");
            }
            this.throwAnyError();
            for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                ByteArray cur = this._readyDataBlocks.get(i);
                if (i == 0) {
                    numBytes += cur.getValid() - this._readyDataBlockIndex;
                    continue;
                }
                numBytes += cur.getValid();
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("available(): " + numBytes);
        }
        return numBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReadySize() {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._locallyClosed) {
                return 0;
            }
            int numBytes = 0;
            for (int i = 0; i < this._readyDataBlocks.size(); ++i) {
                ByteArray cur = this._readyDataBlocks.get(i);
                if (i == 0) {
                    numBytes += cur.getValid() - this._readyDataBlockIndex;
                    continue;
                }
                numBytes += cur.getValid();
            }
            return numBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._dataLock;
        synchronized (object) {
            this._readyDataBlocks.clear();
            for (ByteArray ba : this._notYetReadyBlocks.values()) {
                ba.setData(null);
            }
            this._locallyClosed = true;
            this._dataLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamErrorOccurred(IOException ioe) {
        Object object = this._dataLock;
        synchronized (object) {
            if (this._streamError == null) {
                this._streamError = ioe;
            }
            this._locallyClosed = true;
            this._dataLock.notifyAll();
        }
    }

    private void throwAnyError() throws IOException {
        IOException ioe = this._streamError;
        if (ioe != null) {
            this._streamError = null;
            IOException ioe2 = new IOException("Input stream error");
            ioe2.initCause(ioe);
            throw ioe2;
        }
    }
}

