/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.Subscribe;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.ByteCounter;
import org.ourfilesystem.utilities.Version;

public class FileUtils {
    public static final Logger Log = Logger.getLogger(FileUtils.class.getName());
    public static long MAXFILESIZE = 0x200000L;
    public static long MAXBYTES = 8192L;
    public static int VERSION = 2;
    public static int VERSION_02 = 2;
    public static int VERSION_10;
    public static int VERSION_CUR;

    static {
        VERSION_CUR = VERSION_10 = 16;
    }

    public static boolean validateBytes(byte[] b) {
        return b == null || (long)b.length <= MAXBYTES;
    }

    public static void writeBytes(OutputStream os, byte[] b, ByteCounter c) throws IOException {
        if (!FileUtils.validateBytes(b)) {
            throw new IOException("Too much data. " + b.length);
        }
        if (b == null) {
            os.write(2);
            c.add(1L);
        } else {
            os.write(1);
            c.add(1L);
            byte[] ob = new byte[b.length + 4];
            ByteBuffer buf = ByteBuffer.wrap(ob);
            buf.putInt(b.length);
            buf.put(b);
            os.write(ob);
            c.add(ob.length);
        }
    }

    public static byte[] readBytes(InputStream i, ByteCounter c) throws IOException {
        int f = i.read();
        c.add(1L);
        if (f == 2) {
            return null;
        }
        byte[] lb = new byte[4];
        FileUtils.fillBytes(lb, i);
        c.add(lb.length);
        ByteBuffer buf = ByteBuffer.wrap(lb);
        int len = buf.getInt();
        if ((long)len > MAXBYTES) {
            throw new IOException("Byte buffer too large.");
        }
        byte[] ob = new byte[len];
        FileUtils.fillBytes(ob, i);
        c.add(ob.length);
        return ob;
    }

    public static void fillBytes(byte[] b, InputStream i) throws IOException {
        int len = i.read(b);
        int numzeros = 0;
        while (len < b.length && len >= 0) {
            int il = i.read(b, len, b.length - len);
            if (il == 0) {
                ++numzeros;
            }
            if (il > 0) {
                len += il;
                numzeros = 0;
            }
            if (numzeros <= 1) continue;
            throw new IOException("No data recieved.");
        }
    }

    public static void writeLong(long v, OutputStream os, ByteCounter c) throws IOException {
        byte[] b = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putLong(v);
        FileUtils.writeBytes(os, b, c);
    }

    public static long readLong(InputStream is, ByteCounter c) throws IOException {
        byte[] b = FileUtils.readBytes(is, c);
        ByteBuffer buf = ByteBuffer.wrap(b);
        return buf.getLong();
    }

    public static void writeDate(Date d, OutputStream os, ByteCounter c) throws IOException {
        if (d == null) {
            os.write(2);
            c.add(1L);
        } else {
            os.write(1);
            c.add(1L);
            FileUtils.writeLong(d.getTime(), os, c);
        }
    }

    public static Date readDate(InputStream is, ByteCounter c) throws IOException {
        int v = is.read();
        c.add(1L);
        if (v == 2) {
            return null;
        }
        long tv = FileUtils.readLong(is, c);
        return new Date(tv);
    }

    public static void writeBoolean(boolean b, OutputStream os, ByteCounter c) throws IOException {
        if (b) {
            os.write(2);
            c.add(1L);
        } else {
            os.write(1);
            c.add(1L);
        }
    }

    public static boolean readBoolean(InputStream is, ByteCounter c) throws IOException {
        int v = is.read();
        c.add(1L);
        return v == 2;
    }

    public static void writeDouble(double v, OutputStream os, ByteCounter c) throws IOException {
        byte[] b = new byte[8];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putDouble(v);
        FileUtils.writeBytes(os, b, c);
    }

    public static double readDouble(InputStream is, ByteCounter c) throws IOException {
        byte[] b = FileUtils.readBytes(is, c);
        ByteBuffer buf = ByteBuffer.wrap(b);
        return buf.getDouble();
    }

    public static void writeInt(int v, OutputStream os, ByteCounter c) throws IOException {
        byte[] b = new byte[4];
        ByteBuffer buf = ByteBuffer.wrap(b);
        buf.putInt(v);
        FileUtils.writeBytes(os, b, c);
    }

    public static int readInt(InputStream is, ByteCounter c) throws IOException {
        byte[] b = FileUtils.readBytes(is, c);
        ByteBuffer buf = ByteBuffer.wrap(b);
        return buf.getInt();
    }

    public static boolean validateString(String s) {
        if (s != null) {
            return FileUtils.validateBytes(s.getBytes(Charset.forName("UTF-16BE")));
        }
        return true;
    }

    public static void writeString(String s, OutputStream os, ByteCounter c) throws IOException {
        if (s == null) {
            os.write(2);
            c.add(1L);
        } else {
            os.write(1);
            c.add(1L);
            FileUtils.writeBytes(os, s.getBytes(Charset.forName("UTF-16BE")), c);
        }
    }

    public static String readString(InputStream is, ByteCounter c) throws IOException {
        int v = is.read();
        c.add(1L);
        if (v == 2) {
            return null;
        }
        byte[] b = FileUtils.readBytes(is, c);
        return new String(b, Charset.forName("UTF-16BE"));
    }

    public static List<File> findFiles(String dir, String filename) {
        LinkedList<File> rf = new LinkedList<File>();
        File df = new File(dir);
        if (df.isDirectory()) {
            Pattern p = Pattern.compile(filename);
            Matcher m = p.matcher("");
            FileUtils.findFiles(df, m, rf);
        }
        return rf;
    }

    private static void findFiles(File dir, Matcher m, List<File> rf) {
        if (dir.exists() && dir.isDirectory()) {
            File[] fl = dir.listFiles();
            int cnt = 0;
            while (cnt < fl.length) {
                if (fl[cnt].exists()) {
                    if (fl[cnt].isDirectory()) {
                        FileUtils.findFiles(fl[cnt], m, rf);
                    } else {
                        m.reset(fl[cnt].getName());
                        if (m.find()) {
                            rf.add(fl[cnt]);
                        }
                    }
                }
                ++cnt;
            }
        }
    }

    public static void copyFile(File from, File to, long fromoffset, long tooffset, long size) throws IOException {
        FileInputStream fis = new FileInputStream(from);
        RandomAccessFile raf = new RandomAccessFile(to, "rw");
        fis.skip(fromoffset);
        raf.seek(tooffset);
        byte[] buffer = new byte[1024];
        long xfered = 0L;
        while (xfered < size) {
            int xln = fis.read(buffer, 0, (int)Math.min((long)buffer.length, size - xfered));
            if (xln < 0) {
                throw new IOException("End of file reach prematurely.");
            }
            raf.write(buffer, 0, xln);
            xfered += (long)xln;
        }
        fis.close();
        raf.close();
    }

    public static void copyFile(File from, File to, boolean deleteoncopy) throws IOException {
        FileOutputStream fos = new FileOutputStream(to);
        FileChannel foc = fos.getChannel();
        FileInputStream fis = new FileInputStream(from);
        FileChannel fic = fis.getChannel();
        foc.transferFrom(fic, 0L, from.length());
        foc.close();
        fic.close();
        if (deleteoncopy) {
            from.delete();
        }
    }

    public static boolean validatePeer(Peer p) {
        if (p != null) {
            if (!FileUtils.validateString(p.getIntroduction())) {
                return false;
            }
            if (!FileUtils.validateString(p.getNickname())) {
                return false;
            }
            if (!FileUtils.validateString((String)p.getLocation())) {
                return false;
            }
        }
        return true;
    }

    public static void writePeer(OutputStream os, Peer p, ByteCounter c) throws IOException {
        os.write(VERSION_CUR);
        FileUtils.writeLong(p.getUpdateCount(), os, c);
        FileUtils.writeString(p.getIntroduction(), os, c);
        SecurityTools.writePublicKeySet(p.getPeerKeys(), os, c);
        FileUtils.writeString((String)p.getLocation(), os, c);
        FileUtils.writeString(p.getNickname(), os, c);
        FileUtils.writeBytes(os, p.getIdentity().getBytes(), c);
        FileUtils.writeDate(p.getRDate(), os, c);
        SecurityTools.writeSignedDigest(p.getLocationSignature(), os, c);
    }

    public static Peer readPeer(InputStream is, ByteCounter c, Version v) throws IOException {
        v.Version = is.read();
        Peer p = new Peer();
        p.setUpdateCount(FileUtils.readLong(is, c));
        p.setIntroduction(FileUtils.readString(is, c));
        p.setPeerKeys(SecurityTools.readPublicKeySet(is, c));
        p.setLocation(FileUtils.readString(is, c));
        p.setNickname(FileUtils.readString(is, c));
        p.setIdentity(new BBytes(FileUtils.readBytes(is, c)));
        p.setRDate(FileUtils.readDate(is, c));
        p.setLocationSignature(SecurityTools.readSignedDigest(is, c));
        return p;
    }

    public static boolean validatePostMessage(PostMessage m) {
        if (m != null) {
            if (!FileUtils.validateString(m.getComment())) {
                return false;
            }
            if (!FileUtils.validateString(m.getFileName())) {
                return false;
            }
            if (!FileUtils.validateString(m.getSubject())) {
                return false;
            }
            int c = 0;
            while (c < 8) {
                if (!FileUtils.validateString(m.getString(c))) {
                    return false;
                }
                ++c;
            }
        }
        return true;
    }

    public static void writePostMessage(OutputStream os, PostMessage m, ByteCounter c) throws IOException {
        os.write(VERSION);
        if (m == null) {
            c.add(1L);
            os.write(1);
        } else {
            c.add(1L);
            os.write(2);
            FileUtils.writeBBytes(os, m.getRef0(), c);
            FileUtils.writeBBytes(os, m.getRef1(), c);
            FileUtils.writeBBytes(os, m.getRef2(), c);
            FileUtils.writeBBytes(os, m.getUseTemplate(), c);
            FileUtils.writeString(m.getComment(), os, c);
            FileUtils.writeString(m.getString0(), os, c);
            FileUtils.writeString(m.getString1(), os, c);
            FileUtils.writeString(m.getString2(), os, c);
            FileUtils.writeString(m.getString3(), os, c);
            FileUtils.writeString(m.getString4(), os, c);
            FileUtils.writeString(m.getString5(), os, c);
            FileUtils.writeString(m.getString6(), os, c);
            FileUtils.writeString(m.getString7(), os, c);
            FileUtils.writeString(m.getFileName(), os, c);
            FileUtils.writeString(m.getSubject(), os, c);
            FileUtils.writeDouble(m.getDouble0(), os, c);
            FileUtils.writeDouble(m.getDouble1(), os, c);
            FileUtils.writeDouble(m.getDouble2(), os, c);
            FileUtils.writeDouble(m.getDouble3(), os, c);
            FileUtils.writeDouble(m.getDouble4(), os, c);
            FileUtils.writeDouble(m.getDouble5(), os, c);
            FileUtils.writeDouble(m.getDouble6(), os, c);
            FileUtils.writeDouble(m.getDouble7(), os, c);
            FileUtils.writeDouble(m.getDouble8(), os, c);
            FileUtils.writeDouble(m.getDouble9(), os, c);
            FileUtils.writeLong(m.getNum0(), os, c);
            FileUtils.writeLong(m.getNum1(), os, c);
            FileUtils.writeLong(m.getNum2(), os, c);
            FileUtils.writeLong(m.getNum3(), os, c);
            FileUtils.writeLong(m.getNum4(), os, c);
            FileUtils.writeLong(m.getNum5(), os, c);
            FileUtils.writeLong(m.getNum6(), os, c);
            FileUtils.writeLong(m.getNum7(), os, c);
            FileUtils.writeLong(m.getNum8(), os, c);
            FileUtils.writeLong(m.getNum9(), os, c);
            FileUtils.writeBoolean(m.isBool0(), os, c);
            FileUtils.writeBoolean(m.isBool1(), os, c);
            FileUtils.writeBoolean(m.isBool2(), os, c);
            FileUtils.writeBoolean(m.isBool3(), os, c);
            FileUtils.writeBoolean(m.isBool4(), os, c);
            FileUtils.writeBoolean(m.isBool5(), os, c);
            FileUtils.writeBoolean(m.isBool6(), os, c);
            FileUtils.writeBoolean(m.isBool7(), os, c);
            FileUtils.writeBoolean(m.isBool8(), os, c);
            FileUtils.writeBoolean(m.isBool9(), os, c);
        }
    }

    public static PostMessage readPostMessage(InputStream is, ByteCounter c) throws IOException {
        int vr = is.read();
        if (vr == VERSION) {
            int v = is.read();
            c.add(1L);
            if (v == 2) {
                PostMessage pm = new PostMessage();
                pm.setRef0(FileUtils.readBBytes(is, c));
                pm.setRef1(FileUtils.readBBytes(is, c));
                pm.setRef2(FileUtils.readBBytes(is, c));
                pm.setUseTemplate(FileUtils.readBBytes(is, c));
                pm.setComment(FileUtils.readString(is, c));
                pm.setString0(FileUtils.readString(is, c));
                pm.setString1(FileUtils.readString(is, c));
                pm.setString2(FileUtils.readString(is, c));
                pm.setString3(FileUtils.readString(is, c));
                pm.setString4(FileUtils.readString(is, c));
                pm.setString5(FileUtils.readString(is, c));
                pm.setString6(FileUtils.readString(is, c));
                pm.setString7(FileUtils.readString(is, c));
                pm.setFileName(FileUtils.readString(is, c));
                pm.setSubject(FileUtils.readString(is, c));
                pm.setDouble0(FileUtils.readDouble(is, c));
                pm.setDouble1(FileUtils.readDouble(is, c));
                pm.setDouble2(FileUtils.readDouble(is, c));
                pm.setDouble3(FileUtils.readDouble(is, c));
                pm.setDouble4(FileUtils.readDouble(is, c));
                pm.setDouble5(FileUtils.readDouble(is, c));
                pm.setDouble6(FileUtils.readDouble(is, c));
                pm.setDouble7(FileUtils.readDouble(is, c));
                pm.setDouble8(FileUtils.readDouble(is, c));
                pm.setDouble9(FileUtils.readDouble(is, c));
                pm.setNum0(FileUtils.readLong(is, c));
                pm.setNum1(FileUtils.readLong(is, c));
                pm.setNum2(FileUtils.readLong(is, c));
                pm.setNum3(FileUtils.readLong(is, c));
                pm.setNum4(FileUtils.readLong(is, c));
                pm.setNum5(FileUtils.readLong(is, c));
                pm.setNum6(FileUtils.readLong(is, c));
                pm.setNum7(FileUtils.readLong(is, c));
                pm.setNum8(FileUtils.readLong(is, c));
                pm.setNum9(FileUtils.readLong(is, c));
                pm.setBool0(FileUtils.readBoolean(is, c));
                pm.setBool1(FileUtils.readBoolean(is, c));
                pm.setBool2(FileUtils.readBoolean(is, c));
                pm.setBool3(FileUtils.readBoolean(is, c));
                pm.setBool4(FileUtils.readBoolean(is, c));
                pm.setBool5(FileUtils.readBoolean(is, c));
                pm.setBool6(FileUtils.readBoolean(is, c));
                pm.setBool7(FileUtils.readBoolean(is, c));
                pm.setBool8(FileUtils.readBoolean(is, c));
                pm.setBool9(FileUtils.readBoolean(is, c));
                return pm;
            }
            return null;
        }
        throw new IOException("Unknown version.");
    }

    public static void writeBBytes(OutputStream os, BBytes b, ByteCounter c) throws IOException {
        if (b == null) {
            os.write(1);
            c.add(1L);
        } else {
            os.write(2);
            c.add(1L);
            FileUtils.writeBytes(os, b.getBytes(), c);
        }
    }

    public static BBytes readBBytes(InputStream is, ByteCounter c) throws IOException {
        int v = is.read();
        c.add(1L);
        if (v == 2) {
            byte[] b = FileUtils.readBytes(is, c);
            return new BBytes(b);
        }
        return null;
    }

    public static boolean validatePostTemplate(PostTemplate p) {
        if (p != null) {
            int c = 0;
            while (c < 10) {
                if (!FileUtils.validateString(p.getBool(c))) {
                    return false;
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                if (!FileUtils.validateString(p.getDouble(c))) {
                    return false;
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                if (!FileUtils.validateString(p.getNum(c))) {
                    return false;
                }
                ++c;
            }
            c = 0;
            while (c < 3) {
                if (!FileUtils.validateString(p.getRef(c))) {
                    return false;
                }
                ++c;
            }
            c = 0;
            while (c < 8) {
                if (!FileUtils.validateString(p.getString(c))) {
                    return false;
                }
                ++c;
            }
            if (!FileUtils.validateString(p.getTemplateDescription())) {
                return false;
            }
            if (!FileUtils.validateString(p.getTemplateName())) {
                return false;
            }
        }
        return true;
    }

    public static boolean validatePost(Post p) {
        if (p != null) {
            if (p.getMessage() instanceof PostMessage && !FileUtils.validatePostMessage((PostMessage)p.getMessage())) {
                return false;
            }
            if (p.getMessage() instanceof PostTemplate && !FileUtils.validatePostTemplate((PostTemplate)p.getMessage())) {
                return false;
            }
        }
        return true;
    }

    public static void writePost(OutputStream os, Post p, ByteCounter c) throws IOException {
        os.write(VERSION);
        Object m = p.getMessage();
        FileUtils.writeBBytes(os, p.getFileReferenceDigest(), c);
        if (m == null) {
            os.write(1);
            c.add(1L);
        } else if (m instanceof PostMessage) {
            os.write(2);
            c.add(1L);
            FileUtils.writePostMessage(os, (PostMessage)m, c);
        } else if (m instanceof PostTemplate) {
            os.write(3);
            c.add(1L);
            PostTemplate pt = (PostTemplate)m;
            PostTemplate.writePostTemplate(os, pt, c);
        }
        FileUtils.writeLong(p.getPostNumber(), os, c);
        FileUtils.writeBBytes(os, p.getNetworkId(), c);
        FileUtils.writeBoolean(p.isPosterHasFile(), os, c);
        FileUtils.writeDate(p.getRDate(), os, c);
        SecurityTools.writeSignedDigest(p.getSignedDigest(), os, c);
    }

    public static Post readPost(InputStream is, ByteCounter c) throws IOException {
        int vr = is.read();
        if (vr == VERSION) {
            Post p = new Post();
            p.setFileReferenceDigest(FileUtils.readBBytes(is, c));
            int v = is.read();
            c.add(1L);
            if (v == 2) {
                p.setMessage(FileUtils.readPostMessage(is, c));
            } else if (v == 3) {
                PostTemplate pt = PostTemplate.readPostTemplate(is, c);
                p.setMessage(pt);
            }
            p.setPostNumber(FileUtils.readLong(is, c));
            p.setNetworkId(FileUtils.readBBytes(is, c));
            p.setPosterHasFile(FileUtils.readBoolean(is, c));
            p.setRDate(FileUtils.readDate(is, c));
            p.setSignedDigest(SecurityTools.readSignedDigest(is, c));
            return p;
        }
        throw new IOException("Uknown version.");
    }

    public static boolean validateNetwork(Network n) {
        if (n != null) {
            if (!FileUtils.validateString(n.getDescription())) {
                return false;
            }
            if (!FileUtils.validateString(n.getTitle())) {
                return false;
            }
        }
        return true;
    }

    public static void writeNetwork(OutputStream os, Network n, ByteCounter c, int version) throws IOException {
        os.write(VERSION);
        FileUtils.writeString(n.getDescription(), os, c);
        FileUtils.writeLong(n.getNetworkNumber(), os, c);
        FileUtils.writeString(n.getTitle(), os, c);
        FileUtils.writeDate(n.getRDate(), os, c);
        if (version == VERSION_CUR) {
            if (n.getPublic() == null) {
                os.write(0);
            } else {
                os.write(1);
                FileUtils.writeBoolean(n.getPublic(), os, c);
            }
        } else if (n.getPublic() != null) {
            throw new RuntimeException("THIS IS BAD!  YOU CANNOT SEND NEW NETWORKS TO OLD NODES!");
        }
        SecurityTools.writeSignedDigest(n.getSignature(), os, c);
    }

    public static Network readNetwork(InputStream is, ByteCounter c, int version) throws IOException {
        int v = is.read();
        if (v == VERSION) {
            int in;
            Network n = new Network();
            n.setDescription(FileUtils.readString(is, c));
            n.setNetworkNumber(FileUtils.readLong(is, c));
            n.setTitle(FileUtils.readString(is, c));
            n.setRDate(FileUtils.readDate(is, c));
            if (version == VERSION_CUR && (in = is.read()) == 1) {
                n.setPublic(FileUtils.readBoolean(is, c));
            }
            n.setSignature(SecurityTools.readSignedDigest(is, c));
            return n;
        }
        throw new IOException("Unknown version.");
    }

    public static void writeNetworkAuth(OutputStream os, NetworkAuthorization na, ByteCounter c) throws IOException {
        os.write(VERSION);
        FileUtils.writeBBytes(os, na.getNetworkId(), c);
        FileUtils.writeBBytes(os, na.getPeerId(), c);
        FileUtils.writeInt(na.getSignAuthority(), os, c);
        FileUtils.writeLong(na.getSignatureNumber(), os, c);
        FileUtils.writeDate(na.getRDate(), os, c);
        SecurityTools.writeSignedDigest(na.getSignature(), os, c);
    }

    public static NetworkAuthorization readNetworkAuth(InputStream is, ByteCounter c) throws IOException {
        int v = is.read();
        if (v == VERSION) {
            NetworkAuthorization na = new NetworkAuthorization();
            na.setNetworkId(FileUtils.readBBytes(is, c));
            na.setPeerId(FileUtils.readBBytes(is, c));
            na.setSignAuthority(FileUtils.readInt(is, c));
            na.setSignatureNumber(FileUtils.readLong(is, c));
            na.setRDate(FileUtils.readDate(is, c));
            na.setSignature(SecurityTools.readSignedDigest(is, c));
            return na;
        }
        throw new IOException("Unknown version.");
    }

    public static boolean validatePublicPost(PublicPost p) {
        if (p != null) {
            if (p.getMessage() instanceof String && !FileUtils.validateString((String)p.getMessage())) {
                return false;
            }
            if (p.getMessage() instanceof BBytes && !FileUtils.validateBytes(((BBytes)p.getMessage()).getBytes())) {
                return false;
            }
        }
        return true;
    }

    public static void writePublicPost(OutputStream os, PublicPost p, ByteCounter c) throws IOException {
        os.write(VERSION);
        Object m = p.getMessage();
        if (m == null) {
            os.write(1);
            c.add(1L);
        } else if (m instanceof String) {
            os.write(2);
            c.add(1L);
            FileUtils.writeString((String)m, os, c);
        } else if (m instanceof BBytes) {
            os.write(3);
            c.add(1L);
            FileUtils.writeBBytes(os, (BBytes)m, c);
        } else {
            throw new IOException("Unknown message type. " + m);
        }
        FileUtils.writeBoolean(p.isEncrypted(), os, c);
        FileUtils.writeBBytes(os, p.getNetworkId(), c);
        FileUtils.writeLong(p.getPostNumber(), os, c);
        FileUtils.writeDate(p.getRDate(), os, c);
        SecurityTools.writeSignedDigest(p.getSignature(), os, c);
    }

    public static PublicPost readPublicPost(InputStream is, ByteCounter c) throws IOException {
        int vr = is.read();
        if (vr == VERSION) {
            PublicPost p = new PublicPost();
            int v = is.read();
            c.add(1L);
            if (v == 2) {
                p.setMessage(FileUtils.readString(is, c));
            } else if (v == 3) {
                p.setMessage(FileUtils.readBBytes(is, c));
            }
            p.setEncrypted(FileUtils.readBoolean(is, c));
            p.setNetworkId(FileUtils.readBBytes(is, c));
            p.setPostNumber(FileUtils.readLong(is, c));
            p.setRDate(FileUtils.readDate(is, c));
            p.setSignature(SecurityTools.readSignedDigest(is, c));
            return p;
        }
        throw new IOException("Unknown version.");
    }

    public static void writeSubscribe(OutputStream os, Subscribe s, ByteCounter c) throws IOException {
        os.write(VERSION);
        FileUtils.writeBBytes(os, s.getNetworkID(), c);
        FileUtils.writeDate(s.getRDate(), os, c);
        FileUtils.writeLong(s.getSubNumber(), os, c);
        FileUtils.writeBoolean(s.isSubscribe(), os, c);
        SecurityTools.writeSignedDigest(s.getSignature(), os, c);
    }

    public static Subscribe readSubscribe(InputStream s, ByteCounter c) throws IOException {
        int v = s.read();
        if (v == VERSION) {
            Subscribe sb = new Subscribe();
            sb.setNetworkID(FileUtils.readBBytes(s, c));
            sb.setRDate(FileUtils.readDate(s, c));
            sb.setSubNumber(FileUtils.readLong(s, c));
            sb.setSubscribe(FileUtils.readBoolean(s, c));
            sb.setSignature(SecurityTools.readSignedDigest(s, c));
            return sb;
        }
        return null;
    }

    public static void sendFile(OutputStream os, File in, ByteCounter c) throws IOException {
        long numlength = in.length();
        if (numlength > MAXFILESIZE) {
            throw new IOException("File too large to send. " + numlength);
        }
        FileUtils.writeLong(numlength, os, c);
        FileInputStream fis = new FileInputStream(in);
        FileChannel fic = fis.getChannel();
        WritableByteChannel oc = Channels.newChannel(os);
        long pos = 0L;
        while (numlength > 0L) {
            long num = fic.transferTo(pos, numlength, oc);
            c.add(num);
            pos += num;
            numlength -= num;
        }
        fic.close();
    }

    public static void sendFile(OutputStream os, File in, long start, long size, ByteCounter c) throws IOException {
        if (size > MAXFILESIZE) {
            throw new IOException("Too much data to send from file. " + size);
        }
        FileUtils.writeLong(size, os, c);
        FileInputStream fis = new FileInputStream(in);
        FileChannel fic = fis.getChannel();
        WritableByteChannel oc = Channels.newChannel(os);
        long pos = 0L;
        while (size > 0L) {
            long num = fic.transferTo(start + pos, size, oc);
            c.add(num);
            pos += num;
            size -= num;
        }
        fic.close();
    }

    public static void readFile(InputStream is, File f, ByteCounter c) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        FileChannel foc = fos.getChannel();
        long len = FileUtils.readLong(is, c);
        if (len > MAXFILESIZE) {
            throw new RuntimeException("File too large.");
        }
        long pos = 0L;
        ReadableByteChannel ic = Channels.newChannel(is);
        while (len > 0L) {
            long nt = foc.transferFrom(ic, pos, len);
            c.add(nt);
            if (nt == 0L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            pos += nt;
            len -= nt;
        }
        foc.close();
    }

    public static void deleteDir(String f) {
        FileUtils.deleteDir(new File(f));
    }

    public static void deleteDir(File f) {
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] fl = f.listFiles();
                int c = 0;
                while (c < fl.length) {
                    FileUtils.deleteDir(fl[c]);
                    ++c;
                }
            }
            f.delete();
        }
    }

    public static boolean diff(File f0, File f1) throws IOException {
        int b1;
        int b0;
        if (f0.length() != f1.length()) {
            return false;
        }
        FileInputStream fi0 = new FileInputStream(f0);
        FileInputStream fi1 = new FileInputStream(f1);
        boolean eq = true;
        do {
            if ((b0 = fi0.read()) == (b1 = fi1.read())) continue;
            eq = false;
        } while (b0 != -1 && b1 != -1 && eq);
        fi0.close();
        fi1.close();
        return eq;
    }

    public static boolean diff(File f0, long offset0, File f1, long offset1, long size) throws IOException {
        int b1;
        int b0;
        FileInputStream fi0 = new FileInputStream(f0);
        while (offset0 > 0L) {
            fi0.read();
            --offset0;
        }
        FileInputStream fi1 = new FileInputStream(f1);
        while (offset1 > 0L) {
            fi1.read();
            --offset1;
        }
        boolean eq = true;
        do {
            if ((b0 = fi0.read()) == (b1 = fi1.read())) continue;
            eq = false;
        } while (b0 != -1 && b1 != -1 && eq && --size > 0L);
        fi0.close();
        fi1.close();
        return eq;
    }
}

