/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.ui.NewPeerMessageDialog;

public class ViewPeerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTextField textNickname;
    private JTextField textLocation;
    private JTextPane textIntro;
    private JTextField textDiscovered;
    private LocalPeer Peer;
    private NewPeerMessageDialog MessageDialog;

    public ViewPeerDialog(NewPeerMessageDialog md) {
        this.MessageDialog = md;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("resources/ofs2_wiki.png"));
            this.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][grow][]"));
        JLabel lblNickname = new JLabel("Nickname");
        this.getContentPane().add((Component)lblNickname, "cell 0 0,alignx trailing");
        this.textNickname = new JTextField();
        this.getContentPane().add((Component)this.textNickname, "cell 1 0,growx");
        this.textNickname.setColumns(10);
        this.textNickname.setEditable(false);
        JLabel lblDiscovered = new JLabel("Discovered");
        this.getContentPane().add((Component)lblDiscovered, "cell 0 1,alignx trailing");
        this.textDiscovered = new JTextField();
        this.getContentPane().add((Component)this.textDiscovered, "cell 1 1,growx");
        this.textDiscovered.setColumns(10);
        this.textDiscovered.setEditable(false);
        JLabel lblLocation = new JLabel("Location");
        this.getContentPane().add((Component)lblLocation, "cell 0 2,alignx trailing");
        this.textLocation = new JTextField();
        this.getContentPane().add((Component)this.textLocation, "cell 1 2,growx");
        this.textLocation.setColumns(10);
        this.textLocation.setEditable(false);
        JLabel lblIntroduction = new JLabel("Introduction");
        this.getContentPane().add((Component)lblIntroduction, "cell 0 3");
        JScrollPane scrollPane = new JScrollPane();
        this.getContentPane().add((Component)scrollPane, "cell 1 3,grow");
        this.textIntro = new JTextPane();
        scrollPane.setViewportView(this.textIntro);
        this.textIntro.setEditable(false);
        JButton btnSendMessage = new JButton("Send Message");
        this.getContentPane().add((Component)btnSendMessage, "flowx,cell 1 4");
        btnSendMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ViewPeerDialog.this.Peer != null) {
                    ViewPeerDialog.this.MessageDialog.showDialog(ViewPeerDialog.this.Peer.getPeer().getIdentity(), ViewPeerDialog.this.Peer.getPeer().getNickSig(), null, "");
                    ViewPeerDialog.this.setVisible(false);
                }
            }
        });
        JButton btnDismiss = new JButton("Dismiss");
        this.getContentPane().add((Component)btnDismiss, "cell 1 4");
        btnDismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ViewPeerDialog.this.setVisible(false);
            }
        });
    }

    public void showPeer(LocalPeer peer) {
        this.Peer = peer;
        this.textDiscovered.setText(peer.getLocalDate().toString());
        this.textNickname.setText(peer.getPeer().getNickname());
        this.textLocation.setText((String)peer.getPeer().getLocation());
        this.textIntro.setText(peer.getPeer().getIntroduction());
        this.setVisible(true);
    }

    public JTextField getTextNickname() {
        return this.textNickname;
    }

    public JTextField getTextLocation() {
        return this.textLocation;
    }

    public JTextPane getTextIntro() {
        return this.textIntro;
    }

    public JTextField getTextDiscovered() {
        return this.textDiscovered;
    }
}

