/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.PeerRankDialog;
import org.ourfilesystem.ui.PeerTableModel;
import org.ourfilesystem.ui.SignDialogs;
import org.ourfilesystem.ui.ViewPeerDialog;
import org.ourfilesystem.utilities.BBytes;

public class PeerPanel
extends JPanel
implements NetworkSelectInterface,
RowSorterListener {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JTextField textMax;
    private PeerTableModel Model;
    private Main Mn;
    private JTable table;
    private JLabel lblSelected;
    private LocalNetwork CurNetwork;
    private LocalNetworkAuthorization CurAuth;
    private NewPeerMessageDialog PeerMessageDialog;
    private SignDialogs SignDialogs;
    private ViewPeerDialog PeerDialog;
    private JSpinner spinner;
    private PeerRankDialog rankDialog;
    private String SortKeyWord;
    private boolean SortAsc;

    public void doSearch() {
        int max = 1000;
        try {
            max = Integer.valueOf(this.textMax.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int r = (Integer)this.spinner.getValue();
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchPeers(this.textField.getText(), this.SortKeyWord, max, !this.SortAsc, r);
        this.Model.setPeers(qr);
    }

    public PeerPanel(Main m) {
        this.Mn = m;
        this.Model = new PeerTableModel();
        this.rankDialog = new PeerRankDialog(this.Mn);
        this.SortKeyWord = null;
        this.SortAsc = true;
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JLabel lblSel = new JLabel("Selected group:");
        panel.add((Component)lblSel, "cell 0 0");
        this.lblSelected = new JLabel("none");
        panel.add((Component)this.lblSelected, "flowx,cell 1 0,growx");
        JButton btnUpdatePeersNow = new JButton("Update Peers Now");
        panel.add((Component)btnUpdatePeersNow, "cell 1 0,alignx right");
        btnUpdatePeersNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeerPanel.this.Mn.getCoreUser().updatePeers(10L);
            }
        });
        JLabel lblSearch = new JLabel("Search");
        panel.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JLabel lblMinPeerRank = new JLabel("Min peer rank");
        panel.add((Component)lblMinPeerRank, "cell 1 1");
        SpinnerNumberModel model = new SpinnerNumberModel(5, 0, 999, 1);
        this.spinner = new JSpinner(model);
        panel.add((Component)this.spinner, "cell 1 1");
        JLabel lblMax = new JLabel("Max results");
        panel.add((Component)lblMax, "cell 1 1");
        this.textMax = new JTextField("1000");
        this.textMax.setColumns(6);
        panel.add((Component)this.textMax, "cell 1 1");
        JButton btnSearch = new JButton("Search");
        panel.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PeerPanel.this.doSearch();
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        this.table = new JTable(this.Model);
        this.Model.insertDateRenerer(this.table);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().addRowSorterListener(this);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    int row = PeerPanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                    PeerPanel.this.openPeer(row);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        scrollPane.setViewportView(this.table);
        this.SignDialogs = new SignDialogs(this.Mn, this.table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem view = new JMenuItem("View");
        mnu.add(view);
        view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PeerPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PeerPanel.this.table.getSelectedRow();
                    PeerPanel.this.openPeer(r);
                }
            }
        });
        JMenuItem pmsg = new JMenuItem("Send Private Message");
        pmsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PeerPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PeerPanel.this.table.getSelectedRow();
                    r = PeerPanel.this.table.convertRowIndexToModel(r);
                    LocalPeer peer = PeerPanel.this.Model.getPeer(r);
                    if (peer != null) {
                        PeerPanel.this.PeerMessageDialog.showDialog(peer.getPeer().getIdentity(), peer.getPeer().getNickSig(), null, "");
                    }
                }
            }
        });
        mnu.add(pmsg);
        JMenuItem sgn = new JMenuItem("Grant Group Authorization");
        mnu.add(sgn);
        sgn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PeerPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PeerPanel.this.table.getSelectedRow();
                    r = PeerPanel.this.table.convertRowIndexToModel(r);
                    LocalPeer peer = PeerPanel.this.Model.getPeer(r);
                    if (PeerPanel.this.CurAuth != null) {
                        PeerPanel.this.SignDialogs.setCurAuth(PeerPanel.this.CurAuth);
                        PeerPanel.this.SignDialogs.setPeer(peer);
                        PeerPanel.this.SignDialogs.sign();
                    } else {
                        JOptionPane.showMessageDialog(PeerPanel.this.table, "You are not authorized to grant access.", "Not Authorized", 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(PeerPanel.this.table, "Select a peer first.", "No peer selected", 2);
                }
            }
        });
        JMenuItem rnk = new JMenuItem("Set Rank");
        mnu.add(rnk);
        rnk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PeerPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int[] selr = PeerPanel.this.table.getSelectedRows();
                    LinkedList<BBytes> plst = new LinkedList<BBytes>();
                    int i = 0;
                    while (i < selr.length) {
                        int r = selr[i];
                        r = PeerPanel.this.table.convertRowIndexToModel(r);
                        LocalPeer peer = PeerPanel.this.Model.getPeer(r);
                        plst.add(peer.getPeer().getIdentity());
                        ++i;
                    }
                    PeerPanel.this.rankDialog.showDialog(plst);
                } else {
                    JOptionPane.showMessageDialog(PeerPanel.this.table, "Select a peer first.", "No peer selected", 2);
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
        this.doSearch();
    }

    private void openPeer(int r) {
        LocalPeer peer = this.Model.getPeer(r = this.table.convertRowIndexToModel(r));
        if (peer != null) {
            this.PeerDialog.showPeer(peer);
        }
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network) {
        this.CurNetwork = network;
        BBytes myid = this.Mn.getCoreDB().getMyPeerData().getPeer().getPeer().getIdentity();
        this.CurAuth = this.Mn.getCoreDB().getNetworkAuth(this.CurNetwork.getNetwork().getSignature().getDigest(), myid);
        this.lblSelected.setText(this.CurNetwork.getNetwork().getTitleSig());
    }

    public NewPeerMessageDialog getPeerMessageDialog() {
        return this.PeerMessageDialog;
    }

    public void setPeerMessageDialog(NewPeerMessageDialog peerMessageDialog) {
        this.PeerMessageDialog = peerMessageDialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        List<RowSorter.SortKey> sl = ((RowSorter)e.getSource()).getSortKeys();
        if (sl.size() > 0) {
            RowSorter.SortKey sk = sl.get(0);
            this.SortKeyWord = this.Model.getSortKey(sk.getColumn());
            this.SortAsc = sk.getSortOrder().equals((Object)SortOrder.ASCENDING);
        }
    }
}

