/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.OpenedInterface;

public class NetworkTableModel
extends AbstractTableModel
implements OpenedInterface {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Networks;
    private boolean SimpleMode;
    private String[] Columnnames = new String[]{"Title", "Description", "Creator", "Peer Rank", "Your Authorization", "Subscribed", "Date Created", "Date Received"};

    public String getSortKey(int col) {
        if (this.SimpleMode) {
            if (col == 0) {
                return DataBaseLuceneIndexer.NETWORK_TITLE_STR;
            }
            if (col == 1) {
                return DataBaseLuceneIndexer.NETWORK_CREATOR_STR;
            }
        } else {
            if (col == 0) {
                return DataBaseLuceneIndexer.NETWORK_TITLE_STR;
            }
            if (col == 1) {
                return DataBaseLuceneIndexer.NETWORK_DESCRIPTION_STR;
            }
            if (col == 2) {
                return DataBaseLuceneIndexer.NETWORK_CREATOR_STR;
            }
            if (col == 3) {
                return DataBaseLuceneIndexer.NETWORK_PEERRANK;
            }
            if (col == 4) {
                return DataBaseLuceneIndexer.NETWORK_AUTH_NUM;
            }
            if (col == 5) {
                return DataBaseLuceneIndexer.NETWORK_SUBSCRIBE;
            }
            if (col == 6) {
                return DataBaseLuceneIndexer.NETWORK_CDATE;
            }
            if (col == 7) {
                return DataBaseLuceneIndexer.NETWORK_DATE;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        if (this.SimpleMode) {
            if (col == 0) {
                return "Group";
            }
            if (col == 1) {
                return "Creator";
            }
            return null;
        }
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 6 || col == 7) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        if (!this.SimpleMode) {
            DateRenderer.insertDateIntoTable(t, 6, this);
            DateRenderer.insertDateIntoTable(t, 7, this);
        }
    }

    @Override
    public int getColumnCount() {
        if (this.SimpleMode) {
            return 2;
        }
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Networks != null) {
            return this.Networks.size();
        }
        return 0;
    }

    public synchronized LocalNetwork getNetwork(int r) {
        if (this.Networks != null && r < this.Networks.size()) {
            LocalNetwork nw = (LocalNetwork)this.Networks.get(r);
            return nw;
        }
        return null;
    }

    public synchronized Map<String, Object> getTableFields(int r) {
        if (this.Networks != null && r < this.Networks.size()) {
            return this.Networks.getTableFields(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        Map<String, Object> m = this.getTableFields(r);
        if (m != null) {
            if (this.SimpleMode) {
                if (c == 0) {
                    return m.get(DataBaseLuceneIndexer.NETWORK_TITLE_STR);
                }
                if (c == 1) {
                    return m.get(DataBaseLuceneIndexer.NETWORK_CREATOR_STR);
                }
            }
            if (c == 0) {
                return m.get(DataBaseLuceneIndexer.NETWORK_TITLE_STR);
            }
            if (c == 1) {
                return m.get(DataBaseLuceneIndexer.NETWORK_DESCRIPTION_STR);
            }
            if (c == 2) {
                return m.get(DataBaseLuceneIndexer.NETWORK_CREATOR_STR);
            }
            if (c == 3) {
                return m.get(DataBaseLuceneIndexer.NETWORK_PEERRANK);
            }
            if (c == 4) {
                if (((Boolean)m.get(DataBaseLuceneIndexer.NETWORK_PUBLIC)).booleanValue()) {
                    return "PUBLIC";
                }
                Boolean isa = (Boolean)m.get(DataBaseLuceneIndexer.NETWORK_AUTH);
                if (isa == null) {
                    return "Not Authorized";
                }
                if (!isa.booleanValue()) {
                    return "Not Authorized";
                }
                Long auth = (Long)m.get(DataBaseLuceneIndexer.NETWORK_AUTH_NUM);
                if (auth != null) {
                    if (auth == (long)NetworkAuthorization.NOSIGN) {
                        return "Authorized";
                    }
                    if (auth == (long)NetworkAuthorization.CANSIGN) {
                        return "Grant Authorized";
                    }
                    if (auth == (long)NetworkAuthorization.CANGIVESIGNAUTH) {
                        return "Super Authorized";
                    }
                }
            }
            if (c == 5) {
                return (Boolean)m.get(DataBaseLuceneIndexer.NETWORK_SUBSCRIBE) != false ? "SUBSCRIBED" : "";
            }
            if (c == 6) {
                return m.get(DataBaseLuceneIndexer.NETWORK_CDATE);
            }
            if (c == 7) {
                return m.get(DataBaseLuceneIndexer.NETWORK_DATE);
            }
        }
        return null;
    }

    public synchronized void setNetworks(QueryResultsInterface lst) {
        if (this.Networks != null) {
            this.Networks.Close();
        }
        this.Networks = lst;
        this.fireTableDataChanged();
    }

    public boolean isSimpleMode() {
        return this.SimpleMode;
    }

    public void setSimpleMode(boolean simpleMode) {
        this.SimpleMode = simpleMode;
    }

    @Override
    public boolean isOpened(int row) {
        return true;
    }
}

