/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.ourfilesystem.com.ComConnectionImpl;
import org.ourfilesystem.com.ComPeerImpl;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSI2PConnector;
import org.ourfilesystem.com.OFSI2PServerSocket;
import org.ourfilesystem.com.OFSServerSocket;
import org.ourfilesystem.com.SimpleConnector;
import org.ourfilesystem.com.SimpleServerSocket;
import org.ourfilesystem.core.CoreComImpl;
import org.ourfilesystem.core.CoreUserImpl;
import org.ourfilesystem.core.EventDispatcher;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.DataBaseQueryH2;
import org.ourfilesystem.db.TimeImpl;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.UpgradeTo072DB;
import org.ourfilesystem.db.UpgradeTo073DB;
import org.ourfilesystem.db.UpgradeTo08DB;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.filehandler.FileHandler;
import org.ourfilesystem.security.CryptoComImpl;
import org.ourfilesystem.security.CryptoDataBaseImpl;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.ui.FileStatusTableModel;
import org.ourfilesystem.ui.Gui;
import org.ourfilesystem.ui.Updater;
import org.ourfilesystem.utilities.DumbMIME;
import org.ourfilesystem.utilities.FileUtils;
import org.ourfilesystem.utilities.Licenses;

public class Main
implements Runnable {
    public static String VERSION_FILE = "version.txt";
    public static String VERSION_0_6_0_PRE1 = "0.6.0_pre1";
    public static String VERSION_0_6_0_PRE2 = "0.6.0_pre2";
    public static String VERSION_0_6_0_PRE3 = "0.6.0_pre3";
    public static String VERSION_0_6_0 = "0.6.0";
    public static String VERSION_0_6_1 = "0.6.1";
    public static String VERSION_0_6_2 = "0.6.2";
    public static String VERSION_0_6_3 = "0.6.3";
    public static String VERSION_0_6_4 = "0.6.4";
    public static String VERSION_0_7_0 = "0.7.0";
    public static String VERSION_0_7_1 = "0.7.1";
    public static String VERSION_0_7_2 = "0.7.2";
    public static String VERSION_0_7_3 = "0.7.3";
    public static String VERSION_0_7_4 = "0.7.4";
    public static String VERSION_0_7_5 = "0.7.5";
    public static String VERSION_0_8_0 = "0.8.0";
    public static String VERSION_0_8_1;
    public static String CURRENT_VERSION;
    public static String[] COMPATABLE_VERSIONS;
    public static String[] DO_0_6_1_UPGRADE;
    public static String[] DO_0_6_2_UPGRADE;
    public static String[] DO_0_6_3_UPGRADE;
    public static String[] DO_0_6_4_UPGRADE;
    public static String[] DO_0_7_2_UPGRADE;
    public static String[] DO_0_7_3_UPGRADE;
    public static String[] DO_0_8_0_UPGRADE;
    public static String I2P_SEED_FILE;
    public static String TOR_SEED_FILE;
    public static String NOTSETSTRING;
    public static String DEFAULT_PORT;
    public static String NODE_PROPS_FILE;
    public static String I2P_KEY_FILE;
    public static String I2P_PROPS_FILE;
    public static String PEER_DATA_FILE;
    public static String PEER_NICKNAME;
    public static String PEER_INTRO;
    public static String MAX_CONNECTIONS;
    public static String TIME_CON_STEPS;
    public static String TIME_CON_STEP_SIZE;
    public static String PROCESS_LOOP_DELAY;
    public static String REDISPATCH_TIME;
    public static String RECONNECT_TIME;
    public static String REREQUEST_TIME;
    public static String MAX_BATCH_REQUESTS;
    public static String NETWORKMODE;
    public static String NETWORK_NAKED;
    public static String NETWORK_SOCKS;
    public static String NETWORK_I2P;
    public static String NETWORK_HOST;
    public static String NETWORK_PORT;
    public static String NETWORK_EXTERNAL_PORT;
    public static String SOCKS_HOST;
    public static String SOCKS_PORT;
    public static String PEER_UPDATE_PERIOD;
    public static String POST_UPDATE_PERIOD;
    public static String NETWORK_UPDATE_PERIOD;
    public static String PUBLICPOST_UPDATE_PERIOD;
    public static String NETWORKAUTH_UPDATE_PERIOD;
    public static String SUB_UPDATE_PERIOD;
    public static String DOWNLOAD_DEFAULT_DIR;
    public static String DOWNLOAD_DEFAULT_PRIORITY;
    private boolean Closed;
    private File NodeDir;
    private CryptoDataBaseImpl Crypto;
    private CryptoComImpl ComCrypto;
    private DataBaseCoreImplH2 CoreDB;
    private ComConnectionImpl Com;
    private CoreComImpl CoreCom;
    private CoreUserImpl CoreUser;
    private TimeInterface Time;
    private FileHandler FileHandler;
    private Updater Updater;
    private EventDispatcher Event;
    private OFSConnector Connector;
    private OFSServerSocket ServerSocket;
    private Properties NetProperties;
    private Properties I2PProperties;
    private long ProcDelay;
    private File SeedPeers;
    private File TemplateDir;
    private Gui Gui;
    private boolean DO08UPDATE = false;

    static {
        CURRENT_VERSION = VERSION_0_8_1 = "0.8.1";
        COMPATABLE_VERSIONS = new String[]{VERSION_0_7_0, VERSION_0_7_1, VERSION_0_7_2, VERSION_0_7_3, VERSION_0_7_4, VERSION_0_7_5, VERSION_0_8_0};
        DO_0_6_1_UPGRADE = new String[]{VERSION_0_6_0_PRE3, VERSION_0_6_0};
        DO_0_6_2_UPGRADE = new String[]{VERSION_0_6_1};
        DO_0_6_3_UPGRADE = new String[]{VERSION_0_6_2};
        DO_0_6_4_UPGRADE = new String[]{VERSION_0_6_2, VERSION_0_6_3};
        DO_0_7_2_UPGRADE = new String[]{VERSION_0_7_0, VERSION_0_7_1};
        DO_0_7_3_UPGRADE = new String[]{VERSION_0_7_0, VERSION_0_7_1, VERSION_0_7_2};
        DO_0_8_0_UPGRADE = new String[]{VERSION_0_7_0, VERSION_0_7_1, VERSION_0_7_2, VERSION_0_7_3, VERSION_0_7_4, VERSION_0_7_5};
        I2P_SEED_FILE = "i2pseed.dat";
        TOR_SEED_FILE = "torseed.dat";
        NOTSETSTRING = "YOU.MUST.SET.THIS";
        DEFAULT_PORT = "9764";
        NODE_PROPS_FILE = "node.props";
        I2P_KEY_FILE = "i2pkey.dat";
        I2P_PROPS_FILE = "i2p.props";
        PEER_DATA_FILE = "peer.dat";
        PEER_NICKNAME = "NICKNAME";
        PEER_INTRO = "INTRODUCTION";
        MAX_CONNECTIONS = "MAX_CONNECTIONS";
        TIME_CON_STEPS = "TIME_CON_STEPS";
        TIME_CON_STEP_SIZE = "TIME_CON_STEP_SIZE";
        PROCESS_LOOP_DELAY = "PROCESS_LOOP_DELAY";
        REDISPATCH_TIME = "REDISPATCH_TIME";
        RECONNECT_TIME = "RECONNECT_TIME";
        REREQUEST_TIME = "REREQUEST_TIME";
        MAX_BATCH_REQUESTS = "MAX_BATCH_REQUESTS";
        NETWORKMODE = "NETWORKMODE";
        NETWORK_NAKED = "NAKED";
        NETWORK_SOCKS = "SOCKS";
        NETWORK_I2P = "I2P";
        NETWORK_HOST = "HOST";
        NETWORK_PORT = "PORT";
        NETWORK_EXTERNAL_PORT = "EXTERNAL_PORT";
        SOCKS_HOST = "SOCKS_HOST";
        SOCKS_PORT = "SOCKS_PORT";
        PEER_UPDATE_PERIOD = "PEER_UPDATE_PERIOD";
        POST_UPDATE_PERIOD = "POST_UPDATE_PERIOD";
        NETWORK_UPDATE_PERIOD = "NETWORK_UPDATE_PERIOD";
        PUBLICPOST_UPDATE_PERIOD = "PUBLICPOST_UPDATE_PERIOD";
        NETWORKAUTH_UPDATE_PERIOD = "NETWORKAUTH_UPDATE_PERIOD";
        SUB_UPDATE_PERIOD = "SUB_UPDATE_PERIOD";
        DOWNLOAD_DEFAULT_DIR = "DOWNLOAD_DEFAULT_DIR";
        DOWNLOAD_DEFAULT_PRIORITY = "DOWNLOAD_DEFAULT_PRIORITY";
    }

    private void initNode() {
        String mode = this.NetProperties.getProperty(NETWORKMODE);
        if (mode == null) {
            throw new RuntimeException("No network mode selected!");
        }
        if (mode.equals(NETWORK_NAKED)) {
            String portstr = this.NetProperties.getProperty(NETWORK_PORT);
            try {
                int port = Integer.valueOf(portstr);
                this.ServerSocket = new SimpleServerSocket(new ServerSocket(port));
                this.Connector = new SimpleConnector(false, null, 0);
            }
            catch (Exception e) {
                throw new RuntimeException("Port was not a number:", e);
            }
        }
        if (mode.equals(NETWORK_SOCKS)) {
            try {
                int port = Integer.valueOf(this.NetProperties.getProperty(NETWORK_PORT));
                int socksport = Integer.valueOf(this.NetProperties.getProperty(SOCKS_PORT));
                this.ServerSocket = new SimpleServerSocket(new ServerSocket(port));
                this.Connector = new SimpleConnector(true, this.NetProperties.getProperty(SOCKS_HOST), socksport);
            }
            catch (Exception e) {
                throw new RuntimeException("Port was not a number:", e);
            }
        }
        if (mode.equals(NETWORK_I2P)) {
            try {
                OFSI2PServerSocket server = new OFSI2PServerSocket(String.valueOf(this.NodeDir.getPath()) + File.separator + I2P_KEY_FILE, this.I2PProperties);
                this.Connector = (OFSI2PConnector)server.getOFSConnector();
                this.ServerSocket = server;
                this.NetProperties.setProperty(NETWORK_HOST, server.getMyLocation());
                this.saveProperties();
            }
            catch (Exception e) {
                throw new RuntimeException("Count not connect to i2p.", e);
            }
        }
        if (this.Connector == null || this.ServerSocket == null) {
            throw new RuntimeException("Network mode not reconginized.");
        }
        try {
            this.initNode(this.Connector, this.ServerSocket);
            File peerfile = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + PEER_DATA_FILE);
            this.savePeerData();
            this.writeMyPeerData(peerfile);
            this.loadPeerSeeds(this.SeedPeers);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Main.this.Shutdown();
                }
            });
            this.ProcDelay = this.getProcessLoopDelay();
            Thread t = new Thread(this);
            t.start();
            this.startUpdater();
            this.setUpdater();
            this.saveProperties();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initialize node.", e);
        }
    }

    public void savePeerData() {
        String mode = this.NetProperties.getProperty(NETWORKMODE);
        String locationstring = null;
        if (mode.equals(NETWORK_NAKED)) {
            locationstring = String.valueOf(this.NetProperties.getProperty(NETWORK_HOST)) + ":" + this.NetProperties.getProperty(NETWORK_EXTERNAL_PORT);
        }
        if (mode.equals(NETWORK_SOCKS)) {
            locationstring = String.valueOf(this.NetProperties.getProperty(NETWORK_HOST)) + ":" + this.NetProperties.getProperty(NETWORK_EXTERNAL_PORT);
        }
        if (mode.equals(NETWORK_I2P)) {
            locationstring = this.NetProperties.getProperty(NETWORK_HOST);
        }
        String nick = this.NetProperties.getProperty(PEER_NICKNAME);
        String intro = this.NetProperties.getProperty(PEER_INTRO);
        if (locationstring != null) {
            this.CoreUser.setMyLocation(locationstring);
        }
        if (intro != null) {
            this.CoreUser.setMyIntroduction(intro);
        }
        if (nick != null) {
            this.CoreUser.setMyNickname(nick);
        }
    }

    private void setUpdater() {
        String s = this.NetProperties.getProperty(POST_UPDATE_PERIOD);
        if (s == null) {
            this.NetProperties.setProperty(POST_UPDATE_PERIOD, Long.toString(this.Updater.getPostUpdatePeriod() / 3600000L));
        } else {
            try {
                long v = Long.valueOf(s);
                this.Updater.setPostUpdatePeriod(v *= 3600000L);
            }
            catch (Exception v) {
                // empty catch block
            }
        }
        s = this.NetProperties.getProperty(NETWORK_UPDATE_PERIOD);
        if (s == null) {
            this.NetProperties.setProperty(NETWORK_UPDATE_PERIOD, Long.toString(this.Updater.getNetworkUpdatePeriod() / 3600000L));
        } else {
            try {
                long v = Long.valueOf(s);
                this.Updater.setNetworkUpdatePeriod(v *= 3600000L);
            }
            catch (Exception v) {
                // empty catch block
            }
        }
        s = this.NetProperties.getProperty(NETWORKAUTH_UPDATE_PERIOD);
        if (s == null) {
            this.NetProperties.setProperty(NETWORKAUTH_UPDATE_PERIOD, Long.toString(this.Updater.getNetworkAuthUpdatePeriod() / 3600000L));
        } else {
            try {
                long v = Long.valueOf(s);
                this.Updater.setNetworkAuthUpdatePeriod(v *= 3600000L);
            }
            catch (Exception v) {
                // empty catch block
            }
        }
        s = this.NetProperties.getProperty(PUBLICPOST_UPDATE_PERIOD);
        if (s == null) {
            this.NetProperties.setProperty(PUBLICPOST_UPDATE_PERIOD, Long.toString(this.Updater.getPublicPostUpdatePeriod() / 3600000L));
        } else {
            try {
                long v = Long.valueOf(s);
                this.Updater.setPublicPostUpdatePeriod(v *= 3600000L);
            }
            catch (Exception v) {
                // empty catch block
            }
        }
        s = this.NetProperties.getProperty(PEER_UPDATE_PERIOD);
        if (s == null) {
            this.NetProperties.setProperty(PEER_UPDATE_PERIOD, Long.toString(this.Updater.getPeerUpdatePeriod() / 3600000L));
        } else {
            try {
                long v = Long.valueOf(s);
                this.Updater.setPeerUpdatePeriod(v *= 3600000L);
            }
            catch (Exception v) {
                // empty catch block
            }
        }
        s = this.NetProperties.getProperty(SUB_UPDATE_PERIOD);
        if (s == null) {
            this.NetProperties.setProperty(SUB_UPDATE_PERIOD, Long.toString(this.Updater.getSubscriptionUpdatePeriod() / 3600000L));
        } else {
            try {
                long v = Long.valueOf(s);
                this.Updater.setSubscriptionUpdatePeriod(v *= 3600000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startUpdater() {
        long lv2;
        this.Updater = new Updater(this.CoreUser, this.CoreDB, this.Time);
        String v = this.NetProperties.getProperty(SUB_UPDATE_PERIOD);
        if (v != null) {
            try {
                lv2 = Long.valueOf(v);
                this.Updater.setSubscriptionUpdatePeriod(lv2);
            }
            catch (Exception lv2) {
                // empty catch block
            }
        }
        if ((v = this.NetProperties.getProperty(PEER_UPDATE_PERIOD)) != null) {
            try {
                lv2 = Long.valueOf(v);
                this.Updater.setPeerUpdatePeriod(lv2);
            }
            catch (Exception lv3) {
                // empty catch block
            }
        }
        if ((v = this.NetProperties.getProperty(POST_UPDATE_PERIOD)) != null) {
            try {
                long lv4 = Long.valueOf(v);
                this.Updater.setPostUpdatePeriod(lv4);
            }
            catch (Exception lv4) {
                // empty catch block
            }
        }
        if ((v = this.NetProperties.getProperty(NETWORK_UPDATE_PERIOD)) != null) {
            try {
                long lv5 = Long.valueOf(v);
                this.Updater.setNetworkUpdatePeriod(lv5);
            }
            catch (Exception lv5) {
                // empty catch block
            }
        }
        if ((v = this.NetProperties.getProperty(NETWORKAUTH_UPDATE_PERIOD)) != null) {
            try {
                long lv6 = Long.valueOf(v);
                this.Updater.setNetworkAuthUpdatePeriod(lv6);
            }
            catch (Exception lv6) {
                // empty catch block
            }
        }
        if ((v = this.NetProperties.getProperty(PUBLICPOST_UPDATE_PERIOD)) != null) {
            try {
                long lv7 = Long.valueOf(v);
                this.Updater.setPublicPostUpdatePeriod(lv7);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void loadPeerSeeds(File f) {
        if (f != null && f.exists()) {
            try {
                List<Peer> peerlist = DumbMIME.readPeers(f);
                for (Peer p : peerlist) {
                    this.CoreUser.addLocalPeer(p);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeMyPeerData(File f) {
        Peer pr = this.CoreDB.getMyPeerData().getPeer().getPeer();
        try {
            DumbMIME.writePeerFile(f, pr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private synchronized void Shutdown() {
        this.Closed = true;
        this.saveProperties();
        if (this.Updater != null) {
            this.Updater.Close();
        }
        if (this.Com != null) {
            this.Com.Close();
        }
        if (this.FileHandler != null) {
            this.FileHandler.Close();
        }
        if (this.CoreDB != null) {
            this.CoreDB.Close();
        }
        this.notifyAll();
    }

    public void saveProperties() {
        try {
            FileOutputStream fos;
            if (this.NetProperties != null) {
                File netpropsfile = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + NODE_PROPS_FILE);
                fos = new FileOutputStream(netpropsfile);
                this.NetProperties.store(fos, "Node properties.");
                fos.close();
            }
            if (this.I2PProperties != null) {
                File i2pprops = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + I2P_PROPS_FILE);
                fos = new FileOutputStream(i2pprops);
                this.I2PProperties.store(fos, "I2P Properties.");
                fos.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not save properties.", e);
        }
    }

    private String getStdInput(BufferedReader br, String defval) throws IOException {
        String inp = br.readLine();
        Matcher m = Pattern.compile("\\S+").matcher(inp);
        if (m.find()) {
            return inp;
        }
        return defval;
    }

    private void guidedSetup() {
        if (NOTSETSTRING.equals(this.NetProperties.getProperty(NETWORK_HOST))) {
            try {
                String v;
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String inp = null;
                Matcher m = null;
                while (m == null || !m.find()) {
                    System.out.println("Please choose a nickname: ");
                    inp = br.readLine();
                    m = Pattern.compile("\\S+").matcher(inp);
                }
                this.NetProperties.setProperty(PEER_NICKNAME, inp);
                m = null;
                while (m == null || !m.find()) {
                    System.out.println("Short introduction: ");
                    inp = br.readLine();
                    m = Pattern.compile("\\S+").matcher(inp);
                }
                this.NetProperties.setProperty(PEER_INTRO, inp);
                String mode = "";
                while (!(mode.equals("1") || mode.equals("2") || mode.equals("3"))) {
                    System.out.println("Please select the mode:");
                    System.out.println("1) I2P");
                    System.out.println("2) Proxy (TOR)");
                    System.out.println("3) Open");
                    mode = br.readLine();
                }
                if (mode.equals("1")) {
                    this.NetProperties.setProperty(NETWORKMODE, NETWORK_I2P);
                }
                if (mode.equals("2")) {
                    this.NetProperties.setProperty(NETWORKMODE, NETWORK_SOCKS);
                    System.out.println("Socks proxy address (127.0.0.1): ");
                    v = this.getStdInput(br, "127.0.0.1");
                    this.NetProperties.setProperty(SOCKS_HOST, v);
                    System.out.println("Socks proxy port (9050), tor uses 9150 on OSx and Linux: ");
                    v = this.getStdInput(br, "9050");
                    this.NetProperties.setProperty(SOCKS_PORT, v);
                }
                if (mode.equals("2") || mode.equals("3")) {
                    m = null;
                    while (m == null || !m.find()) {
                        System.out.println("Hostname:");
                        inp = br.readLine();
                        m = Pattern.compile("\\S+").matcher(inp);
                    }
                    this.NetProperties.setProperty(NETWORK_HOST, inp);
                    System.out.println("Port (" + DEFAULT_PORT + "): ");
                    v = this.getStdInput(br, DEFAULT_PORT);
                    this.NetProperties.setProperty(NETWORK_PORT, v);
                    this.NetProperties.setProperty(NETWORK_EXTERNAL_PORT, v);
                }
                if (mode.equals("1")) {
                    System.out.println("Seed file (" + I2P_SEED_FILE + "): ");
                    v = this.getStdInput(br, I2P_SEED_FILE);
                    this.SeedPeers = new File(v);
                }
                if (mode.equals("2")) {
                    System.out.println("Seed file (" + TOR_SEED_FILE + "): ");
                    v = this.getStdInput(br, TOR_SEED_FILE);
                    this.SeedPeers = new File(v);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void loadProperties() {
        try {
            this.NetProperties = new Properties();
            File netpropsfile = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + NODE_PROPS_FILE);
            FileInputStream fis = new FileInputStream(netpropsfile);
            this.NetProperties.load(fis);
            fis.close();
            this.I2PProperties = new Properties();
            File i2pprops = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + I2P_PROPS_FILE);
            if (i2pprops.exists()) {
                fis = new FileInputStream(i2pprops);
                this.I2PProperties.load(fis);
                fis.close();
            } else {
                i2pprops.createNewFile();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load properties.", e);
        }
    }

    private String getDownloadDefaultDir() {
        String dir = this.NetProperties.getProperty(DOWNLOAD_DEFAULT_DIR);
        if (dir != null) {
            return dir;
        }
        return String.valueOf(this.NodeDir.getPath()) + File.separator + "downloads";
    }

    private long getDownloadDefaultPriority() {
        String n = this.NetProperties.getProperty(DOWNLOAD_DEFAULT_PRIORITY);
        if (n != null) {
            try {
                return Long.valueOf(n);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 10L;
    }

    private int getMaxConnections() {
        String maxstr = this.NetProperties.getProperty(MAX_CONNECTIONS);
        if (maxstr != null) {
            try {
                return Integer.valueOf(maxstr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 100;
    }

    private int getTimeConnectedSteps() {
        String tcs = this.NetProperties.getProperty(TIME_CON_STEPS);
        if (tcs != null) {
            try {
                return Integer.valueOf(tcs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 5;
    }

    private long getTimeConnectedStepSize() {
        String ss = this.NetProperties.getProperty(TIME_CON_STEP_SIZE);
        if (ss != null) {
            try {
                return Long.valueOf(ss);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 86400000L;
    }

    private long getProcessLoopDelay() {
        String ps = this.NetProperties.getProperty(PROCESS_LOOP_DELAY);
        if (ps != null) {
            try {
                return Long.valueOf(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 5000L;
    }

    private long getReDispatchTime() {
        String ps = this.NetProperties.getProperty(REDISPATCH_TIME);
        if (ps != null) {
            try {
                return Long.valueOf(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 600000L;
    }

    private long getReConnectTime() {
        String ps = this.NetProperties.getProperty(RECONNECT_TIME);
        if (ps != null) {
            try {
                return Long.valueOf(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 120000L;
    }

    private long getReRequestTime() {
        String ps = this.NetProperties.getProperty(REREQUEST_TIME);
        if (ps != null) {
            try {
                return Long.valueOf(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 120000L;
    }

    private int getMaxBatchRequests() {
        String ps = this.NetProperties.getProperty(MAX_BATCH_REQUESTS);
        if (ps != null) {
            try {
                return Integer.valueOf(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 10;
    }

    private void initNode(OFSConnector connector, OFSServerSocket serversocket) throws IOException {
        this.Connector = connector;
        this.ServerSocket = serversocket;
        this.Crypto = new CryptoDataBaseImpl();
        this.ComCrypto = new CryptoComImpl();
        try {
            this.CoreDB = new DataBaseCoreImplH2(this.NodeDir.getPath());
        }
        catch (SQLException e) {
            System.out.println("Failed to start the database: " + e.getMessage());
            System.exit(1);
        }
        this.CoreCom = new CoreComImpl();
        this.CoreUser = new CoreUserImpl();
        this.Time = new TimeImpl();
        this.Event = new EventDispatcher();
        this.CoreCom.setEventDispatcher(this.Event);
        this.CoreUser.setEventInterface(this.Event);
        this.CoreUser.setCoreCom(this.CoreCom);
        this.CoreUser.setCoreDB(this.CoreDB);
        this.CoreUser.setCrypto(this.Crypto);
        this.CoreUser.setTime(this.Time);
        this.CoreUser.setTemplateDir(this.TemplateDir);
        this.CoreCom.setTemplateDir(this.TemplateDir);
        this.CoreCom.setCoreDB(this.CoreDB);
        this.CoreCom.setCoreUser(this.CoreUser);
        this.CoreCom.setCrypto(this.Crypto);
        this.CoreCom.setMaxConnections(this.getMaxConnections());
        this.CoreCom.setNumberTimeConnectedSteps(this.getTimeConnectedSteps());
        this.CoreCom.setTimeConnectedSteps(this.getTimeConnectedStepSize());
        this.CoreCom.setReDispatchTime(this.getReDispatchTime());
        this.CoreCom.setMaxBatchRequests(this.getMaxBatchRequests());
        this.CoreCom.setReRequestTime(this.getReRequestTime());
        this.CoreCom.setReConnectTime(this.getReConnectTime());
        this.CoreCom.setTime(this.Time);
        this.CoreCom.setRandom(SecurityTools.Random);
        this.Com = new ComConnectionImpl(this.CoreCom, this.CoreDB, this.ComCrypto, this.ServerSocket, this.Connector, this.NodeDir);
        this.Com.setExitOnServerFail(true);
        this.CoreCom.setCom(this.Com);
        this.CoreUser.setCom(this.Com);
        if (this.CoreDB.getMyPeerData() == null) {
            this.CoreUser.generateNewKeys();
        }
        this.FileHandler = new FileHandler(String.valueOf(this.NodeDir.getPath()) + File.separator + "metafiles", this.CoreDB, this.CoreUser, this.CoreCom);
        this.FileHandler.setTime(this.Time);
        this.Event.addEventListener(this.FileHandler);
        File dd = new File(this.getDownloadDefaultDir());
        dd.mkdirs();
        if (!dd.isDirectory()) {
            throw new RuntimeException("Default download dir is not a dir: " + dd);
        }
        this.FileHandler.setDefaultDownloadDir(dd);
        this.FileHandler.setDefaultPriority(this.getDownloadDefaultPriority());
        this.CoreUser.init();
        this.doPostStartUpdate();
    }

    private void mkNodeDir(String nodedir) {
        this.NodeDir = new File(nodedir);
        if (this.NodeDir.exists()) {
            if (!this.NodeDir.isDirectory()) {
                throw new RuntimeException("Node dir: " + nodedir + " is not a directory!");
            }
        } else {
            this.NodeDir.mkdirs();
            File nodeprops = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + NODE_PROPS_FILE);
            File i2pprops = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + I2P_PROPS_FILE);
            try {
                nodeprops.createNewFile();
                i2pprops.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.TemplateDir = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + "templates");
        if (this.TemplateDir.exists()) {
            if (!this.TemplateDir.isDirectory()) {
                throw new RuntimeException("Expecting a directory: " + this.TemplateDir);
            }
        } else {
            this.TemplateDir.mkdirs();
        }
    }

    private synchronized void ProcessDelay() {
        if (!this.Closed) {
            try {
                this.wait(this.ProcDelay);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setDebug(boolean debug) {
        if (!debug) {
            ComConnectionImpl.Log.setLevel(Level.SEVERE);
            ComPeerImpl.Log.setLevel(Level.SEVERE);
            SimpleServerSocket.Log.setLevel(Level.SEVERE);
            CoreComImpl.Log.setLevel(Level.SEVERE);
            CoreUserImpl.Log.setLevel(Level.SEVERE);
            DataBaseLuceneIndexer.Log.setLevel(Level.SEVERE);
            DataBaseQueryH2.Log.setLevel(Level.SEVERE);
            org.ourfilesystem.filehandler.FileHandler.Log.setLevel(Level.SEVERE);
            CryptoDataBaseImpl.Log.setLevel(Level.SEVERE);
            FileStatusTableModel.Log.setLevel(Level.SEVERE);
            FileUtils.Log.setLevel(Level.SEVERE);
        } else {
            ComConnectionImpl.Log.setLevel(Level.INFO);
            ComPeerImpl.Log.setLevel(Level.INFO);
            SimpleServerSocket.Log.setLevel(Level.INFO);
            CoreComImpl.Log.setLevel(Level.INFO);
            CoreUserImpl.Log.setLevel(Level.INFO);
            DataBaseLuceneIndexer.Log.setLevel(Level.INFO);
            DataBaseQueryH2.Log.setLevel(Level.INFO);
            org.ourfilesystem.filehandler.FileHandler.Log.setLevel(Level.INFO);
            CryptoDataBaseImpl.Log.setLevel(Level.INFO);
            FileStatusTableModel.Log.setLevel(Level.INFO);
            FileUtils.Log.setLevel(Level.INFO);
        }
    }

    @Override
    public void run() {
        while (!this.Closed) {
            this.ProcessDelay();
            if (this.Closed) continue;
            this.CoreCom.process();
        }
    }

    public void startNode(String[] args) {
        Options opt = new Options();
        opt.addOption("help", false, "Print the help.");
        opt.addOption("dir", true, "The data directory for the node.");
        opt.addOption("i2p", false, "Configure default options for I2P.");
        opt.addOption("tor", false, "Configure default options for TOR.");
        opt.addOption("host", true, "The hostname/ip advertised to other nodes.");
        opt.addOption("port", true, "The port for this node to listen.");
        opt.addOption("extport", true, "The external port advertised to other nodes.");
        opt.addOption("i2phost", true, "The i2p tcp host.");
        opt.addOption("i2pport", true, "The i2p tcp port.");
        opt.addOption("proxy", true, "The proxy hostname.");
        opt.addOption("proxyport", true, "The proxy port.");
        opt.addOption("nickname", true, "Your nickname.");
        opt.addOption("intro", true, "Your introduction.");
        opt.addOption("constepsize", true, "Time steps used when determining to which peers to connect.");
        opt.addOption("consteps", true, "The number of steps back when determinging to which peers to connect.");
        opt.addOption("processdelay", true, "The delay to take between processing loops.");
        opt.addOption("seedpeer", true, "Add information about another peer.");
        opt.addOption("gui", false, "Show the GUI.");
        opt.addOption("debug", false, "Debug output");
        opt.addOption("guided", false, "Guided commandline setup");
        GnuParser parser = new GnuParser();
        try {
            String peerf;
            String processdelay;
            String consteps;
            String constepsize;
            String intro;
            String nickname;
            String i2pport;
            String i2phost;
            String extport;
            String proxyport;
            String proxyaddr;
            String portstr;
            CommandLine cmd = parser.parse(opt, args);
            if (cmd.hasOption("help")) {
                String header = "Start an OFS node.\n\n";
                String footer = "\nPlease report issues at http://sourceforge.net/p/ourfilesystem/tickets/";
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("OurFileSystem", header, opt, footer, true);
                System.exit(1);
            }
            System.out.println(Licenses.getLicense());
            if (cmd.hasOption("debug")) {
                this.setDebug(true);
            } else {
                this.setDebug(false);
            }
            String dir = cmd.getOptionValue("dir");
            if (dir == null) {
                dir = "ofsdata";
            }
            this.mkNodeDir(dir);
            this.checkVersion();
            this.loadProperties();
            String host = cmd.getOptionValue("host");
            if (host != null) {
                this.NetProperties.setProperty(NETWORK_HOST, host);
            }
            if ((portstr = cmd.getOptionValue("port")) != null) {
                this.NetProperties.setProperty(NETWORK_PORT, portstr);
            }
            if (this.NetProperties.getProperty(NETWORK_PORT) == null) {
                this.NetProperties.setProperty(NETWORK_PORT, DEFAULT_PORT);
            }
            if (cmd.hasOption("i2p")) {
                this.NetProperties.setProperty(NETWORKMODE, NETWORK_I2P);
            }
            if (cmd.hasOption("tor")) {
                this.NetProperties.setProperty(NETWORKMODE, NETWORK_SOCKS);
                this.NetProperties.setProperty(SOCKS_HOST, "127.0.0.1");
                this.NetProperties.setProperty(SOCKS_PORT, "9050");
            }
            if (this.NetProperties.getProperty(NETWORKMODE) == null) {
                this.NetProperties.setProperty(NETWORKMODE, NETWORK_NAKED);
                if (this.NetProperties.getProperty(NETWORK_HOST) == null) {
                    this.NetProperties.setProperty(NETWORK_HOST, NOTSETSTRING);
                }
            }
            if ((proxyaddr = cmd.getOptionValue("proxy")) != null) {
                this.NetProperties.setProperty(NETWORKMODE, NETWORK_SOCKS);
                this.NetProperties.setProperty(SOCKS_HOST, proxyaddr);
            }
            if ((proxyport = cmd.getOptionValue("proxyport")) != null) {
                this.NetProperties.setProperty(SOCKS_PORT, proxyport);
            }
            if ((extport = cmd.getOptionValue("extport")) != null) {
                this.NetProperties.setProperty(NETWORK_EXTERNAL_PORT, extport);
            }
            if (this.NetProperties.getProperty(NETWORK_EXTERNAL_PORT) == null) {
                this.NetProperties.setProperty(NETWORK_EXTERNAL_PORT, this.NetProperties.getProperty(NETWORK_PORT));
            }
            if ((i2phost = cmd.getOptionValue("i2phost")) != null) {
                this.I2PProperties.setProperty("i2cp.tcp.host", i2phost);
            }
            if ((i2pport = cmd.getOptionValue("i2pport")) != null) {
                this.I2PProperties.setProperty("i2cp.tcp.port", i2pport);
            }
            if ((nickname = cmd.getOptionValue("nickname")) != null) {
                this.NetProperties.setProperty(PEER_NICKNAME, nickname);
            }
            if (this.NetProperties.getProperty(PEER_NICKNAME) == null) {
                this.NetProperties.setProperty(PEER_NICKNAME, NOTSETSTRING);
            }
            if ((intro = cmd.getOptionValue("intro")) != null) {
                this.NetProperties.setProperty(PEER_INTRO, intro);
            }
            if (this.NetProperties.getProperty(PEER_INTRO) == null) {
                this.NetProperties.setProperty(PEER_INTRO, NOTSETSTRING);
            }
            if ((constepsize = cmd.getOptionValue("constepsize")) != null) {
                this.NetProperties.setProperty(TIME_CON_STEP_SIZE, constepsize);
            }
            if ((consteps = cmd.getOptionValue("consteps")) != null) {
                this.NetProperties.setProperty(TIME_CON_STEPS, consteps);
            }
            if ((processdelay = cmd.getOptionValue("processdelay")) != null) {
                this.NetProperties.setProperty(PROCESS_LOOP_DELAY, processdelay);
            }
            if ((peerf = cmd.getOptionValue("seedpeer")) != null) {
                this.SeedPeers = new File(peerf);
            }
            if (cmd.hasOption("guided")) {
                this.guidedSetup();
            }
            System.out.println("Starting your node.  Please be patient....");
            this.initNode();
            if (cmd.hasOption("gui")) {
                this.setGui(new Gui(this));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        Main m = new Main();
        m.startNode(args);
    }

    public CryptoDataBaseImpl getCrypto() {
        return this.Crypto;
    }

    public CryptoComImpl getComCrypto() {
        return this.ComCrypto;
    }

    public DataBaseCoreImplH2 getCoreDB() {
        return this.CoreDB;
    }

    public ComConnectionImpl getCom() {
        return this.Com;
    }

    public CoreComImpl getCoreCom() {
        return this.CoreCom;
    }

    public CoreUserImpl getCoreUser() {
        return this.CoreUser;
    }

    public FileHandler getFileHandler() {
        return this.FileHandler;
    }

    public OFSConnector getConnector() {
        return this.Connector;
    }

    public Properties getNetProperties() {
        return this.NetProperties;
    }

    public Properties getI2PProperties() {
        return this.I2PProperties;
    }

    public Updater getUpdater() {
        return this.Updater;
    }

    public Gui getGui() {
        return this.Gui;
    }

    public void setGui(Gui gui) {
        this.Gui = gui;
    }

    public EventDispatcher getEvent() {
        return this.Event;
    }

    private void checkVersion() {
        File f = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + VERSION_FILE);
        if (f.exists()) {
            try {
                FileInputStream fis = new FileInputStream(f);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String oldversion = br.readLine();
                br.close();
                if (!oldversion.equals(CURRENT_VERSION)) {
                    this.doUpgrade(oldversion);
                }
            }
            catch (Exception e) {
                System.out.println("Problems upgrading.");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void writeVersion() {
        File f = new File(String.valueOf(this.NodeDir.getPath()) + File.separator + VERSION_FILE);
        try {
            PrintWriter pw = new PrintWriter(f);
            pw.println(CURRENT_VERSION);
            pw.close();
        }
        catch (Exception e) {
            System.out.println("Problems writing the version file: " + f.getPath());
            System.exit(1);
        }
    }

    private String doUpgrade072(String version) throws SQLException {
        boolean doup = false;
        int c = 0;
        while (!doup && c < DO_0_7_2_UPGRADE.length) {
            if (DO_0_7_2_UPGRADE[c].equals(version)) {
                doup = true;
            }
            ++c;
        }
        if (doup) {
            UpgradeTo072DB.doUpgrade(this.NodeDir.getPath());
            return VERSION_0_7_2;
        }
        return version;
    }

    private String doUpgrade073(String version) throws SQLException {
        boolean doup = false;
        int c = 0;
        while (!doup && c < DO_0_7_3_UPGRADE.length) {
            if (DO_0_7_3_UPGRADE[c].equals(version)) {
                doup = true;
            }
            ++c;
        }
        if (doup) {
            UpgradeTo073DB.doUpgrade(this.NodeDir.getPath());
            return VERSION_0_7_3;
        }
        return version;
    }

    private String doUpgrade080(String version) throws Exception {
        int c = 0;
        while (!this.DO08UPDATE && c < DO_0_8_0_UPGRADE.length) {
            if (DO_0_8_0_UPGRADE[c].equals(version)) {
                this.DO08UPDATE = true;
            }
            ++c;
        }
        if (this.DO08UPDATE) {
            UpgradeTo08DB.doUpgrade(this.NodeDir.getPath());
            return VERSION_0_8_0;
        }
        return version;
    }

    private void doUpgrade(String oldversion) throws Exception {
        System.out.println("UPGRADE: " + oldversion + " TO: " + CURRENT_VERSION);
        boolean compatable = false;
        int cnt = 0;
        while (cnt < COMPATABLE_VERSIONS.length && !compatable) {
            compatable = COMPATABLE_VERSIONS[cnt].equals(oldversion);
            ++cnt;
        }
        if (!compatable) {
            System.out.println("I'm sorry.  This version (" + CURRENT_VERSION + ") is not compatable with your old version (" + oldversion + ")");
            System.out.println("Please just create a new installation.");
            System.exit(1);
        }
        oldversion = this.doUpgrade072(oldversion);
        oldversion = this.doUpgrade073(oldversion);
        oldversion = this.doUpgrade080(oldversion);
    }

    private void doPostStartUpdate() {
        if (this.DO08UPDATE) {
            UpgradeTo08DB.doPostStartUpdate(this);
        }
        this.writeVersion();
    }

    public File getNodeDir() {
        return this.NodeDir;
    }
}

