/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.TopDocsCacheQueryResultsAbstract;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.ui.NewPublicPostDialog;
import org.ourfilesystem.utilities.BBytes;

public class PublicPostQueryResultsH2
extends TopDocsCacheQueryResultsAbstract {
    private DataBaseCoreImplH2 DB;

    public PublicPostQueryResultsH2(TopDocs t, IndexSearcher s, DirectoryReader reader, DataBaseCoreImplH2 db) {
        super(t, s, reader);
        this.DB = db;
    }

    @Override
    public Object getHits(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                StoredField lf = (StoredField)d.getField(DataBaseLuceneIndexer.PUBLIC_POST_ID_STR);
                if (lf != null) {
                    BBytes lfb = new BBytes(lf.binaryValue().bytes);
                    LocalPublicPost lp = this.DB.getLocalPublicPost(lfb);
                    IndexableField ilf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_OPENED);
                    if (ilf != null) {
                        lp.setOpened(ilf.stringValue().equals("1"));
                    }
                    return lp;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> getMap(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Number n;
                HashMap<String, Object> data = new HashMap<String, Object>();
                Document d = this.getSearcher().doc(sd.doc);
                IndexableField lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_CREATOR_STR);
                if (lf != null) {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_CREATOR_STR, lf.stringValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_TOPEER_STR)) != null) {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_TOPEER_STR, lf.stringValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_SUBJECT_STR)) != null) {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_SUBJECT_STR, lf.stringValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_GROUP_STR)) != null) {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_GROUP_STR, lf.stringValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_CDATE)) != null) {
                    n = lf.numericValue();
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_CDATE, new Date(n.longValue()));
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_DATE)) != null) {
                    n = lf.numericValue();
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_DATE, new Date(n.longValue()));
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_PEERRANK)) != null) {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_PEERRANK, lf.numericValue().longValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.PUBLIC_POST_OPENED)) != null) {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_OPENED, lf.stringValue().equals("1"));
                } else {
                    data.put(DataBaseLuceneIndexer.PUBLIC_POST_OPENED, false);
                }
                return data;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> obj2Fields(Object obj) {
        if (obj != null && obj instanceof LocalPublicPost) {
            Object m;
            LocalPublicPost lp = (LocalPublicPost)obj;
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (lp.getDecodedMessage() != null) {
                String str = (String)lp.getDecodedMessage();
                String[] prg = str.split(NewPublicPostDialog.SUBJECTBODY);
                data.put(DataBaseLuceneIndexer.PUBLIC_POST_SUBJECT_STR, prg[0]);
            }
            if ((m = lp.getPublicPost().getMessage()) != null && m instanceof String) {
                String str = (String)m;
                String[] prg = str.split(NewPublicPostDialog.SUBJECTBODY);
                data.put(DataBaseLuceneIndexer.PUBLIC_POST_SUBJECT_STR, prg[0]);
            }
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_CREATOR_STR, lp.getCreator());
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_TOPEER_STR, lp.getToPeer());
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_GROUP_STR, lp.getNetworkTitle());
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_CDATE, lp.getPublicPost().getRDate());
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_DATE, lp.getLocalDate());
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_PEERRANK, lp.getPeerRank());
            data.put(DataBaseLuceneIndexer.PUBLIC_POST_OPENED, lp.isOpened());
            return data;
        }
        return null;
    }
}

