/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ConnectionStatements {
    public Connection Con;
    private Map<String, PreparedStatement> StatementCache = new HashMap<String, PreparedStatement>();
    public static int LIMIT_ALL_QUERIES = 10000;
    public static Map<String, String> StaticSQL = null;
    public static Map<String, Integer> StaticMode = null;

    public PreparedStatement getStatement(String key, String statement) {
        PreparedStatement ps = this.StatementCache.get(key);
        if (ps == null) {
            try {
                ps = this.Con.prepareStatement(statement);
                this.StatementCache.put(key, ps);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ps;
    }

    public PreparedStatement getStatement(String key, String statement, int mode) {
        PreparedStatement ps = this.StatementCache.get(key);
        if (ps == null) {
            try {
                ps = this.Con.prepareStatement(statement, mode);
                this.StatementCache.put(key, ps);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return ps;
    }

    public PreparedStatement getStatement(String key) {
        PreparedStatement ps = this.StatementCache.get(key);
        if (ps == null) {
            String sql;
            if (StaticSQL == null) {
                ConnectionStatements.BuildSQL();
            }
            if ((sql = StaticSQL.get(key)) == null) {
                throw new RuntimeException("Statement not found: " + key);
            }
            Integer mv = StaticMode.get(key);
            ps = mv == null ? this.getStatement(key, sql) : this.getStatement(key, sql, mv);
        }
        return ps;
    }

    public static void BuildSQL() {
        StaticSQL = new HashMap<String, String>();
        StaticMode = new HashMap<String, Integer>();
        StaticSQL.put("savePeerHasFile", "MERGE INTO PEERHASFILE KEY ( PEERID, NETWORKID, DIGEST ) VALUES ( ?, ?, ?, ?, ?  )");
        StaticSQL.put("getPeerHasFile", "SELECT DIGEST, NETWORKID, PEERHASFILEB, LASTMESSAGE, PEERID FROM PEERHASFILE WHERE PEERID = ? AND NETWORKID = ? AND DIGEST = ?");
        StaticSQL.put("getPeersHaveFile", "SELECT DIGEST, NETWORKID, PEERHASFILEB, LASTMESSAGE, PEERID FROM PEERHASFILE WHERE NETWORKID = ? AND DIGEST = ?");
        StaticSQL.put("getOrderedMostFilesMostPostsLastDate", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE LASTNEWFILE >= ? AND NETWORKID = ? ORDER BY NUMBEROFFILES DESC, NUMBEROFNEWPOSTS DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedMostPostsLastDate", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE LASTNEWFILE >= ? AND NETWORKID = ? ORDER BY NUMBEROFNEWPOSTS DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedMostNetworksLastDate", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE LASTNEWNETWORK > ? ORDER BY NUMBEROFNEWNETWORKS DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedMostPublicPostsLastDate", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE LASTNEWPUBLICPOST > ? ORDER BY NUMBEROFNEWPUBLICPOSTS DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedMostPeersLastDate", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE LASTNEWPEER > ? AND REQUESTPEERS = TRUE ORDER BY NUMBEROFNEWPEERS DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("saveMyPeerData", "MERGE INTO MYPEERDATASO KEY ( ALWAYSZERO ) VALUES ( 0 ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? )");
        StaticSQL.put("getMyPeerData", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,PRIVSIGNDP                            ,PRIVSIGNDQ                            ,PRIVSIGNEXPONENT                      ,PRIVSIGNMODULUS                       ,PRIVSIGNP                             ,PRIVSIGNPUBLICEXPONENT                ,PRIVSIGNQ                             ,PRIVSIGNQINV                          ,PRIVENCDP                             ,PRIVENCDQ                             ,PRIVENCEXPONENT                       ,PRIVENCMODULUS                        ,PRIVENCP                              ,PRIVENCPUBLICEXPONENT                 ,PRIVENCQ                              ,PRIVENCQINV                           ,RDATE                                 ,RANK                                   FROM MYPEERDATASO WHERE ALWAYSZERO = 0");
        StaticSQL.put("getFiles", "SELECT USERREQUESTED           , USERREQUESTTIME         , USERREQUESTPRIORITY     , USERREQUESTDISPATCHED   , USERREQUESTDISPATCHTIME , FILEEXISTS              , LOCALDATE               , NETWORKID               , UNSIGNEDDIGEST          , FILE                    , OFFSET                  , SIZE                      FROM FILEREFERENCE WHERE NETWORKID = ? AND UNSIGNEDDIGEST = ?");
        StaticSQL.put("getFile", "SELECT USERREQUESTED           , USERREQUESTTIME         , USERREQUESTPRIORITY     , USERREQUESTDISPATCHED   , USERREQUESTDISPATCHTIME , FILEEXISTS              , LOCALDATE               , NETWORKID               , UNSIGNEDDIGEST          , FILE                    , OFFSET                  , SIZE                      FROM FILEREFERENCE WHERE NETWORKID = ? AND UNSIGNEDDIGEST = ? AND FILE = ? AND OFFSET = ? AND SIZE = ?");
        StaticSQL.put("getFilesRequested", "SELECT USERREQUESTED           , USERREQUESTTIME         , USERREQUESTPRIORITY     , USERREQUESTDISPATCHED   , USERREQUESTDISPATCHTIME , FILEEXISTS              , LOCALDATE               , NETWORKID               , UNSIGNEDDIGEST          , FILE                    , OFFSET                  , SIZE                      FROM FILEREFERENCE WHERE UNSIGNEDDIGEST = ?");
        StaticSQL.put("getFilesForFile", "SELECT USERREQUESTED           , USERREQUESTTIME         , USERREQUESTPRIORITY     , USERREQUESTDISPATCHED   , USERREQUESTDISPATCHTIME , FILEEXISTS              , LOCALDATE               , NETWORKID               , UNSIGNEDDIGEST          , FILE                    , OFFSET                  , SIZE                      FROM FILEREFERENCE WHERE FILE = ?");
        StaticSQL.put("saveFileReference", "MERGE INTO FILEREFERENCE KEY ( NETWORKID, UNSIGNEDDIGEST, FILE ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("getOrderedFilesRequestedNotDispatched", "SELECT USERREQUESTED           , USERREQUESTTIME         , USERREQUESTPRIORITY     , USERREQUESTDISPATCHED   , USERREQUESTDISPATCHTIME , FILEEXISTS              , LOCALDATE               , NETWORKID               , UNSIGNEDDIGEST          , FILE                    , OFFSET                  , SIZE                      FROM FILEREFERENCE WHERE USERREQUESTED = TRUE AND USERREQUESTDISPATCHED = FALSE ORDER BY USERREQUESTPRIORITY DESC, USERREQUESTTIME ASC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getPost0", "SELECT LOCALDATE           ,CREATOR             ,PUSHREQUESTED       ,RECEIVEDFROMPEER    ,PEERRANK            ,LOCALFILE           ,NETWORKID           ,MESSAGETYPE         ,MESSAGEID           ,FILEREFERENCEDIGEST ,POSTERHASFILE       ,POSTNUMBER          ,DIGEST              ,SEERIDENTIFIER      ,SIGNATURE           ,RDATE                FROM LOCALPOST WHERE DIGEST = ? ");
        StaticSQL.put("getPost1", "SELECT LOCALDATE           ,CREATOR             ,PUSHREQUESTED       ,RECEIVEDFROMPEER    ,PEERRANK            ,LOCALFILE           ,NETWORKID           ,MESSAGETYPE         ,MESSAGEID           ,FILEREFERENCEDIGEST ,POSTERHASFILE       ,POSTNUMBER          ,DIGEST              ,SEERIDENTIFIER      ,SIGNATURE           ,RDATE                FROM LOCALPOST WHERE NETWORKID = ? AND SEERIDENTIFIER = ? AND POSTNUMBER = ? ");
        StaticSQL.put("getOrderedFilesRequestedAndDispatched", "SELECT USERREQUESTED           , USERREQUESTTIME         , USERREQUESTPRIORITY     , USERREQUESTDISPATCHED   , USERREQUESTDISPATCHTIME , FILEEXISTS              , LOCALDATE               , NETWORKID               , UNSIGNEDDIGEST          , FILE                    , OFFSET                  , SIZE                      FROM FILEREFERENCE WHERE USERREQUESTED = TRUE AND USERREQUESTDISPATCHED = TRUE ORDER BY USERREQUESTDISPATCHTIME DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedPublicPostsRequestedAndDispatched", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE REQUESTPUBLICPOSTS = TRUE AND REQUESTPUBLICPOSTSDISPATCHED = TRUE ORDER BY REQUESTPUBLICPOSTSDISPATCHEDTIME ASC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedPostsRequestedAndDispatched", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE REQUESTPOSTS = TRUE AND REQUESTPOSTSDISPATCHED = TRUE ORDER BY REQUESTPOSTSDISPATCHEDTIME ASC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedNetworkAuthsRequestedAndDispatched", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE REQUESTAUTHS = TRUE AND REQUESTAUTHSDISPATCHED = TRUE ORDER BY REQUESTAUTHSDISPATCHEDTIME ASC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedNetworksRequestedAndDispatched", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE REQUESTNETWORKS = TRUE AND REQUESTNETWORKSDISPATCHED = TRUE ORDER BY REQUESTNETWORKSDISPATCHEDTIME ASC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getNextPeerPush", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE PUSHREQUESTED = TRUE LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getLocalNetworks", "SELECT LOCALDATE         ,PUSHREQUESTED     ,RECEIVEDFROMPEER  ,CREATOR           ,AUTHORIZED        ,AUTHORIZATION     ,TITLE             ,DESCRIPTION       ,NETWORKNUMBER     ,DIGEST            ,SEERIDENTIFIER    ,SIGNATURE         ,RDATE             ,PEERRANK          ,PUBLIC            ,SUBSCRIBED         FROM LOCALNETWORK ORDER BY LOCALDATE DESC LIMIT ?");
        StaticSQL.put("getNextNetworkPush", "SELECT LOCALDATE         ,PUSHREQUESTED     ,RECEIVEDFROMPEER  ,CREATOR           ,AUTHORIZED        ,AUTHORIZATION     ,TITLE             ,DESCRIPTION       ,NETWORKNUMBER     ,DIGEST            ,SEERIDENTIFIER    ,SIGNATURE         ,RDATE             ,PEERRANK          ,PUBLIC            ,SUBSCRIBED         FROM LOCALNETWORK WHERE PUSHREQUESTED = TRUE");
        StaticSQL.put("getNextPublicPostPush", "SELECT LOCALDATE         , PRIVATEMESSAGE    , DECODEDMESSAGE    , PUSHREQUSTED      , RECEIVEDFROMPEER  , CREATOR           , TOPEER            , NETWORKTITLE      , NETWORKID         , ENCMESSAGE        , ENCRYPTED         , POSTNUMBER        , DIGEST            , SEERIDENTIFIER    , SIGNATURE         , RDATE             , PEERRANK            FROM LOCALPUBLICPOST WHERE PUSHREQUSTED = TRUE");
        StaticSQL.put("getNetworkAuthsForPeer", "SELECT LOCALDATE                   , NUMBEROFNEWAUTHS            , LASTNEWAUTHS                , REQUESTAUTHS                , REQUESTAUTHSTIME            , REQUESTAUTHSPRIORITY        , REQUESTAUTHSDISPATCHED      , REQUESTAUTHSDISPATCHEDTIME  , LASTNETWORKAUTHNUMBER       , PUSHREQUESTED               , RECEIVEDFROMPEER            , NETWORKTITLE                , PEERNICKSIG                 , SIGNERNICKSIG               , PEERID                      , NETWORKID                   , SIGNATURENUMBER             , SIGNAUTHORITY               , DIGEST                      , SEERIDENTIFIER              , SIGNATURE                   , RDATE                         FROM LOCALNETWORKAUTHORIZATION WHERE PEERID = ? ORDER BY LOCALDATE DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getNextNetworkAuthPush", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE PUSHREQUESTED = TRUE AND NETWORKID = ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getNextPostPush", "SELECT LOCALDATE           ,CREATOR             ,PUSHREQUESTED       ,RECEIVEDFROMPEER    ,PEERRANK            ,LOCALFILE           ,NETWORKID           ,MESSAGETYPE         ,MESSAGEID           ,FILEREFERENCEDIGEST ,POSTERHASFILE       ,POSTNUMBER          ,DIGEST              ,SEERIDENTIFIER      ,SIGNATURE           ,RDATE                FROM LOCALPOST WHERE NETWORKID = ? AND PUSHREQUESTED = TRUE");
        StaticSQL.put("getPeer", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE IDENTITY = ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getLocalPeers", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER ORDER BY LOCALDATE DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getPeers", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("saveLocalPeer", "MERGE INTO LOCALPEER KEY ( IDENTITY ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("deletePeer", "DELETE FROM LOCALPEER WHERE IDENTITY = ?");
        StaticSQL.put("getHighestPriorityNeteworkRequest", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE REQUESTNETWORKS = TRUE AND REQUESTNETWORKSDISPATCHED = FALSE ORDER BY REQUESTNETWORKSPRIORITY DESC LIMIT 1");
        StaticSQL.put("getPeerNetworkHoles", "SELECT ID          , PEERID      , FIRSTNUMBER , LASTNUMBER    FROM NETWORKHOLES WHERE PEERID = ?");
        StaticSQL.put("saveNetworkHoles0", "INSERT INTO NETWORKHOLES (PEERID      , FIRSTNUMBER , LASTNUMBER    ) VALUES (?, ?, ?  )");
        StaticSQL.put("saveNetworkHoles1", "MERGE INTO NETWORKHOLES KEY ( ID ) VALUES ( ? , ? , ? , ?   )");
        StaticSQL.put("deleteNetworkHoles", "DELETE FROM NETWORKHOLES WHERE ID = ? ");
        StaticSQL.put("getHighestPriorityPublicPostRequest", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE REQUESTPUBLICPOSTS = TRUE AND REQUESTPUBLICPOSTSDISPATCHED = FALSE ORDER BY REQUESTPUBLICPOSTSPRIORITY DESC LIMIT 1");
        StaticSQL.put("getPublicPostHoles0", "SELECT ID          , PEERID      , FIRSTNUMBER , LASTNUMBER    FROM PUBLICPOSTHOLES WHERE PEERID = ?");
        StaticSQL.put("savePublicPostHoles0", "INSERT INTO PUBLICPOSTHOLES (PEERID       , FIRSTNUMBER  , LASTNUMBER     ) VALUES ( ?, ?, ?  )");
        StaticSQL.put("savePublicPostHoles1", "MERGE INTO PUBLICPOSTHOLES KEY ( ID ) VALUES ( ?, ?, ?, ?  )");
        StaticSQL.put("deletePublicPostHoles", "DELETE FROM PUBLICPOSTHOLES WHERE ID = ? ");
        StaticSQL.put("getLocalPublicPost0", "SELECT LOCALDATE         , PRIVATEMESSAGE    , DECODEDMESSAGE    , PUSHREQUSTED      , RECEIVEDFROMPEER  , CREATOR           , TOPEER            , NETWORKTITLE      , NETWORKID         , ENCMESSAGE        , ENCRYPTED         , POSTNUMBER        , DIGEST            , SEERIDENTIFIER    , SIGNATURE         , RDATE             , PEERRANK            FROM LOCALPUBLICPOST WHERE DIGEST = ? ");
        StaticSQL.put("getLocalPublicPost1", "SELECT LOCALDATE         , PRIVATEMESSAGE    , DECODEDMESSAGE    , PUSHREQUSTED      , RECEIVEDFROMPEER  , CREATOR           , TOPEER            , NETWORKTITLE      , NETWORKID         , ENCMESSAGE        , ENCRYPTED         , POSTNUMBER        , DIGEST            , SEERIDENTIFIER    , SIGNATURE         , RDATE             , PEERRANK            FROM LOCALPUBLICPOST WHERE SEERIDENTIFIER = ? AND POSTNUMBER = ?");
        StaticSQL.put("getHighestPriorityPeerRequest", "SELECT LOCALDATE                             ,CONNECTIONATTEMPTS                    ,SUCCESSFULCONNECTIONATTEMPTS          ,LASTCONNECTIONTIME                    ,REQUESTS                              ,SUCCESSFULREQUESTS                    ,LASTSUCCESSREQUEST                    ,NUMBEROFNEWPEERS                      ,LASTNEWPEER                           ,REQUESTPEERS                          ,REQUESTPEERSTIME                      ,REQUESTPEERSPRIORITY                  ,NUMBEROFNEWNETWORKS                   ,LASTNEWNETWORK                        ,REQUESTNETWORKS                       ,REQUESTNETWORKSTIME                   ,REQUESTNETWORKSPRIORITY               ,REQUESTNETWORKSDISPATCHED             ,REQUESTNETWORKSDISPATCHEDTIME         ,NUMBEROFNEWPUBLICPOSTS                ,LASTNEWPUBLICPOST                     ,REQUESTPUBLICPOSTS                    ,REQUESTPUBLICPOSTSTIME                ,REQUESTPUBLICPOSTSPRIORITY            ,REQUESTPUBLICPOSTSDISPATCHED          ,REQUESTPUBLICPOSTSDISPATCHEDTIME      ,LASTPUBLICPOSTNUMBER                  ,LASTNETWORKNUMBER                     ,PUSHREQUESTED                         ,RECEIVEDFROMPEER                      ,IDENTITY                              ,SIGNEXP                               ,SIGNMOD                               ,ENCEXP                                ,ENCMOD                                ,DIGEST                                ,SEERIDENTIFIER                        ,SIGNATURE                             ,LOCATION                              ,UPDATECOUNT                           ,NICKNAME                              ,INTRODUCTION                          ,RDATE                                 ,RANK                                   FROM LOCALPEER WHERE REQUESTPEERS = TRUE ORDER BY REQUESTPEERSPRIORITY DESC LIMIT 1");
        StaticSQL.put("getNetworkAuth", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE PEERID = ? AND NETWORKID = ? ");
        StaticSQL.put("getNetworkAuths", "SELECT LOCALDATE                  , NUMBEROFNEWAUTHS           , LASTNEWAUTHS               , REQUESTAUTHS               , REQUESTAUTHSTIME           , REQUESTAUTHSPRIORITY       , REQUESTAUTHSDISPATCHED     , REQUESTAUTHSDISPATCHEDTIME , LASTNETWORKAUTHNUMBER      , PUSHREQUESTED              , RECEIVEDFROMPEER           , NETWORKTITLE               , PEERNICKSIG                , SIGNERNICKSIG              , PEERID                     , NETWORKID                  , SIGNATURENUMBER            , SIGNAUTHORITY              , DIGEST                     , SEERIDENTIFIER             , SIGNATURE                  , RDATE                        FROM LOCALNETWORKAUTHORIZATION WHERE NETWORKID = ? ");
        StaticSQL.put("getPeerNetworkAuths", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE PEERID = ? ");
        StaticSQL.put("getNetworkAuthsSignedBy", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE NETWORKID = ? AND SEERIDENTIFIER = ? ");
        StaticSQL.put("saveLocalNetworkAuth", "MERGE INTO LOCALNETWORKAUTHORIZATION KEY ( PEERID, NETWORKID ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("getOrderedNetworkAuthsRequestedNotDispatched", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE REQUESTAUTHS = TRUE AND REQUESTAUTHSDISPATCHED = FALSE ORDER BY REQUESTAUTHSPRIORITY DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("saveNetworkAuthHoles0", "INSERT INTO NETWORKAUTHHOLES (PEERID      , NETWORKID   , FIRSTNUMBER , LASTNUMBER    ) VALUES ( ?, ?, ?, ?  )");
        StaticSQL.put("saveNetworkAuthHoles1", "MERGE INTO NETWORKAUTHHOLES  KEY ( ID ) VALUES ( ?, ?, ?, ?, ?  )");
        StaticSQL.put("deleteNetworkAuthHoles", "DELETE FROM NETWORKAUTHHOLES WHERE ID = ? ");
        StaticSQL.put("getPeerNetworkAuthHoles", "SELECT ID          , PEERID      , NETWORKID   , FIRSTNUMBER , LASTNUMBER    FROM NETWORKAUTHHOLES WHERE NETWORKID = ? AND PEERID = ?");
        StaticSQL.put("getOrderedPostsRequestedNotDispatched", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE REQUESTPOSTS = TRUE AND REQUESTPOSTSDISPATCHED = FALSE ORDER BY REQUESTPOSTSPRIORITY DESC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("savePostHoles0", "INSERT INTO POSTHOLES ( PEERID      , NETWORKID   , FIRSTNUMBER , LASTNUMBER    ) VALUES ( ?, ?, ?, ?  )");
        StaticSQL.put("savePostHoles1", "MERGE INTO POSTHOLES  KEY ( ID ) VALUES (?, ?, ?, ?, ?  )");
        StaticSQL.put("deletePostHoles", "DELETE FROM POSTHOLES WHERE ID = ? ");
        StaticSQL.put("getPostHoles", "SELECT ID          , PEERID      , NETWORKID      , FIRSTNUMBER , LASTNUMBER    FROM POSTHOLES WHERE PEERID = ? AND NETWORKID = ?");
        StaticSQL.put("getNetworks", "SELECT LOCALDATE         ,PUSHREQUESTED     ,RECEIVEDFROMPEER  ,CREATOR           ,AUTHORIZED        ,AUTHORIZATION     ,TITLE             ,DESCRIPTION       ,NETWORKNUMBER     ,DIGEST            ,SEERIDENTIFIER    ,SIGNATURE         ,RDATE             ,PEERRANK          ,PUBLIC            ,SUBSCRIBED         FROM LOCALNETWORK WHERE SEERIDENTIFIER = ? AND NETWORKNUMBER >= ? AND NETWORKNUMBER <= ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getPublicPosts0", "SELECT LOCALDATE         , PRIVATEMESSAGE    , DECODEDMESSAGE    , PUSHREQUSTED      , RECEIVEDFROMPEER  , CREATOR           , TOPEER            , NETWORKTITLE      , NETWORKID         , ENCMESSAGE        , ENCRYPTED         , POSTNUMBER        , DIGEST            , SEERIDENTIFIER    , SIGNATURE         , RDATE             , PEERRANK            FROM LOCALPUBLICPOST WHERE SEERIDENTIFIER = ? AND POSTNUMBER >= ? AND POSTNUMBER <= ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getNetworkAuthorizations", "SELECT LOCALDATE                    , NUMBEROFNEWAUTHS             , LASTNEWAUTHS                 , REQUESTAUTHS                 , REQUESTAUTHSTIME             , REQUESTAUTHSPRIORITY         , REQUESTAUTHSDISPATCHED       , REQUESTAUTHSDISPATCHEDTIME   , LASTNETWORKAUTHNUMBER        , PUSHREQUESTED                , RECEIVEDFROMPEER             , NETWORKTITLE                 , PEERNICKSIG                  , SIGNERNICKSIG                , PEERID                       , NETWORKID                    , SIGNATURENUMBER              , SIGNAUTHORITY                , DIGEST                       , SEERIDENTIFIER               , SIGNATURE                    , RDATE                          FROM LOCALNETWORKAUTHORIZATION WHERE SEERIDENTIFIER = ? AND NETWORKID = ? AND SIGNATURENUMBER >= ? AND SIGNATURENUMBER <= ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getPosts0", "SELECT LOCALDATE           ,CREATOR             ,PUSHREQUESTED       ,RECEIVEDFROMPEER    ,PEERRANK            ,LOCALFILE           ,NETWORKID           ,MESSAGETYPE         ,MESSAGEID           ,FILEREFERENCEDIGEST ,POSTERHASFILE       ,POSTNUMBER          ,DIGEST              ,SEERIDENTIFIER      ,SIGNATURE           ,RDATE                FROM LOCALPOST WHERE SEERIDENTIFIER = ? AND NETWORKID = ? AND POSTNUMBER >= ? AND POSTNUMBER <= ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticMode.put("saveLocalPost0", 1);
        StaticSQL.put("saveLocalPost0", "INSERT INTO POSTMESSAGE (REF0          ,REF1          ,REF2          ,USETEMPLATE   ,BOOL0         ,BOOL1         ,BOOL2         ,BOOL3         ,BOOL4         ,BOOL5         ,BOOL6         ,BOOL7         ,BOOL8         ,BOOL9         ,NUM0          ,NUM1          ,NUM2          ,NUM3          ,NUM4          ,NUM5          ,NUM6          ,NUM7          ,NUM8          ,NUM9          ,DOUBLE0       ,DOUBLE1       ,DOUBLE2       ,DOUBLE3       ,DOUBLE4       ,DOUBLE5       ,DOUBLE6       ,DOUBLE7       ,DOUBLE8       ,DOUBLE9       ,STRING0       ,STRING1       ,STRING2       ,STRING3       ,STRING4       ,STRING5       ,STRING6       ,STRING7       ,SUBJECT       ,FILENAME      ,COMMENT        ) VALUES ( ?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?  ,?   )");
        StaticMode.put("saveLocalPost1", 1);
        StaticSQL.put("saveLocalPost1", "INSERT INTO POSTTEMPLATE (TEMPLATENAME        , TEMPLATEDESCRIPTION , REF0                , REF1                , REF2                , BOOL0               , BOOL1               , BOOL2               , BOOL3               , BOOL4               , BOOL5               , BOOL6               , BOOL7               , BOOL8               , BOOL9               , NUM0                , NUM1                , NUM2                , NUM3                , NUM4                , NUM5                , NUM6                , NUM7                , NUM8                , NUM9                , DOUBLE0             , DOUBLE1             , DOUBLE2             , DOUBLE3             , DOUBLE4             , DOUBLE5             , DOUBLE6             , DOUBLE7             , DOUBLE8             , DOUBLE9             , STRING0             , STRING1             , STRING2             , STRING3             , STRING4             , STRING5             , STRING6             , STRING7               ) VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ?   )");
        StaticSQL.put("saveLocalPost2", "MERGE INTO LOCALPOST KEY ( DIGEST ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("getPostTemplate0", "SELECT ID                  , TEMPLATENAME        , TEMPLATEDESCRIPTION , REF0                , REF1                , REF2                , BOOL0               , BOOL1               , BOOL2               , BOOL3               , BOOL4               , BOOL5               , BOOL6               , BOOL7               , BOOL8               , BOOL9               , NUM0                , NUM1                , NUM2                , NUM3                , NUM4                , NUM5                , NUM6                , NUM7                , NUM8                , NUM9                , DOUBLE0             , DOUBLE1             , DOUBLE2             , DOUBLE3             , DOUBLE4             , DOUBLE5             , DOUBLE6             , DOUBLE7             , DOUBLE8             , DOUBLE9             , STRING0             , STRING1             , STRING2             , STRING3             , STRING4             , STRING5             , STRING6             , STRING7               FROM POSTTEMPLATE WHERE ID = ?");
        StaticSQL.put("getPostMessage0", "SELECT REF0          ,REF1          ,REF2          ,USETEMPLATE   ,BOOL0         ,BOOL1         ,BOOL2         ,BOOL3         ,BOOL4         ,BOOL5         ,BOOL6         ,BOOL7         ,BOOL8         ,BOOL9         ,NUM0          ,NUM1          ,NUM2          ,NUM3          ,NUM4          ,NUM5          ,NUM6          ,NUM7          ,NUM8          ,NUM9          ,DOUBLE0       ,DOUBLE1       ,DOUBLE2       ,DOUBLE3       ,DOUBLE4       ,DOUBLE5       ,DOUBLE6       ,DOUBLE7       ,DOUBLE8       ,DOUBLE9       ,STRING0       ,STRING1       ,STRING2       ,STRING3       ,STRING4       ,STRING5       ,STRING6       ,STRING7       ,SUBJECT       ,FILENAME      ,COMMENT        FROM POSTMESSAGE WHERE ID = ?");
        StaticSQL.put("getPosts1", "SELECT LOCALDATE           ,CREATOR             ,PUSHREQUESTED       ,RECEIVEDFROMPEER    ,PEERRANK            ,LOCALFILE           ,NETWORKID           ,MESSAGETYPE         ,MESSAGEID           ,FILEREFERENCEDIGEST ,POSTERHASFILE       ,POSTNUMBER          ,DIGEST              ,SEERIDENTIFIER      ,SIGNATURE           ,RDATE                FROM LOCALPOST ORDER BY LOCALDATE DESC LIMIT ?");
        StaticSQL.put("getPostsReferencingFile", "SELECT LOCALDATE           ,CREATOR             ,PUSHREQUESTED       ,RECEIVEDFROMPEER    ,PEERRANK            ,LOCALFILE           ,NETWORKID           ,MESSAGETYPE         ,MESSAGEID           ,FILEREFERENCEDIGEST ,POSTERHASFILE       ,POSTNUMBER          ,DIGEST              ,SEERIDENTIFIER      ,SIGNATURE           ,RDATE                FROM LOCALPOST WHERE NETWORKID = ? AND FILEREFERENCEDIGEST = ?");
        StaticSQL.put("saveLocalNetwork0", "MERGE INTO LOCALNETWORK KEY ( DIGEST ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("getLocalNetwork", "SELECT LOCALDATE         ,PUSHREQUESTED     ,RECEIVEDFROMPEER  ,CREATOR           ,AUTHORIZED        ,AUTHORIZATION     ,TITLE             ,DESCRIPTION       ,NETWORKNUMBER     ,DIGEST            ,SEERIDENTIFIER    ,SIGNATURE         ,RDATE             ,PEERRANK          ,PUBLIC            ,SUBSCRIBED         FROM LOCALNETWORK WHERE DIGEST = ?");
        StaticSQL.put("saveLocalPublicPost0", "MERGE INTO LOCALPUBLICPOST KEY ( DIGEST ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("saveFileStatus0", "MERGE INTO FILESTATUS KEY ( FILE ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("getFileStatusList", "SELECT NETWORKID          , FILE               , METAFILEDIGEST     , METAFILESIZE       , COMPLETEDIGEST     , PEERID             , TOTALFILESIZE      , MASTERPOST         , PRIORITY           , NUMBERPARTS        , NUMBERPENDING      , NUMBERPARTSPRESENT , PIECEPOSTSFOUND    , CORRUPTED          , RDATE                FROM FILESTATUS WHERE NUMBERPARTSPRESENT < NUMBERPARTS");
        StaticSQL.put("getFileStatus0", "SELECT NETWORKID          , FILE               , METAFILEDIGEST     , METAFILESIZE       , COMPLETEDIGEST     , PEERID             , TOTALFILESIZE      , MASTERPOST         , PRIORITY           , NUMBERPARTS        , NUMBERPENDING      , NUMBERPARTSPRESENT , PIECEPOSTSFOUND    , CORRUPTED          , RDATE                FROM FILESTATUS WHERE FILE = ?");
        StaticSQL.put("getFileStatus0", "SELECT NETWORKID          , FILE               , METAFILEDIGEST     , METAFILESIZE       , COMPLETEDIGEST     , PEERID             , TOTALFILESIZE      , MASTERPOST         , PRIORITY           , NUMBERPARTS        , NUMBERPENDING      , NUMBERPARTSPRESENT , PIECEPOSTSFOUND    , CORRUPTED          , RDATE                FROM FILESTATUS WHERE NETWORKID = ? AND METAFILEDIGEST = ?");
        StaticSQL.put("deleteFileStatus", "DELETE FROM FILESTATUS WHERE NETWORKID = ? AND METAFILEDIGEST = ?");
        StaticSQL.put("saveSearchQuery0", "UPDATE SEARCHQUERY SET QUERYNAME                       = ? , MAXRESULTS                      = ? , SORTBY                          = ? , SORTREVERSE                     = ? , ADVANCEDQUERYSTRING             = ? , NETWORK                         = ? , PEERID                          = ? , GENERALTERMS                    = ? , TEMPLATE                        = ? , REFS0                           = ? , REFS1                           = ? , REFS2                           = ? , USETEMPLATE                     = ? , DIRECTREF                       = ? , EXCLUDEFILESREFERENCEDBYOTHERS0 = ? , INCLUDEFILESWITHREFERENCES0     = ? , EXCLUDEFILESREFERENCEDBYOTHERS1 = ? , INCLUDEFILESWITHREFERENCES1     = ? , EXCLUDEFILESREFERENCEDBYOTHERS2 = ? , INCLUDEFILESWITHREFERENCES2     = ? , MINPEERRANK                     = ? , FROMDATE                        = ? , TODATE                          = ? , DAYSBACK                        = ? , ONLYLOCAL                       = ? , HIDEOPENED                      = ?   WHERE ID = ?");
        StaticMode.put("saveSearchQuery1", 1);
        StaticSQL.put("saveSearchQuery1", "INSERT INTO SEARCHQUERY (QUERYNAME                        , MAXRESULTS                       , SORTBY                           , SORTREVERSE                      , ADVANCEDQUERYSTRING              , NETWORK                          , PEERID                           , GENERALTERMS                     , TEMPLATE                         , REFS0                            , REFS1                            , REFS2                            , USETEMPLATE                      , DIRECTREF                        , EXCLUDEFILESREFERENCEDBYOTHERS0  , INCLUDEFILESWITHREFERENCES0      , EXCLUDEFILESREFERENCEDBYOTHERS1  , INCLUDEFILESWITHREFERENCES1      , EXCLUDEFILESREFERENCEDBYOTHERS2  , INCLUDEFILESWITHREFERENCES2      , MINPEERRANK                      , FROMDATE                         , TODATE                           , DAYSBACK                         , ONLYLOCAL                        , HIDEOPENED                         ) VALUES ( ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?  , ?    )");
        StaticSQL.put("saveSearchQuery2", "DELETE FROM SEARCHTERMS WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery3", "INSERT INTO SEARCHTERMS (SEARCHID       , TEMPLATESTRING , SEARCHSTRING     ) VALUES (?, ?, ? )");
        StaticSQL.put("saveSearchQuery4", "DELETE FROM ORTRUEBOOLS WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery5", "INSERT INTO ORTRUEBOOLS (SEARCHID       , TEMPLATESTRING   ) VALUES (?, ? )");
        StaticSQL.put("saveSearchQuery6", "DELETE FROM ANDTRUEBOOLS WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery7", "INSERT INTO ANDTRUEBOOLS (SEARCHID       , TEMPLATESTRING   ) VALUES (?, ? )");
        StaticSQL.put("saveSearchQuery8", "DELETE FROM LESSTHAN WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery9", "INSERT INTO LESSTHAN (SEARCHID       , TEMPLATESTRING , NUMVALUE     ) VALUES (?, ?, ? )");
        StaticSQL.put("saveSearchQuery10", "DELETE FROM GREATERTHAN WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery11", "INSERT INTO GREATERTHAN (SEARCHID       , TEMPLATESTRING , NUMVALUE     ) VALUES (?, ?, ? )");
        StaticSQL.put("saveSearchQuery12", "DELETE FROM DLESSTHAN WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery13", "INSERT INTO DLESSTHAN (SEARCHID       , TEMPLATESTRING , NUMVALUE     ) VALUES (?, ?, ? )");
        StaticSQL.put("saveSearchQuery14", "DELETE FROM DGREATERTHAN WHERE SEARCHID = ?");
        StaticSQL.put("saveSearchQuery15", "INSERT INTO DGREATERTHAN (SEARCHID       , TEMPLATESTRING , NUMVALUE     ) VALUES (?, ?, ? )");
        StaticSQL.put("deleteSearchQuery0", "DELETE FROM SEARCHTERMS WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery1", "DELETE FROM ORTRUEBOOLS WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery2", "DELETE FROM ANDTRUEBOOLS WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery3", "DELETE FROM LESSTHAN WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery4", "DELETE FROM GREATERTHAN WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery5", "DELETE FROM DLESSTHAN WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery6", "DELETE FROM DGREATERTHAN WHERE SEARCHID = ?");
        StaticSQL.put("deleteSearchQuery7", "DELETE FROM SEARCHQUERY WHERE ID = ?");
        StaticSQL.put("getSearchQuerys0", "SELECT ID                               , QUERYNAME                        , MAXRESULTS                       , SORTBY                           , SORTREVERSE                      , ADVANCEDQUERYSTRING              , NETWORK                          , PEERID                           , GENERALTERMS                     , TEMPLATE                         , REFS0                            , REFS1                            , REFS2                            , USETEMPLATE                      , DIRECTREF                        , EXCLUDEFILESREFERENCEDBYOTHERS0  , INCLUDEFILESWITHREFERENCES0      , EXCLUDEFILESREFERENCEDBYOTHERS1  , INCLUDEFILESWITHREFERENCES1      , EXCLUDEFILESREFERENCEDBYOTHERS2  , INCLUDEFILESWITHREFERENCES2      , MINPEERRANK                      , FROMDATE                         , TODATE                           , DAYSBACK                         , ONLYLOCAL                        , HIDEOPENED                         FROM SEARCHQUERY WHERE NETWORK = ?");
        StaticSQL.put("getSearchQuerys1", "SELECT SEARCHID       , TEMPLATESTRING , SEARCHSTRING     FROM SEARCHTERMS WHERE SEARCHID = ?");
        StaticSQL.put("getSearchQuerys2", "SELECT SEARCHID       , TEMPLATESTRING   FROM ORTRUEBOOLS WHERE SEARCHID = ?");
        StaticSQL.put("getSearchQuerys3", "SELECT SEARCHID       , TEMPLATESTRING   FROM ANDTRUEBOOLS WHERE SEARCHID = ?");
        StaticSQL.put("getSearchQuerys4", "SELECT SEARCHID       , TEMPLATESTRING , NUMVALUE         FROM LESSTHAN WHERE SEARCHID = ?");
        StaticSQL.put("getSearchQuerys5", "SELECT SEARCHID       , TEMPLATESTRING , NUMVALUE         FROM GREATERTHAN WHERE SEARCHID = ?");
        StaticSQL.put("getSearchQuerys6", "SELECT SEARCHID       , TEMPLATESTRING , NUMVALUE         FROM DLESSTHAN WHERE SEARCHID = ?");
        StaticSQL.put("getSearchQuerys7", "SELECT SEARCHID       , TEMPLATESTRING , NUMVALUE         FROM DGREATERTHAN WHERE SEARCHID = ?");
        StaticSQL.put("getAllNetworksForUpgrade", "SELECT DIGEST        FROM LOCALNETWORK ");
        StaticSQL.put("getAllPublicNetworks", "SELECT DIGEST        FROM LOCALNETWORK WHERE PUBLIC = TRUE");
        StaticSQL.put("getAllPublicPostsForUpgrade", "SELECT DIGEST        FROM LOCALPUBLICPOST ");
        StaticSQL.put("getAllPostsForUpgrade", "SELECT DIGEST        FROM LOCALPOST ");
        StaticSQL.put("getLocalNetworksFromPeer", "SELECT DIGEST          FROM LOCALNETWORK WHERE SEERIDENTIFIER = ? ");
        StaticSQL.put("getLocalPublicPostsFromPeer", "SELECT DIGEST           FROM LOCALPUBLICPOST WHERE SEERIDENTIFIER = ? ");
        StaticSQL.put("deletePost0", "DELETE FROM POSTMESSAGE WHERE ID = ? ");
        StaticSQL.put("deletePost1", "DELETE FROM POSTTEMPLATE WHERE ID = ? ");
        StaticSQL.put("deletePost2", "DELETE FROM LOCALPOST WHERE DIGEST = ? ");
        StaticSQL.put("saveLocalSubscription0", "MERGE INTO LOCALSUBSCRIBE KEY ( SEERIDENTIFIER, NETWORKID ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?  )");
        StaticSQL.put("getOrderedSubsRequestedNotDispatched", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE REQUESTSUB = TRUE AND REQUESTSUBDISPATCHED = FALSE ORDER BY REQUESTSUBPRIORITY DESC, REQUESTSUBTIME ASC LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getPeerPossibleNetworkSubscriptions", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE SEERIDENTIFIER = ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getPeerNetworkSubscriptions", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE SEERIDENTIFIER = ? AND SUBSCRIBED = TRUE LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getAllNetworkSubscriptions", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE NETWORKID = ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getNextSubscribePush", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE NETWORKID = ? AND PUSHREQUESTED = TRUE LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getSubscription", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE NETWORKID = ? AND SEERIDENTIFIER = ? LIMIT " + LIMIT_ALL_QUERIES);
        StaticSQL.put("getOrderedMostSubsLastDate", "SELECT LOCALDATE                    ,MARKEDBAD                    ,MARKEDMADDATE                ,NUMBEROFNEWPOSTS             ,LASTNEWPOST                  ,REQUESTPOSTS                 ,REQUESTPOSTSTIME             ,REQUESTPOSTSPRIORITY         ,REQUESTPOSTSDISPATCHED       ,REQUESTPOSTSDISPATCHEDTIME   ,LASTPOSTNUMBER               ,NUMBEROFNEWSUBS              ,LASTNEWSUB                   ,REQUESTSUB                   ,REQUESTSUBTIME               ,REQUESTSUBPRIORITY           ,REQUESTSUBDISPATCHED         ,REQUESTSUBDISPATCHEDTIME     ,LASTSUBNUMBER                ,NUMBEROFFILES                ,LASTNEWFILE                  ,PEERRANK                     ,PUSHREQUESTED                ,SUBSCRIBED                   ,RECEIVEDFROMPEER             ,NETWORKTITLE                 ,PEERNICKSIG                  ,NETWORKID                    ,DIGEST                       ,SEERIDENTIFIER               ,SIGNATURE                    ,RDATE                         FROM LOCALSUBSCRIBE WHERE NETWORKID = ? AND LASTNEWSUB >= ? ORDER BY NUMBEROFNEWSUBS DESC LIMIT " + LIMIT_ALL_QUERIES);
    }
}

