/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.com.ComPeerImplTest;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventDispatcher;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.LocalSubscribe;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthHoles;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.NetworkHoles;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostHoles;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.PublicPostHoles;
import org.ourfilesystem.db.so.Subscribe;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.FileUtils;

public class CoreComImpl
implements CoreComInterface {
    public static final Logger Log = Logger.getLogger(CoreComImpl.class.getName());
    public static boolean ThrowOnNewConnect = false;
    private CoreUserInterface CoreUser;
    private DataBaseCoreInterface CoreDB;
    private TimeInterface Time;
    private CryptoDataBaseInterface Crypto;
    private EventDispatcher Events;
    private ComConnectionInterface Com;
    private Map<BBytes, ComPeerInterface> Connections = new HashMap<BBytes, ComPeerInterface>();
    private int MaxConnections;
    private long TimeConnectedSteps;
    private int NumberTimeConnectedSteps;
    private long ReDispatchTime;
    private long ReConnectTime;
    private long ReRequestTime;
    private int MaxBatchRequests;
    private Random Random;
    private File TemplateDir;

    public void setMaxConnections(int maxConnections) {
        this.MaxConnections = maxConnections;
    }

    public void setCoreUser(CoreUserInterface coreUser) {
        this.CoreUser = coreUser;
    }

    public void setCom(ComConnectionInterface com) {
        this.Com = com;
    }

    public void setCoreDB(DataBaseCoreInterface coreDB) {
        this.CoreDB = coreDB;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    public void setCrypto(CryptoDataBaseInterface crypto) {
        this.Crypto = crypto;
    }

    public void setConnections(Map<BBytes, ComPeerInterface> connections) {
        this.Connections = connections;
    }

    public void setTimeConnectedSteps(long timeConnectedSteps) {
        this.TimeConnectedSteps = timeConnectedSteps;
    }

    public void setNumberTimeConnectedSteps(int numberTimeConnectedSteps) {
        this.NumberTimeConnectedSteps = numberTimeConnectedSteps;
    }

    public void setRandom(Random random) {
        this.Random = random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newConnection(ComPeerInterface com, boolean force) {
        if (ThrowOnNewConnect) {
            Thread.dumpStack();
        }
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            String me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity().toString();
            Log.info("(" + me + ") Connection: " + com.getPeer().getIdentity());
            ComPeerInterface oc = null;
            Map<BBytes, ComPeerInterface> map = this.Connections;
            synchronized (map) {
                oc = this.Connections.get(com.getPeer().getIdentity());
                if (oc != null) {
                    Log.info("Existing connection found: " + com.getPeer().getIdentity());
                    if (oc != com) {
                        Log.info("Closing old connection in favor of new: " + com.getPeer().getIdentity());
                        com.Close();
                    }
                } else {
                    Log.info("No existing connection found: " + com.getPeer().getIdentity() + " max cons: " + this.MaxConnections + " existing cons: " + this.Connections.size());
                    int size = 0;
                    size = this.Connections.size();
                    if (force || size < this.MaxConnections) {
                        Log.info("Accept new connection: " + com.getPeer().getIdentity());
                        this.Connections.put(com.getPeer().getIdentity(), com);
                        if (!com.isOk()) {
                            this.Connections.remove(com.getPeer().getIdentity());
                        } else {
                            LocalPeer lp = this.CoreDB.getPeer(com.getPeer().getIdentity());
                            if (lp != null && (lp.getRequestPeersTime() != null || lp.isRequestPeers())) {
                                com.requestPeers();
                                lp.setRequestPeers(false);
                                lp.setRequestPeersTime(null);
                                this.CoreDB.saveLocalPeer(lp);
                            }
                        }
                    } else {
                        Log.info("Too many connections closing incoming connection: " + com.getPeer().getIdentity());
                        com.Close();
                    }
                }
            }
            if (com.getPeer() != null) {
                LinkedList<Peer> l = new LinkedList<Peer>();
                l.add(com.getPeer());
                this.processPeers(com.getPeer().getIdentity(), l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed(ComPeerInterface com, boolean error) {
        Object object = this.Connections;
        synchronized (object) {
            ComPeerInterface ct = this.Connections.get(com.getPeer().getIdentity());
            if (ct == com) {
                this.Connections.remove(com.getPeer().getIdentity());
            }
        }
        object = this.CoreDB;
        synchronized (object) {
            LocalPeer lp = this.CoreDB.getPeer(com.getPeer().getIdentity());
            if (lp != null) {
                long rtime = this.Time.getTime().getTime() + (long)((double)this.getReConnectTime() * this.Random.nextDouble());
                lp.setLastConnectionTime(new Date(rtime));
                lp.setRequestPeers(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BBytes> getAuthNetworksForPeer(BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalNetworkAuthorization> lst = this.CoreDB.getPeerNetworkAuths(peerid);
            HashSet<BBytes> peernets = new HashSet<BBytes>();
            for (LocalNetworkAuthorization l : lst) {
                LocalSubscribe ls = this.CoreDB.getSubscription(l.getNetworkAuthorization().getNetworkId(), l.getNetworkAuthorization().getPeerId());
                if (ls != null && ls.isMarkedBad()) continue;
                peernets.add(l.getNetworkAuthorization().getNetworkId());
            }
            return peernets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BBytes> getSubsForPeer(BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalSubscribe> lst = this.CoreDB.getPeerNetworkSubscriptions(peerid);
            HashSet<BBytes> peernets = new HashSet<BBytes>();
            for (LocalSubscribe l : lst) {
                if (l.isMarkedBad() || !l.getSubscription().isSubscribe()) continue;
                peernets.add(l.getSubscription().getNetworkID());
            }
            return peernets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<BBytes> getNetworksForPeer(BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<LocalSubscribe> lst = this.CoreDB.getPeerPossibleNetworkSubscriptions(peerid);
            HashSet<BBytes> peernets = new HashSet<BBytes>();
            for (LocalSubscribe l : lst) {
                if (l.isMarkedBad()) continue;
                peernets.add(l.getSubscription().getNetworkID());
            }
            return peernets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAuthChains(ComPeerInterface com, Set<BBytes> networks) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes peerid = com.getPeer().getIdentity();
            BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            for (BBytes netid : networks) {
                LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(netid, peerid);
                if (lna == null || lna.getNumberOfNewAuths() != 0L) continue;
                lna.setNumberOfNewAuths(1L);
                this.CoreDB.saveLocalNetworkAuth(lna);
                LocalNetworkAuthorization mna = this.CoreDB.getNetworkAuth(netid, myid);
                if (mna == null) continue;
                List<NetworkAuthorization> ylc = this.getAuthChain(lna.getNetworkAuthorization());
                List<NetworkAuthorization> mlc = this.getAuthChain(mna.getNetworkAuthorization());
                for (NetworkAuthorization l : ylc) {
                    com.sendNetworkAuth(l);
                }
                for (NetworkAuthorization l : mlc) {
                    com.sendNetworkAuth(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestSubscriptions(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes peerid = com.getPeer().getIdentity();
            Set<BBytes> netlist = this.getSubsForPeer(peerid);
            Set<BBytes> allnets = this.getNetworksForPeer(peerid);
            for (BBytes nid : netlist) {
                List<LocalSubscribe> pushlist = this.CoreDB.getNextSubscribePush(nid);
                for (LocalSubscribe ls : pushlist) {
                    if (peerid.equals(ls.getReceivedFromPeer()) || ls.getSubscription().getSignature().getPeerIdentifier().equals(peerid)) continue;
                    ls.setPushRequested(false);
                    this.CoreDB.saveLocalSubscription(ls);
                    com.sendSubscription(ls.getSubscription());
                }
            }
            Log.info("requestSubscriptions: allnets.size(): " + allnets.size());
            if (allnets.size() > 0) {
                List<LocalSubscribe> sublist = this.CoreDB.getOrderedSubsRequestedNotDispatched();
                int reqsnt = this.MaxBatchRequests;
                boolean requestsdipatched = false;
                Date curtime = this.Time.getTime();
                long oktime = curtime.getTime();
                long allnettime = (oktime -= this.ReRequestTime) - this.ReRequestTime;
                Log.info("requestSubscriptions: sublists.size(): " + sublist.size() + " reqsnt " + reqsnt + " oktime: " + oktime + " alltime: " + allnettime);
                HashSet<BBytes> netsrequeted = new HashSet<BBytes>();
                Iterator<LocalSubscribe> i = sublist.iterator();
                while (i.hasNext() && reqsnt > 0) {
                    LocalSubscribe ln = i.next();
                    if (!allnets.contains(ln.getSubscription().getNetworkID()) || !ln.isRequestSubs() || ln.isRequestSubsDispatched()) continue;
                    Log.info("requestSubscriptions: contains passed");
                    LocalSubscribe consub = this.CoreDB.getSubscription(ln.getSubscription().getNetworkID(), peerid);
                    boolean subconts = netlist.contains(ln.getSubscription().getNetworkID());
                    if (consub.getRequestSubsTime() != null && (consub.getRequestSubsTime().getTime() >= oktime || !subconts) && consub.getRequestSubsTime().getTime() >= allnettime) continue;
                    BBytes netid = ln.getSubscription().getNetworkID();
                    BBytes subpeer = ln.getSubscription().getSignature().getPeerIdentifier();
                    Log.info("requestSubscriptions: conpeer: " + com.getPeer().getNickSig() + " subpeer: " + ln.getCreator() + " netid: " + ln.getNetworkName() + " request subs: " + ln.getSubscription().getSubNumber());
                    com.requestSubscriptions(subpeer, netid, ln.getSubscription().getSubNumber());
                    netsrequeted.add(netid);
                    requestsdipatched = true;
                    --reqsnt;
                }
                for (BBytes netid : netsrequeted) {
                    LocalSubscribe conauth = this.CoreDB.getSubscription(netid, peerid);
                    if (conauth == null) continue;
                    conauth.setRequestSubsTime(curtime);
                    this.CoreDB.saveLocalSubscription(conauth);
                }
                return requestsdipatched;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestNetworkAuths(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes peerid = com.getPeer().getIdentity();
            Set<BBytes> peernets = this.getAuthNetworksForPeer(peerid);
            this.sendAuthChains(com, peernets);
            for (BBytes netid : peernets) {
                List<LocalNetworkAuthorization> pushlist = this.CoreDB.getNextNetworkAuthPush(netid);
                for (LocalNetworkAuthorization ln : pushlist) {
                    if (peerid.equals(ln.getReceivedFromPeer()) || ln.getNetworkAuthorization().getSignature().getPeerIdentifier().equals(peerid)) continue;
                    ln.setPushRequested(false);
                    this.CoreDB.saveLocalNetworkAuth(ln);
                    com.sendNetworkAuth(ln.getNetworkAuthorization());
                }
            }
            if (peernets.size() > 0) {
                LocalNetworkAuthorization conauth;
                BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                List<LocalNetworkAuthorization> rsts = this.CoreDB.getOrderedNetworkAuthsRequestedNotDispatched();
                Iterator<LocalNetworkAuthorization> i = rsts.iterator();
                int reqsnt = this.MaxBatchRequests;
                boolean requestsdipatched = false;
                Date curtime = this.Time.getTime();
                long oktime = curtime.getTime();
                oktime -= this.ReRequestTime;
                HashSet<BBytes> netsrequeted = new HashSet<BBytes>();
                while (i.hasNext() && reqsnt > 0) {
                    LocalNetworkAuthorization ln = i.next();
                    Log.info("Check if should update network auths for network: " + ln.getNetworkAuthorization().getNetworkId() + " for peer: " + ln.getNetworkAuthorization().getPeerId());
                    if (!peernets.contains(ln.getNetworkAuthorization().getNetworkId()) || !ln.isRequestAuths() || ln.isRequestAuthsDispatched()) continue;
                    LocalNetworkAuthorization myauth = this.CoreDB.getNetworkAuth(ln.getNetworkAuthorization().getNetworkId(), myid);
                    conauth = this.CoreDB.getNetworkAuth(ln.getNetworkAuthorization().getNetworkId(), peerid);
                    if (conauth == null || myauth == null || conauth.getRequestAuthsTime() != null && conauth.getRequestAuthsTime().getTime() >= oktime) continue;
                    BBytes rpeer = ln.getNetworkAuthorization().getPeerId();
                    BBytes netid = ln.getNetworkAuthorization().getNetworkId();
                    ln.setRequestAuthsDispatched(true);
                    ln.setRequestAuthsDispatchedTime(curtime);
                    this.CoreDB.saveLocalNetworkAuth(ln);
                    List<NetworkAuthHoles> holes = this.CoreDB.getPeerNetworkAuthHoles(netid, rpeer);
                    for (NetworkAuthHoles ph : holes) {
                        Log.info("Send request for network auths: " + netid + " to peer: " + rpeer + " " + ph.getFirstNumber() + " > " + ph.getLastNumber());
                        com.requestNetworkAuths(myauth.getNetworkAuthorization(), conauth.getNetworkAuthorization(), rpeer, netid, ph.getFirstNumber(), ph.getLastNumber());
                    }
                    Log.info("Send request for network auths: " + netid + " to peer: " + rpeer + " " + ln.getLastNetworkAuthNumber() + " > " + Long.MAX_VALUE);
                    com.requestNetworkAuths(myauth.getNetworkAuthorization(), conauth.getNetworkAuthorization(), rpeer, netid, ln.getLastNetworkAuthNumber(), Long.MAX_VALUE);
                    netsrequeted.add(netid);
                    requestsdipatched = true;
                    --reqsnt;
                }
                for (BBytes netid : netsrequeted) {
                    conauth = this.CoreDB.getNetworkAuth(netid, peerid);
                    if (conauth == null) continue;
                    conauth.setRequestAuthsTime(curtime);
                    this.CoreDB.saveLocalNetworkAuth(conauth);
                }
                return requestsdipatched;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestNetworks(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Date curtime = this.Time.getTime();
            long oktime = curtime.getTime() - this.ReRequestTime;
            BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            BBytes compeerid = com.getPeer().getIdentity();
            List<LocalNetwork> nlst = this.CoreDB.getNextNetworkPush();
            for (LocalNetwork ln : nlst) {
                if (compeerid.equals(ln.getReceivedFromPeer()) || ln.getNetwork().getSignature().getPeerIdentifier().equals(compeerid)) continue;
                ln.setPushRequseted(false);
                this.CoreDB.saveLocalNetwork(ln);
                com.sendNetwork(ln.getNetwork());
            }
            LocalPeer conpeer = this.CoreDB.getPeer(compeerid);
            if (conpeer != null && (conpeer.getRequestNetworksTime() == null || conpeer.getRequestNetworksTime().getTime() < oktime)) {
                boolean reqsnt = false;
                boolean onefnd = true;
                int maxreq = this.MaxBatchRequests;
                while (maxreq > 0 && onefnd) {
                    onefnd = false;
                    LocalPeer lp = this.CoreDB.getHighestPriorityNeteworkRequest();
                    if (lp == null || !lp.isRequestNetworks() || lp.isRequestNetworksDispatched() || lp.getRequestNetworksTime() != null && lp.getRequestNetworksTime().getTime() >= oktime) continue;
                    BBytes peerid = lp.getPeer().getIdentity();
                    lp.setRequestNetworksDispatched(true);
                    lp.setRequestNetworksDispatchedTime(curtime);
                    lp.setRequestNetworksTime(curtime);
                    this.CoreDB.saveLocalPeer(lp);
                    List<NetworkHoles> nh = this.CoreDB.getPeerNetworkHoles(peerid);
                    for (NetworkHoles n : nh) {
                        Log.info("This peer: " + myid + " requests network update holes from: " + compeerid + " from: " + n.getFirstNumber() + " to " + n.getLastNumber());
                        com.requestNetworks(peerid, n.getFirstNumber(), n.getLastNumber());
                    }
                    Log.info("This peer: " + myid + " requests network update from: " + compeerid + " from " + lp.getLastNetworkNumber());
                    com.requestNetworks(peerid, lp.getLastNetworkNumber(), Long.MAX_VALUE);
                    onefnd = true;
                    reqsnt = true;
                    --maxreq;
                }
                if (reqsnt) {
                    conpeer.setRequestNetworksTime(curtime);
                    this.CoreDB.saveLocalPeer(conpeer);
                }
                return reqsnt;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPeers(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block5: {
                LocalPeer lp2;
                BBytes pid = com.getPeer().getIdentity();
                List<LocalPeer> lstp = this.CoreDB.getNextPeerPush();
                for (LocalPeer lp2 : lstp) {
                    Log.info("Peer: " + lp2.getPeer().getIdentity() + " received from: " + lp2.getReceivedFromPeer() + " push: " + lp2.isPushRequested());
                    if (pid.equals(lp2.getReceivedFromPeer()) || lp2.getPeer().getIdentity().equals(pid)) continue;
                    lp2.setPushRequested(false);
                    this.CoreDB.saveLocalPeer(lp2);
                    com.sendPeer(lp2.getPeer());
                }
                lp2 = this.CoreDB.getPeer(pid);
                if (lp2 == null || !lp2.isRequestPeers()) break block5;
                lp2.setRequestPeers(false);
                lp2.setRequestPeersTime(null);
                this.CoreDB.saveLocalPeer(lp2);
                Log.info("Send request peers!==============================================");
                com.requestPeers();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPosts(ComPeerInterface com) {
        BBytes peerid = com.getPeer().getIdentity();
        Log.info("Calling requestPosts()");
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Set<BBytes> peernets = this.getSubsForPeer(peerid);
            Set<BBytes> allnets = this.getNetworksForPeer(peerid);
            Log.info("peernets.size(): " + peernets.size());
            for (BBytes netid : peernets) {
                LocalSubscribe ls = this.CoreDB.getSubscription(netid, peerid);
                Log.info("Check subscription for pushes: " + ls.getSubscription().isSubscribe());
                if (!ls.getSubscription().isSubscribe()) continue;
                List<LocalPost> plst = this.CoreDB.getNextPostPush(netid);
                Log.info("Push list size: " + plst.size());
                for (LocalPost lp : plst) {
                    Log.info("Preparing to push.");
                    if (!peerid.equals(lp.getReceivedFromPeer()) && !lp.getPost().getSignedDigest().getPeerIdentifier().equals(peerid)) {
                        Log.info("Pushing post to peer.");
                        lp.setPushRequested(false);
                        this.CoreDB.saveLocalPost(lp);
                        com.sendPost(lp.getPost());
                        continue;
                    }
                    Log.info("Did NOT push to peer");
                }
            }
            if (allnets.size() > 0) {
                BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                List<LocalSubscribe> rsts = this.CoreDB.getOrderedPostsRequestedNotDispatched();
                Log.info("Number of post requested: " + rsts.size());
                Iterator<LocalSubscribe> i = rsts.iterator();
                int reqsnt = this.MaxBatchRequests;
                boolean requestsdipatched = false;
                Date curtime = this.Time.getTime();
                long oktime = curtime.getTime() - this.ReRequestTime;
                long alloktime = oktime - this.ReRequestTime;
                HashSet<BBytes> netsrequeted = new HashSet<BBytes>();
                while (i.hasNext() && reqsnt > 0) {
                    LocalSubscribe ln = i.next();
                    boolean peerhas = allnets.contains(ln.getSubscription().getNetworkID());
                    boolean peersub = peernets.contains(ln.getSubscription().getNetworkID());
                    long usetime = alloktime;
                    if (peersub) {
                        usetime = oktime;
                    }
                    Log.info("Check request is contained in peernets: " + peerhas);
                    if (!peerhas || !ln.isRequestPosts() || ln.isRequestPostsDispatched()) continue;
                    NetworkAuthorization myauth = null;
                    NetworkAuthorization conauth = null;
                    LocalNetworkAuthorization mylauth = this.CoreDB.getNetworkAuth(ln.getSubscription().getNetworkID(), myid);
                    LocalNetworkAuthorization colnauth = this.CoreDB.getNetworkAuth(ln.getSubscription().getNetworkID(), peerid);
                    if (mylauth != null && colnauth != null) {
                        myauth = mylauth.getNetworkAuthorization();
                        conauth = colnauth.getNetworkAuthorization();
                    }
                    long rptime = -1L;
                    if (ln.getRequestPostsTime() != null) {
                        rptime = ln.getRequestPostsTime().getTime();
                    }
                    Log.info("ln.getRequestPostTime(): " + rptime + " < " + usetime);
                    if (rptime != -1L && rptime >= usetime) continue;
                    BBytes rpeer = ln.getSubscription().getSignature().getPeerIdentifier();
                    BBytes netid = ln.getSubscription().getNetworkID();
                    ln.setRequestPostsDispatched(true);
                    ln.setRequestPostsDispatchedTime(this.Time.getTime());
                    this.CoreDB.saveLocalSubscription(ln);
                    List<PostHoles> holes = this.CoreDB.getPostHoles(netid, rpeer);
                    Log.info("NUM HOLES: " + holes.size());
                    for (PostHoles ph : holes) {
                        Log.info("REQUEST HOLES: " + ph.getFirstNumber() + " - " + ph.getLastNumber());
                        com.requestPosts(myauth, conauth, rpeer, netid, ph.getFirstNumber(), ph.getLastNumber());
                    }
                    Log.info("RequestPosts: conpeer: " + peerid.toHexString().substring(0, 10) + " me: " + myid.toHexString().substring(0, 10) + " net: " + netid.toHexString().substring(0, 10) + " prid: " + rpeer.toHexString().substring(0, 10) + " num: " + ln.getLastPostNumber());
                    com.requestPosts(myauth, conauth, rpeer, netid, ln.getLastPostNumber(), Long.MAX_VALUE);
                    netsrequeted.add(netid);
                    requestsdipatched = true;
                    --reqsnt;
                }
                for (BBytes netid : netsrequeted) {
                    LocalSubscribe conauth = this.CoreDB.getSubscription(netid, peerid);
                    if (conauth == null) continue;
                    conauth.setRequestPostsTime(curtime);
                    this.CoreDB.saveLocalSubscription(conauth);
                }
                return requestsdipatched;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean requestPublicPosts(ComPeerInterface com) {
        Log.info("requestPublicPosts()");
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Date curtime = this.Time.getTime();
            long oktime = curtime.getTime() - this.ReRequestTime;
            BBytes compeerid = com.getPeer().getIdentity();
            List<LocalPublicPost> plst = this.CoreDB.getNextPublicPostPush();
            for (LocalPublicPost lpp : plst) {
                if (compeerid.equals(lpp.getReceivedFromPeer()) || lpp.getPublicPost().getSignature().getPeerIdentifier().equals(compeerid)) continue;
                lpp.setPushRequsted(false);
                this.CoreDB.saveLocalPublicPost(lpp);
                com.sendPublicPost(lpp.getPublicPost());
            }
            LocalPeer conpeer = this.CoreDB.getPeer(com.getPeer().getIdentity());
            Log.info("requestPublicPosts: conpeer: " + conpeer);
            if (conpeer != null) {
                Log.info("requestPublicPosts: pubpostrequesttime: " + conpeer.getRequestPublicPostsTime());
                if (conpeer.getRequestPublicPostsTime() != null) {
                    boolean timecheck = conpeer.getRequestPublicPostsTime().getTime() < oktime;
                    Log.info("requestPublicPosts: pubpostrequesttime: " + conpeer.getRequestPublicPostsTime().getTime() + " < " + oktime + " timecheck: " + timecheck);
                }
                if (conpeer.getRequestPublicPostsTime() == null || conpeer.getRequestPublicPostsTime().getTime() < oktime) {
                    boolean reqsnt = false;
                    boolean onesnt = true;
                    int maxreq = this.MaxBatchRequests;
                    Log.info("getRequestPublicPostsTime: onesnt: " + onesnt + " maxreq: " + maxreq);
                    while (onesnt && maxreq > 0) {
                        onesnt = false;
                        LocalPeer lp = this.CoreDB.getHighestPriorityPublicPostRequest();
                        Log.info("getRequestPublicPostsTime: lp: " + lp);
                        if (lp == null || !lp.isRequestPublicPosts() || lp.isRequestPublicPostsDispatched()) continue;
                        BBytes peerid = lp.getPeer().getIdentity();
                        lp.setRequestPublicPostsDispatched(true);
                        lp.setRequestPublicPostsDispatchedTime(curtime);
                        lp.setRequestPublicPostsTime(curtime);
                        this.CoreDB.saveLocalPeer(lp);
                        List<PublicPostHoles> nh = this.CoreDB.getPublicPostHoles(peerid);
                        for (PublicPostHoles n : nh) {
                            com.requestPublicPosts(peerid, n.getFirstNumber(), n.getLastNumber());
                            Log.info(" com.requestPublicPosts: " + n.getFirstNumber() + " .. " + n.getLastNumber());
                        }
                        com.requestPublicPosts(peerid, lp.getLastPublicPostNumber(), Long.MAX_VALUE);
                        Log.info("com.requestPublicPosts: " + lp.getLastPublicPostNumber());
                        onesnt = true;
                        reqsnt = true;
                        --maxreq;
                    }
                    if (reqsnt) {
                        conpeer.setRequestPublicPostsTime(curtime);
                        this.CoreDB.saveLocalPeer(conpeer);
                    }
                    return reqsnt;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean requestFile(ComPeerInterface com) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            FileReference ln;
            BBytes peerid = com.getPeer().getIdentity();
            Set<BBytes> peernets = this.getSubsForPeer(peerid);
            if (peernets.size() <= 0) return false;
            List<FileReference> rsts = this.CoreDB.getOrderedFilesRequestedNotDispatched();
            Log.info("File requests found: " + rsts.size());
            Iterator<FileReference> i = rsts.iterator();
            while (true) {
                if (!i.hasNext()) {
                    return false;
                }
                ln = i.next();
                if (ln.getUserRequestPriority() <= 0L || !peernets.contains(ln.getNetworkId()) || !ln.isUserRequested() || ln.isUserRequestDispatched()) continue;
                Log.info("Request is not dispatched.");
                PeerHasFile phf = this.CoreDB.getPeerHasFile(ln.getNetworkId(), peerid, ln.getUnsignedDigest());
                if (phf != null && phf.isPeerHasFile()) break;
            }
            Log.info("Peer has file..  Sending request. " + peerid);
            ln.setUserRequestDispatched(true);
            ln.setUserRequestDispatchTime(this.Time.getTime());
            this.CoreDB.saveFileReference(ln);
            com.requestsFile(ln.getNetworkId(), ln.getUnsignedDigest());
            return true;
        }
    }

    @Override
    public void nextRequest(ComPeerInterface com) {
        Log.info("CALLING NEXT REQUEST!   OK? " + com.isOk());
        if (!com.isOk()) {
            return;
        }
        int lastrequesttype = com.getLastRequestType();
        boolean requestfound = false;
        int cnt = 0;
        while (cnt < 2 && !requestfound) {
            int chk = cnt;
            if (lastrequesttype == 6 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestNetworkAuths(com);
                Log.info("RequestNetworkAuths: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 3 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestNetworks(com);
                Log.info("RequestNetworks: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 2 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestPeers(com);
                Log.info("RequestPeers: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 4 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestPosts(com);
                Log.info("RequestPosts: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 0 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestPublicPosts(com);
                Log.info("RequestPublicPosts: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 1 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestFile(com);
                Log.info("RequestFile: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            if (lastrequesttype == 5 && cnt == 0 || !requestfound && chk > 0) {
                requestfound = this.requestSubscriptions(com);
                Log.info("RequestSubscriptions: " + requestfound + " cnt: " + cnt + " chk: " + chk);
                ++chk;
            }
            ++cnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPostsFailed(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe lna = this.CoreDB.getSubscription(networkid, peerid);
            if (lna != null) {
                lna.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalSubscription(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFileFailed(ComPeerInterface conpeer, BBytes networkid, BBytes filedig) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flist = this.CoreDB.getFilesRequested(filedig);
            for (FileReference f : flist) {
                if (!f.getNetworkId().equals(networkid)) continue;
                f.setUserRequestDispatched(false);
                this.CoreDB.saveFileReference(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworksFailed(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworkAuthsFailed(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
            if (lna != null) {
                lna.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPublicPostsFailed(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSubscriptionFailed(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe ls = this.CoreDB.getSubscription(networkid, peerid);
            if (ls != null) {
                ls.setRequestSubsDispatched(false);
                this.CoreDB.saveLocalSubscription(ls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPostsSucceeded(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe lna = this.CoreDB.getSubscription(networkid, peerid);
            if (lna != null) {
                lna.setRequestPosts(false);
                lna.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalSubscription(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworksSucceeded(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestNetworks(false);
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestNetworkAuthSucceeded(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, peerid);
            if (lna != null) {
                lna.setRequestAuths(false);
                lna.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestPublicPostsSucceeded(ComPeerInterface conpeer, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRequestPublicPosts(false);
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSubscriptionSucceeded(ComPeerInterface conpeer, BBytes peerid, BBytes networkid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe ls = this.CoreDB.getSubscription(networkid, peerid);
            if (ls != null) {
                ls.setRequestSubs(false);
                ls.setRequestSubsDispatched(false);
                this.CoreDB.saveLocalSubscription(ls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyPost(Post p) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block4: {
                BBytes peerid = p.getSignedDigest().getPeerIdentifier();
                LocalPost ep = this.CoreDB.getPost(p.getNetworkId(), peerid, p.getPostNumber());
                if (ep != null) break block4;
                LocalPeer lp = this.CoreDB.getPeer(peerid);
                LocalSubscribe lsu = this.CoreDB.getSubscription(p.getNetworkId(), peerid);
                if (lp == null || lsu == null || lsu.isMarkedBad() || !this.Crypto.verifyPost(p, lp.getPeer().getPeerKeys())) break block4;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processPosts(BBytes conpeer, List<Post> posts) {
        Log.info("processPosts: post size: " + posts.size());
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            for (Post p : posts) {
                LocalSubscribe splna;
                boolean verified = this.verifyPost(p);
                Log.info("processPosts: verified: " + verified);
                if (!verified) continue;
                BBytes peerid = p.getSignedDigest().getPeerIdentifier();
                LocalPost lpst = new LocalPost();
                lpst.setLocalDate(this.Time.getTime());
                lpst.setPost(p);
                lpst.setPushRequested(true);
                lpst.setReceivedFromPeer(conpeer);
                LocalSubscribe slna = this.CoreDB.getSubscription(p.getNetworkId(), peerid);
                Log.info("processPosts: localsub: " + slna);
                if (slna != null) {
                    lpst.setPeerRank(slna.getPeerRank());
                    lpst.setCreator(slna.getCreator());
                    this.CoreDB.saveLocalPost(lpst);
                    long lastnum = slna.getLastPostNumber();
                    if (p.getPostNumber() > lastnum) {
                        slna.setLastPostNumber(p.getPostNumber());
                        if (p.getPostNumber() > lastnum + 1L) {
                            PostHoles nph = new PostHoles();
                            nph.setFirstNumber(lastnum + 1L);
                            nph.setLastNumber(p.getPostNumber() - 1L);
                            nph.setNetworkId(p.getNetworkId());
                            nph.setPeerId(peerid);
                            this.CoreDB.savePostHoles(nph);
                        }
                    } else {
                        List<PostHoles> holes = this.CoreDB.getPostHoles(p.getNetworkId(), peerid);
                        for (PostHoles h : holes) {
                            PostHoles nh = h.newPostReceived(p.getPostNumber());
                            if (nh != null) {
                                this.CoreDB.savePostHoles(nh);
                            }
                            if (h.isDone()) {
                                this.CoreDB.deletePostHoles(h);
                                continue;
                            }
                            this.CoreDB.savePostHoles(h);
                        }
                    }
                    slna.setRequestPosts(false);
                    slna.setRequestPostsDispatched(false);
                    this.CoreDB.saveLocalSubscription(slna);
                    Log.info("processPosts: saving new post");
                }
                if ((splna = this.CoreDB.getSubscription(p.getNetworkId(), conpeer)) != null) {
                    splna.setNumberOfNewPosts(splna.getNumberOfNewPosts() + 1L);
                    splna.setLastNewPost(this.Time.getTime());
                    this.CoreDB.saveLocalSubscription(splna);
                }
                if (p.getFileReferenceDigest() != null) {
                    PeerHasFile phf = this.CoreDB.getPeerHasFile(p.getNetworkId(), p.getSignedDigest().getPeerIdentifier(), p.getFileReferenceDigest());
                    if (phf != null) {
                        if (phf.getLastMessage() < p.getPostNumber() && (phf.isPeerHasFile() && !p.isPosterHasFile() || !phf.isPeerHasFile() && p.isPosterHasFile())) {
                            phf.setPeerHasFile(p.isPosterHasFile());
                            phf.setLastMessage(p.getPostNumber());
                            this.CoreDB.savePeerHasFile(phf);
                        }
                    } else if (p.isPosterHasFile()) {
                        phf = new PeerHasFile();
                        phf.setDigest(p.getFileReferenceDigest());
                        phf.setLastMessage(p.getPostNumber());
                        phf.setNetworkId(p.getNetworkId());
                        phf.setPeerHasFile(p.isPosterHasFile());
                        phf.setPeerId(p.getSignedDigest().getPeerIdentifier());
                        this.CoreDB.savePeerHasFile(phf);
                    }
                }
                this.Events.newPostReceived(lpst);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processSubscription(BBytes conpeer, Subscribe subs) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes subpeerid = subs.getSignature().getPeerIdentifier();
            BBytes networkid = subs.getNetworkID();
            LocalNetwork nw = this.CoreDB.getLocalNetwork(networkid);
            if (nw != null) {
                LocalPeer lp;
                LocalSubscribe ls;
                boolean publicnetwork = false;
                if (nw.getNetwork().getPublic() != null) {
                    publicnetwork = nw.getNetwork().getPublic();
                }
                boolean ok = true;
                if (!publicnetwork) {
                    LocalNetworkAuthorization conlna = this.CoreDB.getNetworkAuth(networkid, conpeer);
                    LocalNetworkAuthorization sublna = this.CoreDB.getNetworkAuth(networkid, subpeerid);
                    if (conlna == null || sublna == null) {
                        ok = false;
                    }
                }
                if ((ls = this.CoreDB.getSubscription(networkid, subpeerid)) != null) {
                    if (ls.isMarkedBad()) {
                        ok = false;
                    }
                    if (ls.getSubscription() != null && ls.getSubscription().getSubNumber() >= subs.getSubNumber()) {
                        ok = false;
                    }
                }
                if (ok && (lp = this.CoreDB.getPeer(subpeerid)) != null && this.Crypto.verifySubscribe(subs, lp.getPeer().getPeerKeys())) {
                    if (ls == null) {
                        ls = new LocalSubscribe();
                        ls.setNetworkName(nw.getNetwork().getTitleSig());
                        ls.setReceivedFromPeer(conpeer);
                        ls.setCreator(lp.getPeer().getNickSig());
                        ls.setLastPostNumber(0L);
                        ls.setLocalDate(this.Time.getTime());
                        ls.setMarkedBad(false);
                        ls.setNetworkName(nw.getNetwork().getTitleSig());
                        ls.setNumberOfFiles(0L);
                        ls.setNumberOfNewPosts(0L);
                        ls.setPeerRank(10L);
                        ls.setRequestPosts(false);
                        ls.setRequestPostsDispatched(false);
                        ls.setRequestPostsPriority(0L);
                        ls.setLastNewPost(new Date(0L));
                        ls.setLastNewFile(new Date(0L));
                        ls.setLastNewSubs(new Date(0L));
                    }
                    ls.setSubscription(subs);
                    ls.setPushRequested(true);
                    ls.setReceivedFromPeer(conpeer);
                    this.CoreDB.saveLocalSubscription(ls);
                    LocalSubscribe consub = this.CoreDB.getSubscription(networkid, conpeer);
                    if (consub != null) {
                        consub.setLastNewSubs(this.Time.getTime());
                        long cnt = consub.getNumberOfNewSubs() + 1L;
                        consub.setNumberOfNewSubs(cnt);
                        this.CoreDB.saveLocalSubscription(consub);
                    }
                }
            }
        }
    }

    private void createHaveFilePost(BBytes networkid, BBytes dig) {
        this.CoreUser.addLocalPost(networkid, null, dig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BBytes processFile(BBytes conpeer, BBytes networkid, File frs) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes dig = this.Crypto.digestFile(frs);
            if (dig != null) {
                List<FileReference> flist = this.CoreDB.getFilesRequested(dig);
                for (FileReference f : flist) {
                    if (!f.isUserRequested() || f.getSize() != frs.length()) continue;
                    try {
                        FileUtils.copyFile(frs, f.getFile(), 0L, f.getOffset(), f.getSize());
                        f.setUserRequested(false);
                        f.setUserRequestDispatched(false);
                        this.CoreDB.saveFileReference(f);
                        this.Events.newFileDownloaded(f);
                        this.createHaveFilePost(f.getNetworkId(), dig);
                        LocalSubscribe splna = this.CoreDB.getSubscription(f.getNetworkId(), conpeer);
                        if (splna == null) continue;
                        splna.setNumberOfFiles(splna.getNumberOfFiles() + 1L);
                        splna.setLastNewFile(this.Time.getTime());
                        this.CoreDB.saveLocalSubscription(splna);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            frs.delete();
            return dig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPeers(BBytes conpeer, List<Peer> peers) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            long numnewpeers = 0L;
            Log.info("Number of peers to process: " + peers.size());
            for (Peer p : peers) {
                String ident = p.getIdentity().toString();
                Log.info("Process peer: " + ident);
                if (this.Crypto.verifyIdentity(p)) {
                    Log.info("Peer identity data verified: " + ident);
                    LocalPeer olp = this.CoreDB.getPeer(p.getIdentity());
                    if (olp != null) {
                        Log.info("Existing peer data found: Current update count: " + olp.getPeer().getUpdateCount() + " new count: " + p.getUpdateCount() + " for: " + ident);
                        if (olp.getPeer().getUpdateCount() >= p.getUpdateCount()) continue;
                        if (this.Crypto.verifyLocation(p, olp.getPeer().getPeerKeys())) {
                            Log.info("Location data verified: " + ident);
                            Log.info(">>>>>> Set push, received from: " + conpeer);
                            this.CoreDB.deletePeer(olp.getPeer(), false);
                            olp.setPeer(p);
                            olp.setPushRequested(true);
                            olp.setReceivedFromPeer(conpeer);
                            this.CoreDB.saveLocalPeer(olp);
                            ++numnewpeers;
                            this.Events.newPeerReceived(olp);
                            continue;
                        }
                        Log.info("Location data was not valid: " + ident);
                        continue;
                    }
                    Log.info("Existing peer data not found: " + ident);
                    if (this.Crypto.verifyLocation(p, p.getPeerKeys())) {
                        Log.info("Location data verfied saving new peer: " + ident);
                        LocalPeer lp = new LocalPeer();
                        lp.setConnectionAttempts(0L);
                        lp.setLastConnectionTime(this.Time.getTime());
                        lp.setLastNetworkNumber(0L);
                        lp.setLastNewNetwork(this.Time.getTime());
                        lp.setLastNewPeer(this.Time.getTime());
                        lp.setLastNewPublicPost(this.Time.getTime());
                        lp.setLastPublicPostNumber(0L);
                        lp.setLastSuccessRequest(this.Time.getTime());
                        lp.setNumberOfNewNetworks(0L);
                        lp.setNumberOfNewPeers(0L);
                        lp.setNumberOfNewPublicPosts(0L);
                        lp.setRequestNetworks(false);
                        lp.setRequestNetworksDispatched(false);
                        lp.setRequestNetworksDispatchedTime(this.Time.getTime());
                        lp.setRequestNetworksPriority(0L);
                        lp.setRequestNetworksTime(this.Time.getTime());
                        lp.setRequestPeers(false);
                        lp.setRequestPeersPriority(0L);
                        lp.setRequestPeersTime(this.Time.getTime());
                        lp.setRequestPublicPosts(false);
                        lp.setRequestPublicPostsDispatched(false);
                        lp.setRequestPublicPostsDispatchedTime(this.Time.getTime());
                        lp.setRequestPublicPostsPriority(0L);
                        lp.setRequestPublicPostsTime(this.Time.getTime());
                        lp.setRequests(0L);
                        lp.setSuccessfulConnectionAttempts(0L);
                        lp.setSuccessfulRequests(0L);
                        lp.setPushRequested(false);
                        lp.setReceivedFromPeer(conpeer);
                        Log.info("CONPEER: " + conpeer);
                        lp.setPeer(p);
                        lp.setLocalDate(this.Time.getTime());
                        this.CoreDB.saveLocalPeer(lp);
                        ++numnewpeers;
                        this.Events.newPeerReceived(lp);
                        continue;
                    }
                    Log.info("Location data was invalid: " + ident);
                    continue;
                }
                Log.info("Identity was not valid: " + ident);
            }
            LocalPeer slp = this.CoreDB.getPeer(conpeer);
            if (slp != null) {
                long numpeers = slp.getNumberOfNewPeers();
                slp.setNumberOfNewPeers(numpeers += numnewpeers);
                slp.setLastNewPeer(this.Time.getTime());
                this.CoreDB.saveLocalPeer(slp);
                Log.info("Update peer newpeer stat: " + conpeer + " number: " + numpeers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processNetworks(BBytes conpeer, List<Network> networks) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            long numnewnetworks = 0L;
            for (Network n : networks) {
                LocalPeer olp = this.CoreDB.getPeer(n.getSignature().getPeerIdentifier());
                LocalNetwork lnw = this.CoreDB.getLocalNetwork(n.getSignature().getDigest());
                if (olp == null || lnw != null) continue;
                LocalPeer creator = this.CoreDB.getPeer(n.getSignature().getPeerIdentifier());
                boolean verified = this.Crypto.verifyNetwork(n, olp.getPeer().getPeerKeys());
                if (creator == null || !verified) continue;
                LocalNetwork ln = new LocalNetwork();
                ln.setLocalDate(this.Time.getTime());
                ln.setPeerRank(creator.getRank());
                ln.setNetwork(n);
                ln.setPushRequseted(true);
                ln.setReceivedFromPeer(conpeer);
                ln.setCreator(creator.getPeer().getNickSig());
                this.CoreDB.saveLocalNetwork(ln);
                ++numnewnetworks;
                long oldlast = olp.getLastNetworkNumber();
                if (n.getNetworkNumber() > oldlast) {
                    olp.setLastNetworkNumber(n.getNetworkNumber());
                    if (n.getNetworkNumber() > oldlast + 1L) {
                        NetworkHoles nh = new NetworkHoles();
                        nh.setFirstNumber(oldlast + 1L);
                        nh.setLastNumber(n.getNetworkNumber() - 1L);
                        nh.setPeerId(olp.getPeer().getIdentity());
                        this.CoreDB.saveNetworkHoles(nh);
                    }
                } else {
                    List<NetworkHoles> nhl = this.CoreDB.getPeerNetworkHoles(olp.getPeer().getIdentity());
                    for (NetworkHoles nh : nhl) {
                        NetworkHoles nnh = nh.newNetworkReceived(n.getNetworkNumber());
                        if (nnh != null) {
                            this.CoreDB.saveNetworkHoles(nnh);
                        }
                        if (nh.isDone()) {
                            this.CoreDB.deleteNetworkHoles(nh);
                            continue;
                        }
                        this.CoreDB.saveNetworkHoles(nh);
                    }
                }
                olp.setRequestNetworks(false);
                olp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(olp);
                this.Events.newNetworkReceived(ln);
            }
            LocalPeer slp = this.CoreDB.getPeer(conpeer);
            if (slp != null) {
                long numnets = slp.getNumberOfNewNetworks();
                slp.setNumberOfNewNetworks(numnets += numnewnetworks);
                slp.setLastNewNetwork(this.Time.getTime());
                this.CoreDB.saveLocalPeer(slp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyNetworkAuthChain(NetworkAuthorization na) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            block6: {
                BBytes networkcreator;
                LocalSubscribe lsa;
                LocalNetworkAuthorization pna;
                LocalNetwork sna;
                BBytes id;
                LocalPeer signingpeer;
                block7: {
                    signingpeer = this.CoreDB.getPeer(na.getSignature().getPeerIdentifier());
                    Log.info("Signing peer: " + signingpeer);
                    if (signingpeer == null) break block6;
                    Log.info("Signing peer: " + signingpeer.getPeer().getIdentity() + " for peer: " + na.getPeerId() + " net: " + na.getNetworkId());
                    id = signingpeer.getPeer().getIdentity();
                    sna = this.CoreDB.getLocalNetwork(na.getNetworkId());
                    if (sna != null) {
                        Log.info("Network signed by: " + sna.getNetwork().getSignature().getPeerIdentifier());
                    }
                    pna = this.CoreDB.getNetworkAuth(na.getNetworkId(), id);
                    lsa = this.CoreDB.getSubscription(na.getNetworkId(), id);
                    Log.info("Signing peer's network auth: " + pna);
                    if (pna == null || lsa != null && lsa.isMarkedBad() || pna == null || sna == null || sna.getNetwork().getSignature().getPeerIdentifier().equals(id) || na.getPeerId().equals(na.getSignature().getPeerIdentifier())) break block7;
                    int sa = pna.getNetworkAuthorization().getSignAuthority();
                    int nna = na.getSignAuthority();
                    Log.info("Signing peer's authority: " + sa + " granted athority: " + nna);
                    if ((sa != NetworkAuthorization.CANSIGN || nna != NetworkAuthorization.NOSIGN) && sa != NetworkAuthorization.CANGIVESIGNAUTH || !this.Crypto.verifyNetworkAuthorization(na, signingpeer.getPeer().getPeerKeys())) break block7;
                    Log.info("Authorization signature is valid.");
                    if (!this.verifyNetworkAuthChain(pna.getNetworkAuthorization())) break block7;
                    Log.info("Peer: " + na.getPeerId() + " is authorized for: " + na.getNetworkId());
                    return true;
                }
                if (sna == null || pna != null && (pna == null || lsa != null && lsa.isMarkedBad()) || !(networkcreator = sna.getNetwork().getSignature().getPeerIdentifier()).equals(id)) break block6;
                Log.info("The signing peer created the network!");
                if (!this.Crypto.verifyNetworkAuthorization(na, signingpeer.getPeer().getPeerKeys())) break block6;
                Log.info("N: Peer: " + na.getPeerId() + " is authorized for: " + na.getNetworkId());
                return true;
            }
            Log.info("Peer: " + na.getPeerId() + " is NOT authorized for: " + na.getNetworkId());
            Log.setLevel(Level.WARNING);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyNetworkAuth(NetworkAuthorization na) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer signingpeer;
            LocalNetworkAuthorization tna = this.CoreDB.getNetworkAuth(na.getNetworkId(), na.getPeerId());
            if (tna == null && (signingpeer = this.CoreDB.getPeer(na.getSignature().getPeerIdentifier())) != null && this.Crypto.verifyNetworkAuthorization(na, signingpeer.getPeer().getPeerKeys())) {
                return this.verifyNetworkAuthChain(na);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processNetworkAuths(BBytes conpeer, List<NetworkAuthorization> auths) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp = this.CoreDB.getMyPeerData();
            for (NetworkAuthorization na : auths) {
                LocalNetworkAuthorization splna;
                LocalPeer forpeer = this.CoreDB.getPeer(na.getPeerId());
                LocalPeer signer = this.CoreDB.getPeer(na.getSignature().getPeerIdentifier());
                LocalNetwork net = this.CoreDB.getLocalNetwork(na.getNetworkId());
                if (forpeer == null || signer == null || net == null || !this.verifyNetworkAuth(na)) continue;
                if (mp.getPeer().getPeer().getIdentity().equals(na.getPeerId())) {
                    net.setAuthorization(na.getSignAuthority());
                    net.setAuthorized(true);
                    this.CoreDB.saveLocalNetwork(net);
                }
                LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                lna.setNetworkAuthorization(na);
                lna.setLastNetworkAuthNumber(0L);
                lna.setLastNewAuths(this.Time.getTime());
                lna.setLocalDate(this.Time.getTime());
                lna.setNumberOfNewAuths(0L);
                lna.setRequestAuths(false);
                lna.setRequestAuthsDispatched(false);
                lna.setRequestAuthsDispatchedTime(this.Time.getTime());
                lna.setRequestAuthsPriority(0L);
                lna.setRequestAuthsTime(this.Time.getTime());
                lna.setPeerNickSig(forpeer.getPeer().getNickSig());
                lna.setSignerNickSig(signer.getPeer().getNickSig());
                lna.setNetworkTitle(net.getNetwork().getTitleSig());
                lna.setReceivedFromPeer(conpeer);
                lna.setPushRequested(true);
                this.CoreDB.saveLocalNetworkAuth(lna);
                LocalNetworkAuthorization slna = this.CoreDB.getNetworkAuth(na.getNetworkId(), na.getSignature().getPeerIdentifier());
                if (slna != null) {
                    long lastnum = slna.getLastNetworkAuthNumber();
                    if (na.getSignatureNumber() > lastnum) {
                        slna.setLastNetworkAuthNumber(na.getSignatureNumber());
                        if (na.getSignatureNumber() > lastnum + 1L) {
                            NetworkAuthHoles newholes = new NetworkAuthHoles();
                            newholes.setFirstNumber(lastnum + 1L);
                            newholes.setLastNumber(na.getSignatureNumber() - 1L);
                            newholes.setNetworkId(na.getNetworkId());
                            newholes.setPeerId(na.getSignature().getPeerIdentifier());
                            this.CoreDB.saveNetworkAuthHoles(newholes);
                        }
                    } else {
                        List<NetworkAuthHoles> holes = this.CoreDB.getPeerNetworkAuthHoles(na.getNetworkId(), na.getSignature().getPeerIdentifier());
                        for (NetworkAuthHoles h : holes) {
                            NetworkAuthHoles nh = h.newNetworkAuthReceived(na.getSignatureNumber());
                            if (nh != null) {
                                this.CoreDB.saveNetworkAuthHoles(nh);
                            }
                            if (h.isDone()) {
                                this.CoreDB.deleteNetworkAuthHoles(h);
                                continue;
                            }
                            this.CoreDB.saveNetworkAuthHoles(h);
                        }
                    }
                    slna.setRequestAuths(false);
                    slna.setRequestAuthsDispatched(false);
                    this.CoreDB.saveLocalNetworkAuth(slna);
                }
                if ((splna = this.CoreDB.getNetworkAuth(na.getNetworkId(), conpeer)) != null) {
                    splna.setNumberOfNewAuths(splna.getNumberOfNewAuths() + 1L);
                    splna.setLastNewAuths(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(splna);
                }
                this.Events.newNetworkAuthReceived(lna);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPublicPosts(BBytes conpeer, List<PublicPost> posts) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            long numpubposts = 0L;
            Log.info("Process public posts: " + posts.size());
            MyPeerDataSO mp = this.CoreDB.getMyPeerData();
            for (PublicPost pp : posts) {
                Log.info("Public post encrypted: " + pp.isEncrypted());
                BBytes peerid = pp.getSignature().getPeerIdentifier();
                LocalPeer lp = this.CoreDB.getPeer(peerid);
                LocalPublicPost olpp = this.CoreDB.getLocalPublicPost(peerid, pp.getPostNumber());
                if (lp == null || olpp != null) continue;
                Log.info("We don't already have the public post.");
                if (this.Crypto.verifyPublicPost(pp, lp.getPeer().getPeerKeys())) {
                    LocalNetwork net;
                    Log.info("The public post verifies!");
                    LocalPublicPost lpp = new LocalPublicPost();
                    lpp.setCreator(lp.getPeer().getNickSig());
                    if (pp.getNetworkId() != null && (net = this.CoreDB.getLocalNetwork(pp.getNetworkId())) != null) {
                        lpp.setNetworkTitle(net.getNetwork().getTitleSig());
                    }
                    lpp.setPeerRank(lp.getRank());
                    lpp.setLocalDate(this.Time.getTime());
                    lpp.setPublicPost(pp);
                    lpp.setPushRequsted(true);
                    lpp.setReceivedFromPeer(conpeer);
                    if (pp.isEncrypted()) {
                        Object privkey = this.CoreDB.getMyPeerData().getKeySet().getPrivateEncryptionKey();
                        Object decmsg = this.Crypto.decodePublicPost(pp.getMessage(), privkey);
                        Log.info("Decrypto public message for me: " + decmsg);
                        lpp.setDecodedMessage(decmsg);
                        if (decmsg != null) {
                            lpp.setPrivateMessage(true);
                            lpp.setToPeer(mp.getPeer().getPeer().getNickSig());
                        }
                    }
                    this.CoreDB.saveLocalPublicPost(lpp);
                    ++numpubposts;
                    long oldpostnum = lp.getLastPublicPostNumber();
                    if (pp.getPostNumber() > oldpostnum) {
                        lp.setLastPublicPostNumber(pp.getPostNumber());
                        if (pp.getPostNumber() > oldpostnum + 1L) {
                            PublicPostHoles pph = new PublicPostHoles();
                            pph.setFirstNumber(oldpostnum + 1L);
                            pph.setLastNumber(pp.getPostNumber() - 1L);
                            pph.setPeerId(peerid);
                            this.CoreDB.savePublicPostHoles(pph);
                        }
                    } else {
                        List<PublicPostHoles> pphl = this.CoreDB.getPublicPostHoles(peerid);
                        for (PublicPostHoles pph : pphl) {
                            PublicPostHoles npph = pph.newPublicPostReceived(pp.getPostNumber());
                            if (npph != null) {
                                this.CoreDB.savePublicPostHoles(npph);
                            }
                            if (pph.isDone()) {
                                this.CoreDB.deletePublicPostHoles(pph);
                                continue;
                            }
                            this.CoreDB.savePublicPostHoles(pph);
                        }
                    }
                    lp.setRequestPublicPosts(false);
                    lp.setRequestPublicPostsDispatched(false);
                    this.CoreDB.saveLocalPeer(lp);
                    this.Events.newPublicPostReceived(lpp);
                    continue;
                }
                Log.info("PUBLIC POST IS INVALID!");
            }
            LocalPeer slp = this.CoreDB.getPeer(conpeer);
            if (slp != null) {
                long numnets = slp.getNumberOfNewPublicPosts();
                slp.setNumberOfNewPublicPosts(numnets += numpubposts);
                slp.setLastNewPublicPost(this.Time.getTime());
                this.CoreDB.saveLocalPeer(slp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPeer(Peer p) {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                com.sendPeer(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushNetwork(Network n) {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                com.sendNetwork(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NetworkAuthorization> getAuthChain(NetworkAuthorization na) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LinkedList<NetworkAuthorization> r = new LinkedList<NetworkAuthorization>();
            BBytes netid = na.getNetworkId();
            BBytes curpeer = na.getSignature().getPeerIdentifier();
            LocalNetwork ln = this.CoreDB.getLocalNetwork(netid);
            if (ln != null) {
                LocalNetworkAuthorization lna;
                BBytes creatorid = ln.getNetwork().getSignature().getPeerIdentifier();
                r.add(na);
                while (curpeer != null && !creatorid.equals(curpeer)) {
                    lna = this.CoreDB.getNetworkAuth(netid, curpeer);
                    curpeer = null;
                    if (lna == null) continue;
                    r.add(0, lna.getNetworkAuthorization());
                    curpeer = lna.getNetworkAuthorization().getSignature().getPeerIdentifier();
                }
                lna = this.CoreDB.getNetworkAuth(netid, creatorid);
                if (lna != null) {
                    r.add(0, lna.getNetworkAuthorization());
                }
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushNetworkAuth(NetworkAuthorization na) {
        LinkedList<ComPeerInterface> cr = new LinkedList<ComPeerInterface>();
        Object object = this.Connections;
        synchronized (object) {
            ComPeerInterface c;
            cr.addAll(this.Connections.values());
            if (!this.Connections.containsKey(na.getPeerId()) && (c = this.connectToPeer(na.getPeerId())) != null) {
                cr.add(c);
            }
        }
        object = this.CoreDB;
        synchronized (object) {
            for (ComPeerInterface com : cr) {
                BBytes ppid = com.getPeer().getIdentity();
                Set<BBytes> nets = this.getNetworksForPeer(ppid);
                this.sendAuthChains(com, nets);
                Log.info("Check if we want to push auth to: " + ppid);
                BBytes nid = na.getNetworkId();
                LocalNetworkAuthorization pna = this.CoreDB.getNetworkAuth(nid, ppid);
                Log.info("Authorization for connected peer: " + ppid + "network: " + nid + " auth: " + pna);
                if (pna == null || !this.verifyNetworkAuthChain(pna.getNetworkAuthorization())) continue;
                Log.info("Push authorization: " + ppid);
                if (pna.getNumberOfNewAuths() == 0L) {
                    List<NetworkAuthorization> lna = this.getAuthChain(na);
                    for (NetworkAuthorization n : lna) {
                        com.sendNetworkAuth(n);
                    }
                    continue;
                }
                com.sendNetworkAuth(na);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPublicPost(PublicPost pp) {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                Log.info("Push new public post!");
                com.sendPublicPost(pp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushPost(Post p) {
        LinkedList<ComPeerInterface> cr = new LinkedList<ComPeerInterface>();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            cr.addAll(this.Connections.values());
        }
        for (ComPeerInterface com : cr) {
            BBytes nid = p.getNetworkId();
            BBytes ppid = com.getPeer().getIdentity();
            LocalSubscribe pna = this.CoreDB.getSubscription(nid, ppid);
            Log.info("PUSH: " + pna);
            if (pna == null) continue;
            Log.info("PUSH?: bad: " + pna.isMarkedBad() + " sub: " + pna.getSubscription().isSubscribe());
            if (pna.isMarkedBad() || !pna.getSubscription().isSubscribe()) continue;
            Log.info("Push post for network: " + nid + " from peer: " + this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity() + " to peer: " + ppid);
            com.sendPost(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushSubscription(Subscribe sub) {
        LinkedList<ComPeerInterface> cr = new LinkedList<ComPeerInterface>();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            cr.addAll(this.Connections.values());
        }
        for (ComPeerInterface com : cr) {
            BBytes ppid;
            BBytes nid = sub.getNetworkID();
            LocalSubscribe pna = this.CoreDB.getSubscription(nid, ppid = com.getPeer().getIdentity());
            if (pna == null || pna.isMarkedBad()) continue;
            com.sendSubscription(sub);
        }
    }

    @Override
    public List<Peer> requestPeers() {
        List<Peer> lst = null;
        lst = this.CoreDB.getPeers();
        Log.info("REQUEST PEERS=============================================: " + lst.size());
        return lst;
    }

    @Override
    public List<PublicPost> requestPublicPosts(BBytes requestingpeer, BBytes peerid, long fromnumber, long tonumber) {
        List<PublicPost> lst = null;
        lst = this.CoreDB.getPublicPosts(peerid, fromnumber, tonumber);
        Log.info("REQUEST: publicPosts: " + fromnumber + " to " + tonumber + " results: " + lst.size());
        return lst;
    }

    @Override
    public List<Network> requestNetworks(BBytes requestingpeer, BBytes peerid, long fromnumber, long tonumber) {
        List<Network> lst = null;
        lst = this.CoreDB.getNetworks(peerid, fromnumber, tonumber);
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkAuthorization> requestNetworkAuths(BBytes requestingpeer, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe lna = this.CoreDB.getSubscription(networkid, requestingpeer);
            if (lna != null && !lna.isMarkedBad()) {
                return this.CoreDB.getNetworkAuthorizations(peerid, networkid, fromnumber, tonumber);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Post> requestPosts(BBytes reqestingpeer, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
        Log.info("requestPosts : myid: " + myid.toHexString().substring(0, 10) + " net: " + networkid.toHexString().substring(0, 10) + " peer: " + peerid.toHexString().substring(0, 10) + " from: " + fromnumber + " to: " + tonumber);
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe lna = this.CoreDB.getSubscription(networkid, reqestingpeer);
            if (lna != null && !lna.isMarkedBad()) {
                List<Post> rl = this.CoreDB.getPosts(peerid, networkid, fromnumber, tonumber);
                Log.info("requestPosts number returned: " + rl.size());
                return rl;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscribe requestSubscription(BBytes requestingpeer, BBytes peerid, BBytes networkid, long lastnum) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            Log.info("requestSubscription myid: " + myid.toHexString().substring(0, 10) + " requestingpeer: " + requestingpeer.toHexString().substring(0, 10) + " peerid: " + peerid.toHexString().substring(0, 10) + " netid: " + networkid.toHexString().substring(0, 10) + " lastnum: " + lastnum);
            LocalNetwork nw = this.CoreDB.getLocalNetwork(networkid);
            boolean pubnet = false;
            if (nw != null && nw.getNetwork().getPublic() != null) {
                pubnet = nw.getNetwork().getPublic();
            }
            boolean ok = true;
            if (!pubnet) {
                LocalNetworkAuthorization conlna = this.CoreDB.getNetworkAuth(networkid, requestingpeer);
                LocalNetworkAuthorization sublna = this.CoreDB.getNetworkAuth(networkid, peerid);
                if (conlna == null || sublna == null) {
                    ok = false;
                }
            }
            Log.info("requestSubscription: ok: " + ok + " pub: " + pubnet);
            if (ok) {
                LocalSubscribe ls = this.CoreDB.getSubscription(networkid, peerid);
                Log.info("requestSubscription: ls: " + ls);
                if (ls != null) {
                    Subscribe subs = ls.getSubscription();
                    Log.info("requestSubscription: subs: " + subs.isSubscribe() + " lastnum: " + lastnum + " subnum: " + subs.getSubNumber());
                    if (subs != null && subs.getSignature().getSignature() != null && lastnum < subs.getSubNumber()) {
                        return subs;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileReference requestFile(BBytes requestingpeer, BBytes networkid, BBytes dig) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe lna = this.CoreDB.getSubscription(networkid, requestingpeer);
            if (lna != null && !lna.isMarkedBad()) {
                MyPeerDataSO me = this.CoreDB.getMyPeerData();
                BBytes myid = me.getPeer().getPeer().getIdentity();
                PeerHasFile phf = this.CoreDB.getPeerHasFile(networkid, myid, dig);
                List<FileReference> frefs = this.CoreDB.getFiles(networkid, dig);
                for (FileReference fr : frefs) {
                    if (fr.getFile() == null || !fr.getFile().exists() || !this.Crypto.digestFile(fr.getFile(), fr.getOffset(), fr.getSize()).equals(dig)) continue;
                    if (phf == null || !phf.isPeerHasFile()) {
                        this.CoreUser.addLocalPost(networkid, null, dig);
                    }
                    return fr;
                }
                if (phf == null) {
                    Log.warning("Someone requested a file from us we never had!");
                } else if (phf.isPeerHasFile()) {
                    this.CoreUser.addLocalPost(networkid, null, dig);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes pickPeerForSubs(BBytes networkid, Date then) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes addpeer = null;
            List<LocalSubscribe> dlst = this.CoreDB.getOrderedMostSubsLastDate(networkid, then);
            LinkedList<LocalSubscribe> nlst = new LinkedList<LocalSubscribe>();
            BBytes meid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            for (LocalSubscribe l : dlst) {
                if (l.getSubscription() == null || l.getSubscription().getSignature().getPeerIdentifier().equals(meid)) continue;
                nlst.add(l);
            }
            if (nlst.size() > 0) {
                double rv = this.Random.nextDouble();
                rv *= rv;
                int idx = (int)((double)nlst.size() * rv);
                idx = Math.min(idx, nlst.size() - 1);
                addpeer = ((LocalSubscribe)nlst.get(idx)).getSubscription().getSignature().getPeerIdentifier();
            }
            return addpeer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForSubs(HashSet<BBytes> conpeers) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Log.info("Pick peer for post update.");
            List<LocalSubscribe> plist = this.CoreDB.getOrderedSubsRequestedNotDispatched();
            if (plist.size() > 0) {
                long oktime = this.Time.getTime().getTime() - this.ReRequestTime;
                boolean found = false;
                LocalSubscribe lna = plist.get(0);
                BBytes netid = lna.getSubscription().getNetworkID();
                Iterator<BBytes> i = conpeers.iterator();
                while (!found && i.hasNext()) {
                    BBytes conpeer = i.next();
                    LocalSubscribe plna = this.CoreDB.getSubscription(netid, conpeer);
                    Log.info("Check if connected peer has auth to the network requesting: " + plna);
                    if (plna == null || !plna.getSubscription().isSubscribe() || plna.getRequestPostsTime() != null && plna.getRequestPostsTime().getTime() >= oktime) continue;
                    Log.info("Connected peer found!!!");
                    found = true;
                }
                if (!found) {
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForSubs(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " :: " + cnt);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForSubs(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " FINAL");
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes pickPeerForFile(HashSet<BBytes> peerwfile, BBytes networkid, Date then) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes addpeer = null;
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalSubscribe> nolst = this.CoreDB.getOrderedMostFilesMostPostsLastDate(networkid, then);
            LinkedList<BBytes> wfile = new LinkedList<BBytes>();
            for (LocalSubscribe n : nolst) {
                BBytes npeerid;
                if (n.getSubscription() == null || !peerwfile.contains(npeerid = n.getSubscription().getSignature().getPeerIdentifier()) || me.equals(npeerid)) continue;
                wfile.add(npeerid);
            }
            if (wfile.size() > 0) {
                double rv = this.Random.nextDouble();
                rv *= rv;
                int idx = (int)((double)wfile.size() * rv);
                idx = Math.min(idx, wfile.size() - 1);
                addpeer = (BBytes)wfile.get(idx);
            }
            return addpeer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForFiles(HashSet<BBytes> conpeers) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flist = this.CoreDB.getOrderedFilesRequestedNotDispatched();
            if (flist.size() > 0) {
                boolean found = false;
                FileReference fr = flist.get(0);
                Iterator<BBytes> i = conpeers.iterator();
                while (i.hasNext() && !found) {
                    BBytes conpeer = i.next();
                    PeerHasFile phf = this.CoreDB.getPeerHasFile(fr.getNetworkId(), conpeer, fr.getUnsignedDigest());
                    if (phf == null || !phf.isPeerHasFile()) continue;
                    found = true;
                }
                if (!found) {
                    List<PeerHasFile> phfl = this.CoreDB.getPeersHaveFile(fr.getNetworkId(), fr.getUnsignedDigest());
                    HashSet<BBytes> peerwfile = new HashSet<BBytes>();
                    for (PeerHasFile phf : phfl) {
                        if (!phf.isPeerHasFile()) continue;
                        peerwfile.add(phf.getPeerId());
                    }
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForFile(peerwfile, fr.getNetworkId(), then);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForFile(peerwfile, fr.getNetworkId(), then);
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes pickPeerForPosts(BBytes networkid, Date then) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes addpeer = null;
            List<LocalSubscribe> dlst = this.CoreDB.getOrderedMostPostsLastDate(networkid, then);
            LinkedList<LocalSubscribe> nlst = new LinkedList<LocalSubscribe>();
            BBytes meid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            for (LocalSubscribe l : dlst) {
                if (l.getSubscription() == null || l.getSubscription().getSignature().getPeerIdentifier().equals(meid)) continue;
                nlst.add(l);
            }
            if (nlst.size() > 0) {
                double rv = this.Random.nextDouble();
                rv *= rv;
                int idx = (int)((double)nlst.size() * rv);
                idx = Math.min(idx, nlst.size() - 1);
                addpeer = ((LocalSubscribe)nlst.get(idx)).getSubscription().getSignature().getPeerIdentifier();
            }
            return addpeer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForPosts(HashSet<BBytes> conpeers) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Log.info("Pick peer for post update.");
            List<LocalSubscribe> plist = this.CoreDB.getOrderedPostsRequestedNotDispatched();
            Log.info("getOrderedPostsRequestedNotDispatched: " + plist.size());
            if (plist.size() > 0) {
                long oktime = this.Time.getTime().getTime() - this.ReRequestTime;
                boolean found = false;
                LocalSubscribe lna = plist.get(0);
                BBytes netid = lna.getSubscription().getNetworkID();
                BBytes peerid = lna.getSubscription().getSignature().getPeerIdentifier();
                Log.info("Trying to find a peer to request posts from peer: " + peerid.toString().substring(0, 10) + " network: " + netid.toString().substring(0, 10));
                Iterator<BBytes> i = conpeers.iterator();
                while (!found && i.hasNext()) {
                    BBytes conpeer = i.next();
                    LocalSubscribe plna = this.CoreDB.getSubscription(netid, conpeer);
                    Log.info("Check if connected peer has auth to the network requesting: " + plna);
                    if (plna == null || !plna.getSubscription().isSubscribe() || plna.getRequestPostsTime() != null && plna.getRequestPostsTime().getTime() >= oktime) continue;
                    Log.info("Connected peer found!!!");
                    found = true;
                }
                if (!found) {
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForPosts(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " :: " + cnt);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForPosts(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " FINAL");
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForAuths(HashSet<BBytes> conpeers) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Log.info("Pick peer for auth update.");
            List<LocalNetworkAuthorization> plist = this.CoreDB.getOrderedNetworkAuthsRequestedNotDispatched();
            Log.info("getOrderedNetworkAuthsRequestedNotDispatched: " + plist.size());
            if (plist.size() > 0) {
                long oktime = this.Time.getTime().getTime() - this.ReRequestTime;
                boolean found = false;
                LocalNetworkAuthorization lna = plist.get(0);
                BBytes netid = lna.getNetworkAuthorization().getNetworkId();
                BBytes peerid = lna.getNetworkAuthorization().getPeerId();
                Log.info("Trying to find a peer to request auths from peer: " + peerid.toString().substring(0, 10) + " network: " + netid.toString().substring(0, 10));
                Iterator<BBytes> i = conpeers.iterator();
                while (!found && i.hasNext()) {
                    BBytes conpeer = i.next();
                    LocalNetworkAuthorization plna = this.CoreDB.getNetworkAuth(netid, conpeer);
                    Log.info("Check if connected peer has auth to the network requesting: " + plna);
                    if (plna == null || plna.getRequestAuthsTime() != null && plna.getRequestAuthsTime().getTime() >= oktime) continue;
                    Log.info("Connected peer found!!!");
                    found = true;
                }
                if (!found) {
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForPosts(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " :: " + cnt);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForPosts(netid, then);
                        Log.info("pickPeerForPosts: " + addpeer + " FINAL");
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes pickPeerForNetwork(Set<BBytes> conpeers, Date then) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes addpeer = null;
            List<LocalPeer> plst = this.CoreDB.getOrderedMostNetworksLastDate(then);
            LinkedList<BBytes> pplst = new LinkedList<BBytes>();
            BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            for (LocalPeer lp : plst) {
                if (conpeers.contains(lp.getPeer().getIdentity()) || myid.equals(lp.getPeer().getIdentity())) continue;
                pplst.add(lp.getPeer().getIdentity());
            }
            if (pplst.size() > 0) {
                double rv = this.Random.nextDouble();
                rv *= rv;
                int idx = (int)((double)pplst.size() * rv);
                idx = Math.min(idx, pplst.size() - 1);
                addpeer = (BBytes)pplst.get(idx);
            }
            return addpeer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForNetworks(HashSet<BBytes> conpeers) {
        if (conpeers.size() < this.MaxConnections) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                if (this.CoreDB.getHighestPriorityNeteworkRequest() != null) {
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForNetwork(conpeers, then);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForNetwork(conpeers, then);
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes pickPeerForPublicPosts(Set<BBytes> conpeers, Date then) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes addpeer = null;
            List<LocalPeer> plst = this.CoreDB.getOrderedMostPublicPostsLastDate(then);
            LinkedList<BBytes> pplst = new LinkedList<BBytes>();
            BBytes myid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            for (LocalPeer lp : plst) {
                if (conpeers.contains(lp.getPeer().getIdentity()) || myid.equals(lp.getPeer().getIdentity())) continue;
                pplst.add(lp.getPeer().getIdentity());
            }
            if (pplst.size() > 0) {
                double rv = this.Random.nextDouble();
                rv *= rv;
                int idx = (int)((double)pplst.size() * rv);
                idx = Math.min(idx, pplst.size() - 1);
                addpeer = (BBytes)pplst.get(idx);
            }
            return addpeer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForPublicPosts(HashSet<BBytes> conpeers) {
        if (conpeers.size() < this.MaxConnections) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalPeer lp = this.CoreDB.getHighestPriorityPublicPostRequest();
                if (lp != null) {
                    Log.info("Highest priority public post request: " + lp.getPeer().getIdentity() + " rqst: " + lp.isRequestPublicPosts());
                    BBytes addpeer = null;
                    Date now = this.Time.getTime();
                    int cnt = 0;
                    while (cnt < this.NumberTimeConnectedSteps && addpeer == null) {
                        Date then = new Date(now.getTime() - (long)(cnt + 1) * this.TimeConnectedSteps);
                        addpeer = this.pickPeerForPublicPosts(conpeers, then);
                        ++cnt;
                    }
                    if (addpeer == null) {
                        Date then = new Date(0L);
                        addpeer = this.pickPeerForPublicPosts(conpeers, then);
                    }
                    return addpeer;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BBytes getNewPeerForPeers(HashSet<BBytes> conpeers, HashSet<BBytes> ncp) {
        Log.info("getNewPeerForPeers: " + conpeers.size());
        if (conpeers.size() + ncp.size() < this.MaxConnections) {
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                LocalPeer lp = this.CoreDB.getHighestPriorityPeerRequest();
                if (lp != null) {
                    lp.setRequestPeers(false);
                    this.CoreDB.saveLocalPeer(lp);
                    return lp.getPeer().getIdentity();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComPeerInterface connectToPeer(BBytes peer) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp;
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            if (!me.equals(peer) && (lp = this.CoreDB.getPeer(peer)) != null) {
                ComPeerInterface c = this.Com.getComPeerInterface(lp.getPeer());
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reDispatch() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            long curtime = this.Time.getTime().getTime();
            long cuttime = curtime - this.getReDispatchTime();
            List<FileReference> l = this.CoreDB.getOrderedFilesRequestedAndDispatched();
            Log.info("Found files dispatched: " + l.size());
            for (FileReference r : l) {
                if (r.getUserRequestDispatchTime().getTime() >= cuttime) break;
                r.setUserRequestDispatched(false);
                this.CoreDB.saveFileReference(r);
                Log.info("Re-dispatch file: " + r.getFile() + " offset: " + r.getOffset());
            }
            List<LocalPeer> lpl = this.CoreDB.getOrderedNetworksRequestedAndDispatched();
            Log.info("Found networks dispatched: " + lpl.size());
            for (LocalPeer lp : lpl) {
                if (lp.getRequestNetworksDispatchedTime().getTime() >= cuttime) break;
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            lpl = this.CoreDB.getOrderedPublicPostsRequestedAndDispatched();
            Log.info("Found public posts dispatched: " + lpl.size());
            for (LocalPeer lp : lpl) {
                if (lp.getRequestPublicPostsDispatchedTime().getTime() >= cuttime) break;
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            List<LocalNetworkAuthorization> lll = this.CoreDB.getOrderedNetworkAuthsRequestedAndDispatched();
            Log.info("Found network auths dispatched: " + lll.size());
            for (LocalNetworkAuthorization ll : lll) {
                if (ll.getRequestAuthsDispatchedTime().getTime() >= cuttime) break;
                ll.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(ll);
            }
            List<LocalSubscribe> lls = this.CoreDB.getOrderedPostsRequestedAndDispatched();
            Log.info("Found posts dispatched: " + lls.size());
            for (LocalSubscribe ll : lls) {
                if (ll.getRequestPostsDispatchedTime().getTime() >= cuttime) break;
                ll.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalSubscription(ll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConnection() {
        long curtime = this.Time.getTime().getTime();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface com : this.Connections.values()) {
                if (!(com instanceof ComPeerImplTest)) continue;
                ComPeerImplTest ct = (ComPeerImplTest)com;
                System.out.println("Com: peer " + com.getPeer().getIdentity() + " times: " + ct.getCloseAtTime() + " <> " + curtime + " ok: " + ct.isOk());
            }
        }
    }

    private boolean canReConnectYet(BBytes pid) {
        LocalPeer lp = this.CoreDB.getPeer(pid);
        return lp.getLastConnectionTime().compareTo(this.Time.getTime()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        BBytes newsubpeer;
        BBytes newpeerpeer;
        BBytes newpubpeer;
        BBytes newnetpeer;
        BBytes newauthpeer;
        BBytes newpostpeer;
        this.reDispatch();
        String me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity().toString();
        Log.info("[" + me + "]");
        HashSet<BBytes> conpeers = new HashSet<BBytes>();
        HashSet<BBytes> newconpeers = new HashSet<BBytes>();
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            conpeers.addAll(this.Connections.keySet());
        }
        BBytes newfilepeer = this.getNewPeerForFiles(conpeers);
        if (newfilepeer != null && this.canReConnectYet(newfilepeer)) {
            Log.info("New peer for files: " + newfilepeer);
            newconpeers.add(newfilepeer);
        }
        if ((newpostpeer = this.getNewPeerForPosts(conpeers)) != null && this.canReConnectYet(newpostpeer)) {
            Log.info("New peer for posts: " + newpostpeer);
            newconpeers.add(newpostpeer);
        }
        if ((newauthpeer = this.getNewPeerForAuths(conpeers)) != null && this.canReConnectYet(newauthpeer)) {
            Log.info("New peer for posts: " + newauthpeer);
            newconpeers.add(newauthpeer);
        }
        if ((newnetpeer = this.getNewPeerForNetworks(conpeers)) != null && this.canReConnectYet(newnetpeer)) {
            Log.info("New peer for networks: " + newnetpeer);
            newconpeers.add(newnetpeer);
        }
        if ((newpubpeer = this.getNewPeerForPublicPosts(conpeers)) != null && this.canReConnectYet(newpubpeer)) {
            Log.info("New peer for public posts: " + newpubpeer);
            newconpeers.add(newpubpeer);
        }
        if ((newpeerpeer = this.getNewPeerForPeers(conpeers, newconpeers)) != null && this.canReConnectYet(newpeerpeer)) {
            Log.info("New peer for peers: " + newpeerpeer);
            newconpeers.add(newpeerpeer);
        }
        if ((newsubpeer = this.getNewPeerForSubs(conpeers)) != null && this.canReConnectYet(newsubpeer)) {
            Log.info("New peer for peers: " + newsubpeer);
            newconpeers.add(newsubpeer);
        }
        int numconnects = conpeers.size() + newconpeers.size();
        while (numconnects > this.MaxConnections) {
            --numconnects;
            ComPeerInterface con = null;
            Map<BBytes, ComPeerInterface> map2 = this.Connections;
            synchronized (map2) {
                Date oldtime = null;
                for (ComPeerInterface c : this.Connections.values()) {
                    if (c.isBusy()) continue;
                    if (oldtime == null) {
                        con = c;
                        oldtime = con.getLastRequestTime();
                        continue;
                    }
                    if (oldtime.compareTo(c.getLastRequestTime()) <= 0) continue;
                    con = c;
                    oldtime = con.getLastRequestTime();
                }
            }
            if (con == null) continue;
            Log.info("Closing old connection because there are too many.");
            con.Close();
        }
        for (BBytes b : newconpeers) {
            Log.info("Go connect to new peer: " + b);
            this.connectToPeer(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReady() {
        Map<BBytes, ComPeerInterface> map = this.Connections;
        synchronized (map) {
            for (ComPeerInterface c : this.Connections.values()) {
                c.requestReady();
            }
        }
    }

    public File getTemplateDir() {
        return this.TemplateDir;
    }

    public void setTemplateDir(File templateDir) {
        this.TemplateDir = templateDir;
    }

    @Override
    public void addConnectionListeners(ConnectionUpdateInterface c) {
        this.Events.addConnectionListeners(c);
    }

    @Override
    public void setEventDispatcher(EventDispatcher e) {
        this.Events = e;
    }

    public long getReDispatchTime() {
        return this.ReDispatchTime;
    }

    public void setReDispatchTime(long reDispatchTime) {
        this.ReDispatchTime = reDispatchTime;
    }

    public long getReConnectTime() {
        return this.ReConnectTime;
    }

    public void setReConnectTime(long reConnectTime) {
        this.ReConnectTime = reConnectTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NetworkAuthorization> requestMyNewNetworkAuths(BBytes requestingpeer) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LinkedList<NetworkAuthorization> r = new LinkedList<NetworkAuthorization>();
            BBytes meid = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalNetworkAuthorization> alllist = this.CoreDB.getPeerNetworkAuths(requestingpeer);
            for (LocalNetworkAuthorization na : alllist) {
                if (na.getNumberOfNewAuths() != 0L) continue;
                LocalNetworkAuthorization mya = this.CoreDB.getNetworkAuth(na.getNetworkAuthorization().getNetworkId(), meid);
                List<NetworkAuthorization> achain = this.getAuthChain(na.getNetworkAuthorization());
                List<NetworkAuthorization> mchain = this.getAuthChain(mya.getNetworkAuthorization());
                r.addAll(achain);
                r.addAll(mchain);
                na.setNumberOfNewAuths(1L);
                this.CoreDB.saveLocalNetworkAuth(na);
            }
            return r;
        }
    }

    public long getReRequestTime() {
        return this.ReRequestTime;
    }

    public void setReRequestTime(long reRequestTime) {
        this.ReRequestTime = reRequestTime;
    }

    public int getMaxBatchRequests() {
        return this.MaxBatchRequests;
    }

    public void setMaxBatchRequests(int maxBatchRequests) {
        this.MaxBatchRequests = maxBatchRequests;
    }
}

