/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.com;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSSocket;
import org.ourfilesystem.com.SimpleSocket;

public class SimpleConnector
implements OFSConnector {
    private boolean UseProxy;
    private int ProxyPort;
    private String ProxyAddr;

    public SimpleConnector(boolean useproxy, String proxyaddr, int port) {
        this.UseProxy = useproxy;
        this.ProxyAddr = proxyaddr;
        this.ProxyPort = port;
    }

    @Override
    public OFSSocket connect(String location) throws IOException {
        Pattern p = Pattern.compile("(\\S+):(\\d+)");
        Matcher m = p.matcher(location);
        if (m.find()) {
            String addr = m.group(1);
            int port = Integer.valueOf(m.group(2));
            if (this.UseProxy) {
                InetSocketAddress address = InetSocketAddress.createUnresolved(this.ProxyAddr, this.ProxyPort);
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, address);
                Socket s = new Socket(proxy);
                InetSocketAddress c = InetSocketAddress.createUnresolved(addr, port);
                s.connect(c, 0);
                return new SimpleSocket(s);
            }
            return new SimpleSocket(new Socket(addr, port));
        }
        throw new IOException("Invalid address " + location);
    }

    public boolean isUseProxy() {
        return this.UseProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.UseProxy = useProxy;
    }

    public int getProxyPort() {
        return this.ProxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.ProxyPort = proxyPort;
    }

    public String getProxyAddr() {
        return this.ProxyAddr;
    }

    public void setProxyAddr(String proxyAddr) {
        this.ProxyAddr = proxyAddr;
    }
}

