/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.com;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ourfilesystem.com.ComPeerInterface;
import org.ourfilesystem.com.ConnectionUpdateInterface;
import org.ourfilesystem.com.OFSConnector;
import org.ourfilesystem.com.OFSSocket;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.Subscribe;
import org.ourfilesystem.security.CryptoComInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SecurityTools;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.ByteCounter;
import org.ourfilesystem.utilities.FileUtils;
import org.ourfilesystem.utilities.Version;

public class ComPeerImpl
implements ComPeerInterface,
ConnectionUpdateInterface {
    public static final Logger Log = Logger.getLogger(ComPeerImpl.class.getName());
    public static int FilePendingPentality = 1;
    public static int MAXSEND = 200;
    private OFSConnector Connector;
    private BBytes PeerId;
    private OFSSocket Socket;
    private boolean Ok;
    private boolean CClosed;
    private CoreComInterface Core;
    private DataBaseCoreInterface DB;
    private CryptoComInterface Crypt;
    private IncomingThread Incoming;
    private OutgoingThread Outgoing;
    private ConcurrentLinkedQueue<PostRequest> PostRequestPending;
    private ConcurrentLinkedQueue<FileRequest> FileRequestPending;
    private ConcurrentLinkedQueue<NetworkAuthRequest> NetworkAuthRequestPending;
    private ConcurrentLinkedQueue<NetworkRequest> NetworkRequestPending;
    private ConcurrentLinkedQueue<PublicPostRequest> PublicPostRequestPending;
    private ConcurrentLinkedQueue<SubscriptionRequest> SubRequestsPending;
    private LinkedList<EventInterface> Events;
    private Peer ConnectedPeer;
    private long MaxPendingWithNoData = 1800000L;
    private InputTimer Timer;
    private File TempDir;
    private int LastRequestType;
    private Date LastRequestTime;
    private Peer MyPeer;
    private Version Version;
    private static int REQUEST_POSTS = 1;
    private static int REQUEST_PEERS = 2;
    private static int REQUEST_FILES = 3;
    private static int REQUEST_NETWORKS = 4;
    private static int REQUEST_NETWORKAUTHS = 5;
    private static int REQUEST_PUBLICPOSTS = 6;
    private static int REQUEST_SUBS = 7;
    private static int SEND_POSTS = 17;
    private static int SEND_PEERS = 18;
    private static int SEND_FILES = 19;
    private static int SEND_NETWORKS = 20;
    private static int SEND_NETWORKAUTHS = 21;
    private static int SEND_PUBLICPOSTS = 22;
    private static int SEND_SUBS = 23;
    private static int SEND_NO_POSTS = 33;
    private static int SEND_FILE_NOT_FOUND = 35;
    private static int SEND_NO_NETWORKS = 36;
    private static int SEND_NO_NETWORKAUTHS = 37;
    private static int SEND_NO_PUBLICPOSTS = 38;
    private static int SEND_NO_SUBS = 39;

    public ComPeerImpl(CoreComInterface core, DataBaseCoreInterface db, CryptoComInterface crypt, File td, Peer p, OFSSocket sock) {
        this.init(core, db, crypt, td, p, null, sock);
    }

    public ComPeerImpl(CoreComInterface core, DataBaseCoreInterface db, CryptoComInterface crypt, File td, Peer p, OFSConnector con) {
        this.init(core, db, crypt, td, p, con, null);
    }

    public ComPeerImpl(CoreComInterface core, DataBaseCoreInterface db, CryptoComInterface crypt, File td, Peer p, OFSConnector con, OFSSocket sock) {
        this.init(core, db, crypt, td, p, con, sock);
    }

    private void init(CoreComInterface core, DataBaseCoreInterface db, CryptoComInterface crypt, File td, Peer p, OFSConnector con, OFSSocket sock) {
        this.Events = new LinkedList();
        this.CClosed = false;
        this.Connector = con;
        this.Socket = sock;
        this.ConnectedPeer = p;
        this.TempDir = td;
        this.TempDir.mkdirs();
        this.Version = new Version();
        this.DB = db;
        if (this.ConnectedPeer != null) {
            this.PeerId = this.ConnectedPeer.getIdentity();
        }
        this.Core = core;
        this.Core.addConnectionListeners(this);
        this.Crypt = crypt;
        this.DB = db;
        this.Ok = true;
        this.Timer = new InputTimer();
        Thread t2 = new Thread(this.Timer);
        t2.start();
        this.PostRequestPending = new ConcurrentLinkedQueue();
        this.FileRequestPending = new ConcurrentLinkedQueue();
        this.NetworkAuthRequestPending = new ConcurrentLinkedQueue();
        this.NetworkRequestPending = new ConcurrentLinkedQueue();
        this.PublicPostRequestPending = new ConcurrentLinkedQueue();
        this.SubRequestsPending = new ConcurrentLinkedQueue();
        this.Incoming = new IncomingThread(this);
        this.Outgoing = new OutgoingThread(this);
        HandShakeThread hs = new HandShakeThread(this);
        Thread t = new Thread(hs);
        t.start();
    }

    private void startBigThreads() {
        Thread ti = new Thread(this.Incoming);
        ti.start();
        Thread to = new Thread(this.Outgoing);
        to.start();
    }

    @Override
    public Peer getPeer() {
        return this.ConnectedPeer;
    }

    @Override
    public boolean isOk() {
        return this.Ok;
    }

    @Override
    public void Close() {
        block8: {
            if (this.PeerId != null) {
                Log.info("CLOSING: " + this.PeerId.toString().substring(0, 10));
            } else {
                Log.info("CLOSING PeerId == null");
            }
            this.Ok = false;
            if (!this.CClosed && this.PeerId != null) {
                this.CClosed = true;
                this.Core.connectionClosed(this, true);
            }
            this.CClosed = true;
            try {
                if (this.Socket != null) {
                    this.Socket.close();
                }
            }
            catch (Exception e) {
                if (!Level.INFO.equals(Log.getLevel())) break block8;
                e.printStackTrace();
            }
        }
        this.Timer.DataReceived();
        if (this.Incoming != null) {
            this.Incoming.Close();
        }
        if (this.Outgoing != null) {
            this.Outgoing.Close();
        }
        this.failPending();
        this.fireUpdate();
    }

    private void failPending() {
        Object nr;
        Object pr;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (this.PostRequestPending.size() > 0) {
            pr = this.PostRequestPending.poll();
            if (pr == null) continue;
            this.Core.requestPostsFailed(this, ((PostRequest)pr).PeerId, ((PostRequest)pr).NetworkId);
        }
        while (this.FileRequestPending.size() > 0) {
            FileRequest fr = this.FileRequestPending.poll();
            if (fr == null) continue;
            this.Core.requestFileFailed(this, fr.NetworkId, fr.Digest);
        }
        while (this.NetworkAuthRequestPending.size() > 0) {
            nr = this.NetworkAuthRequestPending.poll();
            if (nr == null) continue;
            this.Core.requestNetworkAuthsFailed(this, ((NetworkAuthRequest)nr).PeerId, ((NetworkAuthRequest)nr).NetworkId);
        }
        while (this.NetworkRequestPending.size() > 0) {
            nr = this.NetworkRequestPending.poll();
            if (nr == null) continue;
            this.Core.requestNetworksFailed(this, ((NetworkRequest)nr).PeerId);
        }
        while (this.PublicPostRequestPending.size() > 0) {
            pr = this.PublicPostRequestPending.poll();
            if (pr == null) continue;
            this.Core.requestPublicPostsFailed(this, ((PublicPostRequest)pr).PeerId);
        }
        while (this.SubRequestsPending.size() > 0) {
            SubscriptionRequest sr = this.SubRequestsPending.poll();
            if (sr == null) continue;
            this.Core.requestSubscriptionFailed(this, sr.PeerId, sr.NetworkId);
        }
    }

    @Override
    public void requestPosts(NetworkAuthorization myauth, NetworkAuthorization yourauth, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        Log.info("peerid: " + peerid + " networkid: " + networkid + " from: " + fromnumber + " to " + tonumber);
        this.LastRequestType = 0;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestPosts(myauth, yourauth, networkid, peerid, fromnumber, tonumber);
        } else {
            this.Core.requestPostsFailed(this, peerid, networkid);
        }
    }

    @Override
    public void requestsFile(BBytes networkid, BBytes digest) {
        this.LastRequestType = 5;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestFile(networkid, digest);
        } else {
            this.Core.requestFileFailed(this, networkid, digest);
        }
    }

    @Override
    public void requestPeers() {
        this.LastRequestType = 4;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestPeers();
        }
    }

    @Override
    public void requestPublicPosts(BBytes peerid, long fromnumber, long tonumber) {
        this.LastRequestType = 1;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestPublicPosts(peerid, fromnumber, tonumber);
        } else {
            this.Core.requestPublicPostsFailed(this, peerid);
        }
    }

    @Override
    public void requestNetworks(BBytes peerid, long fromnumber, long tonumber) {
        Log.info("peer: " + peerid + " from " + fromnumber + " to " + tonumber);
        this.LastRequestType = 2;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestNetworks(peerid, fromnumber, tonumber);
        } else {
            this.Core.requestNetworksFailed(this, peerid);
        }
    }

    @Override
    public void requestNetworkAuths(NetworkAuthorization myauth, NetworkAuthorization yourauth, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        this.LastRequestType = 3;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestNetworkAuths(myauth, yourauth, networkid, peerid, fromnumber, tonumber);
        } else {
            this.Core.requestNetworkAuthsFailed(this, peerid, networkid);
        }
    }

    @Override
    public void requestSubscriptions(BBytes peerid, BBytes networkid, long lastnum) {
        this.LastRequestType = 6;
        this.LastRequestTime = new Date();
        if (!this.CClosed) {
            if (this.getPendingRequests() == 0) {
                this.Timer.DataReceived();
            }
            this.Outgoing.requestSubscriptions(peerid, networkid, lastnum);
        } else {
            this.Core.requestSubscriptionFailed(this, peerid, networkid);
        }
    }

    @Override
    public void sendSubscription(Subscribe s) {
        this.Outgoing.addSubscription(s);
    }

    @Override
    public void sendPeer(Peer peer) {
        LinkedList<Peer> l = new LinkedList<Peer>();
        l.add(peer);
        this.Outgoing.addPeers(l);
    }

    @Override
    public void sendPost(Post post) {
        LinkedList<Post> p = new LinkedList<Post>();
        p.add(post);
        this.Outgoing.addPosts(p);
    }

    @Override
    public void sendPublicPost(PublicPost post) {
        LinkedList<PublicPost> l = new LinkedList<PublicPost>();
        l.add(post);
        this.Outgoing.addPublicPosts(l);
    }

    @Override
    public void sendNetwork(Network network) {
        LinkedList<Network> l = new LinkedList<Network>();
        l.add(network);
        this.Outgoing.addNetworks(l);
    }

    @Override
    public void sendNetworkAuth(NetworkAuthorization na) {
        LinkedList<NetworkAuthorization> l = new LinkedList<NetworkAuthorization>();
        l.add(na);
        this.Outgoing.addNetworkAuths(l);
    }

    public void doRequestPosts(NetworkAuthorization yauth, NetworkAuthorization myauth, BBytes peerid, BBytes networkid, long fromnumber, long tonumber) {
        List<Post> list;
        if (yauth != null && myauth != null) {
            LinkedList<NetworkAuthorization> nll = new LinkedList<NetworkAuthorization>();
            nll.add(myauth);
            nll.add(yauth);
            this.Core.processNetworkAuths(this.PeerId, nll);
        }
        if ((list = this.Core.requestPosts(this.PeerId, peerid, networkid, fromnumber, tonumber)) != null && list.size() > 0) {
            this.Outgoing.addPosts(list);
        } else {
            PostRequest pr = new PostRequest();
            pr.NetworkId = networkid;
            pr.PeerId = peerid;
            pr.Start = fromnumber;
            pr.End = tonumber;
            this.Outgoing.addNoPosts(pr);
        }
    }

    public void doRequestPeers() {
        List<Peer> list = this.Core.requestPeers();
        this.Outgoing.addPeers(list);
        List<NetworkAuthorization> yourlist = this.Core.requestMyNewNetworkAuths(this.PeerId);
        if (yourlist != null) {
            this.Outgoing.addNetworkAuths(yourlist);
        }
    }

    public void doRequestsFile(BBytes networkid, BBytes digest) {
        FileReference f = this.Core.requestFile(this.PeerId, networkid, digest);
        Log.info("RETURN FileReference: " + f);
        if (f != null) {
            this.Outgoing.addFile(f);
        } else {
            FileRequest fr = new FileRequest();
            fr.NetworkId = networkid;
            fr.Digest = digest;
            this.Outgoing.addFileNotFound(fr);
        }
    }

    public void doRequestNetworks(BBytes peerid, long start, long end) {
        List<Network> l = this.Core.requestNetworks(this.PeerId, peerid, start, end);
        if (l.size() > 0) {
            Log.info("Sending networks! " + l.size());
            this.Outgoing.addNetworks(l);
        } else {
            Log.info("Sending no networks! " + peerid);
            NetworkRequest nr = new NetworkRequest();
            nr.PeerId = peerid;
            nr.Start = start;
            nr.End = end;
            this.Outgoing.addNoNetworks(nr);
        }
    }

    public void doRequestNetworkAuths(NetworkAuthorization yauth, NetworkAuthorization myauth, BBytes peerid, BBytes networkid, long start, long end) {
        List<NetworkAuthorization> l = new LinkedList<NetworkAuthorization>();
        l.add(myauth);
        l.add(yauth);
        this.Core.processNetworkAuths(this.PeerId, l);
        l = this.Core.requestNetworkAuths(this.PeerId, peerid, networkid, start, end);
        if (l != null && l.size() > 0) {
            this.Outgoing.addNetworkAuths(l);
        } else {
            NetworkAuthRequest nr = new NetworkAuthRequest();
            nr.NetworkId = networkid;
            nr.PeerId = peerid;
            nr.Start = start;
            nr.End = end;
            this.Outgoing.addNoNetworkAuths(nr);
        }
    }

    public void doRequestPublicPosts(BBytes peerid, long start, long end) {
        List<PublicPost> l = this.Core.requestPublicPosts(this.PeerId, peerid, start, end);
        if (l.size() > 0) {
            this.Outgoing.addPublicPosts(l);
        } else {
            PublicPostRequest pr = new PublicPostRequest();
            pr.PeerId = peerid;
            pr.Start = start;
            pr.End = end;
            this.Outgoing.addNoPublicPosts(pr);
        }
    }

    public void doRequestSubscriptions(BBytes networkid, BBytes peerid, long last) {
        Subscribe sub = this.Core.requestSubscription(this.PeerId, peerid, networkid, last);
        if (sub != null) {
            this.Outgoing.addSubscription(sub);
        } else {
            SubscriptionRequest sr = new SubscriptionRequest();
            sr.NetworkId = networkid;
            sr.PeerId = peerid;
            sr.LastSubNum = last;
            this.Outgoing.addNoSub(sr);
        }
    }

    private void addPostRequestPending(PostRequest pr) {
        if (pr != null) {
            this.PostRequestPending.add(pr);
        }
    }

    private void addFileRequestPending(FileRequest dig) {
        if (dig != null) {
            this.FileRequestPending.add(dig);
        }
    }

    private void addNetworkRequestPending(NetworkRequest nr) {
        if (nr != null) {
            this.NetworkRequestPending.add(nr);
        }
    }

    private void addNetworkAuthRequestPending(NetworkAuthRequest nr) {
        if (nr != null) {
            this.NetworkAuthRequestPending.add(nr);
        }
    }

    private void addPublicPostRequestPending(PublicPostRequest pr) {
        if (pr != null) {
            this.PublicPostRequestPending.add(pr);
        }
    }

    private void addSubRequestPending(SubscriptionRequest s) {
        if (s != null) {
            this.SubRequestsPending.add(s);
        }
    }

    private void removePostRequestPending(BBytes networkid, BBytes peerid) {
        PostRequest pr = new PostRequest();
        pr.NetworkId = networkid;
        pr.PeerId = peerid;
        while (this.PostRequestPending.remove(pr)) {
        }
    }

    private void removeFileRequestPending(BBytes networkid, BBytes dig) {
        FileRequest fr = new FileRequest();
        fr.NetworkId = networkid;
        fr.Digest = dig;
        while (this.FileRequestPending.remove(fr)) {
        }
    }

    private void removeNetworkRequestPending(BBytes peerid) {
        NetworkRequest nr = new NetworkRequest();
        nr.PeerId = peerid;
        while (this.NetworkRequestPending.remove(nr)) {
        }
    }

    private void removeNetworkAuthRequestPending(BBytes networkid, BBytes peerid) {
        NetworkAuthRequest nr = new NetworkAuthRequest();
        nr.NetworkId = networkid;
        nr.PeerId = peerid;
        while (this.NetworkAuthRequestPending.remove(nr)) {
        }
    }

    private void removePublicPostRequestPending(BBytes peerid) {
        PublicPostRequest pr = new PublicPostRequest();
        pr.PeerId = peerid;
        while (this.PublicPostRequestPending.remove(pr)) {
        }
    }

    private void removeSubscriptionPending(BBytes networkid, BBytes peerid) {
        SubscriptionRequest sr = new SubscriptionRequest();
        sr.NetworkId = networkid;
        sr.PeerId = peerid;
        while (this.SubRequestsPending.remove(sr)) {
        }
    }

    public long getMaxPendingWithNoData() {
        return this.MaxPendingWithNoData;
    }

    public void setMaxPendingWithNoData(long maxPendingWithNoData) {
        this.MaxPendingWithNoData = maxPendingWithNoData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUpdate() {
        LinkedList<EventInterface> rl = new LinkedList<EventInterface>();
        LinkedList<EventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            rl.addAll(this.Events);
        }
        Iterator i = rl.iterator();
        while (i.hasNext()) {
            ((EventInterface)i.next()).connectionEvent(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventInterface(EventInterface ev) {
        LinkedList<EventInterface> linkedList = this.Events;
        synchronized (linkedList) {
            this.Events.add(ev);
        }
    }

    @Override
    public int getLastRequestType() {
        return this.LastRequestType;
    }

    @Override
    public boolean isBusy() {
        return this.Incoming.isBusy() || this.Outgoing.isBusy();
    }

    @Override
    public Date getLastRequestTime() {
        return this.LastRequestTime;
    }

    @Override
    public int getPendingRequests() {
        int n = this.PostRequestPending.size();
        n += this.FileRequestPending.size();
        n += this.NetworkAuthRequestPending.size();
        n += this.NetworkRequestPending.size();
        n += this.PublicPostRequestPending.size();
        return n += this.SubRequestsPending.size();
    }

    @Override
    public long getBytesSent() {
        return this.Outgoing.Counter.getNumber();
    }

    @Override
    public long getBytesReceived() {
        return this.Incoming.Counter.getNumber();
    }

    @Override
    public void requestReady() {
        this.Outgoing.requestReady();
    }

    class FileRequest {
        public BBytes NetworkId;
        public BBytes Digest;

        FileRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof FileRequest)) {
                return false;
            }
            FileRequest fr = (FileRequest)obj;
            if (this.NetworkId == null) {
                return false;
            }
            if (this.Digest == null) {
                return false;
            }
            if (fr.NetworkId == null) {
                return false;
            }
            if (fr.Digest == null) {
                return false;
            }
            return this.Digest.equals(fr.Digest) && this.NetworkId.equals(fr.NetworkId);
        }

        public int hashCode() {
            return this.NetworkId.hashCode() ^ this.Digest.hashCode();
        }
    }

    class HandShakeThread
    implements Runnable {
        private ComPeerImpl Com;

        public HandShakeThread(ComPeerImpl i) {
            this.Com = i;
        }

        @Override
        public void run() {
            ByteCounter c = new ByteCounter();
            try {
                if (ComPeerImpl.this.Socket == null) {
                    if (ComPeerImpl.this.ConnectedPeer.getLocation() != null) {
                        Log.info("Attempt to connect using connector: " + ComPeerImpl.this.Connector + " to peer: " + ComPeerImpl.this.ConnectedPeer.getNickSig());
                        ComPeerImpl.this.Socket = ComPeerImpl.this.Connector.connect((String)ComPeerImpl.this.ConnectedPeer.getLocation());
                        ComPeerImpl.this.Socket.setSoTimeout(300000);
                    } else {
                        ComPeerImpl.this.Close();
                        return;
                    }
                }
                if (ComPeerImpl.this.Socket == null) {
                    Log.info("No socket returned.  No connection.");
                    ComPeerImpl.this.Close();
                } else {
                    Log.info("Process handshake.");
                    InputStream is = ComPeerImpl.this.Socket.getInputStream();
                    OutputStream os = ComPeerImpl.this.Socket.getOutputStream();
                    Log.info("Send Challenge.");
                    BBytes outchallenge = (BBytes)this.Com.Crypt.getChallenge();
                    FileUtils.writeBytes(os, outchallenge.getBytes(), c);
                    os.flush();
                    Log.info("Read Challenge.");
                    KeySet ks = this.Com.DB.getMyPeerData().getKeySet();
                    BBytes inchallenge = new BBytes(FileUtils.readBytes(is, c));
                    ComPeerImpl.this.MyPeer = this.Com.DB.getMyPeerData().getPeer().getPeer();
                    SignedDigest signedchallenge = this.Com.Crypt.signChallenge(inchallenge, ComPeerImpl.this.MyPeer.getIdentity(), ks);
                    Log.info("Send Peer data.");
                    FileUtils.writePeer(os, ComPeerImpl.this.MyPeer, c);
                    Log.info("Send Signed Digest.");
                    SecurityTools.writeSignedDigest(signedchallenge, os, c);
                    os.flush();
                    Log.info("Read peer data.");
                    ComPeerImpl.this.ConnectedPeer = FileUtils.readPeer(is, c, ComPeerImpl.this.Version);
                    Log.info("Verify the Identity for ConnectedPeer: " + ComPeerImpl.this.ConnectedPeer.getNickname());
                    if (ComPeerImpl.this.Crypt.verifyIdentity(ComPeerImpl.this.ConnectedPeer)) {
                        Log.info("Location signature is valid: " + ComPeerImpl.this.ConnectedPeer.getNickname());
                        Log.info("Read Signed digest of challenge.");
                        SignedDigest inchallenge_check = SecurityTools.readSignedDigest(is, c);
                        boolean rightconnection = true;
                        if (this.Com.PeerId != null) {
                            if (!this.Com.PeerId.equals(ComPeerImpl.this.ConnectedPeer.getIdentity())) {
                                rightconnection = false;
                                Log.warning("We're not connected to who we thought we were!");
                                this.Com.Close();
                            }
                        } else {
                            this.Com.PeerId = ComPeerImpl.this.ConnectedPeer.getIdentity();
                        }
                        if (rightconnection) {
                            Log.info("This is the correct connection: " + ComPeerImpl.this.ConnectedPeer.getNickSig());
                            LinkedList<Peer> pl = new LinkedList<Peer>();
                            pl.add(ComPeerImpl.this.ConnectedPeer);
                            this.Com.Core.processPeers(ComPeerImpl.this.ConnectedPeer.getIdentity(), pl);
                            if (this.Com.Crypt.verifyChallenge(outchallenge, inchallenge_check, ComPeerImpl.this.ConnectedPeer)) {
                                ComPeerImpl.this.fireUpdate();
                                this.Com.startBigThreads();
                                ComPeerImpl.this.Core.newConnection(this.Com, false);
                            } else {
                                Log.warning("Invalid authentication signature!");
                                this.Com.Close();
                            }
                        } else {
                            Log.info("Not connected to the peer we expected.");
                            this.Com.Close();
                        }
                    } else {
                        Log.info("Identity is not valid.");
                        this.Com.Close();
                    }
                }
            }
            catch (Exception e) {
                Log.info("Exception caught: " + e.getMessage());
                if (Level.INFO.equals(Log.getLevel())) {
                    e.printStackTrace();
                }
                this.Com.Close();
            }
        }
    }

    class IncomingThread
    implements Runnable {
        private ComPeerImpl Com;
        private boolean Ok;
        private boolean Closed;
        private boolean Busy;
        private ByteCounter Counter;

        public IncomingThread(ComPeerImpl i) {
            this.Com = i;
            this.Ok = true;
            this.Closed = false;
            this.Busy = true;
            this.Counter = new ByteCounter();
        }

        public ByteCounter getCounter() {
            return this.Counter;
        }

        public void Close() {
            if (!this.Closed) {
                Log.info("Closing from input thread.");
                this.Closed = true;
                this.Com.Close();
            }
        }

        public boolean isBusy() {
            return this.Busy;
        }

        @Override
        public void run() {
            try {
                this.Com.Core.nextRequest(this.Com);
                InputStream is = ComPeerImpl.this.Socket.getInputStream();
                while (this.Ok && ComPeerImpl.this.Socket.isConnected() && !ComPeerImpl.this.Socket.isClosed() && !this.Closed) {
                    LinkedList<Peer> l;
                    BBytes peerid;
                    BBytes networkid;
                    long end;
                    long start;
                    NetworkAuthorization myauth;
                    this.Busy = false;
                    ComPeerImpl.this.fireUpdate();
                    int v = is.read();
                    this.Busy = true;
                    if (v == REQUEST_PEERS) {
                        this.Com.doRequestPeers();
                    } else if (v == REQUEST_POSTS) {
                        myauth = null;
                        NetworkAuthorization yauth = null;
                        if (((ComPeerImpl)ComPeerImpl.this).Version.Version != FileUtils.VERSION_CUR) {
                            myauth = FileUtils.readNetworkAuth(is, this.Counter);
                            yauth = FileUtils.readNetworkAuth(is, this.Counter);
                        }
                        BBytes networkid2 = FileUtils.readBBytes(is, this.Counter);
                        BBytes peerid2 = FileUtils.readBBytes(is, this.Counter);
                        start = FileUtils.readLong(is, this.Counter);
                        end = FileUtils.readLong(is, this.Counter);
                        this.Com.doRequestPosts(yauth, myauth, peerid2, networkid2, start, end);
                    } else if (v == REQUEST_FILES) {
                        networkid = FileUtils.readBBytes(is, this.Counter);
                        BBytes digest = FileUtils.readBBytes(is, this.Counter);
                        Log.info("READ REQUEST_FILE " + networkid + " dig " + digest);
                        this.Com.doRequestsFile(networkid, digest);
                    } else if (v == REQUEST_NETWORKS) {
                        peerid = FileUtils.readBBytes(is, this.Counter);
                        long start2 = FileUtils.readLong(is, this.Counter);
                        long end2 = FileUtils.readLong(is, this.Counter);
                        Log.info("READ: REQUEST_NETWORKS " + peerid + " start " + start2 + " end " + end2);
                        this.Com.doRequestNetworks(peerid, start2, end2);
                    } else if (v == REQUEST_NETWORKAUTHS) {
                        myauth = FileUtils.readNetworkAuth(is, this.Counter);
                        NetworkAuthorization yauth = FileUtils.readNetworkAuth(is, this.Counter);
                        BBytes networkid3 = FileUtils.readBBytes(is, this.Counter);
                        BBytes peerid3 = FileUtils.readBBytes(is, this.Counter);
                        start = FileUtils.readLong(is, this.Counter);
                        end = FileUtils.readLong(is, this.Counter);
                        this.Com.doRequestNetworkAuths(yauth, myauth, peerid3, networkid3, start, end);
                    } else if (v == REQUEST_PUBLICPOSTS) {
                        peerid = FileUtils.readBBytes(is, this.Counter);
                        long start3 = FileUtils.readLong(is, this.Counter);
                        long end3 = FileUtils.readLong(is, this.Counter);
                        this.Com.doRequestPublicPosts(peerid, start3, end3);
                    } else if (v == REQUEST_SUBS) {
                        networkid = FileUtils.readBBytes(is, this.Counter);
                        BBytes peerid4 = FileUtils.readBBytes(is, this.Counter);
                        long last = FileUtils.readLong(is, this.Counter);
                        this.Com.doRequestSubscriptions(networkid, peerid4, last);
                    } else if (v == SEND_POSTS) {
                        l = new LinkedList<Peer>();
                        long numposts = FileUtils.readLong(is, this.Counter);
                        Log.info("READ: SEND_POSTS: " + numposts);
                        while (numposts > 0L) {
                            Post p = FileUtils.readPost(is, this.Counter);
                            this.Com.removePostRequestPending(p.getNetworkId(), p.getSignedDigest().getPeerIdentifier());
                            l.add((Peer)((Object)p));
                            --numposts;
                        }
                        this.Com.Core.processPosts(ComPeerImpl.this.PeerId, l);
                        this.Com.requestReady();
                    } else if (v == SEND_PEERS) {
                        l = new LinkedList();
                        long numpeers = FileUtils.readLong(is, this.Counter);
                        while (numpeers > 0L) {
                            Peer p = FileUtils.readPeer(is, this.Counter, ComPeerImpl.this.Version);
                            l.add(p);
                            --numpeers;
                        }
                        this.Com.Core.processPeers(ComPeerImpl.this.PeerId, l);
                        this.Com.requestReady();
                    } else if (v == SEND_FILES) {
                        networkid = FileUtils.readBBytes(is, this.Counter);
                        File tmpfile = File.createTempFile("file", ".dat", ComPeerImpl.this.TempDir);
                        FileUtils.readFile(is, tmpfile, this.Counter);
                        BBytes dig = this.Com.Core.processFile(ComPeerImpl.this.PeerId, networkid, tmpfile);
                        Log.info("READ SEND_FILES: " + tmpfile + " networkid " + networkid + " peerid: " + ComPeerImpl.this.PeerId + " dig " + dig);
                        this.Com.removeFileRequestPending(networkid, dig);
                        this.Com.requestReady();
                    } else if (v == SEND_NETWORKS) {
                        l = new LinkedList();
                        long num = FileUtils.readLong(is, this.Counter);
                        while (num > 0L) {
                            Network n = FileUtils.readNetwork(is, this.Counter, ((ComPeerImpl)ComPeerImpl.this).Version.Version);
                            l.add((Peer)((Object)n));
                            this.Com.removeNetworkRequestPending(n.getSignature().getPeerIdentifier());
                            --num;
                        }
                        this.Com.Core.processNetworks(ComPeerImpl.this.PeerId, l);
                        this.Com.requestReady();
                    } else if (v == SEND_NETWORKAUTHS) {
                        l = new LinkedList();
                        long num = FileUtils.readLong(is, this.Counter);
                        while (num > 0L) {
                            NetworkAuthorization na = FileUtils.readNetworkAuth(is, this.Counter);
                            l.add((Peer)((Object)na));
                            this.Com.removeNetworkAuthRequestPending(na.getNetworkId(), na.getSignature().getPeerIdentifier());
                            --num;
                        }
                        this.Com.Core.processNetworkAuths(ComPeerImpl.this.PeerId, l);
                        this.Com.requestReady();
                    } else if (v == SEND_PUBLICPOSTS) {
                        l = new LinkedList();
                        long num = FileUtils.readLong(is, this.Counter);
                        Log.info("Getting ready to read " + num + " public posts.");
                        while (num > 0L) {
                            PublicPost p = FileUtils.readPublicPost(is, this.Counter);
                            Log.info("Read new public post: " + p.getMessage());
                            l.add((Peer)((Object)p));
                            this.Com.removePublicPostRequestPending(p.getSignature().getPeerIdentifier());
                            --num;
                        }
                        Log.info("Call processPublicPosts: " + l.size());
                        this.Com.Core.processPublicPosts(ComPeerImpl.this.PeerId, l);
                        this.Com.requestReady();
                    } else if (v == SEND_SUBS) {
                        Subscribe s = FileUtils.readSubscribe(is, this.Counter);
                        this.Com.removeSubscriptionPending(s.getNetworkID(), s.getSignature().getPeerIdentifier());
                        this.Com.Core.processSubscription(ComPeerImpl.this.PeerId, s);
                        this.Com.requestReady();
                    } else if (v == SEND_NO_POSTS) {
                        networkid = FileUtils.readBBytes(is, this.Counter);
                        BBytes peerid5 = FileUtils.readBBytes(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        this.Com.removePostRequestPending(networkid, peerid5);
                        ComPeerImpl.this.Core.requestPostsSucceeded(this.Com, peerid5, networkid);
                    } else if (v == SEND_FILE_NOT_FOUND) {
                        networkid = FileUtils.readBBytes(is, this.Counter);
                        BBytes dig = FileUtils.readBBytes(is, this.Counter);
                        this.Com.Core.requestFileFailed(this.Com, networkid, dig);
                    } else if (v == SEND_NO_NETWORKS) {
                        peerid = FileUtils.readBBytes(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        Log.info("Read SEND_NO_NETWORKS! " + peerid);
                        this.Com.removeNetworkRequestPending(peerid);
                        ComPeerImpl.this.Core.requestNetworksSucceeded(this.Com, peerid);
                    } else if (v == SEND_NO_NETWORKAUTHS) {
                        networkid = FileUtils.readBBytes(is, this.Counter);
                        BBytes peerid6 = FileUtils.readBBytes(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        this.Com.removeNetworkAuthRequestPending(networkid, peerid6);
                        ComPeerImpl.this.Core.requestNetworkAuthSucceeded(this.Com, peerid6, networkid);
                    } else if (v == SEND_NO_PUBLICPOSTS) {
                        peerid = FileUtils.readBBytes(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        this.Com.removePublicPostRequestPending(peerid);
                        ComPeerImpl.this.Core.requestPublicPostsSucceeded(this.Com, peerid);
                    } else if (v == SEND_NO_SUBS) {
                        BBytes netid = FileUtils.readBBytes(is, this.Counter);
                        BBytes peerid7 = FileUtils.readBBytes(is, this.Counter);
                        FileUtils.readLong(is, this.Counter);
                        this.Com.removeSubscriptionPending(netid, peerid7);
                        ComPeerImpl.this.Core.requestSubscriptionSucceeded(this.Com, peerid7, netid);
                    } else {
                        this.Close();
                    }
                    ComPeerImpl.this.Timer.DataReceived();
                }
            }
            catch (Exception e) {
                if (Level.INFO.equals(Log.getLevel())) {
                    e.printStackTrace();
                }
                this.Close();
            }
        }
    }

    class InputTimer
    implements Runnable {
        InputTimer() {
        }

        public synchronized void waitInputProgress() {
            long timestart = new Date().getTime();
            try {
                this.wait(ComPeerImpl.this.MaxPendingWithNoData);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long endtime = new Date().getTime();
            if (endtime - timestart > ComPeerImpl.this.MaxPendingWithNoData - 10L && ComPeerImpl.this.getPendingRequests() > 0) {
                Log.info("CLosing due to inactivity.");
                ComPeerImpl.this.Close();
            }
        }

        public synchronized void DataReceived() {
            this.notifyAll();
        }

        @Override
        public void run() {
            while (!ComPeerImpl.this.CClosed) {
                this.waitInputProgress();
            }
        }
    }

    class NetworkAuthRequest {
        public NetworkAuthorization MyAuth;
        public NetworkAuthorization NetworkAuth;
        public BBytes NetworkId;
        public BBytes PeerId;
        public long Start;
        public long End;

        NetworkAuthRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NetworkAuthRequest)) {
                return false;
            }
            NetworkAuthRequest pr = (NetworkAuthRequest)obj;
            if (this.PeerId == null) {
                return false;
            }
            if (pr.PeerId == null) {
                return false;
            }
            if (this.NetworkId == null) {
                return false;
            }
            if (pr.NetworkId == null) {
                return false;
            }
            return this.PeerId.equals(pr.PeerId) && this.NetworkId.equals(pr.NetworkId);
        }

        public int hashCode() {
            return this.PeerId.hashCode() ^ this.NetworkId.hashCode();
        }
    }

    class NetworkRequest {
        public BBytes PeerId;
        public long Start;
        public long End;

        NetworkRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof NetworkRequest)) {
                return false;
            }
            NetworkRequest pr = (NetworkRequest)obj;
            if (this.PeerId == null) {
                return false;
            }
            if (pr.PeerId == null) {
                return false;
            }
            return this.PeerId.equals(pr.PeerId);
        }

        public int hashCode() {
            return this.PeerId.hashCode();
        }
    }

    class OutgoingThread
    implements Runnable {
        private ComPeerImpl Com;
        private boolean Ok;
        private boolean Closed;
        private ByteCounter Counter;
        private boolean Busy;
        private boolean RequestPeers;
        private ConcurrentLinkedQueue<NetworkAuthRequest> NetworkAuthRequestQueue;
        private ConcurrentLinkedQueue<PostRequest> PostRequestQueue;
        private ConcurrentLinkedQueue<NetworkRequest> NetworkRequestQueue;
        private ConcurrentLinkedQueue<PublicPostRequest> PublicPostRequestQueue;
        private ConcurrentLinkedQueue<FileRequest> FileRequestQueue;
        private ConcurrentLinkedQueue<SubscriptionRequest> SubRequestQueue;
        private ConcurrentLinkedQueue<List<Peer>> PeerQueue;
        private ConcurrentLinkedQueue<List<Post>> PostQueue;
        private ConcurrentLinkedQueue<List<Network>> NetworkQueue;
        private ConcurrentLinkedQueue<List<NetworkAuthorization>> NetworkAuthQueue;
        private ConcurrentLinkedQueue<List<PublicPost>> PublicPostQueue;
        private ConcurrentLinkedQueue<FileReference> FileQueue;
        private ConcurrentLinkedQueue<Subscribe> SubQueue;
        private ConcurrentLinkedQueue<FileRequest> FileNotFoundQueue;
        private ConcurrentLinkedQueue<PostRequest> NoPostsQueue;
        private ConcurrentLinkedQueue<NetworkRequest> NoNetworksQueue;
        private ConcurrentLinkedQueue<NetworkAuthRequest> NoNetworkAuthsQueue;
        private ConcurrentLinkedQueue<PublicPostRequest> NoPublicPostsQueue;
        private ConcurrentLinkedQueue<SubscriptionRequest> NoSubQueue;

        public OutgoingThread(ComPeerImpl i) {
            this.Com = i;
            this.Ok = true;
            this.Closed = false;
            this.RequestPeers = false;
            this.Busy = true;
            this.Counter = new ByteCounter();
            this.PeerQueue = new ConcurrentLinkedQueue();
            this.PostQueue = new ConcurrentLinkedQueue();
            this.NetworkQueue = new ConcurrentLinkedQueue();
            this.NetworkAuthQueue = new ConcurrentLinkedQueue();
            this.PublicPostQueue = new ConcurrentLinkedQueue();
            this.FileQueue = new ConcurrentLinkedQueue();
            this.SubRequestQueue = new ConcurrentLinkedQueue();
            this.FileRequestQueue = new ConcurrentLinkedQueue();
            this.NetworkAuthRequestQueue = new ConcurrentLinkedQueue();
            this.PostRequestQueue = new ConcurrentLinkedQueue();
            this.NetworkRequestQueue = new ConcurrentLinkedQueue();
            this.PublicPostRequestQueue = new ConcurrentLinkedQueue();
            this.SubQueue = new ConcurrentLinkedQueue();
            this.FileNotFoundQueue = new ConcurrentLinkedQueue();
            this.NoPostsQueue = new ConcurrentLinkedQueue();
            this.NoNetworksQueue = new ConcurrentLinkedQueue();
            this.NoNetworkAuthsQueue = new ConcurrentLinkedQueue();
            this.NoPublicPostsQueue = new ConcurrentLinkedQueue();
            this.NoSubQueue = new ConcurrentLinkedQueue();
        }

        public synchronized void requestFile(BBytes networkid, BBytes digest) {
            FileRequest fr = new FileRequest();
            fr.NetworkId = networkid;
            fr.Digest = digest;
            this.FileRequestQueue.add(fr);
            Log.info("netid: " + networkid + " dig " + digest);
            this.notifyAll();
        }

        public synchronized void requestPosts(NetworkAuthorization myauth, NetworkAuthorization yourauth, BBytes networkid, BBytes peerid, long start, long end) {
            PostRequest pr = new PostRequest();
            pr.MyAuth = myauth;
            pr.NetworkAuth = yourauth;
            pr.NetworkId = networkid;
            pr.PeerId = peerid;
            pr.Start = start;
            pr.End = end;
            this.PostRequestQueue.add(pr);
            this.notifyAll();
        }

        public synchronized void requestNetworkAuths(NetworkAuthorization myauth, NetworkAuthorization yourauth, BBytes networkid, BBytes peerid, long start, long end) {
            NetworkAuthRequest nr = new NetworkAuthRequest();
            nr.MyAuth = myauth;
            nr.NetworkAuth = yourauth;
            nr.NetworkId = networkid;
            nr.PeerId = peerid;
            nr.Start = start;
            nr.End = end;
            this.NetworkAuthRequestQueue.add(nr);
            this.notifyAll();
        }

        public synchronized void requestPublicPosts(BBytes peerid, long start, long end) {
            PublicPostRequest pr = new PublicPostRequest();
            pr.PeerId = peerid;
            pr.Start = start;
            pr.End = end;
            this.PublicPostRequestQueue.add(pr);
            this.notifyAll();
        }

        public synchronized void requestNetworks(BBytes peerid, long start, long end) {
            Log.info("peer: " + peerid + " start " + start + " end " + end);
            NetworkRequest nr = new NetworkRequest();
            nr.PeerId = peerid;
            nr.Start = start;
            nr.End = end;
            this.NetworkRequestQueue.add(nr);
            this.notifyAll();
        }

        public synchronized void requestSubscriptions(BBytes peerid, BBytes networkid, long lastnum) {
            SubscriptionRequest s = new SubscriptionRequest();
            s.NetworkId = networkid;
            s.PeerId = peerid;
            s.LastSubNum = lastnum;
            this.SubRequestQueue.add(s);
            this.notifyAll();
        }

        public synchronized void requestPeers() {
            this.RequestPeers = true;
            this.notifyAll();
        }

        public synchronized void addNoPosts(PostRequest pr) {
            this.NoPostsQueue.add(pr);
            this.notifyAll();
        }

        public synchronized void addFileNotFound(FileRequest fr) {
            this.FileNotFoundQueue.add(fr);
            this.notifyAll();
        }

        public synchronized void addNoNetworks(NetworkRequest nr) {
            this.NoNetworksQueue.add(nr);
            this.notifyAll();
        }

        public synchronized void addNoNetworkAuths(NetworkAuthRequest nr) {
            this.NoNetworkAuthsQueue.add(nr);
            this.notifyAll();
        }

        public synchronized void addNoPublicPosts(PublicPostRequest pr) {
            this.NoPublicPostsQueue.add(pr);
            this.notifyAll();
        }

        public synchronized void addNoSub(SubscriptionRequest s) {
            this.NoSubQueue.add(s);
            this.notifyAll();
        }

        public synchronized void addPeers(List<Peer> p) {
            this.PeerQueue.add(p);
            this.notifyAll();
        }

        public synchronized void addPosts(List<Post> p) {
            this.PostQueue.add(p);
            this.notifyAll();
        }

        public synchronized void addFile(FileReference f) {
            this.FileQueue.add(f);
            this.notifyAll();
        }

        public synchronized void addNetworks(List<Network> n) {
            this.NetworkQueue.add(n);
            this.notifyAll();
        }

        public synchronized void addNetworkAuths(List<NetworkAuthorization> n) {
            this.NetworkAuthQueue.add(n);
            this.notifyAll();
        }

        public synchronized void addPublicPosts(List<PublicPost> p) {
            Log.info("addPublicPosts: " + p.size());
            this.PublicPostQueue.add(p);
            this.notifyAll();
        }

        public synchronized void addSubscription(Subscribe s) {
            this.SubQueue.add(s);
            this.notifyAll();
        }

        public synchronized void requestReady() {
            if (this.getNumberRequests() == 0) {
                if (ComPeerImpl.this.getPendingRequests() == 0) {
                    this.notifyAll();
                } else {
                    Log.info("Pending request: " + ComPeerImpl.this.getPendingRequests());
                }
            } else {
                Log.info("Number requests: " + this.getNumberRequests());
            }
        }

        public void Close() {
            Object nr;
            Object pr;
            if (!this.Closed) {
                Log.info("Closing due to output thread.");
                this.Closed = true;
                this.Com.Close();
            }
            while (this.PostRequestQueue.size() > 0) {
                pr = this.PostRequestQueue.poll();
                if (pr == null) continue;
                this.Com.Core.requestPostsFailed(this.Com, ((PostRequest)pr).PeerId, ((PostRequest)pr).NetworkId);
            }
            while (this.FileRequestQueue.size() > 0) {
                FileRequest fr = this.FileRequestQueue.poll();
                if (fr == null) continue;
                this.Com.Core.requestFileFailed(this.Com, fr.NetworkId, fr.Digest);
            }
            while (this.NetworkRequestQueue.size() > 0) {
                nr = this.NetworkRequestQueue.poll();
                if (nr == null) continue;
                this.Com.Core.requestNetworksFailed(this.Com, ((NetworkRequest)nr).PeerId);
            }
            while (this.NetworkAuthRequestQueue.size() > 0) {
                nr = this.NetworkAuthRequestQueue.poll();
                if (nr == null) continue;
                this.Com.Core.requestNetworkAuthsFailed(this.Com, ((NetworkAuthRequest)nr).PeerId, ((NetworkAuthRequest)nr).NetworkId);
            }
            while (this.PublicPostRequestQueue.size() > 0) {
                pr = this.PublicPostRequestQueue.poll();
                if (pr == null) continue;
                this.Com.Core.requestPublicPostsFailed(this.Com, ((PublicPostRequest)pr).PeerId);
            }
            while (this.SubRequestQueue.size() > 0) {
                SubscriptionRequest s = this.SubRequestQueue.poll();
                if (s == null) continue;
                this.Com.Core.requestSubscriptionFailed(this.Com, s.PeerId, s.NetworkId);
            }
        }

        private synchronized int getNumberRequests() {
            int num = 0;
            if (this.RequestPeers) {
                ++num;
            }
            num += this.PostRequestQueue.size();
            num += this.FileRequestQueue.size();
            num += this.NetworkRequestQueue.size();
            num += this.NetworkAuthRequestQueue.size();
            num += this.PublicPostRequestQueue.size();
            return num += this.SubRequestQueue.size();
        }

        private synchronized void WaitForData() {
            this.Busy = true;
            if (this.RequestPeers) {
                Log.info("waiting for peers.");
                return;
            }
            if (this.PostRequestQueue.size() > 0) {
                Log.info("waiting for posts: " + this.PostRequestQueue.size());
                return;
            }
            if (this.FileRequestQueue.size() > 0) {
                Log.info("waiting for file requests: " + this.FileRequestQueue.size());
                return;
            }
            if (this.NetworkRequestQueue.size() > 0) {
                Log.info("waiting for network request: " + this.NetworkRequestQueue.size());
                return;
            }
            if (this.NetworkAuthRequestQueue.size() > 0) {
                Log.info("waiting for network auth request: " + this.NetworkAuthRequestQueue.size());
                return;
            }
            if (this.PublicPostRequestQueue.size() > 0) {
                Log.info("waiting for public post request: " + this.PublicPostRequestQueue.size());
                return;
            }
            if (this.SubRequestQueue.size() > 0) {
                return;
            }
            if (this.PeerQueue.size() > 0) {
                Log.info("peer queue: " + this.PeerQueue.size());
                return;
            }
            if (this.PostQueue.size() > 0) {
                Log.info("post queue: " + this.PostQueue.size());
                return;
            }
            if (this.FileQueue.size() > 0) {
                Log.info("file queue: " + this.FileQueue.size());
                return;
            }
            if (this.NetworkQueue.size() > 0) {
                Log.info("network queue: " + this.NetworkQueue.size());
                return;
            }
            if (this.NetworkAuthQueue.size() > 0) {
                Log.info("network auth queue: " + this.NetworkAuthQueue.size());
                return;
            }
            if (this.PublicPostQueue.size() > 0) {
                Log.info("public post queue: " + this.PublicPostQueue.size());
                return;
            }
            if (this.SubQueue.size() > 0) {
                return;
            }
            if (this.NoPostsQueue.size() > 0) {
                Log.info("no post queue: " + this.NoPostsQueue.size());
                return;
            }
            if (this.NoNetworksQueue.size() > 0) {
                Log.info("no network queue: " + this.NoNetworksQueue.size());
                return;
            }
            if (this.NoNetworkAuthsQueue.size() > 0) {
                Log.info("no network auth queue: " + this.NoNetworkAuthsQueue.size());
                return;
            }
            if (this.NoPublicPostsQueue.size() > 0) {
                Log.info("no public post queue: " + this.NoPublicPostsQueue.size());
                return;
            }
            if (this.FileNotFoundQueue.size() > 0) {
                Log.info("file not found queue: " + this.FileNotFoundQueue.size());
                return;
            }
            if (this.NoSubQueue.size() > 0) {
                return;
            }
            try {
                this.Busy = false;
                this.wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public boolean isBusy() {
            return this.Busy;
        }

        private void nextRequest() {
            if (this.getNumberRequests() == 0 && ComPeerImpl.this.getPendingRequests() == 0) {
                this.Com.Core.nextRequest(this.Com);
            }
        }

        @Override
        public void run() {
            try {
                OutputStream os = ComPeerImpl.this.Socket.getOutputStream();
                while (this.Ok && ComPeerImpl.this.Socket.isConnected() && !ComPeerImpl.this.Socket.isClosed() && !this.Closed) {
                    Subscribe ls;
                    List<PublicPost> ppl;
                    List<NetworkAuthorization> nal;
                    int sentsize;
                    List<Network> nl;
                    FileReference sf;
                    Iterator<Object> i;
                    List<Post> postlist;
                    List<Peer> peerlist;
                    SubscriptionRequest nsr;
                    PublicPostRequest npp;
                    NetworkAuthRequest nna;
                    NetworkRequest nn;
                    PostRequest np;
                    FileRequest nfd;
                    ComPeerImpl.this.fireUpdate();
                    this.nextRequest();
                    this.WaitForData();
                    if (this.RequestPeers) {
                        this.RequestPeers = false;
                        os.write(REQUEST_PEERS);
                    }
                    PostRequest pr = this.PostRequestQueue.poll();
                    ComPeerImpl.this.addPostRequestPending(pr);
                    if (pr != null) {
                        os.write(REQUEST_POSTS);
                        if (((ComPeerImpl)ComPeerImpl.this).Version.Version != FileUtils.VERSION_CUR) {
                            FileUtils.writeNetworkAuth(os, pr.NetworkAuth, this.Counter);
                            FileUtils.writeNetworkAuth(os, pr.MyAuth, this.Counter);
                        }
                        FileUtils.writeBBytes(os, pr.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, pr.PeerId, this.Counter);
                        FileUtils.writeLong(pr.Start, os, this.Counter);
                        FileUtils.writeLong(pr.End, os, this.Counter);
                    }
                    FileRequest fr = this.FileRequestQueue.poll();
                    ComPeerImpl.this.addFileRequestPending(fr);
                    if (fr != null) {
                        os.write(REQUEST_FILES);
                        FileUtils.writeBBytes(os, fr.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, fr.Digest, this.Counter);
                        Log.info("SEND REQUEST_FILE: " + fr.NetworkId + " dig " + fr.Digest);
                    }
                    NetworkRequest nr = this.NetworkRequestQueue.poll();
                    ComPeerImpl.this.addNetworkRequestPending(nr);
                    if (nr != null) {
                        Log.info("SEND REQUEST_NETWORKS: " + nr.PeerId + " start " + nr.Start + " end " + nr.End);
                        os.write(REQUEST_NETWORKS);
                        FileUtils.writeBBytes(os, nr.PeerId, this.Counter);
                        FileUtils.writeLong(nr.Start, os, this.Counter);
                        FileUtils.writeLong(nr.End, os, this.Counter);
                    }
                    NetworkAuthRequest nar = this.NetworkAuthRequestQueue.poll();
                    ComPeerImpl.this.addNetworkAuthRequestPending(nar);
                    if (nar != null) {
                        os.write(REQUEST_NETWORKAUTHS);
                        FileUtils.writeNetworkAuth(os, nar.NetworkAuth, this.Counter);
                        FileUtils.writeNetworkAuth(os, nar.MyAuth, this.Counter);
                        FileUtils.writeBBytes(os, nar.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, nar.PeerId, this.Counter);
                        FileUtils.writeLong(nar.Start, os, this.Counter);
                        FileUtils.writeLong(nar.End, os, this.Counter);
                    }
                    PublicPostRequest ppr = this.PublicPostRequestQueue.poll();
                    ComPeerImpl.this.addPublicPostRequestPending(ppr);
                    if (ppr != null) {
                        os.write(REQUEST_PUBLICPOSTS);
                        FileUtils.writeBBytes(os, ppr.PeerId, this.Counter);
                        FileUtils.writeLong(ppr.Start, os, this.Counter);
                        FileUtils.writeLong(ppr.End, os, this.Counter);
                    }
                    SubscriptionRequest sr = this.SubRequestQueue.poll();
                    ComPeerImpl.this.addSubRequestPending(sr);
                    if (sr != null) {
                        os.write(REQUEST_SUBS);
                        FileUtils.writeBBytes(os, sr.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, sr.PeerId, this.Counter);
                        FileUtils.writeLong(sr.LastSubNum, os, this.Counter);
                    }
                    if ((nfd = this.FileNotFoundQueue.poll()) != null) {
                        os.write(SEND_FILE_NOT_FOUND);
                        FileUtils.writeBBytes(os, nfd.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, nfd.Digest, this.Counter);
                    }
                    if ((np = this.NoPostsQueue.poll()) != null) {
                        os.write(SEND_NO_POSTS);
                        FileUtils.writeBBytes(os, np.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, np.PeerId, this.Counter);
                        FileUtils.writeLong(np.Start, os, this.Counter);
                        FileUtils.writeLong(np.End, os, this.Counter);
                    }
                    if ((nn = this.NoNetworksQueue.poll()) != null) {
                        Log.info("SEND_NO_NETWORKS: " + nn.PeerId);
                        os.write(SEND_NO_NETWORKS);
                        FileUtils.writeBBytes(os, nn.PeerId, this.Counter);
                        FileUtils.writeLong(nn.Start, os, this.Counter);
                        FileUtils.writeLong(nn.End, os, this.Counter);
                    }
                    if ((nna = this.NoNetworkAuthsQueue.poll()) != null) {
                        os.write(SEND_NO_NETWORKAUTHS);
                        FileUtils.writeBBytes(os, nna.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, nna.PeerId, this.Counter);
                        FileUtils.writeLong(nna.Start, os, this.Counter);
                        FileUtils.writeLong(nna.End, os, this.Counter);
                    }
                    if ((npp = this.NoPublicPostsQueue.poll()) != null) {
                        os.write(SEND_NO_PUBLICPOSTS);
                        FileUtils.writeBBytes(os, npp.PeerId, this.Counter);
                        FileUtils.writeLong(npp.Start, os, this.Counter);
                        FileUtils.writeLong(npp.End, os, this.Counter);
                    }
                    if ((nsr = this.NoSubQueue.poll()) != null) {
                        os.write(SEND_NO_SUBS);
                        FileUtils.writeBBytes(os, nsr.NetworkId, this.Counter);
                        FileUtils.writeBBytes(os, nsr.PeerId, this.Counter);
                        FileUtils.writeLong(nsr.LastSubNum, os, this.Counter);
                    }
                    if ((peerlist = this.PeerQueue.poll()) != null) {
                        os.write(SEND_PEERS);
                        int sendsize = peerlist.size();
                        int sentsize2 = 0;
                        FileUtils.writeLong(sendsize, os, this.Counter);
                        Iterator<Peer> i2 = peerlist.iterator();
                        while (i2.hasNext() && sentsize2 < sendsize) {
                            Peer peer = i2.next();
                            FileUtils.writePeer(os, peer, this.Counter);
                            ++sentsize2;
                        }
                        if (sentsize2 != sendsize) {
                            this.Close();
                        }
                    }
                    if ((postlist = this.PostQueue.poll()) != null) {
                        Log.info("SEND SEND_POSTS: " + postlist.size());
                        os.write(SEND_POSTS);
                        int sendsize = Math.min(MAXSEND, postlist.size());
                        int sentsize3 = 0;
                        FileUtils.writeLong(sendsize, os, this.Counter);
                        i = postlist.iterator();
                        while (i.hasNext() && sentsize3 < sendsize) {
                            Post post = (Post)i.next();
                            FileUtils.writePost(os, post, this.Counter);
                            ++sentsize3;
                        }
                        if (sentsize3 != sendsize) {
                            this.Close();
                        }
                    }
                    if ((sf = this.FileQueue.poll()) != null) {
                        Log.info("SEND_FILES: " + sf.getFile());
                        os.write(SEND_FILES);
                        FileUtils.writeBBytes(os, sf.getNetworkId(), this.Counter);
                        FileUtils.sendFile(os, sf.getFile(), sf.getOffset(), sf.getSize(), this.Counter);
                    }
                    if ((nl = this.NetworkQueue.poll()) != null) {
                        Log.info("Sending SEND_NETWORKS");
                        os.write(SEND_NETWORKS);
                        i = null;
                        if (((ComPeerImpl)ComPeerImpl.this).Version.Version != FileUtils.VERSION_CUR) {
                            i = nl.iterator();
                            while (i.hasNext()) {
                                Network netw = (Network)i.next();
                                if (netw.getPublic() == null) continue;
                                i.remove();
                            }
                        }
                        int sendsize = Math.min(MAXSEND, nl.size());
                        sentsize = 0;
                        FileUtils.writeLong(sendsize, os, this.Counter);
                        i = nl.iterator();
                        while (i.hasNext() && sentsize < sendsize) {
                            Network netw = (Network)i.next();
                            FileUtils.writeNetwork(os, netw, this.Counter, ((ComPeerImpl)ComPeerImpl.this).Version.Version);
                            ++sentsize;
                        }
                        if (sentsize != sendsize) {
                            this.Close();
                        }
                    }
                    if ((nal = this.NetworkAuthQueue.poll()) != null) {
                        os.write(SEND_NETWORKAUTHS);
                        int sendsize = Math.min(MAXSEND, nal.size());
                        sentsize = 0;
                        FileUtils.writeLong(sendsize, os, this.Counter);
                        Iterator<NetworkAuthorization> i3 = nal.iterator();
                        while (i3.hasNext() && sentsize < sendsize) {
                            NetworkAuthorization na = i3.next();
                            FileUtils.writeNetworkAuth(os, na, this.Counter);
                            ++sentsize;
                        }
                    }
                    if ((ppl = this.PublicPostQueue.poll()) != null) {
                        os.write(SEND_PUBLICPOSTS);
                        int sendsize = Math.min(MAXSEND, ppl.size());
                        int sentsize4 = 0;
                        FileUtils.writeLong(sendsize, os, this.Counter);
                        Iterator<PublicPost> i4 = ppl.iterator();
                        while (i4.hasNext() && sentsize4 < sendsize) {
                            PublicPost pp = i4.next();
                            Log.info("Sending public post: " + pp.getMessage());
                            FileUtils.writePublicPost(os, pp, this.Counter);
                            ++sentsize4;
                        }
                    }
                    if ((ls = this.SubQueue.poll()) != null) {
                        os.write(SEND_SUBS);
                        FileUtils.writeSubscribe(os, ls, this.Counter);
                    }
                    os.flush();
                }
            }
            catch (Exception e) {
                if (Level.INFO.equals(Log.getLevel())) {
                    e.printStackTrace();
                }
                this.Close();
            }
        }
    }

    class PostRequest {
        public NetworkAuthorization MyAuth;
        public NetworkAuthorization NetworkAuth;
        public BBytes NetworkId;
        public BBytes PeerId;
        public long Start;
        public long End;

        PostRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PostRequest)) {
                return false;
            }
            PostRequest pr = (PostRequest)obj;
            if (this.PeerId == null) {
                return false;
            }
            if (pr.PeerId == null) {
                return false;
            }
            if (this.NetworkId == null) {
                return false;
            }
            if (pr.NetworkId == null) {
                return false;
            }
            return this.PeerId.equals(pr.PeerId) && this.NetworkId.equals(pr.NetworkId);
        }

        public int hashCode() {
            return this.PeerId.hashCode() ^ this.NetworkId.hashCode();
        }
    }

    class PublicPostRequest {
        public BBytes PeerId;
        public long Start;
        public long End;

        PublicPostRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PublicPostRequest)) {
                return false;
            }
            PublicPostRequest pr = (PublicPostRequest)obj;
            if (this.PeerId == null) {
                return false;
            }
            if (pr.PeerId == null) {
                return false;
            }
            return this.PeerId.equals(pr.PeerId);
        }

        public int hashCode() {
            return this.PeerId.hashCode();
        }
    }

    class SubscriptionRequest {
        public BBytes NetworkId;
        public BBytes PeerId;
        public long LastSubNum;

        SubscriptionRequest() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubscriptionRequest)) {
                return false;
            }
            SubscriptionRequest s = (SubscriptionRequest)obj;
            if (this.NetworkId == null) {
                return false;
            }
            if (this.PeerId == null) {
                return false;
            }
            return this.NetworkId.equals(s.NetworkId) && this.PeerId.equals(s.PeerId);
        }

        public int hashCode() {
            return this.NetworkId.hashCode() ^ this.PeerId.hashCode();
        }
    }
}

