/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class DestroySessionMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 3;
    private SessionId _sessionId;

    public SessionId getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        SessionId id = new SessionId();
        try {
            id.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
        this.setSessionId(id);
    }

    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(64);
        try {
            this._sessionId.writeBytes(os);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    public int getType() {
        return 3;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[DestroySessionMessage: ");
        buf.append("\n\tSessionId: ").append(this._sessionId);
        buf.append("]");
        return buf.toString();
    }
}

