/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.I2PAppContext;
import net.i2p.client.ClientWriterRunner;
import net.i2p.client.I2CPMessageHandler;
import net.i2p.client.I2CPMessageProducer;
import net.i2p.client.I2PClientMessageHandlerMap;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.SessionIdleTimer;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.SessionId;
import net.i2p.internal.I2CPMessageQueue;
import net.i2p.internal.InternalClientManager;
import net.i2p.internal.QueuedI2CPMessageReader;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

abstract class I2PSessionImpl
implements I2PSession,
I2CPMessageReader.I2CPMessageEventListener {
    protected final Log _log;
    private final Destination _myDestination;
    private final PrivateKey _privateKey;
    private final SigningPrivateKey _signingPrivateKey;
    private final Properties _options;
    private SessionId _sessionId;
    private volatile LeaseSet _leaseSet;
    protected final String _hostname;
    protected final int _portNum;
    protected Socket _socket;
    protected I2CPMessageReader _reader;
    protected ClientWriterRunner _writer;
    protected I2CPMessageQueue _queue;
    protected I2PSessionListener _sessionListener;
    protected final I2CPMessageProducer _producer;
    protected Map<Long, MessagePayloadMessage> _availableMessages;
    protected final LinkedBlockingQueue<LookupWaiter> _pendingLookups = new LinkedBlockingQueue();
    protected final Object _bwReceivedLock = new Object();
    protected volatile int[] _bwLimits;
    protected final I2PClientMessageHandlerMap _handlerMap;
    protected final I2PAppContext _context;
    private final Object _leaseSetWait = new Object();
    private State _state = State.CLOSED;
    protected final Object _stateLock = new Object();
    private volatile boolean _dateReceived;
    private final Object _dateReceivedLock = new Object();
    protected AvailabilityNotifier _availabilityNotifier;
    private long _lastActivity;
    private boolean _isReduced;
    private final boolean _fastReceive;
    private volatile boolean _routerSupportsFastReceive;
    private static final Map<Hash, Destination> _lookupCache = new LHMCache<Hash, Destination>(16);
    protected static final String PROP_ENABLE_SSL = "i2cp.SSL";
    private static final long VERIFY_USAGE_TIME = 60000L;
    private static final long MAX_SEND_WAIT = 10000L;
    private static final String MIN_FAST_VERSION = "0.9.4";
    public static final int LISTEN_PORT = 7654;
    private static final int BUF_SIZE = 32768;
    private static final int MAX_RECONNECT_DELAY = 320000;
    private static final int BASE_RECONNECT_DELAY = 10000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dateUpdated(String routerVersion) {
        this._routerSupportsFastReceive = this._context.isRouterContext() || routerVersion != null && routerVersion.length() > 0 && VersionComparator.comp(routerVersion, MIN_FAST_VERSION) >= 0;
        this._dateReceived = true;
        Object object = this._dateReceivedLock;
        synchronized (object) {
            this._dateReceivedLock.notifyAll();
        }
    }

    protected I2PSessionImpl(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap) {
        this(context, options, handlerMap, false);
    }

    private I2PSessionImpl(I2PAppContext context, Properties options, I2PClientMessageHandlerMap handlerMap, boolean hasDest) {
        this._context = context;
        this._handlerMap = handlerMap;
        this._log = context.logManager().getLog(this.getClass());
        if (options == null) {
            options = (Properties)System.getProperties().clone();
        }
        this._options = this.loadConfig(options);
        this._hostname = this.getHost();
        this._portNum = this.getPort();
        this._fastReceive = Boolean.parseBoolean(this._options.getProperty("i2cp.fastReceive"));
        if (hasDest) {
            this._producer = new I2CPMessageProducer(context);
            this._availableMessages = new ConcurrentHashMap<Long, MessagePayloadMessage>();
            this._myDestination = new Destination();
            this._privateKey = new PrivateKey();
            this._signingPrivateKey = new SigningPrivateKey();
        } else {
            this._producer = null;
            this._availableMessages = null;
            this._myDestination = null;
            this._privateKey = null;
            this._signingPrivateKey = null;
        }
    }

    public I2PSessionImpl(I2PAppContext context, InputStream destKeyStream, Properties options) throws I2PSessionException {
        this(context, options, new I2PClientMessageHandlerMap(context), true);
        this._availabilityNotifier = new AvailabilityNotifier();
        try {
            this.readDestination(destKeyStream);
        }
        catch (DataFormatException dfe) {
            throw new I2PSessionException("Error reading the destination key stream", dfe);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error reading the destination key stream", ioe);
        }
    }

    private final Properties loadConfig(Properties opts) {
        Properties options = new Properties();
        options.putAll((Map<?, ?>)this.filter(opts));
        if (!(this._context.isRouterContext() || !this._context.getBooleanProperty("i2cp.auth") || opts.containsKey("i2cp.username") && opts.containsKey("i2cp.password"))) {
            String configUser = this._context.getProperty("i2cp.username");
            String configPW = this._context.getProperty("i2cp.password");
            if (configUser != null && configPW != null) {
                options.setProperty("i2cp.username", configUser);
                options.setProperty("i2cp.password", configPW);
            }
        }
        if (options.getProperty("i2cp.fastReceive") == null) {
            options.setProperty("i2cp.fastReceive", "true");
        }
        if (options.getProperty("i2cp.messageReliability") == null) {
            options.setProperty("i2cp.messageReliability", "none");
        }
        return options;
    }

    private String getHost() {
        if (this._context.isRouterContext()) {
            return "[internal connection]";
        }
        return this._options.getProperty("i2cp.tcp.host", "127.0.0.1");
    }

    private int getPort() {
        if (this._context.isRouterContext()) {
            return 0;
        }
        String portNum = this._options.getProperty("i2cp.tcp.port", "7654");
        try {
            return Integer.parseInt(portNum);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Invalid port number specified, defaulting to " + 7654, nfe);
            }
            return 7654;
        }
    }

    private Properties filter(Properties options) {
        Properties rv = new Properties();
        for (String string : options.keySet()) {
            if (string.startsWith("java.") || string.startsWith("user.") || string.startsWith("os.") || string.startsWith("sun.") || string.startsWith("file.") || string.equals("line.separator") || string.equals("path.separator") || string.equals("prng.buffers") || string.equals("router.trustedUpdateKeys") || string.startsWith("router.update") || string.startsWith("routerconsole.") || string.startsWith("time.") || string.startsWith("stat.") || string.startsWith("gnu.") || string.startsWith("net.i2p.router.web.") || string.startsWith("wrapper.")) {
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("Skipping property: " + string);
                continue;
            }
            String val = options.getProperty(string);
            if (string.length() > 255 || val.length() > 255) {
                if (!this._log.shouldLog(30)) continue;
                this._log.warn("Not passing on property [" + string + "] in the session config, key or value is too long (max = 255): " + val);
                continue;
            }
            rv.setProperty(string, val);
        }
        return rv;
    }

    public void updateOptions(Properties options) {
        this._options.putAll((Map<?, ?>)this.filter(options));
        this._producer.updateBandwidth(this);
        try {
            this._producer.updateTunnels(this, 0);
        }
        catch (I2PSessionException i2PSessionException) {
            // empty catch block
        }
    }

    public boolean getFastReceive() {
        return this._fastReceive && this._routerSupportsFastReceive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLeaseSet(LeaseSet ls) {
        this._leaseSet = ls;
        if (ls != null) {
            Object object = this._leaseSetWait;
            synchronized (object) {
                this._leaseSetWait.notifyAll();
            }
        }
    }

    LeaseSet getLeaseSet() {
        return this._leaseSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(State state) {
        Object object = this._stateLock;
        synchronized (object) {
            this._state = state;
            this._stateLock.notifyAll();
        }
    }

    private void readDestination(InputStream destKeyStream) throws DataFormatException, IOException {
        this._myDestination.readBytes(destKeyStream);
        this._privateKey.readBytes(destKeyStream);
        this._signingPrivateKey.readBytes(destKeyStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void connect() throws I2PSessionException {
        block58: {
            Object object;
            Object object2 = this._stateLock;
            synchronized (object2) {
                boolean wasOpening = false;
                boolean loop = true;
                while (loop) {
                    switch (this._state) {
                        case CLOSED: {
                            if (wasOpening) {
                                throw new I2PSessionException("connect by other thread failed");
                            }
                            loop = false;
                            break;
                        }
                        case OPENING: {
                            wasOpening = true;
                            try {
                                this._stateLock.wait(10000L);
                                break;
                            }
                            catch (InterruptedException ie) {
                                throw new I2PSessionException("Interrupted", ie);
                            }
                        }
                        case CLOSING: {
                            throw new I2PSessionException("close in progress");
                        }
                        case OPEN: {
                            return;
                        }
                    }
                }
                this.changeState(State.OPENING);
            }
            this._availabilityNotifier.stopNotifying();
            if (this._options != null && "Guaranteed".equals(this._options.getProperty("i2cp.messageReliability", "BestEffort")) && this._log.shouldLog(40)) {
                this._log.error("I2CP guaranteed delivery mode has been removed, using best effort.");
            }
            boolean success = false;
            long startConnect = this._context.clock().now();
            try {
                Object out;
                Object ie = this._stateLock;
                synchronized (ie) {
                    if (this._context.isRouterContext()) {
                        InternalClientManager mgr = this._context.internalClientManager();
                        if (mgr == null) {
                            throw new I2PSessionException("Router is not ready for connections");
                        }
                        this._queue = mgr.connect();
                        this._reader = new QueuedI2CPMessageReader(this._queue, (I2CPMessageReader.I2CPMessageEventListener)this);
                    } else {
                        if (Boolean.parseBoolean(this._options.getProperty(PROP_ENABLE_SSL))) {
                            try {
                                I2PSSLSocketFactory fact = new I2PSSLSocketFactory(this._context, false, "certificates/i2cp");
                                this._socket = fact.createSocket(this._hostname, this._portNum);
                            }
                            catch (GeneralSecurityException gse) {
                                IOException ioe = new IOException("SSL Fail");
                                ioe.initCause(gse);
                                throw ioe;
                            }
                        } else {
                            this._socket = new Socket(this._hostname, this._portNum);
                        }
                        out = this._socket.getOutputStream();
                        ((OutputStream)out).write(42);
                        ((OutputStream)out).flush();
                        this._writer = new ClientWriterRunner((OutputStream)out, this);
                        BufferedInputStream in = new BufferedInputStream(this._socket.getInputStream(), 32768);
                        this._reader = new I2CPMessageReader(in, this);
                    }
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "before startReading");
                }
                this._reader.startReading();
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "Before getDate");
                }
                this.sendMessage(new GetDateMessage("0.9.9"));
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "After getDate / begin waiting for a response");
                }
                int waitcount = 0;
                while (!this._dateReceived) {
                    if (waitcount++ > 30) {
                        throw new IOException("No handshake received from the router");
                    }
                    out = this._dateReceivedLock;
                    synchronized (out) {
                        this._dateReceivedLock.wait(1000L);
                    }
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "After received a SetDate response");
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "Before producer.connect()");
                }
                this._producer.connect(this);
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "After producer.connect()");
                }
                waitcount = 0;
                while (this._leaseSet == null) {
                    if (waitcount++ > 300) {
                        throw new IOException("No tunnels built after waiting 5 minutes. Your network connection may be down, or there is severe network congestion.");
                    }
                    out = this._leaseSetWait;
                    synchronized (out) {
                        this._leaseSetWait.wait(1000L);
                    }
                }
                if (this._log.shouldLog(20)) {
                    long connected = this._context.clock().now();
                    this._log.info(this.getPrefix() + "Lease set created with inbound tunnels after " + (connected - startConnect) + "ms - ready to participate in the network!");
                }
                I2PAppThread notifier = new I2PAppThread(this._availabilityNotifier, "ClientNotifier " + this.getPrefix(), true);
                notifier.start();
                this.startIdleMonitor();
                this.startVerifyUsage();
                success = true;
                Object var11_22 = null;
                if (success) {
                    this.changeState(State.OPEN);
                    break block58;
                }
                this._availabilityNotifier.stopNotifying();
                object = this._stateLock;
            }
            catch (Throwable throwable) {
                Object var11_23 = null;
                if (success) {
                    this.changeState(State.OPEN);
                } else {
                    this._availabilityNotifier.stopNotifying();
                    Object object3 = this._stateLock;
                    synchronized (object3) {
                        this.changeState(State.CLOSING);
                        try {
                            this._producer.disconnect(this);
                        }
                        catch (I2PSessionException ipe) {
                            // empty catch block
                        }
                        this.closeSocket();
                    }
                }
                throw throwable;
            }
            synchronized (object) {
                this.changeState(State.CLOSING);
                try {
                    this._producer.disconnect(this);
                }
                catch (I2PSessionException ipe) {
                    // empty catch block
                }
                this.closeSocket();
            }
            {
                catch (InterruptedException ie) {
                    throw new I2PSessionException("Interrupted", ie);
                }
                catch (UnknownHostException uhe) {
                    throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, uhe);
                }
                catch (IOException ioe) {
                    throw new I2PSessionException(this.getPrefix() + "Cannot connect to the router on " + this._hostname + ':' + this._portNum, ioe);
                }
            }
        }
    }

    public byte[] receiveMessage(int msgId) throws I2PSessionException {
        MessagePayloadMessage msg = this._availableMessages.remove(msgId);
        if (msg == null) {
            this._log.error("Receive message " + msgId + " had no matches");
            return null;
        }
        this.updateActivity();
        return msg.getPayload().getUnencryptedData();
    }

    public void reportAbuse(int msgId, int severity) throws I2PSessionException {
        if (this.isClosed()) {
            throw new I2PSessionException(this.getPrefix() + "Already closed");
        }
        this._producer.reportAbuse(this, msgId, severity);
    }

    public abstract void receiveStatus(int var1, long var2, int var4);

    public void addNewMessage(MessagePayloadMessage msg) {
        Long mid = msg.getMessageId();
        this._availableMessages.put(mid, msg);
        long id = msg.getMessageId();
        byte[] data = msg.getPayload().getUnencryptedData();
        if (data == null || data.length <= 0) {
            if (this._log.shouldLog(50)) {
                this._log.log(50, this.getPrefix() + "addNewMessage of a message with no unencrypted data", new Exception("Empty message"));
            }
        } else {
            int size = data.length;
            this._availabilityNotifier.available(id, size);
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Notified availability for session " + this._sessionId + ", message " + id);
            }
        }
    }

    private void startVerifyUsage() {
        this._context.simpleScheduler().addEvent(new VerifyUsage(), 60000L);
    }

    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        I2CPMessageHandler handler = this._handlerMap.getHandler(message.getType());
        if (handler == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Unknown message or unhandleable message received: type = " + message.getType());
            }
        } else {
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix() + "Message received of type " + message.getType() + " to be handled by " + handler.getClass().getSimpleName());
            }
            handler.handleMessage(message, this);
        }
    }

    public void readError(I2CPMessageReader reader, Exception error) {
        this.propogateError("There was an error reading data", error);
        this.disconnect();
    }

    public Destination getMyDestination() {
        return this._myDestination;
    }

    public PrivateKey getDecryptionKey() {
        return this._privateKey;
    }

    public SigningPrivateKey getPrivateKey() {
        return this._signingPrivateKey;
    }

    I2CPMessageProducer getProducer() {
        return this._producer;
    }

    Properties getOptions() {
        return this._options;
    }

    SessionId getSessionId() {
        return this._sessionId;
    }

    void setSessionId(SessionId id) {
        this._sessionId = id;
    }

    public void setSessionListener(I2PSessionListener lsnr) {
        this._sessionListener = lsnr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.CLOSED;
        }
    }

    void sendMessage(I2CPMessage message) throws I2PSessionException {
        block6: {
            if (this.isClosed()) {
                throw new I2PSessionException("Already closed");
            }
            if (this._queue != null) {
                try {
                    if (!this._queue.offer(message, 10000L)) {
                        throw new I2PSessionException("Timed out waiting while write queue was full");
                    }
                    break block6;
                }
                catch (InterruptedException ie) {
                    throw new I2PSessionException("Interrupted", ie);
                }
            }
            if (this._writer == null) {
                throw new I2PSessionException("Already closed");
            }
            this._writer.addMessage(message);
        }
    }

    void propogateError(String msg, Throwable error) {
        String msgpfx;
        int level;
        if (error instanceof EOFException) {
            level = 30;
            msgpfx = "Router closed connection: ";
        } else {
            level = 40;
            msgpfx = "Error occurred communicating with router: ";
        }
        if (this._log.shouldLog(level)) {
            this._log.log(level, this.getPrefix() + msgpfx + msg, error);
        }
        if (this._sessionListener != null) {
            this._sessionListener.errorOccurred(this, msg, error);
        }
    }

    public void destroySession() {
        this.destroySession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySession(boolean sendDisconnect) {
        block10: {
            Object object = this._stateLock;
            synchronized (object) {
                if (this._state == State.CLOSING || this._state == State.CLOSED) {
                    return;
                }
                this.changeState(State.CLOSING);
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Destroy the session", new Exception("DestroySession()"));
            }
            if (sendDisconnect && this._producer != null) {
                try {
                    this._producer.disconnect(this);
                }
                catch (I2PSessionException ipe) {
                    if (!this._log.shouldLog(30)) break block10;
                    this._log.warn("Error destroying the session", ipe);
                }
            }
        }
        if (this._availabilityNotifier != null) {
            this._availabilityNotifier.stopNotifying();
        }
        this.closeSocket();
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocket() {
        Object object = this._stateLock;
        synchronized (object) {
            this.changeState(State.CLOSING);
            this.locked_closeSocket();
            this.changeState(State.CLOSED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_closeSocket() {
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Closing the socket", new Exception("closeSocket"));
        }
        if (this._reader != null) {
            this._reader.stopReading();
            this._reader = null;
        }
        if (this._queue != null) {
            this._queue.close();
        }
        if (this._writer != null) {
            this._writer.stopWriting();
            this._writer = null;
        }
        if (this._socket != null) {
            try {
                try {
                    this._socket.close();
                }
                catch (IOException ioe) {
                    this.propogateError("Caught an IO error closing the socket.  ignored", ioe);
                    Object var3_2 = null;
                    this._socket = null;
                }
                Object var3_1 = null;
                this._socket = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this._socket = null;
                throw throwable;
            }
        }
    }

    public void disconnected(I2CPMessageReader reader) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Disconnected", new Exception("Disconnected"));
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.CLOSING || this._state == State.CLOSED) {
                return;
            }
            this.changeState(State.CLOSING);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Disconnect() called", new Exception("Disconnect"));
        }
        if (this.shouldReconnect()) {
            if (this.reconnect()) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "I2CP reconnection successful");
                }
                return;
            }
            if (this._log.shouldLog(40)) {
                this._log.error(this.getPrefix() + "I2CP reconnection failed");
            }
        }
        if (this._log.shouldLog(40)) {
            this._log.error(this.getPrefix() + "Disconned from the router, and not trying to reconnect");
        }
        if (this._sessionListener != null) {
            this._sessionListener.disconnected(this);
        }
        this.closeSocket();
        this.changeState(State.CLOSED);
    }

    protected boolean shouldReconnect() {
        return true;
    }

    protected boolean reconnect() {
        this.closeSocket();
        if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "Reconnecting...");
        }
        int i = 0;
        while (true) {
            long delay = 10000 << i;
            ++i;
            if (delay > 320000L || delay <= 0L) {
                delay = 320000L;
            }
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return false;
            }
            try {
                this.connect();
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getPrefix() + "Reconnected on attempt " + i);
                }
                return true;
            }
            catch (I2PSessionException ise) {
                if (!this._log.shouldLog(40)) continue;
                this._log.error(this.getPrefix() + "Error reconnecting on attempt " + i, ise);
                continue;
            }
            break;
        }
    }

    protected String getPrefix() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        String s = this._options.getProperty("inbound.nickname");
        if (s != null) {
            buf.append(s);
        } else {
            buf.append(this.getClass().getSimpleName());
        }
        if (this._sessionId != null) {
            buf.append(" #").append(this._sessionId.getSessionId());
        }
        buf.append("]: ");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destReceived(Destination d) {
        Hash h = d.calculateHash();
        Map<Hash, Destination> map = _lookupCache;
        synchronized (map) {
            _lookupCache.put(h, d);
        }
        for (LookupWaiter w : this._pendingLookups) {
            if (!w.hash.equals(h)) continue;
            w.destination = d;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destLookupFailed(Hash h) {
        for (LookupWaiter w : this._pendingLookups) {
            if (!w.hash.equals(h)) continue;
            LookupWaiter lookupWaiter = w;
            synchronized (lookupWaiter) {
                w.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bwReceived(int[] i) {
        this._bwLimits = i;
        Object object = this._bwReceivedLock;
        synchronized (object) {
            this._bwReceivedLock.notifyAll();
        }
    }

    public Destination lookupDest(Hash h) throws I2PSessionException {
        return this.lookupDest(h, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination lookupDest(Hash h, long maxWait) throws I2PSessionException {
        Object rv;
        Map<Hash, Destination> map = _lookupCache;
        synchronized (map) {
            rv = _lookupCache.get(h);
            if (rv != null) {
                return rv;
            }
        }
        if (this.isClosed()) {
            return null;
        }
        LookupWaiter waiter = new LookupWaiter(h);
        this._pendingLookups.offer(waiter);
        try {
            this.sendMessage(new DestLookupMessage(h));
            try {
                rv = waiter;
                synchronized (rv) {
                    waiter.wait(maxWait);
                }
            }
            catch (InterruptedException ie) {
                throw new I2PSessionException("Interrupted", ie);
            }
            Object var9_8 = null;
            this._pendingLookups.remove(waiter);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this._pendingLookups.remove(waiter);
            throw throwable;
        }
        return waiter.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] bandwidthLimits() throws I2PSessionException {
        if (this.isClosed()) {
            return null;
        }
        this.sendMessage(new GetBandwidthLimitsMessage());
        try {
            Object object = this._bwReceivedLock;
            synchronized (object) {
                this._bwReceivedLock.wait(5000L);
            }
        }
        catch (InterruptedException ie) {
            throw new I2PSessionException("Interrupted", ie);
        }
        return this._bwLimits;
    }

    protected void updateActivity() {
        this._lastActivity = this._context.clock().now();
        if (this._isReduced) {
            this._isReduced = false;
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getPrefix() + "Restoring original tunnel quantity");
            }
            try {
                this._producer.updateTunnels(this, 0);
            }
            catch (I2PSessionException ise) {
                this._log.error(this.getPrefix() + "bork restore from reduced");
            }
        }
    }

    public long lastActivity() {
        return this._lastActivity;
    }

    public void setReduced() {
        this._isReduced = true;
    }

    private void startIdleMonitor() {
        this._isReduced = false;
        boolean reduce = Boolean.parseBoolean(this._options.getProperty("i2cp.reduceOnIdle"));
        boolean close = Boolean.parseBoolean(this._options.getProperty("i2cp.closeOnIdle"));
        if (reduce || close) {
            this.updateActivity();
            this._context.simpleScheduler().addEvent(new SessionIdleTimer(this._context, this, reduce, close), 300000L);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        buf.append("Session: ");
        if (this._myDestination != null) {
            buf.append(this._myDestination.calculateHash().toBase64().substring(0, 4));
        } else {
            buf.append("[null dest]");
        }
        buf.append(this.getPrefix());
        return buf.toString();
    }

    protected class AvailabilityNotifier
    implements Runnable {
        private final List<Long> _pendingIds = new ArrayList<Long>(2);
        private final List<Integer> _pendingSizes = new ArrayList<Integer>(2);
        private volatile boolean _alive;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopNotifying() {
            this._alive = false;
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void available(long msgId, int size) {
            AvailabilityNotifier availabilityNotifier = this;
            synchronized (availabilityNotifier) {
                this._pendingIds.add(msgId);
                this._pendingSizes.add(size);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._alive = true;
            while (this._alive) {
                Long msgId = null;
                Integer size = null;
                AvailabilityNotifier availabilityNotifier = this;
                synchronized (availabilityNotifier) {
                    if (this._pendingIds.isEmpty()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (!this._pendingIds.isEmpty()) {
                        msgId = this._pendingIds.remove(0);
                        size = this._pendingSizes.remove(0);
                    }
                }
                if (msgId == null || size == null) continue;
                if (I2PSessionImpl.this._sessionListener != null) {
                    try {
                        long before = System.currentTimeMillis();
                        I2PSessionImpl.this._sessionListener.messageAvailable(I2PSessionImpl.this, msgId.intValue(), size.intValue());
                        long duration = System.currentTimeMillis() - before;
                        if (duration <= 100L || !I2PSessionImpl.this._log.shouldLog(20)) continue;
                        I2PSessionImpl.this._log.info("Message availability notification for " + msgId.intValue() + " took " + duration + " to " + I2PSessionImpl.this._sessionListener);
                    }
                    catch (Exception e) {
                        I2PSessionImpl.this._log.log(50, "Error notifying app of message availability", e);
                    }
                    continue;
                }
                I2PSessionImpl.this._log.log(50, "Unable to notify an app that " + msgId + " of size " + size + " is available!");
            }
        }
    }

    private static class LookupWaiter {
        public final Hash hash;
        public volatile Destination destination;

        public LookupWaiter(Hash h) {
            this.hash = h;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum State {
        OPENING,
        OPEN,
        CLOSING,
        CLOSED;

    }

    private class VerifyUsage
    implements SimpleTimer.TimedEvent {
        private final List<Long> toCheck = new ArrayList<Long>();

        private VerifyUsage() {
        }

        public void timeReached() {
            if (I2PSessionImpl.this.isClosed()) {
                return;
            }
            if (!this.toCheck.isEmpty()) {
                for (Long msgId : this.toCheck) {
                    MessagePayloadMessage removed = I2PSessionImpl.this._availableMessages.remove(msgId);
                    if (removed == null) continue;
                    I2PSessionImpl.this._log.error("Message NOT removed!  id=" + msgId + ": " + removed);
                }
                this.toCheck.clear();
            }
            this.toCheck.addAll(I2PSessionImpl.this._availableMessages.keySet());
            I2PSessionImpl.this._context.simpleScheduler().addEvent(this, 60000L);
        }
    }
}

