/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.command.dml.Update;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class Insert
extends Prepared
implements ResultTarget {
    private Table table;
    private Column[] columns;
    private final ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private boolean sortedInsertMode;
    private int rowNumber;
    private boolean insertFromSelect;
    private HashMap<Column, Expression> duplicateKeyAssignmentMap;

    public Insert(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addAssignmentForDuplicate(Column column, Expression expression) {
        if (this.duplicateKeyAssignmentMap == null) {
            this.duplicateKeyAssignmentMap = New.hashMap();
        }
        if (this.duplicateKeyAssignmentMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.duplicateKeyAssignmentMap.put(column, expression);
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        Index index = null;
        if (this.sortedInsertMode) {
            index = this.table.getScanIndex(this.session);
            index.setSortedInsertMode(true);
        }
        try {
            int n = this.insertRows();
            return n;
        }
        finally {
            if (index != null) {
                index.setSortedInsertMode(false);
            }
        }
    }

    private int insertRows() {
        this.session.getUser().checkRight(this.table, 4);
        this.setCurrentRowNumber(0);
        this.table.fire(this.session, 1, true);
        this.rowNumber = 0;
        int n = this.list.size();
        if (n > 0) {
            int n2 = this.columns.length;
            for (int i = 0; i < n; ++i) {
                int n3;
                this.session.startStatementWithinTransaction();
                Row row = this.table.getTemplateRow();
                Expression[] expressionArray = this.list.get(i);
                this.setCurrentRowNumber(i + 1);
                for (n3 = 0; n3 < n2; ++n3) {
                    Column column = this.columns[n3];
                    int n4 = column.getColumnId();
                    Expression expression = expressionArray[n3];
                    if (expression == null) continue;
                    expression = expression.optimize(this.session);
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n4, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, i, Insert.getSQL(expressionArray));
                    }
                }
                ++this.rowNumber;
                this.table.validateConvertUpdateSequence(this.session, row);
                n3 = this.table.fireBeforeRow(this.session, null, row) ? 1 : 0;
                if (n3 != 0) continue;
                this.table.lock(this.session, true, false);
                try {
                    this.table.addRow(this.session, row);
                }
                catch (DbException dbException) {
                    this.handleOnDuplicate(dbException);
                }
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
            }
        } else {
            this.table.lock(this.session, true, false);
            if (this.insertFromSelect) {
                this.query.query(0, this);
            } else {
                LocalResult localResult = this.query.query(0);
                while (localResult.next()) {
                    Value[] valueArray = localResult.currentRow();
                    this.addRow(valueArray);
                }
                localResult.close();
            }
        }
        this.table.fire(this.session, 1, false);
        return this.rowNumber;
    }

    @Override
    public void addRow(Value[] valueArray) {
        int n;
        Row row = this.table.getTemplateRow();
        this.setCurrentRowNumber(++this.rowNumber);
        int n2 = this.columns.length;
        for (n = 0; n < n2; ++n) {
            Column column = this.columns[n];
            int n3 = column.getColumnId();
            try {
                Value value = column.convert(valueArray[n]);
                row.setValue(n3, value);
                continue;
            }
            catch (DbException dbException) {
                throw this.setRow(dbException, this.rowNumber, Insert.getSQL(valueArray));
            }
        }
        this.table.validateConvertUpdateSequence(this.session, row);
        n = this.table.fireBeforeRow(this.session, null, row) ? 1 : 0;
        if (n == 0) {
            this.table.addRow(this.session, row);
            this.session.log(this.table, (short)0, row);
            this.table.fireAfterRow(this.session, null, row, false);
        }
    }

    @Override
    public int getRowCount() {
        return this.rowNumber;
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("INSERT INTO ");
        statementBuilder.append(this.table.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(")\n");
        if (this.insertFromSelect) {
            statementBuilder.append("DIRECT ");
        }
        if (this.sortedInsertMode) {
            statementBuilder.append("SORTED ");
        }
        if (this.list.size() > 0) {
            statementBuilder.append("VALUES ");
            int n = 0;
            if (this.list.size() > 1) {
                statementBuilder.append('\n');
            }
            for (Expression[] expressionArray : this.list) {
                if (n++ > 0) {
                    statementBuilder.append(",\n");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] expressionArray : this.list) {
                if (expressionArray.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                int n = expressionArray.length;
                for (int i = 0; i < n; ++i) {
                    Expression expression = expressionArray[i];
                    if (expression == null) continue;
                    if ((expression = expression.optimize(this.session)) instanceof Parameter) {
                        Parameter parameter = (Parameter)expression;
                        parameter.setColumn(this.columns[i]);
                    }
                    expressionArray[i] = expression;
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    @Override
    public int getType() {
        return 61;
    }

    public void setInsertFromSelect(boolean bl) {
        this.insertFromSelect = bl;
    }

    @Override
    public boolean isCacheable() {
        return this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty();
    }

    private void handleOnDuplicate(DbException dbException) {
        Object object;
        if (dbException.getErrorCode() != 23505) {
            throw dbException;
        }
        if (this.duplicateKeyAssignmentMap == null || this.duplicateKeyAssignmentMap.isEmpty()) {
            throw dbException;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(this.duplicateKeyAssignmentMap.size());
        for (int i = 0; i < this.columns.length; ++i) {
            object = this.session.getCurrentSchemaName() + "." + this.table.getName() + "." + this.columns[i].getName();
            arrayList.add(object);
            this.session.setVariable((String)object, this.list.get(this.getCurrentRowNumber() - 1)[i].getValue(this.session));
        }
        Update update = new Update(this.session);
        update.setTableFilter(new TableFilter(this.session, this.table, null, true, null));
        for (Column object2 : this.duplicateKeyAssignmentMap.keySet()) {
            update.setAssignment(object2, this.duplicateKeyAssignmentMap.get(object2));
        }
        object = this.searchForUpdateIndex();
        if (object == null) {
            throw DbException.getUnsupportedException("Unable to apply ON DUPLICATE KEY UPDATE, no index found!");
        }
        update.setCondition(this.prepareUpdateCondition((Index)object));
        update.prepare();
        update.update();
        for (String string : arrayList) {
            this.session.setVariable(string, ValueNull.INSTANCE);
        }
    }

    private Index searchForUpdateIndex() {
        Index index = null;
        for (Index index2 : this.table.getIndexes()) {
            if (!index2.getIndexType().isPrimaryKey() && !index2.getIndexType().isUnique()) continue;
            for (Column column : index2.getColumns()) {
                for (Column column2 : this.columns) {
                    if (column.getName() == column2.getName()) {
                        index = index2;
                        break;
                    }
                    index = null;
                }
                if (index == null) break;
            }
            if (index == null) continue;
            break;
        }
        return index;
    }

    private Expression prepareUpdateCondition(Index index) {
        Condition condition = null;
        for (Column column : index.getColumns()) {
            ExpressionColumn expressionColumn = new ExpressionColumn(this.session.getDatabase(), this.session.getCurrentSchemaName(), null, column.getName());
            for (int i = 0; i < this.columns.length; ++i) {
                if (!expressionColumn.getColumnName().equals(this.columns[i].getName())) continue;
                condition = condition == null ? new Comparison(this.session, 0, expressionColumn, this.list.get(this.getCurrentRowNumber() - 1)[i++]) : new ConditionAndOr(0, condition, new Comparison(this.session, 0, expressionColumn, this.list.get(0)[i++]));
            }
        }
        return condition;
    }
}

