/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.util.BigPipedInputStream;
import net.i2p.util.ByteCache;
import net.i2p.util.I2PAppThread;
import net.i2p.util.InternalSocket;
import net.i2p.util.Log;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.SocketTimeout;

public class EepGet {
    protected final I2PAppContext _context;
    protected final Log _log;
    protected final boolean _shouldProxy;
    private final String _proxyHost;
    private final int _proxyPort;
    protected final int _numRetries;
    private final long _minSize;
    private final long _maxSize;
    protected final String _outputFile;
    protected final OutputStream _outputStream;
    protected final String _url;
    protected String _actualURL;
    private final String _postData;
    private boolean _allowCaching;
    protected final List<StatusListener> _listeners;
    protected List<String> _extraHeaders;
    protected boolean _keepFetching;
    protected Socket _proxy;
    protected OutputStream _proxyOut;
    protected InputStream _proxyIn;
    protected OutputStream _out;
    protected long _alreadyTransferred;
    protected long _bytesTransferred;
    protected long _bytesRemaining;
    protected int _currentAttempt;
    protected int _responseCode = -1;
    protected String _responseText;
    protected boolean _shouldWriteErrorToOutput;
    protected String _etag;
    protected String _lastModified;
    protected final String _etagOrig;
    protected final String _lastModifiedOrig;
    protected boolean _encodingChunked;
    protected boolean _notModified;
    protected String _contentType;
    protected boolean _transferFailed;
    protected boolean _headersRead;
    protected boolean _aborted;
    private long _fetchHeaderTimeout;
    private long _fetchEndTime;
    protected long _fetchInactivityTimeout;
    protected int _redirects;
    protected String _redirectLocation;
    protected boolean _isGzippedResponse;
    protected IOException _decompressException;
    protected static final String USER_AGENT = "Wget/1.11.4";
    protected static final long CONNECT_TIMEOUT = 45000L;
    protected static final long INACTIVITY_TIMEOUT = 60000L;
    protected static final int MAX_COMPLETE_FAILS = 5;
    private static final char[] ILLEGAL = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f'};
    private static final byte NL = 10;

    public EepGet(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String outputFile, String url) {
        this(ctx, true, proxyHost, proxyPort, numRetries, outputFile, url);
    }

    public EepGet(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, boolean allowCaching) {
        this(ctx, true, proxyHost, proxyPort, numRetries, outputFile, url, allowCaching, null);
    }

    public EepGet(I2PAppContext ctx, int numRetries, String outputFile, String url) {
        this(ctx, false, null, -1, numRetries, outputFile, url);
    }

    public EepGet(I2PAppContext ctx, int numRetries, String outputFile, String url, boolean allowCaching) {
        this(ctx, false, null, -1, numRetries, outputFile, url, allowCaching, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, outputFile, url, true, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, String postData) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, true, null, postData);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, boolean allowCaching, String etag) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, allowCaching, etag, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, String outputFile, String url, boolean allowCaching, String etag, String lastModified) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, -1L, -1L, outputFile, null, url, allowCaching, etag, lastModified, null);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, long minSize, long maxSize, String outputFile, OutputStream outputStream, String url, boolean allowCaching, String etag, String postData) {
        this(ctx, shouldProxy, proxyHost, proxyPort, numRetries, minSize, maxSize, outputFile, outputStream, url, allowCaching, etag, null, postData);
    }

    public EepGet(I2PAppContext ctx, boolean shouldProxy, String proxyHost, int proxyPort, int numRetries, long minSize, long maxSize, String outputFile, OutputStream outputStream, String url, boolean allowCaching, String etag, String lastModified, String postData) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._shouldProxy = proxyHost != null && proxyHost.length() > 0 && proxyPort > 0 && shouldProxy;
        this._proxyHost = proxyHost;
        this._proxyPort = proxyPort;
        this._numRetries = numRetries;
        this._minSize = minSize;
        this._maxSize = maxSize;
        this._outputFile = outputFile;
        this._outputStream = outputStream;
        this._url = url;
        this._actualURL = url;
        this._postData = postData;
        this._bytesRemaining = -1L;
        this._fetchHeaderTimeout = 45000L;
        this._listeners = new ArrayList<StatusListener>(1);
        this._etag = etag;
        this._lastModified = lastModified;
        this._etagOrig = etag;
        this._lastModifiedOrig = lastModified;
    }

    public static void main(String[] args) {
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        int numRetries = 5;
        int markSize = 1024;
        int lineLen = 40;
        long inactivityTimeout = 60000L;
        String etag = null;
        String saveAs = null;
        String url = null;
        ArrayList<String> extra = null;
        String username = null;
        String password = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-p")) {
                    proxyHost = args[++i].substring(0, args[i].indexOf(58));
                    String port = args[i].substring(args[i].indexOf(58) + 1);
                    proxyPort = Integer.parseInt(port);
                    continue;
                }
                if (args[i].equals("-n")) {
                    numRetries = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-t")) {
                    inactivityTimeout = 1000 * Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equals("-e")) {
                    etag = "\"" + args[i + 1] + "\"";
                    ++i;
                    continue;
                }
                if (args[i].equals("-o")) {
                    saveAs = args[i + 1];
                    ++i;
                    continue;
                }
                if (args[i].equals("-m")) {
                    markSize = Integer.parseInt(args[++i]);
                    lineLen = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-h")) {
                    if (extra == null) {
                        extra = new ArrayList<String>(2);
                    }
                    extra.add(args[++i]);
                    extra.add(args[++i]);
                    continue;
                }
                if (args[i].equals("-u")) {
                    username = args[++i];
                    password = args[++i];
                    continue;
                }
                if (args[i].startsWith("-")) {
                    EepGet.usage();
                    return;
                }
                url = args[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EepGet.usage();
            return;
        }
        if (url == null) {
            EepGet.usage();
            return;
        }
        if (saveAs == null) {
            saveAs = EepGet.suggestName(url);
        }
        EepGet get = new EepGet(I2PAppContext.getGlobalContext(), true, proxyHost, proxyPort, numRetries, saveAs, url, true, etag);
        if (extra != null) {
            for (int i = 0; i < extra.size(); i += 2) {
                get.addHeader((String)extra.get(i), (String)extra.get(i + 1));
            }
        }
        if (username != null && password != null) {
            get.addAuthorization(username, password);
        }
        EepGet eepGet = get;
        eepGet.getClass();
        get.addStatusListener(eepGet.new CLIStatusListener(markSize, lineLen));
        if (!get.fetch(45000L, -1L, inactivityTimeout)) {
            System.exit(1);
        }
    }

    public static String suggestName(String url) {
        int last = url.lastIndexOf(47);
        if (last < 0 || url.lastIndexOf(35) > last) {
            last = url.lastIndexOf(35);
        }
        if (last < 0 || url.lastIndexOf(63) > last) {
            last = url.lastIndexOf(63);
        }
        if (last < 0 || url.lastIndexOf(61) > last) {
            last = url.lastIndexOf(61);
        }
        String name = null;
        if (last >= 0) {
            name = EepGet.sanitize(url.substring(last + 1));
        }
        if (name != null && name.length() > 0) {
            return name;
        }
        return EepGet.sanitize(url);
    }

    private static String sanitize(String name) {
        if (name.equals(".") || name.equals(" ")) {
            return "_";
        }
        String rv = name;
        if (rv.startsWith(".")) {
            rv = '_' + rv.substring(1);
        }
        if (rv.endsWith(".") || rv.endsWith(" ")) {
            rv = rv.substring(0, rv.length() - 1) + '_';
        }
        for (int i = 0; i < ILLEGAL.length; ++i) {
            if (rv.indexOf(ILLEGAL[i]) < 0) continue;
            rv = rv.replace(ILLEGAL[i], '_');
        }
        return rv;
    }

    private static void usage() {
        System.err.println("EepGet [-p 127.0.0.1:4444] [-n #retries] [-o outputFile]\n       [-m markSize lineLen] [-t timeout] [-h headerKey headerValue]\n       [-u username password] url]\n       (use -p :0 for no proxy)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener lsnr) {
        List<StatusListener> list = this._listeners;
        synchronized (list) {
            this._listeners.add(lsnr);
        }
    }

    public void stopFetching() {
        this._keepFetching = false;
    }

    public boolean fetch() {
        return this.fetch(this._fetchHeaderTimeout);
    }

    public boolean fetch(long fetchHeaderTimeout) {
        return this.fetch(fetchHeaderTimeout, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean fetch(long fetchHeaderTimeout, long totalTimeout, long inactivityTimeout) {
        this._fetchHeaderTimeout = fetchHeaderTimeout;
        this._fetchEndTime = totalTimeout > 0L ? System.currentTimeMillis() + totalTimeout : -1L;
        this._fetchInactivityTimeout = inactivityTimeout;
        this._keepFetching = true;
        if (this._log.shouldLog(10)) {
            this._log.debug("Fetching (proxied? " + this._shouldProxy + ") url=" + this._actualURL);
        }
        while (this._keepFetching) {
            IOException ioe222;
            IOException cioe222;
            Object var11_12;
            SocketTimeout timeout;
            block38: {
                block34: {
                    int i;
                    block35: {
                        timeout = null;
                        if (this._fetchHeaderTimeout > 0L) {
                            final SocketTimeout stimeout = timeout = new SocketTimeout(this._fetchHeaderTimeout);
                            timeout.setTimeoutCommand(new Runnable(){

                                public void run() {
                                    if (EepGet.this._log.shouldLog(10)) {
                                        EepGet.this._log.debug("timeout reached on " + EepGet.this._url + ": " + stimeout);
                                    }
                                    EepGet.this._aborted = true;
                                }
                            });
                            timeout.setTotalTimeoutPeriod(this._fetchEndTime);
                        }
                        for (i = 0; i < this._listeners.size(); i += 1) {
                            this._listeners.get(i).attempting(this._url);
                        }
                        this.sendRequest(timeout);
                        if (timeout != null) {
                            timeout.resetTimer();
                        }
                        this.doFetch(timeout);
                        if (timeout != null) {
                            timeout.cancel();
                        }
                        if (this._transferFailed) break block34;
                        i = 1;
                        var11_12 = null;
                        if (this._out == null) break block35;
                        try {
                            this._out.close();
                        }
                        catch (IOException cioe222) {
                            // empty catch block
                        }
                        this._out = null;
                    }
                    if (this._proxy != null) {
                        try {
                            this._proxy.close();
                            this._proxy = null;
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    return i != 0;
                }
                var11_12 = null;
                if (this._out == null) break block38;
                try {
                    this._out.close();
                }
                catch (IOException cioe222) {
                    // empty catch block
                }
                this._out = null;
            }
            if (this._proxy == null) break;
            try {
                this._proxy.close();
                this._proxy = null;
            }
            catch (IOException ioe222) {}
            break;
            {
                catch (IOException ioe3) {
                    if (timeout != null) {
                        timeout.cancel();
                    }
                    for (int i = 0; i < this._listeners.size(); ++i) {
                        this._listeners.get(i).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, ioe3);
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("ERR: doFetch failed ", ioe3);
                    }
                    if (ioe3 instanceof MalformedURLException || ioe3 instanceof ConnectException) {
                        this._keepFetching = false;
                    }
                    var11_12 = null;
                    if (this._out != null) {
                        try {
                            this._out.close();
                        }
                        catch (IOException cioe222) {
                            // empty catch block
                        }
                        this._out = null;
                    }
                    if (this._proxy != null) {
                        try {
                            this._proxy.close();
                            this._proxy = null;
                        }
                        catch (IOException ioe222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                var11_12 = null;
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (IOException cioe222) {
                        // empty catch block
                    }
                    this._out = null;
                }
                if (this._proxy != null) {
                    try {
                        this._proxy.close();
                        this._proxy = null;
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            ++this._currentAttempt;
            if (this._currentAttempt > this._numRetries || this._alreadyTransferred == 0L && this._currentAttempt > 5 || !this._keepFetching) break;
            this._redirects = 0;
            try {
                long delay = this._context.random().nextInt(60000);
                Thread.sleep(5000L + delay);
            }
            catch (InterruptedException ie) {}
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).transferFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("All attempts failed for " + this._url);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFetch(SocketTimeout timeout) throws IOException {
        int i;
        boolean strictSize;
        this._headersRead = false;
        this._aborted = false;
        try {
            this.readHeaders();
            Object var3_2 = null;
            this._headersRead = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this._headersRead = true;
            throw throwable;
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0L) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(60000L);
            }
        }
        if (this._redirectLocation != null) {
            if (this._redirectLocation.startsWith("http://")) {
                this._actualURL = this._redirectLocation;
            } else {
                URL url = new URL(this._actualURL);
                this._actualURL = this._redirectLocation.startsWith("/") ? "http://" + url.getHost() + ":" + url.getPort() + this._redirectLocation : "http://" + url.getHost() + ":" + url.getPort() + "/" + this._redirectLocation;
            }
            ++this._redirects;
            if (this._redirects > 5) {
                throw new IOException("Too many redirects: to " + this._redirectLocation);
            }
            if (this._log.shouldLog(20)) {
                this._log.info("Redirecting to " + this._redirectLocation);
            }
            this._bytesRemaining = -1L;
            this._redirectLocation = null;
            this._etag = this._etagOrig;
            this._lastModified = this._lastModifiedOrig;
            this._contentType = null;
            this._encodingChunked = false;
            this.sendRequest(timeout);
            this.doFetch(timeout);
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Headers read completely, reading " + this._bytesRemaining);
        }
        boolean bl = strictSize = this._bytesRemaining >= 0L;
        if (this._minSize > 0L && this._bytesRemaining < this._minSize) {
            throw new IOException("HTTP response size " + this._bytesRemaining + " violates minimum of " + this._minSize + " bytes");
        }
        if (this._maxSize > -1L && this._bytesRemaining > this._maxSize) {
            throw new IOException("HTTP response size " + this._bytesRemaining + " violates maximum of " + this._maxSize + " bytes");
        }
        I2PAppThread pusher = null;
        this._decompressException = null;
        if (this._isGzippedResponse) {
            PipedInputStream pi = BigPipedInputStream.getInstance();
            PipedOutputStream po = new PipedOutputStream(pi);
            pusher = new I2PAppThread(new Gunzipper(pi, this._out), "EepGet Decompressor");
            this._out = po;
            pusher.start();
        }
        int remaining = (int)this._bytesRemaining;
        byte[] buf = new byte[16384];
        while (!(!this._keepFetching || remaining <= 0 && strictSize || this._aborted)) {
            int read;
            int toRead = buf.length;
            if (strictSize && toRead > remaining) {
                toRead = remaining;
            }
            if ((read = this._proxyIn.read(buf, 0, toRead)) == -1) break;
            if (timeout != null) {
                timeout.resetTimer();
            }
            this._out.write(buf, 0, read);
            this._bytesTransferred += (long)read;
            if (this._maxSize > -1L && this._alreadyTransferred + (long)read > this._maxSize) {
                throw new IOException("Bytes transferred " + (this._alreadyTransferred + (long)read) + " violates maximum of " + this._maxSize + " bytes");
            }
            if ((remaining -= read) == 0 && this._encodingChunked) {
                int char1 = this._proxyIn.read();
                if (char1 == 13) {
                    int char2 = this._proxyIn.read();
                    if (char2 == 10) {
                        remaining = (int)this.readChunkLength();
                    } else {
                        this._out.write(char1);
                        this._out.write(char2);
                        this._bytesTransferred += 2L;
                        remaining -= 2;
                        read += 2;
                    }
                } else {
                    this._out.write(char1);
                    ++this._bytesTransferred;
                    --remaining;
                    ++read;
                }
            }
            if (timeout != null) {
                timeout.resetTimer();
            }
            if (this._bytesRemaining >= (long)read) {
                this._bytesRemaining -= (long)read;
            }
            if (read <= 0) continue;
            for (i = 0; i < this._listeners.size(); ++i) {
                this._listeners.get(i).bytesTransferred(this._alreadyTransferred, read, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url);
            }
            this._alreadyTransferred += (long)read;
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._isGzippedResponse) {
            try {
                pusher.join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            pusher = null;
            if (this._decompressException != null) {
                this._keepFetching = false;
                throw this._decompressException;
            }
        }
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Done transferring " + this._bytesTransferred + " (ok? " + !this._transferFailed + ")");
        }
        if (this._transferFailed) {
            if (!this._listeners.isEmpty()) {
                String s = this._responseText != null ? "Attempt failed: " + this._responseCode + ' ' + this._responseText : "Attempt failed: " + this._responseCode;
                IOException e = new IOException(s);
                for (i = 0; i < this._listeners.size(); ++i) {
                    this._listeners.get(i).attemptFailed(this._url, this._bytesTransferred, this._bytesRemaining, this._currentAttempt, this._numRetries, e);
                }
            }
        } else {
            if (this._minSize > 0L && this._alreadyTransferred < this._minSize) {
                throw new IOException("Bytes transferred " + this._alreadyTransferred + " violates minimum of " + this._minSize + " bytes");
            }
            if (this._bytesRemaining == -1L || remaining == 0) {
                for (int i2 = 0; i2 < this._listeners.size(); ++i2) {
                    this._listeners.get(i2).transferComplete(this._alreadyTransferred, this._bytesTransferred, this._encodingChunked ? -1L : this._bytesRemaining, this._url, this._outputFile, this._notModified);
                }
            } else {
                throw new IOException("Disconnection on attempt " + this._currentAttempt + " after " + this._bytesTransferred);
            }
        }
    }

    protected void readHeaders() throws IOException {
        String key = null;
        StringBuilder buf = new StringBuilder(32);
        boolean read = DataHelper.readLine(this._proxyIn, buf);
        if (!read) {
            throw new IOException("Unable to read the first line");
        }
        this._responseCode = this.handleStatus(buf.toString());
        boolean redirect = false;
        if (this._log.shouldLog(10)) {
            this._log.debug("rc: " + this._responseCode + " for " + this._actualURL);
        }
        boolean rcOk = false;
        switch (this._responseCode) {
            case 200: {
                this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, false);
                this._alreadyTransferred = 0L;
                rcOk = true;
                break;
            }
            case 206: {
                this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, true);
                rcOk = true;
                break;
            }
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                this._alreadyTransferred = 0L;
                rcOk = true;
                redirect = true;
                break;
            }
            case 304: {
                this._bytesRemaining = 0L;
                this._keepFetching = false;
                this._notModified = true;
                return;
            }
            case 403: 
            case 404: 
            case 409: 
            case 503: {
                this._transferFailed = true;
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput) {
                    this._keepFetching = false;
                    return;
                }
                rcOk = true;
                if (this._out != null) break;
                if (this._outputStream != null) {
                    this._out = this._outputStream;
                    break;
                }
                this._out = new FileOutputStream(this._outputFile, true);
                break;
            }
            case 416: {
                this._bytesRemaining = 0L;
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput) {
                    this._keepFetching = false;
                    return;
                }
                rcOk = true;
                if (this._out != null) break;
                if (this._outputStream != null) {
                    this._out = this._outputStream;
                    break;
                }
                this._out = new FileOutputStream(this._outputFile, true);
                break;
            }
            case 504: {
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput || this._currentAttempt < this._numRetries) {
                    throw new IOException("HTTP Proxy timeout");
                }
                rcOk = true;
                if (this._out == null) {
                    this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, true);
                }
                this._transferFailed = true;
                break;
            }
            default: {
                if (this._alreadyTransferred > 0L || !this._shouldWriteErrorToOutput) {
                    this._keepFetching = false;
                } else {
                    rcOk = true;
                    if (this._out == null) {
                        this._out = this._outputStream != null ? this._outputStream : new FileOutputStream(this._outputFile, true);
                    }
                }
                this._transferFailed = true;
            }
        }
        this._isGzippedResponse = false;
        this._etag = null;
        this._lastModified = null;
        buf.setLength(0);
        byte[] lookahead = new byte[3];
        block14: do {
            int cur = this._proxyIn.read();
            switch (cur) {
                case -1: {
                    throw new IOException("Headers ended too soon");
                }
                case 58: {
                    if (key == null) {
                        key = buf.toString();
                        buf.setLength(0);
                        EepGet.increment(lookahead, cur);
                        break;
                    }
                    buf.append((char)cur);
                    EepGet.increment(lookahead, cur);
                    break;
                }
                case 10: 
                case 13: {
                    if (key != null) {
                        this.handle(key, buf.toString());
                    }
                    buf.setLength(0);
                    key = null;
                    EepGet.increment(lookahead, cur);
                    if (!EepGet.isEndOfHeaders(lookahead)) continue block14;
                    if (!rcOk) {
                        throw new IOException("Invalid HTTP response code: " + this._responseCode);
                    }
                    if (this._encodingChunked) {
                        this._bytesRemaining = this.readChunkLength();
                    }
                    if (!redirect) {
                        this._redirectLocation = null;
                    }
                    return;
                }
                default: {
                    buf.append((char)cur);
                    EepGet.increment(lookahead, cur);
                }
            }
        } while (buf.length() <= 1024);
        throw new IOException("Header line too long: " + buf.toString());
    }

    protected long readChunkLength() throws IOException {
        StringBuilder buf = new StringBuilder(8);
        int nl = 0;
        do {
            int cur = this._proxyIn.read();
            switch (cur) {
                case -1: {
                    throw new IOException("Chunk ended too soon");
                }
                case 10: 
                case 13: {
                    ++nl;
                }
            }
            buf.append((char)cur);
        } while (nl < 2);
        String len = buf.toString().trim();
        try {
            long bytes = Long.parseLong(len, 16);
            if (this._log.shouldLog(10)) {
                this._log.debug("Chunked length: " + bytes);
            }
            return bytes;
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Invalid chunk length [" + len + "]");
        }
    }

    private int handleStatus(String line) {
        String[] toks;
        if (this._log.shouldLog(10)) {
            this._log.debug("Status line: [" + line + "]");
        }
        if ((toks = line.split(" ", 3)).length < 2) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ERR: status " + line);
            }
            return -1;
        }
        String rc = toks[1];
        try {
            this._responseText = toks.length >= 3 ? toks[2].trim() : null;
            return Integer.parseInt(rc);
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ERR: status is invalid: " + line, nfe);
            }
            return -1;
        }
    }

    private void handle(String key, String val) {
        key = key.trim();
        val = val.trim();
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).headerReceived(this._url, this._currentAttempt, key, val);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Header line: [" + key + "] = [" + val + "]");
        }
        if ((key = key.toLowerCase(Locale.US)).equals("content-length")) {
            try {
                this._bytesRemaining = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        } else if (key.equals("etag")) {
            this._etag = val;
        } else if (key.equals("last-modified")) {
            this._lastModified = val;
        } else if (key.equals("transfer-encoding")) {
            this._encodingChunked = val.toLowerCase(Locale.US).contains("chunked");
        } else if (key.equals("content-encoding")) {
            if (!this._actualURL.endsWith(".gz") && !this._actualURL.endsWith(".tgz")) {
                this._isGzippedResponse = val.toLowerCase(Locale.US).contains("gzip");
            }
        } else if (key.equals("content-type")) {
            this._contentType = val;
        } else if (key.equals("location")) {
            this._redirectLocation = val;
        }
    }

    private static void increment(byte[] lookahead, int cur) {
        lookahead[0] = lookahead[1];
        lookahead[1] = lookahead[2];
        lookahead[2] = (byte)cur;
    }

    private static boolean isEndOfHeaders(byte[] lookahead) {
        byte first = lookahead[0];
        byte second = lookahead[1];
        byte third = lookahead[2];
        return EepGet.isNL(second) && EepGet.isNL(third) || EepGet.isNL(first) && EepGet.isNL(third);
    }

    private static boolean isNL(byte b) {
        return b == 10;
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        File outFile;
        if (this._outputStream == null && (outFile = new File(this._outputFile)).exists()) {
            this._alreadyTransferred = outFile.length();
        }
        String req = this.getRequest();
        if (this._proxyIn != null) {
            try {
                this._proxyIn.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._proxyOut != null) {
            try {
                this._proxyOut.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._proxy != null) {
            try {
                this._proxy.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (this._shouldProxy) {
            this._proxy = InternalSocket.getSocket(this._proxyHost, this._proxyPort);
        } else {
            URL url = new URL(this._actualURL);
            if ("http".equals(url.getProtocol())) {
                String host = url.getHost();
                if (host.toLowerCase(Locale.US).endsWith(".i2p")) {
                    throw new MalformedURLException("I2P addresses must be proxied");
                }
                int port = url.getPort();
                if (port == -1) {
                    port = 80;
                }
                this._proxy = new Socket(host, port);
            } else {
                throw new MalformedURLException("URL is not supported:" + this._actualURL);
            }
        }
        this._proxyIn = this._proxy.getInputStream();
        if (!(this._proxy instanceof InternalSocket)) {
            this._proxyIn = new BufferedInputStream(this._proxyIn);
        }
        this._proxyOut = this._proxy.getOutputStream();
        if (timeout != null) {
            timeout.setSocket(this._proxy);
        }
        this._proxyOut.write(DataHelper.getUTF8(req));
        this._proxyOut.flush();
        if (this._log.shouldLog(10)) {
            this._log.debug("Request flushed");
        }
    }

    protected String getRequest() throws IOException {
        String urlToSend;
        URL url;
        String host;
        StringBuilder buf = new StringBuilder(2048);
        boolean post = false;
        if (this._postData != null && this._postData.length() > 0) {
            post = true;
        }
        if ((host = (url = new URL(this._actualURL)).getHost()) == null || host.length() <= 0) {
            throw new MalformedURLException("Bad URL, no host");
        }
        int port = url.getPort();
        String path = url.getPath();
        String query = url.getQuery();
        if (this._log.shouldLog(10)) {
            this._log.debug("Requesting " + this._actualURL);
        }
        if (this._shouldProxy) {
            urlToSend = this._actualURL;
            if (!(path != null && path.length() > 0 || query != null && query.length() > 0)) {
                urlToSend = urlToSend + "/";
            }
        } else {
            urlToSend = path;
            if (urlToSend == null || urlToSend.length() <= 0) {
                urlToSend = "/";
            }
            if (query != null) {
                urlToSend = urlToSend + '?' + query;
            }
        }
        if (post) {
            buf.append("POST ").append(urlToSend).append(" HTTP/1.1\r\n");
        } else {
            buf.append("GET ").append(urlToSend).append(" HTTP/1.1\r\n");
        }
        buf.append("Host: ").append(host);
        if (port >= 0) {
            buf.append(':').append(port);
        }
        buf.append("\r\n");
        if (this._alreadyTransferred > 0L) {
            buf.append("Range: bytes=");
            buf.append(this._alreadyTransferred);
            buf.append("-\r\n");
        }
        if (!this._allowCaching) {
            buf.append("Cache-control: no-cache\r\nPragma: no-cache\r\n");
        }
        if (this._etag != null && this._alreadyTransferred <= 0L) {
            buf.append("If-None-Match: ");
            buf.append(this._etag);
            buf.append("\r\n");
        }
        if (this._lastModified != null && this._alreadyTransferred <= 0L) {
            buf.append("If-Modified-Since: ");
            buf.append(this._lastModified);
            buf.append("\r\n");
        }
        if (post) {
            buf.append("Content-length: ").append(this._postData.length()).append("\r\n");
        }
        buf.append("Accept-Encoding: ");
        if (!(this._shouldProxy || path.endsWith(".gz") || path.endsWith(".tgz"))) {
            buf.append("gzip");
        }
        buf.append("\r\nUser-Agent: Wget/1.11.4\r\nConnection: close\r\n");
        if (this._extraHeaders != null) {
            for (String hdr : this._extraHeaders) {
                buf.append(hdr).append("\r\n");
            }
        }
        buf.append("\r\n");
        if (post) {
            buf.append(this._postData);
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }

    public String getETag() {
        return this._etag;
    }

    public String getLastModified() {
        return this._lastModified;
    }

    public boolean getNotModified() {
        return this._notModified;
    }

    public String getContentType() {
        return this._contentType;
    }

    public int getStatusCode() {
        return this._responseCode;
    }

    public String getStatusText() {
        return this._responseText;
    }

    public void setWriteErrorToOutput() {
        this._shouldWriteErrorToOutput = true;
    }

    public void addHeader(String name, String value) {
        if (this._extraHeaders == null) {
            this._extraHeaders = new ArrayList<String>();
        }
        this._extraHeaders.add(name + ": " + value);
    }

    public void addAuthorization(String userName, String password) {
        if (this._shouldProxy) {
            this.addHeader("Proxy-Authorization", "Basic " + Base64.encode(DataHelper.getUTF8(userName + ':' + password), true));
        }
    }

    protected class CLIStatusListener
    implements StatusListener {
        private final int _markSize;
        private final int _lineSize;
        private final long _startedOn;
        private long _written;
        private long _previousWritten;
        private long _discarded;
        private long _lastComplete;
        private boolean _firstTime;
        private final DecimalFormat _pct = new DecimalFormat("00.0%");
        private final DecimalFormat _kbps = new DecimalFormat("###,000.00");

        public CLIStatusListener() {
            this(1024, 40);
        }

        public CLIStatusListener(int markSize, int lineSize) {
            this._markSize = markSize;
            this._lineSize = lineSize;
            this._startedOn = this._lastComplete = EepGet.this._context.clock().now();
            this._firstTime = true;
        }

        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
            if (this._firstTime) {
                if (alreadyTransferred > 0L) {
                    this._previousWritten = alreadyTransferred;
                    System.out.println("File found with length " + alreadyTransferred + ", resuming");
                }
                this._firstTime = false;
            }
            if (this._written == 0L && alreadyTransferred == 0L && this._previousWritten > 0L) {
                System.out.println("Server does not support resume, discarding " + this._previousWritten + " bytes");
                this._discarded += this._previousWritten;
                this._previousWritten = 0L;
            }
            for (int i = 0; i < currentWrite; ++i) {
                ++this._written;
                if (this._markSize <= 0 || this._written % (long)this._markSize != 0L) continue;
                System.out.print("#");
                if (this._lineSize <= 0 || this._written % ((long)this._markSize * (long)this._lineSize) != 0L) continue;
                long now = EepGet.this._context.clock().now();
                long timeToSend = now - this._lastComplete;
                if (timeToSend > 0L) {
                    StringBuilder buf = new StringBuilder(50);
                    Formatter fmt = new Formatter(buf);
                    buf.append(" ");
                    if (bytesRemaining > 0L) {
                        double pct = 100.0 * ((double)this._written + (double)this._previousWritten) / ((double)alreadyTransferred + (double)currentWrite + (double)bytesRemaining);
                        fmt.format("%4.1f", pct);
                        buf.append("%: ");
                    }
                    fmt.format("%8d", this._written);
                    buf.append(" @ ");
                    double lineKBytes = (double)this._markSize * (double)this._lineSize / 1024.0;
                    double kbps = lineKBytes / ((double)timeToSend / 1000.0);
                    fmt.format("%7.2f", kbps);
                    buf.append(" KBps");
                    buf.append(" / ");
                    long lifetime = EepGet.this._context.clock().now() - this._startedOn;
                    double lifetimeKBps = 1000.0 * (double)this._written / ((double)lifetime * 1024.0);
                    fmt.format("%7.2f", lifetimeKBps);
                    buf.append(" KBps");
                    System.out.println(buf.toString());
                }
                this._lastComplete = now;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            long transferred = this._firstTime ? 0L : alreadyTransferred - this._previousWritten;
            System.out.println();
            System.out.println("== " + new Date());
            if (notModified) {
                System.out.println("== Source not modified since last download");
            } else {
                if (bytesRemaining > 0L) {
                    System.out.println("== Transfer of " + url + " completed with " + transferred + " transferred and " + (bytesRemaining - bytesTransferred) + " remaining" + (this._discarded > 0L ? " and " + this._discarded + " bytes discarded" : ""));
                } else {
                    System.out.println("== Transfer of " + url + " completed with " + transferred + " bytes transferred" + (this._discarded > 0L ? " and " + this._discarded + " bytes discarded" : ""));
                }
                if (transferred > 0L) {
                    System.out.println("== Output saved to " + outputFile + " (" + alreadyTransferred + " bytes)");
                }
            }
            long timeToSend = EepGet.this._context.clock().now() - this._startedOn;
            System.out.println("== Transfer time: " + DataHelper.formatDuration(timeToSend));
            if (EepGet.this._etag != null) {
                System.out.println("== ETag: " + EepGet.this._etag);
            }
            if (transferred > 0L) {
                StringBuilder buf = new StringBuilder(50);
                buf.append("== Transfer rate: ");
                double kbps = 1000.0 * (double)transferred / ((double)timeToSend * 1024.0);
                DecimalFormat decimalFormat = this._kbps;
                synchronized (decimalFormat) {
                    buf.append(this._kbps.format(kbps));
                }
                buf.append("KBps");
                System.out.println(buf.toString());
            }
        }

        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            System.out.println();
            System.out.println("** " + new Date());
            System.out.println("** Attempt " + currentAttempt + " of " + url + " failed");
            System.out.println("** Transfered " + bytesTransferred + " with " + (bytesRemaining < 0L ? "unknown" : "" + bytesRemaining) + " remaining");
            System.out.println("** " + cause.getMessage());
            this._previousWritten += this._written;
            this._written = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
            System.out.println("== " + new Date());
            System.out.println("== Transfer of " + url + " failed after " + currentAttempt + " attempts");
            System.out.println("== Transfer size: " + bytesTransferred + " with " + (bytesRemaining < 0L ? "unknown" : "" + bytesRemaining) + " remaining");
            long timeToSend = EepGet.this._context.clock().now() - this._startedOn;
            System.out.println("== Transfer time: " + DataHelper.formatDuration(timeToSend));
            double kbps = timeToSend > 0L ? 1000.0 * (double)bytesTransferred / ((double)timeToSend * 1024.0) : 0.0;
            StringBuilder buf = new StringBuilder(50);
            buf.append("== Transfer rate: ");
            DecimalFormat decimalFormat = this._kbps;
            synchronized (decimalFormat) {
                buf.append(this._kbps.format(kbps));
            }
            buf.append("KBps");
            System.out.println(buf.toString());
        }

        public void attempting(String url) {
        }

        public void headerReceived(String url, int currentAttempt, String key, String val) {
        }
    }

    protected class Gunzipper
    implements Runnable {
        private final InputStream _inRaw;
        private final OutputStream _out;
        private static final int CACHE_SIZE = 8192;
        private final ByteCache _cache = ByteCache.getInstance(8, 8192);

        public Gunzipper(InputStream in, OutputStream out) {
            this._inRaw = in;
            this._out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block21: {
                long written;
                ByteArray ba;
                ReusableGZIPInputStream in;
                block19: {
                    in = ReusableGZIPInputStream.acquire();
                    ba = null;
                    written = 0L;
                    in.initialize(this._inRaw);
                    ba = this._cache.acquire();
                    byte[] buf = ba.getData();
                    int read = -1;
                    while ((read = in.read(buf)) != -1) {
                        this._out.write(buf, 0, read);
                    }
                    Object var8_8 = null;
                    if (this._out == null) break block19;
                    try {
                        this._out.close();
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                }
                ReusableGZIPInputStream.release(in);
                if (ba != null) {
                    this._cache.release(ba);
                }
                break block21;
                {
                    catch (IOException ioe) {
                        EepGet.this._decompressException = ioe;
                        if (EepGet.this._log.shouldLog(30)) {
                            EepGet.this._log.warn("Error decompressing: " + written + ", " + in.getTotalRead() + "/" + in.getTotalExpanded(), ioe);
                        }
                        Object var8_9 = null;
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        ReusableGZIPInputStream.release(in);
                        if (ba != null) {
                            this._cache.release(ba);
                        }
                        break block21;
                    }
                    catch (OutOfMemoryError oom) {
                        EepGet.this._decompressException = new IOException("OOM in HTTP Decompressor");
                        EepGet.this._log.error("OOM in HTTP Decompressor", oom);
                        Object var8_10 = null;
                        if (this._out != null) {
                            try {
                                this._out.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        ReusableGZIPInputStream.release(in);
                        if (ba != null) {
                            this._cache.release(ba);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    if (this._out != null) {
                        try {
                            this._out.close();
                        }
                        catch (IOException ioe2) {
                            // empty catch block
                        }
                    }
                    ReusableGZIPInputStream.release(in);
                    if (ba != null) {
                        this._cache.release(ba);
                    }
                    throw throwable;
                }
            }
        }
    }

    public static interface StatusListener {
        public void bytesTransferred(long var1, int var3, long var4, long var6, String var8);

        public void transferComplete(long var1, long var3, long var5, String var7, String var8, boolean var9);

        public void attemptFailed(String var1, long var2, long var4, int var6, int var7, Exception var8);

        public void transferFailed(String var1, long var2, long var4, int var6);

        public void headerReceived(String var1, int var2, String var3, String var4);

        public void attempting(String var1);
    }
}

