/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.ourfilesystem.ui.ExtensionDialog;
import org.ourfilesystem.ui.ProgramManager;

public class ProgramPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ExtensionDialog ExtDialog;
    private ProgramManager Manager;
    private JTable Table;

    public ProgramPanel(String basedir) throws Exception {
        this.Manager = new ProgramManager(basedir);
        this.ExtDialog = new ExtensionDialog(this.Manager);
        this.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "Center");
        this.Table = new JTable(this.Manager);
        this.Table.setShowGrid(false);
        this.Table.setIntercellSpacing(new Dimension(0, 0));
        this.Table.setFillsViewportHeight(true);
        scrollPane.setViewportView(this.Table);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem add = new JMenuItem("Add File Extension");
        mnu.add(add);
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProgramPanel.this.ExtDialog.showExt("", "", "");
            }
        });
        JMenuItem edit = new JMenuItem("Edit/Add File Extension");
        mnu.add(edit);
        edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ProgramPanel.this.Table.getSelectionModel().isSelectionEmpty()) {
                    int r = ProgramPanel.this.Table.getSelectedRow();
                    r = ProgramPanel.this.Table.convertRowIndexToModel(r);
                    ProgramManager.Program p = ProgramPanel.this.Manager.getRow(r);
                    ProgramPanel.this.ExtDialog.showExt(p.Extension, p.Name, p.Program);
                }
            }
        });
        JMenuItem del = new JMenuItem("Remove");
        mnu.add(del);
        del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ProgramPanel.this.Table.getSelectionModel().isSelectionEmpty()) {
                    int r = ProgramPanel.this.Table.getSelectedRow();
                    r = ProgramPanel.this.Table.convertRowIndexToModel(r);
                    ProgramManager.Program p = ProgramPanel.this.Manager.getRow(r);
                    ProgramPanel.this.Manager.removeProgramExtension(p.Extension);
                }
            }
        });
        this.Table.setComponentPopupMenu(mnu);
        JButton btnAddProgram = new JButton("Add Program File Extension");
        this.add((Component)btnAddProgram, "North");
        btnAddProgram.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramPanel.this.ExtDialog.showExt("", "", "");
            }
        });
    }

    public ProgramManager getManager() {
        return this.Manager;
    }
}

