/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkAuthTableModel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPostDialog;
import org.ourfilesystem.ui.PostPanel;
import org.ourfilesystem.ui.PostTableModel;
import org.ourfilesystem.ui.QueryTableModel;
import org.ourfilesystem.ui.TemplateTableModel;
import org.ourfilesystem.utilities.BBytes;

public class PostSearchPanel
extends JPanel
implements NetworkSelectInterface,
RowSorterListener {
    private static final long serialVersionUID = 1L;
    private JTextField textQueryName;
    private JLabel lblGeneralSearch;
    private JTextField textGeneral;
    private JCheckBox chckbxUseGeneral;
    private JTextField textFileName;
    private JCheckBox chckbxUseFileName;
    private JCheckBox chckbxOnlyFindLocalFiles;
    private JTextField textSubject;
    private JCheckBox chckbxUseSubject;
    private JTextField textComment;
    private JCheckBox chckbxUseComment;
    private JTextField textMinRank;
    private JCheckBox chckbxUseMinRank;
    private JCheckBox[] chckbxBool;
    private JLabel lblPrimaryReference;
    private BBytes PrimaryReference;
    private JLabel[] lblRefName;
    private JLabel[] lblReference;
    private BBytes[] References;
    private JCheckBox[] chckbxRemoveRef;
    private JCheckBox[] chckbxAddRef;
    private JLabel[] lblNumLessThan;
    private JTextField[] txtNumLessThan;
    private JCheckBox[] chckbxNumLessThan;
    private JLabel[] lblNumGreaterThan;
    private JTextField[] txtNumGreaterThan;
    private JCheckBox[] chckbxNumGreaterThan;
    private JLabel[] lblDoubleLessThan;
    private JTextField[] txtDoubleLessThan;
    private JCheckBox[] chckbxDoubleLessThan;
    private JLabel[] lblDoubleGreaterThan;
    private JTextField[] txtDoubleGreaterThan;
    private JCheckBox[] chckbxDoubleGreaterThan;
    private JLabel[] lblString;
    private JTextField[] textString;
    private JCheckBox[] chckbxUseString;
    private JSplitPane mainSplitPane;
    private JScrollPane mainScroll;
    private Main Mn;
    private JLabel lblGroupSel;
    private JTable table;
    private QueryTableModel QueryTableModel;
    private TemplateTableModel TemplateTableModel;
    private NetworkAuthTableModel NetworkAuthTableModel;
    private NewPostDialog NewPostDialog;
    private LocalPost SelectedTempPost;
    private PostTemplate SelectedTemp;
    private LocalNetwork SelectedNetwork;
    private LocalPost SelectedPost;
    private SearchQuery SelectedQuery;
    private JButton btnSearch;
    private PostTableModel PostTableModel;
    private JLabel lblMaxResults;
    private JTextField textMaxResults;
    private JLabel lblFileReference;
    private JButton btnClear;
    private JLabel lblFromDate;
    private JCheckBox chckbxUseFromDate;
    private JDateChooser FromDate;
    private JLabel lblToDate;
    private JCheckBox chckbxUseToDate;
    private JDateChooser ToDate;
    private JTextField textDaysBackwards;
    private JCheckBox chckbxUseDaysBackwards;
    private JCheckBox chckbxHideOpened;
    private boolean SortClicked;
    private int SortColumn;
    private boolean SortAsc;

    public PostSearchPanel(Main m, PostPanel pp, PostTableModel tm) {
        this.Mn = m;
        this.PostTableModel = tm;
        this.SortClicked = false;
        this.QueryTableModel = new QueryTableModel(this.Mn);
        this.TemplateTableModel = new TemplateTableModel();
        this.NetworkAuthTableModel = new NetworkAuthTableModel(this.Mn.getCoreDB());
        this.NetworkAuthTableModel.setSimple(true);
        this.setLayout(new BorderLayout(0, 0));
        this.NewPostDialog = new NewPostDialog(this.Mn, this);
        this.mainSplitPane = new JSplitPane();
        this.add((Component)this.mainSplitPane, "Center");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(100, 2));
        this.mainSplitPane.setLeftComponent(scrollPane);
        JPopupMenu querymenu = new JPopupMenu();
        JMenuItem usequery = new JMenuItem("Select Query");
        querymenu.add(usequery);
        usequery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.doLoadQuery();
            }
        });
        JMenuItem delquery = new JMenuItem("Delete Query");
        querymenu.add(delquery);
        delquery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.doDeleteQuery();
            }
        });
        this.table = new JTable(this.QueryTableModel);
        this.table.setComponentPopupMenu(querymenu);
        this.table.setAutoCreateRowSorter(true);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        scrollPane.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                PostSearchPanel.this.doLoadQuery();
            }
        });
        this.mainScroll = new JScrollPane();
        this.mainSplitPane.setRightComponent(this.mainScroll);
        this.mainSplitPane.setDividerLocation(100);
        this.buildSearchPane();
    }

    private void doLoadQuery() {
        if (!this.table.getSelectionModel().isSelectionEmpty()) {
            int r = this.table.getSelectedRow();
            r = this.table.convertRowIndexToModel(r);
            this.SelectedQuery = this.QueryTableModel.getSearchQuery(r);
            this.updateFromSelectedQuery();
        }
    }

    private void doDeleteQuery() {
        if (!this.table.getSelectionModel().isSelectionEmpty()) {
            int r = this.table.getSelectedRow();
            r = this.table.convertRowIndexToModel(r);
            this.QueryTableModel.deleteSearchQuery(r);
        }
    }

    public void doTempSearch() {
        if (this.SelectedNetwork != null) {
            SearchQuery sq = new SearchQuery();
            sq.PeerId = this.SelectedNetwork.getNetwork().getSignature().getPeerIdentifier();
            sq.Network = this.SelectedNetwork.getNetwork().getSignature().getDigest();
            sq.Template = true;
            sq.SortBy = DataBaseLuceneIndexer.POST_POSTNUM;
            sq.SortReverse = true;
            QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchPosts(sq);
            if (qr.size() > 0) {
                this.SelectedTempPost = (LocalPost)qr.get(0);
                if (this.SelectedTempPost != null && this.SelectedTempPost.getPost().getMessage() instanceof PostTemplate) {
                    this.SelectedTemp = (PostTemplate)this.SelectedTempPost.getPost().getMessage();
                }
            }
        }
    }

    public void doSearchPosts() {
        SearchQuery sq = this.buildQuery();
        if (sq != null && this.Mn != null && this.PostTableModel != null) {
            if (this.SortClicked) {
                sq.SortBy = this.PostTableModel.getSortKey(this.SortColumn);
                sq.SortReverse = !this.SortAsc;
            }
            QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchPosts(sq);
            this.PostTableModel.setPosts(qr);
        }
    }

    public void searchPrimaryPost(BBytes ref) {
        this.buildSearchPane();
        this.lblPrimaryReference.setText("(" + ref.toString().substring(0, 20) + ")");
        this.PrimaryReference = ref;
        this.doSearchPosts();
    }

    private void addKeyListener(final JTextField field, final JCheckBox chk) {
        field.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                Matcher m = Pattern.compile("\\S+").matcher(field.getText());
                if (m.find()) {
                    chk.setSelected(true);
                } else {
                    chk.setSelected(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
    }

    private void buildSearchPane() {
        final JPanel panel = new JPanel();
        this.mainScroll.setViewportView(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow][]", "[][][][][][][][][][][][]"));
        String grpname = "none";
        if (this.SelectedNetwork != null) {
            grpname = this.SelectedNetwork.getNetwork().getTitleSig();
        }
        this.chckbxHideOpened = new JCheckBox("Hide opened");
        panel.add((Component)this.chckbxHideOpened, "cell 0 2");
        JButton btnNewPost = new JButton("New Post");
        panel.add((Component)btnNewPost, "flowx,cell 1 2,alignx left");
        btnNewPost.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PostSearchPanel.this.SelectedTempPost != null) {
                    if (PostSearchPanel.this.SelectedNetwork != null) {
                        PostSearchPanel.this.NewPostDialog.showDialog(PostSearchPanel.this.SelectedTempPost, PostSearchPanel.this.SelectedPost, PostSearchPanel.this.SelectedNetwork.getNetwork().getTitleSig());
                    } else {
                        JOptionPane.showMessageDialog(panel, "Select a group first.", "Select group", 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(panel, "The post format data was not found yet.\nUpdate both subscriptions and posts a few times.", "No post format", 2);
                }
            }
        });
        JButton btnUpdatePosts = new JButton("Update Posts");
        panel.add((Component)btnUpdatePosts, "cell 1 2,alignx right");
        btnUpdatePosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.Mn.getUpdater().updatePostsNow();
            }
        });
        JButton btnUpdateSubs = new JButton("Update Subscriptions");
        panel.add((Component)btnUpdateSubs, "cell 1 2,alignx right");
        btnUpdateSubs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PostSearchPanel.this.Mn.getUpdater().updateSubscriptionsNow();
            }
        });
        this.btnSearch = new JButton("Search");
        panel.add((Component)this.btnSearch, "cell 2 2");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PostSearchPanel.this.SelectedNetwork == null) {
                    JOptionPane.showMessageDialog(panel, "No Group is selected.", "No Group", 2);
                    return;
                }
                if (PostSearchPanel.this.SelectedTemp == null) {
                    JOptionPane.showMessageDialog(panel, "The post format data was not found yet.\nUpdate posts a few times.", "No post format", 2);
                    return;
                }
                PostSearchPanel.this.doSearchPosts();
            }
        });
        JLabel lblQueryName = new JLabel("Query name");
        panel.add((Component)lblQueryName, "cell 0 3,alignx trailing");
        this.textQueryName = new JTextField();
        panel.add((Component)this.textQueryName, "cell 1 3,growx");
        this.textQueryName.setColumns(10);
        JButton btnSaveQuery = new JButton("Save Query");
        panel.add((Component)btnSaveQuery, "cell 2 3");
        btnSaveQuery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchQuery sq = PostSearchPanel.this.buildQuery();
                Matcher m = Pattern.compile("\\S+").matcher(sq.QueryName);
                if (m.find()) {
                    PostSearchPanel.this.SelectedQuery = sq;
                    PostSearchPanel.this.QueryTableModel.saveSearchQuery(sq);
                } else {
                    JOptionPane.showMessageDialog(panel, "You must name the query.", "Name Query", 2);
                }
            }
        });
        this.lblFileReference = new JLabel("File Reference");
        panel.add((Component)this.lblFileReference, "cell 0 4,alignx trailing");
        this.lblPrimaryReference = new JLabel("none");
        panel.add((Component)this.lblPrimaryReference, "cell 1 4");
        this.btnClear = new JButton("Clear");
        panel.add((Component)this.btnClear, "cell 2 4");
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PostSearchPanel.this.lblPrimaryReference.setText("none");
                PostSearchPanel.this.PrimaryReference = null;
            }
        });
        this.lblGeneralSearch = new JLabel("General Search");
        panel.add((Component)this.lblGeneralSearch, "cell 0 5,alignx trailing");
        this.textGeneral = new JTextField();
        panel.add((Component)this.textGeneral, "cell 1 5,growx");
        this.textGeneral.setColumns(10);
        this.chckbxUseGeneral = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseGeneral, "cell 2 5");
        this.addKeyListener(this.textGeneral, this.chckbxUseGeneral);
        JLabel lblFileName = new JLabel("File name");
        panel.add((Component)lblFileName, "cell 0 6,alignx trailing");
        this.textFileName = new JTextField();
        panel.add((Component)this.textFileName, "cell 1 6,growx");
        this.textFileName.setColumns(10);
        this.chckbxUseFileName = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseFileName, "cell 2 6");
        this.addKeyListener(this.textFileName, this.chckbxUseFileName);
        JLabel lblSubject = new JLabel("Subject");
        panel.add((Component)lblSubject, "cell 0 7,alignx trailing");
        this.textSubject = new JTextField();
        panel.add((Component)this.textSubject, "cell 1 7,growx");
        this.textSubject.setColumns(10);
        this.chckbxUseSubject = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseSubject, "cell 2 7");
        this.addKeyListener(this.textSubject, this.chckbxUseSubject);
        JLabel lblComment = new JLabel("Comment");
        panel.add((Component)lblComment, "cell 0 8,alignx trailing");
        this.textComment = new JTextField();
        panel.add((Component)this.textComment, "cell 1 8,growx");
        this.textComment.setColumns(10);
        this.chckbxUseComment = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseComment, "cell 2 8");
        this.addKeyListener(this.textComment, this.chckbxUseComment);
        JLabel lblMinPeerRank = new JLabel("Min Peer Rank");
        panel.add((Component)lblMinPeerRank, "cell 0 9,alignx trailing");
        this.textMinRank = new JTextField();
        panel.add((Component)this.textMinRank, "cell 1 9,growx");
        this.textMinRank.setColumns(10);
        this.chckbxUseMinRank = new JCheckBox("Use");
        panel.add((Component)this.chckbxUseMinRank, "cell 2 9");
        this.addKeyListener(this.textMinRank, this.chckbxUseMinRank);
        this.chckbxOnlyFindLocalFiles = new JCheckBox("Only find posts for files I have");
        panel.add((Component)this.chckbxOnlyFindLocalFiles, "cell 1 10,growx");
        JLabel lblGroup = new JLabel("Current Group:");
        panel.add((Component)lblGroup, "cell 1 0,alignx left");
        this.lblGroupSel = new JLabel(grpname);
        panel.add((Component)this.lblGroupSel, "cell 1 0");
        this.lblNumLessThan = new JLabel[10];
        this.txtNumLessThan = new JTextField[10];
        this.chckbxNumLessThan = new JCheckBox[10];
        this.lblNumGreaterThan = new JLabel[10];
        this.txtNumGreaterThan = new JTextField[10];
        this.chckbxNumGreaterThan = new JCheckBox[10];
        this.lblDoubleLessThan = new JLabel[10];
        this.txtDoubleLessThan = new JTextField[10];
        this.chckbxDoubleLessThan = new JCheckBox[10];
        this.lblDoubleGreaterThan = new JLabel[10];
        this.txtDoubleGreaterThan = new JTextField[10];
        this.chckbxDoubleGreaterThan = new JCheckBox[10];
        this.chckbxBool = new JCheckBox[10];
        this.lblString = new JLabel[8];
        this.textString = new JTextField[8];
        this.chckbxUseString = new JCheckBox[8];
        this.lblRefName = new JLabel[3];
        this.lblReference = new JLabel[3];
        this.References = new BBytes[3];
        this.chckbxRemoveRef = new JCheckBox[3];
        this.chckbxAddRef = new JCheckBox[3];
        int r = 11;
        if (this.SelectedTemp != null) {
            int c3;
            JButton btnMin;
            int c2;
            JButton btnMax;
            String nv;
            int numinserted = 0;
            int c = 0;
            while (c < 10) {
                nv = this.SelectedTemp.getBool(c);
                if (nv != null) {
                    this.chckbxBool[c] = new JCheckBox(nv);
                    panel.add((Component)this.chckbxBool[c], "cell 1 " + r);
                    if (++numinserted % 2 == 0) {
                        ++r;
                    }
                }
                ++c;
            }
            if (numinserted % 2 != 0) {
                ++r;
            }
            c = 0;
            while (c < 10) {
                nv = this.SelectedTemp.getNum(c);
                if (nv != null) {
                    this.lblNumLessThan[c] = new JLabel(String.valueOf(nv) + " <");
                    panel.add((Component)this.lblNumLessThan[c], "cell 0 " + r + ",alignx trailing");
                    this.txtNumLessThan[c] = new JTextField();
                    panel.add((Component)this.txtNumLessThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtNumLessThan[c].setColumns(10);
                    btnMax = new JButton("Max");
                    panel.add((Component)btnMax, "cell 1 " + r);
                    c2 = c;
                    btnMax.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            PostSearchPanel.this.txtNumLessThan[c2].setText(Long.toString(Long.MAX_VALUE));
                            PostSearchPanel.this.chckbxNumLessThan[c2].setSelected(true);
                        }
                    });
                    this.chckbxNumLessThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxNumLessThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtNumLessThan[c], this.chckbxNumLessThan[c]);
                    this.lblNumGreaterThan[c] = new JLabel(String.valueOf(nv) + " >");
                    panel.add((Component)this.lblNumGreaterThan[c], "cell 0 " + ++r + ",alignx trailing");
                    this.txtNumGreaterThan[c] = new JTextField();
                    panel.add((Component)this.txtNumGreaterThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtNumGreaterThan[c].setColumns(10);
                    btnMin = new JButton("Min");
                    panel.add((Component)btnMin, "cell 1 " + r);
                    c3 = c;
                    btnMin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PostSearchPanel.this.txtNumGreaterThan[c3].setText(Long.toString(Long.MIN_VALUE));
                            PostSearchPanel.this.chckbxNumGreaterThan[c3].setSelected(true);
                        }
                    });
                    this.chckbxNumGreaterThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxNumGreaterThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtNumGreaterThan[c], this.chckbxNumGreaterThan[c]);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 10) {
                nv = this.SelectedTemp.getDouble(c);
                if (nv != null) {
                    this.lblDoubleLessThan[c] = new JLabel(String.valueOf(nv) + " <");
                    panel.add((Component)this.lblDoubleLessThan[c], "cell 0 " + r + ",alignx trailing");
                    this.txtDoubleLessThan[c] = new JTextField();
                    panel.add((Component)this.txtDoubleLessThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtDoubleLessThan[c].setColumns(10);
                    btnMax = new JButton("Max");
                    panel.add((Component)btnMax, "cell 1 " + r);
                    c2 = c;
                    btnMax.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            PostSearchPanel.this.txtDoubleLessThan[c2].setText(Double.toString(9.223372036854776E18));
                            PostSearchPanel.this.chckbxDoubleLessThan[c2].setSelected(true);
                        }
                    });
                    this.chckbxDoubleLessThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxDoubleLessThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtDoubleLessThan[c], this.chckbxDoubleLessThan[c]);
                    this.lblDoubleGreaterThan[c] = new JLabel(String.valueOf(nv) + " >");
                    panel.add((Component)this.lblDoubleGreaterThan[c], "cell 0 " + ++r + ",alignx trailing");
                    this.txtDoubleGreaterThan[c] = new JTextField();
                    panel.add((Component)this.txtDoubleGreaterThan[c], "flowx,cell 1 " + r + ",growx");
                    this.txtDoubleGreaterThan[c].setColumns(10);
                    btnMin = new JButton("Min");
                    panel.add((Component)btnMin, "cell 1 " + r);
                    c3 = c;
                    btnMin.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PostSearchPanel.this.txtDoubleGreaterThan[c3].setText(Double.toString(-9.223372036854776E18));
                            PostSearchPanel.this.chckbxDoubleGreaterThan[c3].setSelected(true);
                        }
                    });
                    this.chckbxDoubleGreaterThan[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxDoubleGreaterThan[c], "cell 2 " + r);
                    this.addKeyListener(this.txtDoubleGreaterThan[c], this.chckbxDoubleGreaterThan[c]);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 8) {
                nv = this.SelectedTemp.getString(c);
                if (nv != null) {
                    this.lblString[c] = new JLabel(nv);
                    panel.add((Component)this.lblString[c], "cell 0 " + r + ",alignx trailing");
                    this.textString[c] = new JTextField();
                    panel.add((Component)this.textString[c], "flowx,cell 1 " + r + ",growx");
                    this.textString[c].setColumns(10);
                    this.chckbxUseString[c] = new JCheckBox("Use");
                    panel.add((Component)this.chckbxUseString[c], "cell 2 " + r);
                    this.addKeyListener(this.textString[c], this.chckbxUseString[c]);
                    ++r;
                }
                ++c;
            }
            c = 0;
            while (c < 3) {
                nv = this.SelectedTemp.getRef(c);
                if (nv != null) {
                    this.lblRefName[c] = new JLabel(String.valueOf(nv) + ":");
                    panel.add((Component)this.lblRefName[c], "cell 0 " + r + ",alignx trailing");
                    this.lblReference[c] = new JLabel("none");
                    panel.add((Component)this.lblReference[c], "flowx,cell 1 " + r + ",growx");
                    this.References[c] = null;
                    JButton clr = new JButton("Clear");
                    panel.add((Component)clr, "cell 2 " + r);
                    final int rnum = c;
                    clr.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            ((PostSearchPanel)PostSearchPanel.this).References[rnum] = null;
                            PostSearchPanel.this.lblReference[rnum].setText("none");
                        }
                    });
                    this.chckbxRemoveRef[c] = new JCheckBox("Remove posts marked as " + nv);
                    panel.add((Component)this.chckbxRemoveRef[c], "cell 1 " + ++r);
                    this.chckbxAddRef[c] = new JCheckBox("Include posts marked as " + nv);
                    panel.add((Component)this.chckbxAddRef[c], "cell 1 " + ++r);
                    ++r;
                }
                ++c;
            }
        }
        this.lblMaxResults = new JLabel("Max Results");
        panel.add((Component)this.lblMaxResults, "cell 0 " + r + ",alignx trailing");
        this.textMaxResults = new JTextField("1000");
        panel.add((Component)this.textMaxResults, "flowx,cell 1 " + r);
        this.textMaxResults.setColumns(6);
        this.lblFromDate = new JLabel("From Date:");
        panel.add((Component)this.lblFromDate, "cell 0 " + ++r + ",alignx trailing");
        this.FromDate = new JDateChooser();
        panel.add((Component)this.FromDate, "cell 1 " + r);
        this.chckbxUseFromDate = new JCheckBox("Use From Date");
        panel.add((Component)this.chckbxUseFromDate, "cell 1 " + r);
        this.FromDate.getDateEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    PostSearchPanel.this.chckbxUseFromDate.setSelected(true);
                }
            }
        });
        this.lblToDate = new JLabel("To Date:");
        panel.add((Component)this.lblToDate, "cell 0 " + ++r + ",alignx trailing");
        this.ToDate = new JDateChooser();
        panel.add((Component)this.ToDate, "cell 1 " + r);
        this.chckbxUseToDate = new JCheckBox("Use To Date");
        panel.add((Component)this.chckbxUseToDate, "cell 1 " + r);
        this.ToDate.getDateEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    PostSearchPanel.this.chckbxUseToDate.setSelected(true);
                }
            }
        });
        JLabel lbldaysback = new JLabel("Number Days back:");
        panel.add((Component)lbldaysback, "cell 0 " + ++r + ",alignx trailing");
        this.textDaysBackwards = new JTextField();
        panel.add((Component)this.textDaysBackwards, "cell 1 " + r);
        this.textDaysBackwards.setColumns(6);
        this.chckbxUseDaysBackwards = new JCheckBox("Use Days Backwards");
        panel.add((Component)this.chckbxUseDaysBackwards, "cell 1 " + r);
        this.addKeyListener(this.textDaysBackwards, this.chckbxUseDaysBackwards);
        JButton search2 = new JButton("Search");
        panel.add((Component)search2, "cell 2 2");
        search2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PostSearchPanel.this.SelectedNetwork == null) {
                    JOptionPane.showMessageDialog(panel, "No Group is selected.", "No Group", 2);
                    return;
                }
                if (PostSearchPanel.this.SelectedTemp == null) {
                    JOptionPane.showMessageDialog(panel, "No template is selected.", "No template", 2);
                    return;
                }
                PostSearchPanel.this.doSearchPosts();
            }
        });
        panel.add((Component)search2, "cell 2 " + r);
    }

    private void updateFromSelectedQuery() {
        if (this.SelectedQuery != null) {
            Double v;
            Map<String, Double> dl;
            Long v2;
            int c;
            Map<String, Long> l;
            Set<String> b;
            Long mr;
            SearchQuery s = this.SelectedQuery;
            if (s.UseTemplate != null) {
                this.SelectedTempPost = this.Mn.getCoreDB().getPost(s.UseTemplate);
                if (this.SelectedTempPost != null && this.SelectedTempPost.getPost().getMessage() instanceof PostTemplate) {
                    this.SelectedTemp = (PostTemplate)this.SelectedTempPost.getPost().getMessage();
                }
            }
            this.buildSearchPane();
            this.chckbxHideOpened.setSelected(s.HideOpened);
            this.textQueryName.setText(s.QueryName);
            if (s.Generalterms != null) {
                this.textGeneral.setText(s.Generalterms);
                this.chckbxUseGeneral.setSelected(true);
            }
            this.chckbxOnlyFindLocalFiles.setSelected(s.OnlyLocalFile);
            if (s.Searchterms != null) {
                String n = s.Searchterms.get(DataBaseLuceneIndexer.POST_FILENAME);
                if (n != null) {
                    this.chckbxUseFileName.setSelected(true);
                    this.textFileName.setText(n);
                }
                if ((n = s.Searchterms.get(DataBaseLuceneIndexer.POST_SUBJECT)) != null) {
                    this.chckbxUseSubject.setSelected(true);
                    this.textSubject.setText(n);
                }
                if ((n = s.Searchterms.get(DataBaseLuceneIndexer.POST_COMMENT)) != null) {
                    this.chckbxUseComment.setSelected(true);
                    this.textComment.setText(n);
                }
                int c2 = 0;
                while (c2 < 8) {
                    n = s.Searchterms.get(PostTemplate.getStringKey(c2));
                    if (n != null) {
                        this.chckbxUseString[c2].setSelected(true);
                        this.textString[c2].setText(n);
                    }
                    ++c2;
                }
            }
            if ((mr = s.Minpeerrank) != null) {
                this.chckbxUseMinRank.setSelected(true);
                this.textMinRank.setText(Long.toString(mr));
            }
            if ((b = s.Andtruebools) != null) {
                int c3 = 0;
                while (c3 < 10) {
                    if (b.contains(PostTemplate.getBoolKey(c3))) {
                        this.chckbxBool[c3].setSelected(true);
                    }
                    ++c3;
                }
            }
            if ((l = s.Lessthan) != null) {
                c = 0;
                while (c < 10) {
                    v2 = l.get(PostTemplate.getNumKey(c));
                    if (v2 != null) {
                        this.chckbxNumLessThan[c].setSelected(true);
                        this.txtNumLessThan[c].setText(Long.toString(v2));
                    }
                    ++c;
                }
            }
            if ((l = s.Greaterthan) != null) {
                c = 0;
                while (c < 10) {
                    v2 = l.get(PostTemplate.getNumKey(c));
                    if (v2 != null) {
                        this.chckbxNumGreaterThan[c].setSelected(true);
                        this.txtNumGreaterThan[c].setText(Long.toString(v2));
                    }
                    ++c;
                }
            }
            if ((dl = s.Dlessthan) != null) {
                int c4 = 0;
                while (c4 < 10) {
                    v = dl.get(PostTemplate.getDoubleKey(c4));
                    if (v != null) {
                        this.chckbxDoubleLessThan[c4].setSelected(true);
                        this.txtDoubleLessThan[c4].setText(Double.toString(v));
                    }
                    ++c4;
                }
            }
            if ((dl = s.Dgreaterthan) != null) {
                int c5 = 0;
                while (c5 < 10) {
                    v = dl.get(PostTemplate.getDoubleKey(c5));
                    if (v != null) {
                        this.chckbxDoubleGreaterThan[c5].setSelected(true);
                        this.txtDoubleGreaterThan[c5].setText(Double.toString(v));
                    }
                    ++c5;
                }
            }
            if (s.Directref != null) {
                this.lblPrimaryReference.setText(s.Directref.toString().substring(0, 20));
                this.PrimaryReference = s.Directref;
            }
            if (s.Excludefilesreferencedbyothers0) {
                this.chckbxRemoveRef[0].setSelected(true);
            }
            if (s.Excludefilesreferencedbyothers1) {
                this.chckbxRemoveRef[1].setSelected(true);
            }
            if (s.Excludefilesreferencedbyothers2) {
                this.chckbxRemoveRef[2].setSelected(true);
            }
            if (s.Includefileswithreferences0) {
                this.chckbxAddRef[0].setSelected(true);
            }
            if (s.Includefileswithreferences1) {
                this.chckbxAddRef[1].setSelected(true);
            }
            if (s.Includefileswithreferences2) {
                this.chckbxAddRef[2].setSelected(true);
            }
            if (s.Refs0 != null) {
                this.lblReference[0].setText(s.Refs0.toString().substring(0, 20));
                this.References[0] = s.Refs0;
            }
            if (s.Refs1 != null) {
                this.lblReference[1].setText(s.Refs1.toString().substring(0, 20));
                this.References[1] = s.Refs1;
            }
            if (s.Refs2 != null) {
                this.lblReference[2].setText(s.Refs2.toString().substring(0, 20));
                this.References[2] = s.Refs2;
            }
            if (s.DaysBack != null) {
                s.Fromdate = null;
                this.textDaysBackwards.setText(Integer.toString(s.DaysBack));
                this.chckbxUseDaysBackwards.setSelected(true);
            } else {
                this.chckbxUseDaysBackwards.setSelected(false);
            }
            if (s.Fromdate != null) {
                this.FromDate.setDate(s.Fromdate);
                this.chckbxUseFromDate.setSelected(true);
            } else {
                this.chckbxUseFromDate.setSelected(false);
            }
            if (s.Todate != null) {
                this.ToDate.setDate(s.Todate);
                this.chckbxUseToDate.setSelected(true);
            } else {
                this.chckbxUseToDate.setSelected(false);
            }
        }
    }

    private SearchQuery buildQuery() {
        if (this.SelectedTemp != null) {
            long v2;
            SearchQuery sq = new SearchQuery();
            try {
                sq.MaxResults = Integer.valueOf(this.textMaxResults.getText());
            }
            catch (Exception e) {
                sq.MaxResults = 1000;
            }
            sq.HideOpened = this.chckbxHideOpened.isSelected();
            if (this.chckbxUseFromDate.isSelected()) {
                sq.Fromdate = this.FromDate.getDate();
            }
            if (this.chckbxUseToDate.isSelected()) {
                sq.Todate = this.ToDate.getDate();
            }
            if (this.chckbxUseDaysBackwards.isSelected()) {
                try {
                    sq.DaysBack = Integer.valueOf(this.textDaysBackwards.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.SelectedTempPost != null) {
                sq.UseTemplate = new BBytes(this.SelectedTempPost.getPost().getSignedDigest().getDigest());
                sq.Network = new BBytes(this.SelectedTempPost.getPost().getNetworkId());
            }
            sq.QueryName = this.textQueryName.getText();
            if (this.chckbxUseGeneral.isSelected()) {
                sq.Generalterms = this.textGeneral.getText();
            }
            if (this.chckbxUseSubject.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseLuceneIndexer.POST_SUBJECT, this.textSubject.getText());
            }
            if (this.chckbxUseFileName.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseLuceneIndexer.POST_FILENAME, this.textFileName.getText());
            }
            if (this.chckbxOnlyFindLocalFiles.isSelected()) {
                sq.OnlyLocalFile = true;
            }
            if (this.chckbxUseComment.isSelected()) {
                if (sq.Searchterms == null) {
                    sq.Searchterms = new HashMap<String, String>();
                }
                sq.Searchterms.put(DataBaseLuceneIndexer.POST_COMMENT, this.textComment.getText());
            }
            if (this.chckbxUseMinRank.isSelected()) {
                try {
                    long minr = Long.valueOf(this.textMinRank.getText());
                    sq.Minpeerrank = minr;
                }
                catch (Exception minr) {
                    // empty catch block
                }
            }
            int cnt = 0;
            while (cnt < 8) {
                if (this.chckbxUseString[cnt] != null && this.chckbxUseString[cnt].isSelected()) {
                    if (sq.Searchterms == null) {
                        sq.Searchterms = new HashMap<String, String>();
                    }
                    sq.Searchterms.put(PostTemplate.getStringKey(cnt), this.textString[cnt].getText());
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxBool[cnt] != null && this.chckbxBool[cnt].isSelected()) {
                    if (sq.Andtruebools == null) {
                        sq.Andtruebools = new HashSet<String>();
                    }
                    sq.Andtruebools.add(PostTemplate.getBoolKey(cnt));
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxNumLessThan[cnt] != null && this.chckbxNumLessThan[cnt].isSelected()) {
                    if (sq.Lessthan == null) {
                        sq.Lessthan = new HashMap<String, Long>();
                    }
                    try {
                        v2 = Long.valueOf(this.txtNumLessThan[cnt].getText());
                        sq.Lessthan.put(PostTemplate.getNumKey(cnt), v2);
                    }
                    catch (Exception v2) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxNumGreaterThan[cnt] != null && this.chckbxNumGreaterThan[cnt].isSelected()) {
                    if (sq.Greaterthan == null) {
                        sq.Greaterthan = new HashMap<String, Long>();
                    }
                    try {
                        v2 = Long.valueOf(this.txtNumGreaterThan[cnt].getText());
                        sq.Greaterthan.put(PostTemplate.getNumKey(cnt), v2);
                    }
                    catch (Exception v3) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxDoubleLessThan[cnt] != null && this.chckbxDoubleLessThan[cnt].isSelected()) {
                    if (sq.Dlessthan == null) {
                        sq.Dlessthan = new HashMap<String, Double>();
                    }
                    try {
                        double v4 = Double.valueOf(this.txtDoubleLessThan[cnt].getText());
                        sq.Dlessthan.put(PostTemplate.getDoubleKey(cnt), v4);
                    }
                    catch (Exception v4) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            cnt = 0;
            while (cnt < 10) {
                if (this.chckbxDoubleGreaterThan[cnt] != null && this.chckbxDoubleGreaterThan[cnt].isSelected()) {
                    if (sq.Dgreaterthan == null) {
                        sq.Dgreaterthan = new HashMap<String, Double>();
                    }
                    try {
                        double v5 = Double.valueOf(this.txtDoubleGreaterThan[cnt].getText());
                        sq.Dgreaterthan.put(PostTemplate.getDoubleKey(cnt), v5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++cnt;
            }
            if (this.PrimaryReference != null) {
                sq.Directref = new BBytes(this.PrimaryReference);
            }
            cnt = 0;
            while (cnt < 3) {
                if (this.References[cnt] != null) {
                    if (cnt == 0) {
                        sq.Refs0 = new BBytes(this.References[cnt]);
                    }
                    if (cnt == 1) {
                        sq.Refs1 = new BBytes(this.References[cnt]);
                    }
                    if (cnt == 2) {
                        sq.Refs2 = new BBytes(this.References[cnt]);
                    }
                }
                if (this.chckbxRemoveRef[cnt] != null && this.chckbxRemoveRef[cnt].isSelected()) {
                    if (cnt == 0) {
                        sq.Excludefilesreferencedbyothers0 = true;
                    }
                    if (cnt == 1) {
                        sq.Excludefilesreferencedbyothers1 = true;
                    }
                    if (cnt == 2) {
                        sq.Excludefilesreferencedbyothers2 = true;
                    }
                }
                if (this.chckbxAddRef[cnt] != null && this.chckbxAddRef[cnt].isSelected()) {
                    if (cnt == 0) {
                        sq.Includefileswithreferences0 = true;
                    }
                    if (cnt == 1) {
                        sq.Includefileswithreferences1 = true;
                    }
                    if (cnt == 2) {
                        sq.Includefileswithreferences2 = true;
                    }
                }
                ++cnt;
            }
            return sq;
        }
        return null;
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network) {
        this.SelectedNetwork = network;
        this.lblGroupSel.setText(network.getNetwork().getTitleSig());
        this.QueryTableModel.setSelectedNetwork(network);
        this.TemplateTableModel.setSelectedNetwork(network);
        this.SelectedTemp = null;
        this.SelectedTempPost = null;
        this.doTempSearch();
        this.buildSearchPane();
    }

    public NewPostDialog getNewPostDialog() {
        return this.NewPostDialog;
    }

    public void setNewPostDialog(NewPostDialog newPostDialog) {
        this.NewPostDialog = newPostDialog;
    }

    public void setPrimaryReference(LocalPost lp) {
        if (lp != null) {
            this.PrimaryReference = lp.getPost().getFileReferenceDigest();
            if (lp.getPost().getMessage() instanceof PostMessage) {
                PostMessage pm = (PostMessage)lp.getPost().getMessage();
                this.lblPrimaryReference.setText(String.valueOf(pm.getFileName()) + " (" + this.PrimaryReference.toString().substring(0, 20) + ")");
            }
        }
    }

    public void setReference(int num, LocalPost lp) {
        this.References[num] = lp.getPost().getFileReferenceDigest();
        if (this.References[num] != null) {
            StringBuilder sb = new StringBuilder();
            if (lp.getPost().getMessage() instanceof PostMessage) {
                PostMessage pm = (PostMessage)lp.getPost().getMessage();
                sb.append(pm.getFileName());
                sb.append(" ");
            }
            sb.append("(");
            sb.append(this.References[num].toString().substring(0, 20));
            sb.append(")");
            this.lblReference[num].setText(sb.toString());
        }
    }

    public void setPostReference(int num, LocalPost lp) {
        this.NewPostDialog.setReference(num, lp);
    }

    public PostTemplate getSelectedTemplate() {
        return this.SelectedTemp;
    }

    public JCheckBox getChckbxHideOpened() {
        return this.chckbxHideOpened;
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        List<RowSorter.SortKey> sl = ((RowSorter)e.getSource()).getSortKeys();
        if (sl.size() > 0) {
            RowSorter.SortKey sk = sl.get(0);
            this.SortClicked = true;
            this.SortColumn = sk.getColumn();
            this.SortAsc = sk.getSortOrder().equals((Object)SortOrder.ASCENDING);
        }
    }
}

