/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.ui.GroupPanel;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.PostSearchPanel;
import org.ourfilesystem.ui.PostTableModel;
import org.ourfilesystem.ui.ProgramManager;
import org.ourfilesystem.ui.ProgramRunner;
import org.ourfilesystem.ui.ViewPeerDialog;

public class PostPanel
extends JPanel
implements NetworkSelectInterface {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private PostSearchPanel SearchPanel;
    private GroupPanel GroupPanel;
    private PostTableModel PostTableModel;
    private NewPeerMessageDialog MessageDialog;
    private ViewPeerDialog PeerDialog;
    private ProgramManager Manager;
    private JMenuItem OpenItem;
    private Main Mn;

    public PostPanel(Main m) {
        this.Mn = m;
        this.PostTableModel = new PostTableModel();
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane leftRightSplitPane = new JSplitPane();
        this.add((Component)leftRightSplitPane, "Center");
        this.GroupPanel = new GroupPanel(this.Mn);
        leftRightSplitPane.setLeftComponent(this.GroupPanel);
        JSplitPane splitPane = new JSplitPane();
        leftRightSplitPane.setRightComponent(splitPane);
        splitPane.setOrientation(0);
        this.SearchPanel = new PostSearchPanel(this.Mn, this, this.PostTableModel);
        splitPane.setLeftComponent(this.SearchPanel);
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        splitPane.setDividerLocation(200);
        this.table = new JTable(this.PostTableModel);
        this.PostTableModel.insertDateRenderer(this.table);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().addRowSorterListener(this.SearchPanel);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    ProgramManager.Program prog;
                    File f;
                    String fname;
                    boolean setup = false;
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    Map<String, Object> m = PostPanel.this.PostTableModel.getTableFields(r);
                    if (m != null && (fname = (String)m.get(DataBaseLuceneIndexer.POST_LOCAL_FILENAME)) != null && (f = new File(fname)) != null && f.exists() && (prog = PostPanel.this.Manager.findProgramForFile(f.getPath())) != null && PostPanel.this.OpenItem != null) {
                        PostPanel.this.OpenItem.setText("Open file with " + prog.Name);
                        setup = true;
                    }
                    if (!setup) {
                        PostPanel.this.OpenItem.setText("Open");
                    }
                }
            }
        });
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    int row = PostPanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                    PostPanel.this.openPost(row);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        scrollPane.setViewportView(this.table);
        this.buildPopupMenu(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openPost(int r) {
        r = this.table.convertRowIndexToModel(r);
        LocalPost lp = this.PostTableModel.getPost(r);
        boolean started = false;
        if (lp != null) {
            ProgramManager.Program prog;
            File f = lp.getLocalFile();
            if (f != null && f.exists() && (prog = this.Manager.findProgramForFile(f.getPath())) != null) {
                new ProgramRunner(prog.Program, f.getPath(), this.Mn.getNodeDir().getPath());
                started = true;
            }
            if (!started) {
                this.SearchPanel.getNewPostDialog().showPost(lp);
            }
            if (!lp.isOpened()) {
                lp.setOpened(true);
                DataBaseCoreImplH2 dataBaseCoreImplH2 = this.Mn.getCoreDB();
                synchronized (dataBaseCoreImplH2) {
                    this.Mn.getCoreDB().saveLocalPost(lp);
                }
                this.PostTableModel.setOpened(r);
            }
        }
    }

    public void buildPopupMenu(PostTemplate t) {
        JPopupMenu mnu = new JPopupMenu();
        this.OpenItem = new JMenuItem("Open");
        mnu.add(this.OpenItem);
        this.OpenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    PostPanel.this.openPost(r);
                }
            }
        });
        JMenuItem view = new JMenuItem("View");
        mnu.add(view);
        view.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.SearchPanel.getNewPostDialog().showPost(lp);
                        if (!lp.isOpened()) {
                            lp.setOpened(true);
                            DataBaseCoreImplH2 dataBaseCoreImplH2 = PostPanel.this.Mn.getCoreDB();
                            synchronized (dataBaseCoreImplH2) {
                                PostPanel.this.Mn.getCoreDB().saveLocalPost(lp);
                            }
                            PostPanel.this.PostTableModel.setOpened(r);
                        }
                    }
                }
            }
        });
        JMenuItem download = new JMenuItem("Download Files");
        mnu.add(download);
        download.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = PostPanel.this.table.getSelectedRows();
                int c = 0;
                while (c < selr.length) {
                    int r = selr[c];
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.Mn.getFileHandler().downloadFile(lp);
                    }
                    ++c;
                }
            }
        });
        JMenuItem reply = new JMenuItem("Reply");
        mnu.add(reply);
        reply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.SearchPanel.getNewPostDialog().replyToPost(lp);
                    }
                }
            }
        });
        JMenuItem priv = new JMenuItem("Send Private Message");
        mnu.add(priv);
        priv.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        LocalNetwork ln = null;
                        DataBaseCoreImplH2 dataBaseCoreImplH2 = PostPanel.this.Mn.getCoreDB();
                        synchronized (dataBaseCoreImplH2) {
                            ln = PostPanel.this.Mn.getCoreDB().getLocalNetwork(lp.getPost().getNetworkId());
                        }
                        if (ln != null) {
                            PostPanel.this.MessageDialog.showDialog(lp.getPost().getSignedDigest().getPeerIdentifier(), lp.getCreator(), lp.getPost().getNetworkId(), ln.getNetwork().getTitleSig());
                        }
                    }
                }
            }
        });
        JMenuItem redownload = new JMenuItem("Reset Downloads");
        mnu.add(redownload);
        redownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = PostPanel.this.table.getSelectedRows();
                int c = 0;
                while (c < selr.length) {
                    FileStatus fs;
                    int r = selr[c];
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null && (fs = PostPanel.this.Mn.getCoreDB().getFileStatus(lp.getPost().getNetworkId(), lp.getPost().getFileReferenceDigest())) != null) {
                        PostPanel.this.Mn.getFileHandler().reDownloadFile(fs);
                    }
                    ++c;
                }
            }
        });
        JMenuItem sr = new JMenuItem("Search posts for file");
        mnu.add(sr);
        sr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null) {
                        PostPanel.this.SearchPanel.setPrimaryReference(lp);
                    }
                }
            }
        });
        if (t != null) {
            int c = 0;
            while (c < 3) {
                final int refnum = c;
                String rt = t.getRef(c);
                if (rt != null) {
                    JMenuItem srch = new JMenuItem("Search for " + rt);
                    mnu.add(srch);
                    srch.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                                int r = PostPanel.this.table.getSelectedRow();
                                r = PostPanel.this.table.convertRowIndexToModel(r);
                                LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                                if (lp != null) {
                                    PostPanel.this.SearchPanel.setReference(refnum, lp);
                                }
                            }
                        }
                    });
                    JMenuItem pst = new JMenuItem("New post is " + rt + " for selected");
                    mnu.add(pst);
                    pst.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                                int r = PostPanel.this.table.getSelectedRow();
                                r = PostPanel.this.table.convertRowIndexToModel(r);
                                LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                                if (lp != null) {
                                    PostPanel.this.SearchPanel.setPostReference(refnum, lp);
                                }
                            }
                        }
                    });
                }
                ++c;
            }
        }
        JMenuItem viewpeer = new JMenuItem("View peer info");
        mnu.add(viewpeer);
        viewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PostPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer peer;
                    int r = PostPanel.this.table.getSelectedRow();
                    r = PostPanel.this.table.convertRowIndexToModel(r);
                    LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                    if (lp != null && (peer = PostPanel.this.Mn.getCoreDB().getPeer(lp.getPost().getSignedDigest().getPeerIdentifier())) != null) {
                        PostPanel.this.PeerDialog.showPeer(peer);
                    }
                }
            }
        });
        JMenuItem rnk = new JMenuItem("Set Peer Group Rank");
        mnu.add(rnk);
        rnk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selr = PostPanel.this.table.getSelectedRows();
                if (selr.length > 0) {
                    Object[] options = new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
                    Object v = JOptionPane.showInputDialog(PostPanel.this.table, "Select new rank.\nHigher number means more trusted.\n", "Set Rank", 2, null, options, options[1]);
                    if (v != null) {
                        int c = 0;
                        while (c < selr.length) {
                            int r = selr[c];
                            r = PostPanel.this.table.convertRowIndexToModel(r);
                            LocalPost lp = PostPanel.this.PostTableModel.getPost(r);
                            if (lp != null) {
                                long vl = ((Integer)v).longValue();
                                PostPanel.this.Mn.getCoreUser().updatePeerNetworkRank(lp.getPost().getNetworkId(), lp.getPost().getSignedDigest().getPeerIdentifier(), vl);
                            }
                            ++c;
                        }
                    }
                }
            }
        });
        this.table.setComponentPopupMenu(mnu);
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network) {
        this.SearchPanel.setSelectedNetwork(network);
    }

    public NewPeerMessageDialog getMessageDialog() {
        return this.MessageDialog;
    }

    public void setMessageDialog(NewPeerMessageDialog messageDialog) {
        this.MessageDialog = messageDialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }

    public ProgramManager getManager() {
        return this.Manager;
    }

    public void setManager(ProgramManager manager) {
        this.Manager = manager;
    }
}

