/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.OpenedInterface;

public class PeerTableModel
extends AbstractTableModel
implements OpenedInterface {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Peers;
    private String[] ColumnNames = new String[]{"Nickname", "Introduction", "Rank", "Date Created", "Date Received"};

    public String getSortKey(int col) {
        if (col == 0) {
            return DataBaseLuceneIndexer.PEER_NICKNAME_STR;
        }
        if (col == 1) {
            return DataBaseLuceneIndexer.PEER_INTRO_STR;
        }
        if (col == 2) {
            return DataBaseLuceneIndexer.PEER_RANK;
        }
        if (col == 3) {
            return DataBaseLuceneIndexer.PEER_CDATE;
        }
        if (col == 4) {
            return DataBaseLuceneIndexer.PEER_DATE;
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        return this.ColumnNames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 2) {
            return Integer.class;
        }
        if (col == 3 || col == 4) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenerer(JTable t) {
        DateRenderer.insertDateIntoTable(t, 3, this);
        DateRenderer.insertDateIntoTable(t, 4, this);
    }

    @Override
    public int getColumnCount() {
        return this.ColumnNames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Peers != null) {
            return this.Peers.size();
        }
        return 0;
    }

    public synchronized LocalPeer getPeer(int r) {
        if (this.Peers != null && r < this.Peers.size()) {
            return (LocalPeer)this.Peers.get(r);
        }
        return null;
    }

    @Override
    public Object getValueAt(int r, int c) {
        LocalPeer lp = this.getPeer(r);
        if (lp != null) {
            if (c == 0) {
                return lp.getPeer().getNickSig();
            }
            if (c == 1) {
                return lp.getPeer().getIntroduction();
            }
            if (c == 2) {
                return lp.getRank();
            }
            if (c == 3) {
                return lp.getPeer().getRDate();
            }
            if (c == 4) {
                return lp.getLocalDate();
            }
        }
        return null;
    }

    public synchronized void setPeers(QueryResultsInterface p) {
        if (this.Peers != null) {
            this.Peers.Close();
        }
        this.Peers = p;
        this.fireTableDataChanged();
    }

    @Override
    public boolean isOpened(int row) {
        return true;
    }
}

