/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkTableModel;
import org.ourfilesystem.ui.NewNetworkDialog;

public class GroupPanel
extends JPanel
implements RowSorterListener {
    private static final long serialVersionUID = 1L;
    private JSplitPane splitPane;
    private JPanel panel_1;
    private JButton btnSearch_1;
    private JPanel panel_2;
    private JScrollPane scrollPane_2;
    private JTable table_2;
    private JLabel lblRank;
    private JTextField textGrpSearch;
    private JSpinner spinnerMinGroup;
    private NetworkTableModel TableModel;
    private String SortKeyWord;
    private boolean SortAsc;
    private JButton btnNewGroup;
    private NewNetworkDialog Dialog;
    private Main Mn;

    public GroupPanel(Main mn) {
        this.Mn = mn;
        this.setLayout(new BorderLayout(0, 0));
        this.Dialog = new NewNetworkDialog(this.Mn);
        this.splitPane = new JSplitPane();
        this.splitPane.setPreferredSize(new Dimension(100, 2));
        this.splitPane.setOrientation(0);
        this.add(this.splitPane);
        this.panel_1 = new JPanel();
        this.splitPane.setLeftComponent(this.panel_1);
        this.panel_1.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][]"));
        this.textGrpSearch = new JTextField();
        this.panel_1.add((Component)this.textGrpSearch, "flowx,cell 0 0,growx");
        this.textGrpSearch.setColumns(10);
        this.lblRank = new JLabel("Min Rank");
        this.panel_1.add((Component)this.lblRank, "flowx,cell 0 1");
        SpinnerNumberModel model = new SpinnerNumberModel(5, 0, 999, 1);
        this.spinnerMinGroup = new JSpinner(model);
        this.panel_1.add((Component)this.spinnerMinGroup, "cell 0 1");
        this.btnSearch_1 = new JButton();
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("resources/search.png"));
            this.btnSearch_1.setIcon(new ImageIcon(img));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.btnSearch_1.setBorder(null);
        this.panel_1.add((Component)this.btnSearch_1, "cell 0 1");
        this.btnSearch_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupPanel.this.doSearch();
            }
        });
        this.btnNewGroup = new JButton("New Group");
        this.panel_1.add((Component)this.btnNewGroup, "flowx,cell 0 2");
        this.btnNewGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GroupPanel.this.Dialog.showDialog();
            }
        });
        this.panel_2 = new JPanel();
        this.splitPane.setRightComponent(this.panel_2);
        this.panel_2.setLayout(new BorderLayout(0, 0));
        this.panel_2.setPreferredSize(new Dimension(100, 2));
        this.scrollPane_2 = new JScrollPane();
        this.scrollPane_2.setPreferredSize(new Dimension(100, 2));
        this.panel_2.add((Component)this.scrollPane_2, "Center");
        this.TableModel = new NetworkTableModel();
        this.TableModel.setSimpleMode(true);
        this.table_2 = new JTable(this.TableModel);
        this.table_2.setSelectionMode(0);
        this.table_2.setShowGrid(false);
        this.table_2.setIntercellSpacing(new Dimension(0, 0));
        this.table_2.setFillsViewportHeight(true);
        this.table_2.setColumnSelectionAllowed(false);
        this.table_2.setAutoCreateRowSorter(true);
        this.table_2.getRowSorter().addRowSorterListener(this);
        this.scrollPane_2.setViewportView(this.table_2);
        this.table_2.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!GroupPanel.this.table_2.getSelectionModel().isSelectionEmpty()) {
                    int r = GroupPanel.this.table_2.getSelectedRow();
                    r = GroupPanel.this.table_2.convertRowIndexToModel(r);
                    LocalNetwork ln = GroupPanel.this.TableModel.getNetwork(r);
                    if (ln != null) {
                        GroupPanel.this.Mn.getGui().setNewNetwork(ln);
                    }
                }
            }
        });
        this.doSearch();
    }

    public void doSearch() {
        int max = Integer.MAX_VALUE;
        String s = this.textGrpSearch.getText();
        int r = (Integer)this.spinnerMinGroup.getValue();
        boolean subscribed = true;
        boolean notsubscribed = false;
        boolean ispub = true;
        boolean ispriv = true;
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchNetworks(s, this.SortKeyWord, subscribed, notsubscribed, ispub, ispriv, max, !this.SortAsc, r);
        this.TableModel.setNetworks(qr);
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        List<RowSorter.SortKey> sl = ((RowSorter)e.getSource()).getSortKeys();
        if (sl.size() > 0) {
            RowSorter.SortKey sk = sl.get(0);
            this.SortKeyWord = this.TableModel.getSortKey(sk.getColumn());
            this.SortAsc = sk.getSortOrder().equals((Object)SortOrder.ASCENDING);
        }
    }
}

