/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.SubscriptionQueryResultsList;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalSubscribe;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkAuthTableModel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NetworkTableModel;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.SubscriptionTableModel;
import org.ourfilesystem.ui.ViewPeerDialog;
import org.ourfilesystem.utilities.BBytes;

public class AuthorizationPanel
extends JPanel
implements NetworkSelectInterface,
RowSorterListener {
    private static final long serialVersionUID = 1L;
    private NetworkTableModel MyNetModel;
    private NetworkAuthTableModel OtherAuths;
    private SubscriptionTableModel SubModel;
    private ViewPeerDialog PeerDialog;
    private Main Mn;
    private JTable table;
    private JTable table_1;
    private JTable subtable;
    private LocalNetwork CurNetwork;
    private JLabel lblNetwork;
    private JTextField textField;
    private NewPeerMessageDialog MessageDialog;
    private JSpinner spinner;
    private String SortKeyWord;
    private boolean SortAsc;

    public AuthorizationPanel(Main m) {
        this.Mn = m;
        this.MyNetModel = new NetworkTableModel();
        this.OtherAuths = new NetworkAuthTableModel(this.Mn.getCoreDB());
        this.SubModel = new SubscriptionTableModel();
        this.MyNetModel.setSimpleMode(true);
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel();
        splitPane.setRightComponent(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane_1 = new JSplitPane();
        panel.add((Component)splitPane_1, "Center");
        JScrollPane scrollPane = new JScrollPane();
        splitPane_1.setLeftComponent(scrollPane);
        this.table = new JTable(this.MyNetModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(0);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.getRowSorter().addRowSorterListener(this);
        scrollPane.setViewportView(this.table);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!AuthorizationPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = AuthorizationPanel.this.table.getSelectedRow();
                    r = AuthorizationPanel.this.table.convertRowIndexToModel(r);
                    AuthorizationPanel.this.CurNetwork = AuthorizationPanel.this.MyNetModel.getNetwork(r);
                    if (AuthorizationPanel.this.CurNetwork != null) {
                        AuthorizationPanel.this.Mn.getGui().setNewNetwork(AuthorizationPanel.this.CurNetwork);
                    }
                }
            }
        });
        JSplitPane splitPaneAuthSub = new JSplitPane();
        splitPaneAuthSub.setOrientation(0);
        splitPane_1.setRightComponent(splitPaneAuthSub);
        splitPane_1.setDividerLocation(200);
        JScrollPane scrollPaneSubs = new JScrollPane();
        splitPaneAuthSub.setRightComponent(scrollPaneSubs);
        splitPaneAuthSub.setDividerLocation(100);
        this.subtable = new JTable(this.SubModel);
        this.SubModel.insertDateRenderer(this.subtable);
        this.subtable.setAutoCreateRowSorter(true);
        this.subtable.setSelectionMode(2);
        this.subtable.setShowGrid(false);
        this.subtable.setIntercellSpacing(new Dimension(0, 0));
        this.subtable.setFillsViewportHeight(true);
        scrollPaneSubs.setViewportView(this.subtable);
        JPopupMenu submnu = new JPopupMenu();
        JMenuItem subsendmessage = new JMenuItem("Send private message");
        submnu.add(subsendmessage);
        subsendmessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!AuthorizationPanel.this.subtable.getSelectionModel().isSelectionEmpty()) {
                    int r = AuthorizationPanel.this.subtable.getSelectedRow();
                    r = AuthorizationPanel.this.subtable.convertRowIndexToModel(r);
                    LocalSubscribe ls = AuthorizationPanel.this.SubModel.getSubscription(r);
                    if (ls != null) {
                        AuthorizationPanel.this.MessageDialog.showDialog(ls.getSubscription().getSignature().getPeerIdentifier(), ls.getCreator(), ls.getSubscription().getNetworkID(), ls.getNetworkName());
                    }
                }
            }
        });
        JMenuItem subviewpeer = new JMenuItem("View peer info");
        submnu.add(subviewpeer);
        subviewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!AuthorizationPanel.this.subtable.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer peer;
                    int r = AuthorizationPanel.this.subtable.getSelectedRow();
                    r = AuthorizationPanel.this.subtable.convertRowIndexToModel(r);
                    LocalSubscribe ls = AuthorizationPanel.this.SubModel.getSubscription(r);
                    if (ls != null && (peer = AuthorizationPanel.this.Mn.getCoreDB().getPeer(ls.getSubscription().getSignature().getPeerIdentifier())) != null) {
                        AuthorizationPanel.this.PeerDialog.showPeer(peer);
                    }
                }
            }
        });
        JMenuItem rank = new JMenuItem("Set Peer Group Rank");
        submnu.add(rank);
        rank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = AuthorizationPanel.this.subtable.getSelectedRows();
                if (selr.length > 0) {
                    Object[] options = new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
                    Object v = JOptionPane.showInputDialog(AuthorizationPanel.this.subtable, "Select new rank.\nHigher number means more trusted.\n", "Set Rank", 2, null, options, options[1]);
                    if (v != null) {
                        int c = 0;
                        while (c < selr.length) {
                            int r = selr[c];
                            r = AuthorizationPanel.this.subtable.convertRowIndexToModel(r);
                            LocalSubscribe ls = AuthorizationPanel.this.SubModel.getSubscription(r);
                            if (ls != null) {
                                long vl = ((Integer)v).longValue();
                                AuthorizationPanel.this.Mn.getCoreUser().updatePeerNetworkRank(ls.getSubscription().getNetworkID(), ls.getSubscription().getSignature().getPeerIdentifier(), vl);
                            }
                            ++c;
                        }
                        AuthorizationPanel.this.delayUpdate();
                    }
                }
            }
        });
        JMenuItem markbad = new JMenuItem("Mark peer as bad");
        submnu.add(markbad);
        markbad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int v;
                int[] selr = AuthorizationPanel.this.subtable.getSelectedRows();
                if (selr.length > 0 && (v = JOptionPane.showConfirmDialog(AuthorizationPanel.this.subtable, "Are you sure you want to set the selected peers as bad?\nAll peers granted access by these peers will\nalso be marked bad and all their posts will be\ndeleted!  Consider using peer rank instead if\nyou are not sure.", "Mark Bad", 0, 2)) == 0) {
                    int c = 0;
                    while (c < selr.length) {
                        int r = selr[c];
                        r = AuthorizationPanel.this.subtable.convertRowIndexToModel(r);
                        LocalSubscribe ls = AuthorizationPanel.this.SubModel.getSubscription(r);
                        if (ls != null) {
                            AuthorizationPanel.this.Mn.getCoreUser().setBadPeer(ls.getSubscription().getNetworkID(), ls.getSubscription().getSignature().getPeerIdentifier());
                        }
                        ++c;
                    }
                    AuthorizationPanel.this.delayUpdate();
                }
            }
        });
        JMenuItem markgood = new JMenuItem("Mark peer as good");
        submnu.add(markgood);
        markgood.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = AuthorizationPanel.this.subtable.getSelectedRows();
                if (selr.length > 0) {
                    int c = 0;
                    while (c < selr.length) {
                        int r = selr[c];
                        r = AuthorizationPanel.this.subtable.convertRowIndexToModel(r);
                        LocalSubscribe ls = AuthorizationPanel.this.SubModel.getSubscription(r);
                        if (ls != null) {
                            AuthorizationPanel.this.Mn.getCoreUser().unsetBadPeer(ls.getSubscription().getNetworkID(), ls.getSubscription().getSignature().getPeerIdentifier());
                        }
                        ++c;
                    }
                    AuthorizationPanel.this.delayUpdate();
                }
            }
        });
        this.subtable.setComponentPopupMenu(submnu);
        JScrollPane scrollPane_1 = new JScrollPane();
        splitPaneAuthSub.setLeftComponent(scrollPane_1);
        this.table_1 = new JTable(this.OtherAuths);
        this.OtherAuths.insertDateRenderer(this.table_1);
        this.table_1.setAutoCreateRowSorter(true);
        this.table_1.setSelectionMode(2);
        this.table_1.setShowGrid(false);
        this.table_1.setIntercellSpacing(new Dimension(0, 0));
        this.table_1.setFillsViewportHeight(true);
        scrollPane_1.setViewportView(this.table_1);
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem sendmessage = new JMenuItem("Send private message");
        mnu.add(sendmessage);
        sendmessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!AuthorizationPanel.this.table_1.getSelectionModel().isSelectionEmpty()) {
                    int r = AuthorizationPanel.this.table_1.getSelectedRow();
                    r = AuthorizationPanel.this.table_1.convertRowIndexToModel(r);
                    LocalNetworkAuthorization a = AuthorizationPanel.this.OtherAuths.getNetworkAuth(r);
                    if (a != null) {
                        AuthorizationPanel.this.MessageDialog.showDialog(a.getNetworkAuthorization().getPeerId(), a.getPeerNickSig(), a.getNetworkAuthorization().getNetworkId(), a.getNetworkTitle());
                    }
                }
            }
        });
        JMenuItem viewpeer = new JMenuItem("View peer info");
        mnu.add(viewpeer);
        viewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!AuthorizationPanel.this.table_1.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer peer;
                    int r = AuthorizationPanel.this.table_1.getSelectedRow();
                    r = AuthorizationPanel.this.table_1.convertRowIndexToModel(r);
                    LocalNetworkAuthorization a = AuthorizationPanel.this.OtherAuths.getNetworkAuth(r);
                    if (a != null && (peer = AuthorizationPanel.this.Mn.getCoreDB().getPeer(a.getNetworkAuthorization().getSignature().getPeerIdentifier())) != null) {
                        AuthorizationPanel.this.PeerDialog.showPeer(peer);
                    }
                }
            }
        });
        this.table_1.setComponentPopupMenu(mnu);
        JPanel panel_1 = new JPanel();
        splitPane.setLeftComponent(panel_1);
        panel_1.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JLabel lblSelectedGroup = new JLabel("Selected group:");
        panel_1.add((Component)lblSelectedGroup, "cell 0 0");
        JLabel lblSearch = new JLabel("Search");
        panel_1.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel_1.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JLabel lblMinPeerRank = new JLabel("Min peer rank");
        panel_1.add((Component)lblMinPeerRank, "cell 1 1");
        SpinnerNumberModel model = new SpinnerNumberModel(5, 0, 999, 1);
        this.spinner = new JSpinner(model);
        panel_1.add((Component)this.spinner, "cell 1 1");
        JButton btnSearch = new JButton("Search");
        panel_1.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AuthorizationPanel.this.doSearch();
            }
        });
        this.lblNetwork = new JLabel("none");
        panel_1.add((Component)this.lblNetwork, "flowx,cell 1 0,growx");
        JButton btnRefreshLists = new JButton("Update Auths");
        panel_1.add((Component)btnRefreshLists, "cell 1 0");
        btnRefreshLists.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AuthorizationPanel.this.Mn.getUpdater().updateNetworkAuthsNow();
            }
        });
        JButton btnUpdateSubscriptions = new JButton("Update Subscriptions");
        panel_1.add((Component)btnUpdateSubscriptions, "cell 1 0");
        btnUpdateSubscriptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AuthorizationPanel.this.Mn.getUpdater().updateSubscriptionsNow();
            }
        });
        this.doSearch();
    }

    private void delayUpdate() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(DataBaseLuceneIndexer.COMMITDELAY);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AuthorizationPanel.this.doSearch();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    public void doSearch() {
        int max = Integer.MAX_VALUE;
        String s = this.textField.getText();
        int r = (Integer)this.spinner.getValue();
        boolean subscribed = true;
        boolean notsubscribed = false;
        boolean ispub = true;
        boolean ispriv = true;
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchNetworks(s, this.SortKeyWord, subscribed, notsubscribed, ispub, ispriv, max, !this.SortAsc, r);
        this.MyNetModel.setNetworks(qr);
        if (this.CurNetwork != null) {
            BBytes netid = this.CurNetwork.getNetwork().getSignature().getDigest();
            qr = this.Mn.getCoreDB().getDBQuery().queryNetworkAuths(netid);
            this.OtherAuths.setNetworkAuths(qr);
            List<LocalSubscribe> sublist = this.Mn.getCoreDB().getAllNetworkSubscriptions(netid);
            this.SubModel.setSubscriptions(new SubscriptionQueryResultsList(sublist));
        }
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network) {
        this.CurNetwork = network;
        if (this.CurNetwork != null) {
            this.lblNetwork.setText(this.CurNetwork.getNetwork().getTitleSig());
        }
        this.doSearch();
    }

    public NewPeerMessageDialog getMessageDialog() {
        return this.MessageDialog;
    }

    public void setMessageDialog(NewPeerMessageDialog messageDialog) {
        this.MessageDialog = messageDialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        List<RowSorter.SortKey> sl = ((RowSorter)e.getSource()).getSortKeys();
        if (sl.size() > 0) {
            RowSorter.SortKey sk = sl.get(0);
            this.SortKeyWord = this.MyNetModel.getSortKey(sk.getColumn());
            this.SortAsc = sk.getSortOrder().equals((Object)SortOrder.ASCENDING);
        }
    }
}

