/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseCoreImplHSQLDB;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalNetworkAuthorizationV0;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.LocalSubscribe;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.NetworkAuthHoles;
import org.ourfilesystem.db.so.NetworkHoles;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.PostHoles;
import org.ourfilesystem.db.so.PublicPostHoles;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.db.so.Subscribe;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.utilities.BBytes;

public class UpgradeTo08DB {
    public static void doUpgrade(String basedir) throws Exception {
        Object nid;
        File f = new File(String.valueOf(basedir) + File.separator + "h2.h2.db");
        if (f.exists()) {
            f.delete();
        }
        DataBaseCoreImplHSQLDB db = new DataBaseCoreImplHSQLDB(basedir, true);
        DataBaseCoreImplH2 dbh2 = new DataBaseCoreImplH2(basedir);
        System.out.println("Porting your peer data.");
        MyPeerDataSO mpd = db.getMyPeerData();
        dbh2.saveMyPeerData(mpd);
        BBytes myid = mpd.getPeer().getPeer().getIdentity();
        List<LocalNetworkAuthorizationV0> alst = db.getNetworkAuthsForPeer(myid);
        for (LocalNetworkAuthorizationV0 a : alst) {
            LocalNetworkAuthorization nna = new LocalNetworkAuthorization();
            nna.setLastNetworkAuthNumber(a.getLastNetworkAuthNumber());
            nna.setLastNewAuths(a.getLastNewAuths());
            nna.setLocalDate(a.getLocalDate());
            nna.setNetworkTitle(a.getNetworkTitle());
            nna.setNumberOfNewAuths(a.getNumberOfNewAuths());
            nna.setPeerNickSig(a.getPeerNickSig());
            nna.setPushRequested(a.isPushRequested());
            nna.setReceivedFromPeer(a.getReceivedFromPeer());
            nna.setRequestAuths(a.isRequestAuths());
            nna.setRequestAuthsDispatched(a.isRequestAuthsDispatched());
            nna.setRequestAuthsDispatchedTime(a.getRequestAuthsDispatchedTime());
            nna.setRequestAuthsPriority(a.getRequestAuthsPriority());
            nna.setRequestAuthsTime(a.getRequestAuthsTime());
            nna.setSignerNickSig(a.getSignerNickSig());
            nna.setNetworkAuthorization(a.getNetworkAuthorization());
            dbh2.saveLocalNetworkAuth(nna);
            LocalSubscribe ls = new LocalSubscribe();
            ls.setCreator(nna.getPeerNickSig());
            ls.setLastNewFile(a.getLastNewFile());
            ls.setLastNewPost(a.getLastNewPost());
            ls.setLastPostNumber(a.getLastPostNumber());
            ls.setLocalDate(a.getLocalDate());
            ls.setMarkedBad(a.isMarkedBad());
            ls.setMarkedBadDate(a.getMarkedBadDate());
            ls.setNetworkName(a.getNetworkTitle());
            ls.setNumberOfFiles(a.getNumberOfFiles());
            ls.setNumberOfNewPosts(a.getNumberOfNewPosts());
            ls.setNumberOfNewSubs(0L);
            ls.setPeerRank(a.getPeerRank());
            ls.setPushRequested(false);
            ls.setRequestPosts(a.isRequestPosts());
            ls.setRequestPostsDispatched(a.isRequestAuthsDispatched());
            ls.setRequestPostsDispatchedTime(a.getRequestPostsDispatchedTime());
            ls.setRequestPostsPriority(a.getRequestPostsPriority());
            ls.setRequestPostsTime(a.getRequestPostsTime());
            ls.setRequestSubs(false);
            ls.setRequestSubsDispatched(false);
            ls.setRequestSubsPriority(0L);
            Subscribe s = new Subscribe();
            ls.setSubscription(s);
            s.setNetworkID(a.getNetworkAuthorization().getNetworkId());
            s.setSubNumber(0L);
            s.setSubscribe(true);
            SignedDigest sg = new SignedDigest();
            sg.setPeerIdentifier(a.getNetworkAuthorization().getPeerId());
            s.setSignature(sg);
            dbh2.saveLocalSubscription(ls);
        }
        List<FileStatus> flst = db.getFileStatusList();
        System.out.println("Porting " + flst.size() + " file status data.");
        for (FileStatus fs : flst) {
            System.out.print(".");
            dbh2.saveFileStatus(fs);
        }
        System.out.println();
        List<LocalPeer> lplst = db.getLocalPeers();
        System.out.println("Porting " + lplst.size() + " peer data.");
        for (LocalPeer lp : lplst) {
            System.out.print(".");
            dbh2.saveLocalPeer(lp);
            BBytes pid = lp.getPeer().getIdentity();
            List<PublicPostHoles> pphlst = db.getPublicPostHoles(pid);
            for (PublicPostHoles pph : pphlst) {
                dbh2.savePublicPostHoles(pph);
            }
            List<NetworkHoles> nhlst = db.getPeerNetworkHoles(pid);
            Iterator<Object> iterator = nhlst.iterator();
            while (iterator.hasNext()) {
                NetworkHoles nh = (NetworkHoles)iterator.next();
                dbh2.saveNetworkHoles(nh);
            }
            alst = db.getNetworkAuthsForPeer(pid);
            for (LocalNetworkAuthorizationV0 a : alst) {
                nid = a.getNetworkAuthorization().getNetworkId();
                LocalNetworkAuthorization nna = new LocalNetworkAuthorization();
                nna.setLastNetworkAuthNumber(a.getLastNetworkAuthNumber());
                nna.setLastNewAuths(a.getLastNewAuths());
                nna.setLocalDate(a.getLocalDate());
                nna.setNetworkTitle(a.getNetworkTitle());
                nna.setNumberOfNewAuths(a.getNumberOfNewAuths());
                nna.setPeerNickSig(a.getPeerNickSig());
                nna.setPushRequested(a.isPushRequested());
                nna.setReceivedFromPeer(a.getReceivedFromPeer());
                nna.setRequestAuths(a.isRequestAuths());
                nna.setRequestAuthsDispatched(a.isRequestAuthsDispatched());
                nna.setRequestAuthsDispatchedTime(a.getRequestAuthsDispatchedTime());
                nna.setRequestAuthsPriority(a.getRequestAuthsPriority());
                nna.setRequestAuthsTime(a.getRequestAuthsTime());
                nna.setSignerNickSig(a.getSignerNickSig());
                nna.setNetworkAuthorization(a.getNetworkAuthorization());
                dbh2.saveLocalNetworkAuth(nna);
                LocalSubscribe ls = new LocalSubscribe();
                ls.setCreator(nna.getPeerNickSig());
                ls.setLastNewFile(a.getLastNewFile());
                ls.setLastNewPost(a.getLastNewPost());
                ls.setLastPostNumber(a.getLastPostNumber());
                ls.setLocalDate(a.getLocalDate());
                ls.setMarkedBad(a.isMarkedBad());
                ls.setMarkedBadDate(a.getMarkedBadDate());
                ls.setNetworkName(a.getNetworkTitle());
                ls.setNumberOfFiles(a.getNumberOfFiles());
                ls.setNumberOfNewPosts(a.getNumberOfNewPosts());
                ls.setNumberOfNewSubs(0L);
                ls.setPeerRank(a.getPeerRank());
                ls.setPushRequested(false);
                ls.setRequestPosts(a.isRequestPosts());
                ls.setRequestPostsDispatched(a.isRequestAuthsDispatched());
                ls.setRequestPostsDispatchedTime(a.getRequestPostsDispatchedTime());
                ls.setRequestPostsPriority(a.getRequestPostsPriority());
                ls.setRequestPostsTime(a.getRequestPostsTime());
                ls.setRequestSubs(false);
                ls.setRequestSubsDispatched(false);
                ls.setRequestSubsPriority(0L);
                Subscribe s = new Subscribe();
                ls.setSubscription(s);
                s.setNetworkID(a.getNetworkAuthorization().getNetworkId());
                s.setSubNumber(0L);
                s.setSubscribe(true);
                SignedDigest sg = new SignedDigest();
                sg.setPeerIdentifier(a.getNetworkAuthorization().getPeerId());
                s.setSignature(sg);
                dbh2.saveLocalSubscription(ls);
                List<PostHoles> phlist = db.getPostHoles((BBytes)nid, pid);
                for (PostHoles ph : phlist) {
                    dbh2.savePostHoles(ph);
                }
                List<NetworkAuthHoles> nahlst = db.getPeerNetworkAuthHoles((BBytes)nid, pid);
                for (NetworkAuthHoles nh : nahlst) {
                    dbh2.saveNetworkAuthHoles(nh);
                }
            }
        }
        System.out.println();
        List<BBytes> frlst = db.getAllFileReferences();
        System.out.println("Porting " + frlst.size() + " file references.");
        int steps = frlst.size() / 200;
        int cnt = 0;
        for (BBytes digid : frlst) {
            if (++cnt > steps) {
                System.out.print(".");
                cnt = 0;
            }
            List<FileReference> rlst = db.getFilesRequested(digid);
            nid = rlst.iterator();
            while (nid.hasNext()) {
                FileReference r = nid.next();
                dbh2.saveFileReference(r);
                List<PeerHasFile> phflst = db.getPeersHaveFile(r.getNetworkId(), r.getUnsignedDigest());
                for (PeerHasFile phf : phflst) {
                    dbh2.savePeerHasFile(phf);
                }
            }
        }
        System.out.println();
        List<BBytes> netlist = db.getAllNetworksForUpgrade();
        System.out.println("Porting " + netlist.size() + " group data.");
        for (BBytes nid2 : netlist) {
            System.out.print(".");
            LocalNetwork ln = db.getLocalNetwork(nid2);
            if (ln == null) continue;
            if (ln.isAuthorized()) {
                ln.setSubscribed(true);
            }
            dbh2.saveLocalNetwork(ln);
            List<SearchQuery> sqlst = db.getSearchQuerys(nid2);
            for (SearchQuery sq : sqlst) {
                dbh2.saveSearchQuery(sq);
            }
        }
        System.out.println();
        List<BBytes> pstlist = db.getAllPostsForUpgrade();
        System.out.println("Porting " + pstlist.size() + " post data.");
        steps = pstlist.size() / 200;
        cnt = 0;
        for (BBytes pid : pstlist) {
            LocalPost lp;
            if (++cnt > steps) {
                System.out.print(".");
                cnt = 0;
            }
            if ((lp = db.getPost(pid)) == null) continue;
            dbh2.saveLocalPost(lp);
        }
        System.out.println();
        List<BBytes> pplist = db.getAllPublicPostsForUpgrade();
        System.out.println("Porting " + pplist.size() + " public posts.");
        steps = pplist.size() / 200;
        cnt = 0;
        for (BBytes ppid : pplist) {
            LocalPublicPost lpp;
            if (++cnt > steps) {
                System.out.print(".");
                cnt = 0;
            }
            if ((lpp = db.getLocalPublicPost(ppid)) == null) continue;
            dbh2.saveLocalPublicPost(lpp);
        }
        System.out.println();
        dbh2.Close();
        db.Close();
    }

    public static void doPostStartUpdate(Main Mn) {
        BBytes myid = Mn.getCoreDB().getMyPeerData().getPeer().getPeer().getIdentity();
        List<LocalNetworkAuthorization> llst = Mn.getCoreDB().getPeerNetworkAuths(myid);
        for (LocalNetworkAuthorization a : llst) {
            Mn.getCoreUser().subscribe(a.getNetworkAuthorization().getNetworkId());
        }
    }
}

