/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.TopDocsCacheQueryResultsAbstract;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.filehandler.FileHandler;
import org.ourfilesystem.utilities.BBytes;

public class PostQueryResultsH2
extends TopDocsCacheQueryResultsAbstract {
    private DataBaseCoreImplH2 DB;

    public PostQueryResultsH2(TopDocs t, IndexSearcher s, DirectoryReader reader, DataBaseCoreImplH2 db) {
        super(t, s, reader);
        if (db == null) {
            Thread.dumpStack();
        }
        this.DB = db;
    }

    @Override
    public Object getHits(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                StoredField lf = (StoredField)d.getField(DataBaseLuceneIndexer.POST_ID_STR);
                if (lf != null) {
                    BBytes lfb = new BBytes(lf.binaryValue().bytes);
                    LocalPost lp = this.DB.getPost(lfb);
                    IndexableField ilf = d.getField(DataBaseLuceneIndexer.POST_OPENED);
                    if (ilf != null) {
                        lp.setOpened(ilf.stringValue().equals("1"));
                    }
                    return lp;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> getMapStatic(Document d) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            IndexableField lf = d.getField(DataBaseLuceneIndexer.DOC_TYPE);
            if (lf != null) {
                Number n;
                String type = lf.stringValue();
                lf = d.getField(DataBaseLuceneIndexer.POST_PEERNICK_STR);
                if (lf != null) {
                    data.put(DataBaseLuceneIndexer.POST_PEERNICK_STR, lf.stringValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.POST_PEERRANK)) != null) {
                    n = lf.numericValue();
                    data.put(DataBaseLuceneIndexer.POST_PEERRANK, n.longValue());
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.POST_DATE)) != null) {
                    n = lf.numericValue();
                    data.put(DataBaseLuceneIndexer.POST_DATE, new Date(n.longValue()));
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.POST_CDATE)) != null) {
                    n = lf.numericValue();
                    data.put(DataBaseLuceneIndexer.POST_CDATE, new Date(n.longValue()));
                }
                if (type.equals(DataBaseLuceneIndexer.POST_TYPE)) {
                    lf = d.getField(DataBaseLuceneIndexer.POST_FILENAME_STR);
                    if (lf != null) {
                        data.put(DataBaseLuceneIndexer.POST_FILENAME_STR, lf.stringValue());
                    }
                    if ((lf = d.getField(DataBaseLuceneIndexer.POST_SUBJECT_STR)) != null) {
                        data.put(DataBaseLuceneIndexer.POST_SUBJECT_STR, lf.stringValue());
                    }
                    if ((lf = d.getField(DataBaseLuceneIndexer.POST_FILE_SIZE)) != null) {
                        n = lf.numericValue();
                        data.put(DataBaseLuceneIndexer.POST_FILE_SIZE, n.longValue());
                    }
                    if ((lf = d.getField(DataBaseLuceneIndexer.POST_LOCAL_FILENAME_STR)) != null) {
                        data.put(DataBaseLuceneIndexer.POST_LOCAL_FILENAME_STR, lf.stringValue());
                    }
                }
                if (type.equals(DataBaseLuceneIndexer.TEMPLATE_TYPE)) {
                    lf = d.getField(DataBaseLuceneIndexer.POST_TEMPLATE_NAME);
                    if (lf != null) {
                        data.put(DataBaseLuceneIndexer.POST_TEMPLATE_NAME, lf.stringValue());
                    }
                    if ((lf = d.getField(DataBaseLuceneIndexer.POST_TEMPLATE_DESC)) != null) {
                        data.put(DataBaseLuceneIndexer.POST_TEMPLATE_DESC, lf.stringValue());
                    }
                }
                if ((lf = d.getField(DataBaseLuceneIndexer.POST_OPENED)) != null) {
                    data.put(DataBaseLuceneIndexer.POST_OPENED, lf.stringValue().equals("1"));
                } else {
                    data.put(DataBaseLuceneIndexer.POST_OPENED, false);
                }
            }
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getMap(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                return PostQueryResultsH2.getMapStatic(d);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> obj2FieldsStatic(Object o) {
        if (o != null && o instanceof LocalPost) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            LocalPost lp = (LocalPost)o;
            Post p = lp.getPost();
            if (p != null) {
                data.put(DataBaseLuceneIndexer.POST_PEERNICK_STR, lp.getCreator());
                data.put(DataBaseLuceneIndexer.POST_PEERRANK, lp.getPeerRank());
                data.put(DataBaseLuceneIndexer.POST_DATE, lp.getLocalDate());
                data.put(DataBaseLuceneIndexer.POST_CDATE, p.getRDate());
                if (lp.getLocalFile() != null) {
                    data.put(DataBaseLuceneIndexer.POST_LOCAL_FILENAME_STR, lp.getLocalFile().toString());
                }
                if (p.getMessage() instanceof PostMessage) {
                    PostMessage pm = (PostMessage)p.getMessage();
                    data.put(DataBaseLuceneIndexer.POST_FILENAME_STR, pm.getFileName());
                    data.put(DataBaseLuceneIndexer.POST_SUBJECT_STR, pm.getSubject());
                    if (FileHandler.MASTER_VALUE.equals(pm.getString0())) {
                        data.put(DataBaseLuceneIndexer.POST_FILE_SIZE, pm.getNum1());
                    }
                }
                if (p.getMessage() instanceof PostTemplate) {
                    PostTemplate pt = (PostTemplate)p.getMessage();
                    data.put(DataBaseLuceneIndexer.POST_TEMPLATE_NAME, pt.getTemplateName());
                    data.put(DataBaseLuceneIndexer.POST_TEMPLATE_DESC, pt.getTemplateDescription());
                }
                data.put(DataBaseLuceneIndexer.POST_OPENED, lp.isOpened());
            }
            return data;
        }
        return null;
    }

    @Override
    public Map<String, Object> obj2Fields(Object o) {
        return PostQueryResultsH2.obj2FieldsStatic(o);
    }
}

