/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.ourfilesystem.db.DataBaseCoreImplH2;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.TopDocsCacheQueryResultsAbstract;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.utilities.BBytes;

public class PeerQueryResultsH2
extends TopDocsCacheQueryResultsAbstract {
    private DataBaseCoreImplH2 DB;

    public PeerQueryResultsH2(TopDocs t, IndexSearcher s, DirectoryReader reader, DataBaseCoreImplH2 db) {
        super(t, s, reader);
        this.DB = db;
    }

    @Override
    public Object getHits(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                StoredField lf = (StoredField)d.getField(DataBaseLuceneIndexer.PEER_ID_STR);
                if (lf != null) {
                    BBytes lfb = new BBytes(lf.binaryValue().bytes);
                    return this.DB.getPeer(lfb);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> getMapStatic(Document d) {
        try {
            Number n;
            HashMap<String, Object> data = new HashMap<String, Object>();
            IndexableField lf = d.getField(DataBaseLuceneIndexer.PEER_NICKNAME_STR);
            if (lf != null) {
                data.put(DataBaseLuceneIndexer.PEER_NICKNAME_STR, lf.stringValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.PEER_INTRO_STR)) != null) {
                data.put(DataBaseLuceneIndexer.PEER_INTRO_STR, lf.stringValue());
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.PEER_CDATE)) != null) {
                n = lf.numericValue();
                data.put(DataBaseLuceneIndexer.PEER_CDATE, new Date(n.longValue()));
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.PEER_DATE)) != null) {
                n = lf.numericValue();
                data.put(DataBaseLuceneIndexer.PEER_DATE, new Date(n.longValue()));
            }
            if ((lf = d.getField(DataBaseLuceneIndexer.PEER_RANK)) != null) {
                data.put(DataBaseLuceneIndexer.PEER_RANK, lf.numericValue().longValue());
            }
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getMap(int i) {
        if (i >= 0 && i < this.getCurDocs().scoreDocs.length) {
            ScoreDoc sd = this.getCurDocs().scoreDocs[i];
            try {
                Document d = this.getSearcher().doc(sd.doc);
                return PeerQueryResultsH2.getMapStatic(d);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> obj2FieldsStatic(Object obj) {
        if (obj != null && obj instanceof LocalPeer) {
            LocalPeer lp = (LocalPeer)obj;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(DataBaseLuceneIndexer.PEER_NICKNAME_STR, lp.getPeer().getNickSig());
            data.put(DataBaseLuceneIndexer.PEER_INTRO_STR, lp.getPeer().getIntroduction());
            data.put(DataBaseLuceneIndexer.PEER_CDATE, lp.getPeer().getRDate());
            data.put(DataBaseLuceneIndexer.PEER_DATE, lp.getLocalDate());
            data.put(DataBaseLuceneIndexer.PEER_RANK, lp.getRank());
            return data;
        }
        return null;
    }

    @Override
    public Map<String, Object> obj2Fields(Object obj) {
        return PeerQueryResultsH2.obj2FieldsStatic(obj);
    }
}

