/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.util.Version;

public class OFSAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public OFSAnalyzer(Version matchVersion, CharArraySet stopWords) {
        super(matchVersion, stopWords);
    }

    public OFSAnalyzer(Version matchVersion) {
        this(matchVersion, STOP_WORDS_SET);
    }

    public OFSAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, OFSAnalyzer.loadStopwordSet((Reader)stopwords, (Version)matchVersion));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        WhitespaceTokenizer src = new WhitespaceTokenizer(this.matchVersion, reader);
        WordDelimiterFilter wtok = new WordDelimiterFilter((TokenStream)src, 255, null);
        StandardFilter tok = new StandardFilter(this.matchVersion, (TokenStream)wtok);
        tok = new LowerCaseFilter(this.matchVersion, (TokenStream)tok);
        tok = new StopFilter(this.matchVersion, (TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
    }
}

