/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.ourfilesystem.db.ConnectionPool;
import org.ourfilesystem.db.ConnectionStatements;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.DataBaseQueryInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.LocalSubscribe;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthHoles;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.NetworkHoles;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostHoles;
import org.ourfilesystem.db.so.PostMessage;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.PublicPostHoles;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.db.so.Subscribe;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.PublicKeySet;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;

public class DataBaseCoreImplH2
implements DataBaseCoreInterface {
    public static int MESSAGE_POST_TYPE = 0;
    public static int MESSAGE_TEMPLATE_TYPE = 1;
    public static int LIMIT_ALL_QUERIES = 10000;
    private MyPeerDataSO MyData;
    private DataBaseLuceneIndexer Indexer;
    private ConnectionPool Pool;

    public DataBaseCoreImplH2(String basedir) throws IOException, SQLException {
        String db = String.valueOf(basedir) + File.separator + "h2";
        String dburl = "jdbc:h2:" + db + ";MVCC=TRUE";
        this.Pool = new ConnectionPool(dburl);
        ConnectionStatements Con = this.Pool.getCon();
        Statement s = null;
        DatabaseMetaData meta = Con.Con.getMetaData();
        ResultSet res = meta.getTables(null, null, null, new String[]{"TABLE"});
        boolean filereferencefnd = false;
        boolean filestatus = false;
        boolean localnetwork = false;
        boolean localnetworkauthorization = false;
        boolean localsubscribe = false;
        boolean localpeer = false;
        boolean postmessage = false;
        boolean localpost = false;
        boolean localpublicpost = false;
        boolean mypeerdataso = false;
        boolean networkauthholes = false;
        boolean networkholes = false;
        boolean postholes = false;
        boolean publicpostholes = false;
        boolean peerhasfile = false;
        boolean posttemplate = false;
        boolean searchquery = false;
        boolean searchterms = false;
        boolean ortruebools = false;
        boolean andtruebools = false;
        boolean lessthan = false;
        boolean greaterthan = false;
        boolean dlessthan = false;
        boolean dgreaterthan = false;
        while (res.next()) {
            String tn = res.getString("TABLE_NAME");
            filereferencefnd = "FILEREFERENCE".equals(tn) || filereferencefnd;
            filestatus = "FILESTATUS".equals(tn) || filestatus;
            localnetwork = "LOCALNETWORK".equals(tn) || localnetwork;
            localnetworkauthorization = "LOCALNETWORKAUTHORIZATION".equals(tn) || localnetworkauthorization;
            localsubscribe = "LOCALSUBSCRIBE".equals(tn) || localsubscribe;
            localpeer = "LOCALPEER".equals(tn) || localpeer;
            postmessage = "POSTMESSAGE".equals(tn) || postmessage;
            localpost = "LOCALPOST".equals(tn) || localpost;
            localpublicpost = "LOCALPUBLICPOST".equals(tn) || localpublicpost;
            mypeerdataso = "MYPEERDATASO".equals(tn) || mypeerdataso;
            networkauthholes = "NETWORKAUTHHOLES".equals(tn) || networkauthholes;
            networkholes = "NETWORKHOLES".equals(tn) || networkholes;
            postholes = "POSTHOLES".equals(tn) || postholes;
            publicpostholes = "PUBLICPOSTHOLES".equals(tn) || publicpostholes;
            peerhasfile = "PEERHASFILE".equals(tn) || peerhasfile;
            posttemplate = "POSTTEMPLATE".equals(tn) || posttemplate;
            searchquery = "SEARCHQUERY".equals(tn) || searchquery;
            searchterms = "SEARCHTERMS".equals(tn) || searchterms;
            ortruebools = "ORTRUEBOOLS".equals(tn) || ortruebools;
            andtruebools = "ANDTRUEBOOLS".equals(tn) || andtruebools;
            lessthan = "LESSTHAN".equals(tn) || lessthan;
            greaterthan = "GREATERTHAN".equals(tn) || greaterthan;
            dlessthan = "DLESSTHAN".equals(tn) || dlessthan;
            boolean bl = dgreaterthan = "DGREATERTHAN".equals(tn) || dgreaterthan;
        }
        if (!filereferencefnd) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE FILEREFERENCE ( USERREQUESTED           BOOLEAN       ,USERREQUESTTIME         DATETIME     ,USERREQUESTPRIORITY     BIGINT        ,USERREQUESTDISPATCHED   BOOLEAN       ,USERREQUESTDISPATCHTIME DATETIME     ,FILEEXISTS              BOOLEAN       ,LOCALDATE               DATETIME     ,NETWORKID               VARBINARY(256)    ,UNSIGNEDDIGEST          VARBINARY(256)    ,FILE                    VARCHAR(1024) ,OFFSET                  BIGINT        ,SIZE                    BIGINT        )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX FILEREFERENCEIDX0 ON FILEREFERENCE (NETWORKID,UNSIGNEDDIGEST,FILE,OFFSET,SIZE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX FILEREFERENCEIDX1 ON FILEREFERENCE (UNSIGNEDDIGEST)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX FILEREFERENCEIDX2 ON FILEREFERENCE (NETWORKID,UNSIGNEDDIGEST)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX FILEREFERENCEIDX3 ON FILEREFERENCE (FILE)");
        }
        if (!filestatus) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE FILESTATUS (            NETWORKID             VARBINARY(256)    ,FILE                  VARCHAR(1024) ,METAFILEDIGEST        VARBINARY(256)    ,METAFILESIZE          BIGINT        ,COMPLETEDIGEST        VARBINARY(256)    ,PEERID                VARBINARY(256)    ,TOTALFILESIZE         BIGINT        ,MASTERPOST            VARBINARY(256)    ,PRIORITY              BIGINT        ,NUMBERPARTS           BIGINT        ,NUMBERPENDING         BIGINT        ,NUMBERPARTSPRESENT    BIGINT        ,PIECEPOSTSFOUND       BIGINT        ,CORRUPTED             BOOLEAN       ,RDATE                 DATETIME      )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX FILESTATUSIDX0 ON FILESTATUS (FILE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX FILESTATUSIDX1 ON FILESTATUS (NETWORKID,METAFILEDIGEST)");
        }
        if (!localnetwork) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LOCALNETWORK (      LOCALDATE         DATETIME     ,PUSHREQUESTED     BOOLEAN       ,RECEIVEDFROMPEER  VARBINARY(256)    ,CREATOR           VARCHAR(1024)  ,AUTHORIZED        BOOLEAN       ,AUTHORIZATION     INT           ,TITLE             VARCHAR(1024) ,DESCRIPTION       VARCHAR(4096) ,NETWORKNUMBER     BIGINT        ,DIGEST            VARBINARY(256)    ,SEERIDENTIFIER    VARBINARY(256)    ,SIGNATURE         VARBINARY(256)    ,RDATE             DATETIME          ,PEERRANK          INT               ,PUBLIC            BOOLEAN           ,SUBSCRIBED        BOOLEAN           )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKIDX0 ON LOCALNETWORK (LOCALDATE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKIDX1 ON LOCALNETWORK (PUSHREQUESTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKIDX2 ON LOCALNETWORK (SEERIDENTIFIER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKIDX3 ON LOCALNETWORK (NETWORKNUMBER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKIDX4 ON LOCALNETWORK (DIGEST)");
        }
        if (!localnetworkauthorization) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LOCALNETWORKAUTHORIZATION (    LOCALDATE                    DATETIME     ,NUMBEROFNEWAUTHS             BIGINT        ,LASTNEWAUTHS                 DATETIME     ,REQUESTAUTHS                 BOOLEAN       ,REQUESTAUTHSTIME             DATETIME     ,REQUESTAUTHSPRIORITY         BIGINT        ,REQUESTAUTHSDISPATCHED       BOOLEAN       ,REQUESTAUTHSDISPATCHEDTIME   DATETIME     ,LASTNETWORKAUTHNUMBER        BIGINT        ,PUSHREQUESTED                BOOLEAN       ,RECEIVEDFROMPEER             VARBINARY(256)    ,NETWORKTITLE                 VARCHAR(1024) ,PEERNICKSIG                  VARCHAR(1024) ,SIGNERNICKSIG                VARCHAR(1024) ,PEERID                       VARBINARY(256)    ,NETWORKID                    VARBINARY(256)    ,SIGNATURENUMBER              BIGINT        ,SIGNAUTHORITY                INT           ,DIGEST                       VARBINARY(256)    ,SEERIDENTIFIER               VARBINARY(256)    ,SIGNATURE                    VARBINARY(256)    ,RDATE                        DATETIME          )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX1 ON LOCALNETWORKAUTHORIZATION (NETWORKID)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX7 ON LOCALNETWORKAUTHORIZATION (REQUESTAUTHSDISPATCHED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX8 ON LOCALNETWORKAUTHORIZATION (REQUESTAUTHSDISPATCHEDTIME)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX9 ON LOCALNETWORKAUTHORIZATION (PEERID)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX10 ON LOCALNETWORKAUTHORIZATION (LOCALDATE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX11 ON LOCALNETWORKAUTHORIZATION (PUSHREQUESTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALNETWORKAUTHIDX12 ON LOCALNETWORKAUTHORIZATION (SEERIDENTIFIER)");
        }
        if (!localsubscribe) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LOCALSUBSCRIBE (    LOCALDATE                    DATETIME     ,MARKEDBAD                    BOOLEAN       ,MARKEDMADDATE                DATETIME     ,NUMBEROFNEWPOSTS             BIGINT        ,LASTNEWPOST                  DATETIME     ,REQUESTPOSTS                 BOOLEAN       ,REQUESTPOSTSTIME             DATETIME     ,REQUESTPOSTSPRIORITY         BIGINT        ,REQUESTPOSTSDISPATCHED       BOOLEAN       ,REQUESTPOSTSDISPATCHEDTIME   DATETIME     ,LASTPOSTNUMBER               BIGINT        ,NUMBEROFNEWSUBS              BIGINT        ,LASTNEWSUB                   DATETIME     ,REQUESTSUB                   BOOLEAN       ,REQUESTSUBTIME               DATETIME     ,REQUESTSUBPRIORITY           BIGINT        ,REQUESTSUBDISPATCHED         BOOLEAN       ,REQUESTSUBDISPATCHEDTIME     DATETIME     ,LASTSUBNUMBER                BIGINT        ,NUMBEROFFILES                BIGINT        ,LASTNEWFILE                  DATETIME     ,PEERRANK                     BIGINT        ,PUSHREQUESTED                BOOLEAN       ,SUBSCRIBED                   BOOLEAN       ,RECEIVEDFROMPEER             VARBINARY(256)    ,NETWORKTITLE                 VARCHAR(1024) ,PEERNICKSIG                  VARCHAR(1024) ,NETWORKID                    VARBINARY(256)    ,DIGEST                       VARBINARY(256)    ,SEERIDENTIFIER               VARBINARY(256)    ,SIGNATURE                    VARBINARY(256)    ,RDATE                        DATETIME          )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX0 ON LOCALSUBSCRIBE (LASTNEWFILE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX1 ON LOCALSUBSCRIBE (NETWORKID)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX2 ON LOCALSUBSCRIBE (NUMBEROFFILES)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX3 ON LOCALSUBSCRIBE (NUMBEROFNEWPOSTS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX4 ON LOCALSUBSCRIBE (REQUESTPOSTS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX5 ON LOCALSUBSCRIBE (REQUESTPOSTSDISPATCHED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX6 ON LOCALSUBSCRIBE (REQUESTPOSTSDISPATCHEDTIME)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX7 ON LOCALSUBSCRIBE (NUMBEROFNEWSUBS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX8 ON LOCALSUBSCRIBE (REQUESTSUB)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX9 ON LOCALSUBSCRIBE (REQUESTSUBDISPATCHED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX10 ON LOCALSUBSCRIBE (REQUESTSUBDISPATCHEDTIME)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX11 ON LOCALSUBSCRIBE (LOCALDATE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX12 ON LOCALSUBSCRIBE (PUSHREQUESTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX13 ON LOCALSUBSCRIBE (SEERIDENTIFIER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALSUBSCRIBEIDX14 ON LOCALSUBSCRIBE (SUBSCRIBED)");
        }
        if (!localpeer) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LOCALPEER (                        LOCALDATE                        DATETIME     ,CONNECTIONATTEMPTS               BIGINT        ,SUCCESSFULCONNECTIONATTEMPTS     BIGINT        ,LASTCONNECTIONTIME               DATETIME     ,REQUESTS                         BIGINT        ,SUCCESSFULREQUESTS               BIGINT        ,LASTSUCCESSREQUEST               DATETIME     ,NUMBEROFNEWPEERS                 BIGINT        ,LASTNEWPEER                      DATETIME     ,REQUESTPEERS                     BOOLEAN       ,REQUESTPEERSTIME                 DATETIME     ,REQUESTPEERSPRIORITY             BIGINT        ,NUMBEROFNEWNETWORKS              BIGINT        ,LASTNEWNETWORK                   DATETIME     ,REQUESTNETWORKS                  BOOLEAN       ,REQUESTNETWORKSTIME              DATETIME     ,REQUESTNETWORKSPRIORITY          BIGINT        ,REQUESTNETWORKSDISPATCHED        BOOLEAN       ,REQUESTNETWORKSDISPATCHEDTIME    DATETIME     ,NUMBEROFNEWPUBLICPOSTS           BIGINT        ,LASTNEWPUBLICPOST                DATETIME     ,REQUESTPUBLICPOSTS               BOOLEAN       ,REQUESTPUBLICPOSTSTIME           DATETIME     ,REQUESTPUBLICPOSTSPRIORITY       BIGINT        ,REQUESTPUBLICPOSTSDISPATCHED     BOOLEAN       ,REQUESTPUBLICPOSTSDISPATCHEDTIME DATETIME     ,LASTPUBLICPOSTNUMBER             BIGINT        ,LASTNETWORKNUMBER                BIGINT        ,PUSHREQUESTED                    BOOLEAN       ,RECEIVEDFROMPEER                 VARBINARY(256)    ,IDENTITY                         VARBINARY(256)    ,SIGNEXP                          VARBINARY(2096)       ,SIGNMOD                          VARBINARY(2096)       ,ENCEXP                           VARBINARY(2096)       ,ENCMOD                           VARBINARY(2096)       ,DIGEST                           VARBINARY(256)    ,SEERIDENTIFIER                   VARBINARY(256)    ,SIGNATURE                        VARBINARY(256)    ,LOCATION                         VARCHAR(4096) ,UPDATECOUNT                      BIGINT        ,NICKNAME                         VARCHAR(1024)  ,INTRODUCTION                     VARCHAR(4096)  ,RDATE                            DATETIME       ,RANK                             INT            )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX0 ON LOCALPEER (IDENTITY)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX1 ON LOCALPEER (LASTNEWNETWORK)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX2 ON LOCALPEER (NUMBEROFNEWNETWORKS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX3 ON LOCALPEER (NUMBEROFNEWPUBLICPOSTS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX4 ON LOCALPEER (LASTNEWPEER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX5 ON LOCALPEER (NUMBEROFNEWPEERS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX6 ON LOCALPEER (REQUESTPUBLICPOSTS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX7 ON LOCALPEER (REQUESTPUBLICPOSTSDISPATCHED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX8 ON LOCALPEER (REQUESTPUBLICPOSTSDISPATCHEDTIME)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX9 ON LOCALPEER (REQUESTNETWORKS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX10 ON LOCALPEER (REQUESTNETWORKSDISPATCHED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX11 ON LOCALPEER (REQUESTNETWORKSDISPATCHEDTIME)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX12 ON LOCALPEER (PUSHREQUESTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX13 ON LOCALPEER (LOCALDATE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX14 ON LOCALPEER (REQUESTNETWORKSPRIORITY)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX15 ON LOCALPEER (REQUESTPUBLICPOSTSPRIORITY)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX16 ON LOCALPEER (REQUESTPEERS)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPEERIDX17 ON LOCALPEER (REQUESTPEERSPRIORITY)");
        }
        if (!postmessage) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE POSTMESSAGE (                      ID                               BIGINT AUTO_INCREMENT PRIMARY KEY ,REF0                             VARBINARY(256)    ,REF1                             VARBINARY(256)    ,REF2                             VARBINARY(256)    ,USETEMPLATE                      VARBINARY(256)    ,BOOL0                            BOOLEAN       ,BOOL1                            BOOLEAN       ,BOOL2                            BOOLEAN       ,BOOL3                            BOOLEAN       ,BOOL4                            BOOLEAN       ,BOOL5                            BOOLEAN       ,BOOL6                            BOOLEAN       ,BOOL7                            BOOLEAN       ,BOOL8                            BOOLEAN       ,BOOL9                            BOOLEAN       ,NUM0                             BIGINT        ,NUM1                             BIGINT        ,NUM2                             BIGINT        ,NUM3                             BIGINT        ,NUM4                             BIGINT        ,NUM5                             BIGINT        ,NUM6                             BIGINT        ,NUM7                             BIGINT        ,NUM8                             BIGINT        ,NUM9                             BIGINT        ,DOUBLE0                          DOUBLE        ,DOUBLE1                          DOUBLE        ,DOUBLE2                          DOUBLE        ,DOUBLE3                          DOUBLE        ,DOUBLE4                          DOUBLE        ,DOUBLE5                          DOUBLE        ,DOUBLE6                          DOUBLE        ,DOUBLE7                          DOUBLE        ,DOUBLE8                          DOUBLE        ,DOUBLE9                          DOUBLE        ,STRING0                          VARCHAR(4096) ,STRING1                          VARCHAR(4096) ,STRING2                          VARCHAR(4096) ,STRING3                          VARCHAR(4096) ,STRING4                          VARCHAR(4096) ,STRING5                          VARCHAR(4096) ,STRING6                          VARCHAR(4096) ,STRING7                          VARCHAR(4096) ,SUBJECT                          VARCHAR(4096) ,FILENAME                         VARCHAR(1024) ,COMMENT                          VARCHAR(8192) )");
        }
        if (!localpost) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LOCALPOST (                        LOCALDATE                        DATETIME     ,CREATOR                          VARCHAR(1024)  ,PUSHREQUESTED                    BOOLEAN       ,RECEIVEDFROMPEER                 VARBINARY(256)    ,PEERRANK                         BIGINT        ,LOCALFILE                        VARCHAR(1024) ,NETWORKID                        VARBINARY(256)    ,MESSAGETYPE                      INT           ,MESSAGEID                        BIGINT        ,FILEREFERENCEDIGEST              VARBINARY(256)    ,POSTERHASFILE                    BOOLEAN       ,POSTNUMBER                       BIGINT        ,DIGEST                           VARBINARY(256)    ,SEERIDENTIFIER                   VARBINARY(256)    ,SIGNATURE                        VARBINARY(256)    ,RDATE                            DATETIME          )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX0 ON LOCALPOST (DIGEST)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX1 ON LOCALPOST (NETWORKID)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX2 ON LOCALPOST (SEERIDENTIFIER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX3 ON LOCALPOST (POSTNUMBER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX4 ON LOCALPOST (PUSHREQUESTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX5 ON LOCALPOST (SEERIDENTIFIER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX6 ON LOCALPOST (POSTNUMBER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX7 ON LOCALPOST (LOCALDATE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPOSTIDX8 ON LOCALPOST (FILEREFERENCEDIGEST)");
        }
        if (!localpublicpost) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LOCALPUBLICPOST (                    LOCALDATE                        DATETIME       ,PRIVATEMESSAGE                   BOOLEAN         ,DECODEDMESSAGE                   VARCHAR(8192)   ,PUSHREQUSTED                     BOOLEAN         ,RECEIVEDFROMPEER                 VARBINARY(256)      ,CREATOR                          VARCHAR(1024)    ,TOPEER                           VARCHAR(1024)    ,NETWORKTITLE                     VARCHAR(1024)   ,NETWORKID                        VARBINARY(256)      ,ENCMESSAGE                       VARBINARY(8192) ,ENCRYPTED                        BOOLEAN         ,POSTNUMBER                       BIGINT          ,DIGEST                           VARBINARY(256)      ,SEERIDENTIFIER                   VARBINARY(256)      ,SIGNATURE                        VARBINARY(256)      ,RDATE                            DATETIME            ,PEERRANK                         INT                 )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX1 ON LOCALPUBLICPOST (PUSHREQUSTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX2 ON LOCALPUBLICPOST (PRIVATEMESSAGE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX3 ON LOCALPUBLICPOST (ENCRYPTED)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX4 ON LOCALPUBLICPOST (LOCALDATE)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX5 ON LOCALPUBLICPOST (DIGEST)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX6 ON LOCALPUBLICPOST (SEERIDENTIFIER)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX LOCALPUBLICPOSTIDX7 ON LOCALPUBLICPOST (POSTNUMBER)");
        }
        if (!mypeerdataso) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE MYPEERDATASO (                     ALWAYSZERO                       BIGINT        ,LOCALDATE                        DATETIME     ,CONNECTIONATTEMPTS               BIGINT        ,SUCCESSFULCONNECTIONATTEMPTS     BIGINT        ,LASTCONNECTIONTIME               DATETIME     ,REQUESTS                         BIGINT        ,SUCCESSFULREQUESTS               BIGINT        ,LASTSUCCESSREQUEST               DATETIME     ,NUMBEROFNEWPEERS                 BIGINT        ,LASTNEWPEER                      DATETIME     ,REQUESTPEERS                     BOOLEAN       ,REQUESTPEERSTIME                 DATETIME     ,REQUESTPEERSPRIORITY             BIGINT        ,NUMBEROFNEWNETWORKS              BIGINT        ,LASTNEWNETWORK                   DATETIME     ,REQUESTNETWORKS                  BOOLEAN       ,REQUESTNETWORKSTIME              DATETIME     ,REQUESTNETWORKSPRIORITY          BIGINT        ,REQUESTNETWORKSDISPATCHED        BOOLEAN       ,REQUESTNETWORKSDISPATCHEDTIME    DATETIME     ,NUMBEROFNEWPUBLICPOSTS           BIGINT        ,LASTNEWPUBLICPOST                DATETIME     ,REQUESTPUBLICPOSTS               BOOLEAN       ,REQUESTPUBLICPOSTSTIME           DATETIME     ,REQUESTPUBLICPOSTSPRIORITY       BIGINT        ,REQUESTPUBLICPOSTSDISPATCHED     BOOLEAN       ,REQUESTPUBLICPOSTSDISPATCHEDTIME DATETIME     ,LASTPUBLICPOSTNUMBER             BIGINT        ,LASTNETWORKNUMBER                BIGINT        ,PUSHREQUESTED                    BOOLEAN       ,RECEIVEDFROMPEER                 VARBINARY(256)    ,IDENTITY                         VARBINARY(256)    ,SIGNEXP                          VARBINARY(2096)       ,SIGNMOD                          VARBINARY(2096)       ,ENCEXP                           VARBINARY(2096)       ,ENCMOD                           VARBINARY(2096)       ,DIGEST                           VARBINARY(256)    ,SEERIDENTIFIER                   VARBINARY(256)    ,SIGNATURE                        VARBINARY(256)    ,LOCATION                         VARCHAR(4096) ,UPDATECOUNT                      BIGINT        ,NICKNAME                         VARCHAR(1024)  ,INTRODUCTION                     VARCHAR(4096) ,PRIVSIGNDP                       VARBINARY(2096)       ,PRIVSIGNDQ                       VARBINARY(2096)       ,PRIVSIGNEXPONENT                 VARBINARY(2096)       ,PRIVSIGNMODULUS                  VARBINARY(2096)       ,PRIVSIGNP                        VARBINARY(2096)       ,PRIVSIGNPUBLICEXPONENT           VARBINARY(2096)       ,PRIVSIGNQ                        VARBINARY(2096)       ,PRIVSIGNQINV                     VARBINARY(2096)       ,PRIVENCDP                        VARBINARY(2096)       ,PRIVENCDQ                        VARBINARY(2096)       ,PRIVENCEXPONENT                  VARBINARY(2096)       ,PRIVENCMODULUS                   VARBINARY(2096)       ,PRIVENCP                         VARBINARY(2096)       ,PRIVENCPUBLICEXPONENT            VARBINARY(2096)       ,PRIVENCQ                         VARBINARY(2096)       ,PRIVENCQINV                      VARBINARY(2096)       ,RDATE                            DATETIME              ,RANK                             INT                   )");
        }
        if (!networkauthholes) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE NETWORKAUTHHOLES (                 ID                               BIGINT AUTO_INCREMENT PRIMARY KEY   ,PEERID                           VARBINARY(256)    ,NETWORKID                        VARBINARY(256)    ,FIRSTNUMBER                      BIGINT        ,LASTNUMBER                       BIGINT        )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX NETWORKAUTHHOLESIDX0 ON NETWORKAUTHHOLES (PEERID)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX NETWORKAUTHHOLESIDX1 ON NETWORKAUTHHOLES (NETWORKID)");
        }
        if (!networkholes) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE NETWORKHOLES (                     ID                               BIGINT AUTO_INCREMENT PRIMARY KEY  ,PEERID                           VARBINARY(256)    ,FIRSTNUMBER                      BIGINT        ,LASTNUMBER                       BIGINT        )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX NETWORKHOLESIDX0 ON NETWORKHOLES (PEERID)");
        }
        if (!postholes) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE POSTHOLES (                        ID                               BIGINT AUTO_INCREMENT PRIMARY KEY  ,PEERID                           VARBINARY(256)    ,NETWORKID                        VARBINARY(256)    ,FIRSTNUMBER                      BIGINT        ,LASTNUMBER                       BIGINT        )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX POSTHOLESIDX0 ON POSTHOLES (PEERID)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX POSTHOLESIDX1 ON POSTHOLES (NETWORKID)");
        }
        if (!publicpostholes) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE PUBLICPOSTHOLES (                  ID                               BIGINT AUTO_INCREMENT PRIMARY KEY   ,PEERID                           VARBINARY(256)    ,FIRSTNUMBER                      BIGINT        ,LASTNUMBER                       BIGINT        )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX PUBLICPOSTHOLESIDX0 ON PUBLICPOSTHOLES (PEERID)");
        }
        if (!peerhasfile) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE PEERHASFILE (                      PEERHASFILEB                     BOOLEAN       ,PEERID                           VARBINARY(256)    ,NETWORKID                        VARBINARY(256)    ,DIGEST                           VARBINARY(256)    ,LASTMESSAGE                      BIGINT        )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX PEERHASFILEIDX0 ON PEERHASFILE (PEERID, NETWORKID, DIGEST)");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX PEERHASFILEIDX1 ON PEERHASFILE (NETWORKID, DIGEST)");
        }
        if (!posttemplate) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE POSTTEMPLATE (                     ID                               BIGINT AUTO_INCREMENT PRIMARY KEY,TEMPLATENAME                     VARCHAR(1024) ,TEMPLATEDESCRIPTION              VARCHAR(4096) ,REF0                             VARCHAR(1024)  ,REF1                             VARCHAR(1024)  ,REF2                             VARCHAR(1024)  ,BOOL0                            VARCHAR(1024)  ,BOOL1                            VARCHAR(1024)  ,BOOL2                            VARCHAR(1024)  ,BOOL3                            VARCHAR(1024)  ,BOOL4                            VARCHAR(1024)  ,BOOL5                            VARCHAR(1024)  ,BOOL6                            VARCHAR(1024)  ,BOOL7                            VARCHAR(1024)  ,BOOL8                            VARCHAR(1024)  ,BOOL9                            VARCHAR(1024)  ,NUM0                             VARCHAR(1024)  ,NUM1                             VARCHAR(1024)  ,NUM2                             VARCHAR(1024)  ,NUM3                             VARCHAR(1024)  ,NUM4                             VARCHAR(1024)  ,NUM5                             VARCHAR(1024)  ,NUM6                             VARCHAR(1024)  ,NUM7                             VARCHAR(1024)  ,NUM8                             VARCHAR(1024)  ,NUM9                             VARCHAR(1024)  ,DOUBLE0                          VARCHAR(1024)  ,DOUBLE1                          VARCHAR(1024)  ,DOUBLE2                          VARCHAR(1024)  ,DOUBLE3                          VARCHAR(1024)  ,DOUBLE4                          VARCHAR(1024)  ,DOUBLE5                          VARCHAR(1024)  ,DOUBLE6                          VARCHAR(1024)  ,DOUBLE7                          VARCHAR(1024)  ,DOUBLE8                          VARCHAR(1024)  ,DOUBLE9                          VARCHAR(1024)  ,STRING0                          VARCHAR(1024)  ,STRING1                          VARCHAR(1024)  ,STRING2                          VARCHAR(1024)  ,STRING3                          VARCHAR(1024)  ,STRING4                          VARCHAR(1024)  ,STRING5                          VARCHAR(1024)  ,STRING6                          VARCHAR(1024)  ,STRING7                          VARCHAR(1024)  )");
        }
        if (!searchquery) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE SEARCHQUERY (                          ID                                  BIGINT AUTO_INCREMENT PRIMARY KEY   ,QUERYNAME                           VARCHAR(1024)   ,MAXRESULTS                          INT            ,SORTBY                              VARCHAR(1024)   ,SORTREVERSE                         BOOLEAN        ,ADVANCEDQUERYSTRING                 VARCHAR(4096)  ,NETWORK                             VARBINARY(256)     ,PEERID                              VARBINARY(256)     ,GENERALTERMS                        VARCHAR(4096)  ,TEMPLATE                            BOOLEAN        ,REFS0                               VARBINARY(256)     ,REFS1                               VARBINARY(256)     ,REFS2                               VARBINARY(256)     ,USETEMPLATE                         VARBINARY(256)     ,DIRECTREF                           VARBINARY(256)     ,EXCLUDEFILESREFERENCEDBYOTHERS0     BOOLEAN        ,INCLUDEFILESWITHREFERENCES0         BOOLEAN        ,EXCLUDEFILESREFERENCEDBYOTHERS1     BOOLEAN        ,INCLUDEFILESWITHREFERENCES1         BOOLEAN        ,EXCLUDEFILESREFERENCEDBYOTHERS2     BOOLEAN        ,INCLUDEFILESWITHREFERENCES2         BOOLEAN        ,MINPEERRANK                         BIGINT         ,FROMDATE                            DATETIME      ,TODATE                              DATETIME      ,DAYSBACK                            INT           ,ONLYLOCAL                           BOOLEAN       ,HIDEOPENED                          BOOLEAN       )");
            s = Con.Con.createStatement();
            s.execute("CREATE INDEX SEARCHQUERYIDX0 ON SEARCHQUERY (NETWORK)");
        }
        if (!searchterms) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE SEARCHTERMS (                          SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,SEARCHSTRING                        VARCHAR(4096)  ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        if (!ortruebools) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE ORTRUEBOOLS (                          SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        if (!andtruebools) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE ANDTRUEBOOLS (                         SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        if (!lessthan) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE LESSTHAN (                             SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,NUMVALUE                            BIGINT         ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        if (!greaterthan) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE GREATERTHAN (                          SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,NUMVALUE                            BIGINT         ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        if (!dlessthan) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE DLESSTHAN (                            SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,NUMVALUE                            DOUBLE         ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        if (!dgreaterthan) {
            s = Con.Con.createStatement();
            s.execute("CREATE TABLE DGREATERTHAN (                         SEARCHID                            BIGINT         ,TEMPLATESTRING                      VARCHAR(1024)   ,NUMVALUE                            DOUBLE         ,FOREIGN KEY (SEARCHID) REFERENCES SEARCHQUERY(ID)  )");
        }
        this.Pool.done(Con);
        this.Indexer = new DataBaseLuceneIndexer(basedir, this);
    }

    @Override
    public void Close() {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            Statement s = Con.Con.createStatement();
            s.execute("SHUTDOWN");
            this.Pool.done(Con);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.Indexer != null) {
            this.Indexer.Close();
        }
    }

    @Override
    public DataBaseQueryInterface getDBQuery() {
        return this.Indexer.getDBQuery();
    }

    private BBytes rsBBytes(ResultSet rs, String idx) throws SQLException {
        byte[] b = rs.getBytes(idx);
        if (b != null) {
            return new BBytes(b);
        }
        return null;
    }

    private File rsFile(ResultSet rs, String idx) throws SQLException {
        String s = rs.getString(idx);
        if (s != null) {
            return new File(s);
        }
        return null;
    }

    private Date rsDate(ResultSet rs, String idx) throws SQLException {
        Timestamp d = rs.getTimestamp(idx);
        if (d != null) {
            return new Date(d.getTime());
        }
        return null;
    }

    private void saveDate(PreparedStatement s, int idx, Date d) throws SQLException {
        if (d == null) {
            s.setNull(idx, 93);
        } else {
            s.setTimestamp(idx, this.getSqlDate(d));
        }
    }

    private void saveBBytes(PreparedStatement s, int idx, BBytes b) throws SQLException {
        if (b == null) {
            s.setNull(idx, -3);
        } else {
            s.setBytes(idx, this.getBytes(b));
        }
    }

    private String getFileString(File f) {
        if (f != null) {
            return f.getPath();
        }
        return null;
    }

    private byte[] getBytes(BBytes b) {
        if (b != null) {
            return b.getBytes();
        }
        return null;
    }

    public Timestamp getSqlDate(Date d) {
        if (d != null) {
            return new Timestamp(d.getTime());
        }
        return null;
    }

    @Override
    public void savePeerHasFile(PeerHasFile ph) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("savePeerHasFile");
            s.setBoolean(1, ph.isPeerHasFile());
            s.setBytes(2, this.getBytes(ph.getPeerId()));
            s.setBytes(3, this.getBytes(ph.getNetworkId()));
            s.setBytes(4, this.getBytes(ph.getDigest()));
            s.setLong(5, ph.getLastMessage());
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private PeerHasFile getPeerHasFileRS(ResultSet rs) throws SQLException {
        PeerHasFile phf = new PeerHasFile();
        phf.setDigest(this.rsBBytes(rs, "DIGEST"));
        phf.setLastMessage(rs.getLong("LASTMESSAGE"));
        phf.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
        phf.setPeerHasFile(rs.getBoolean("PEERHASFILEB"));
        phf.setPeerId(new BBytes(this.rsBBytes(rs, "PEERID")));
        return phf;
    }

    @Override
    public PeerHasFile getPeerHasFile(BBytes networkid, BBytes peerid, BBytes dig) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeerHasFile");
            s.setBytes(1, this.getBytes(peerid));
            s.setBytes(2, this.getBytes(networkid));
            s.setBytes(3, this.getBytes(dig));
            ResultSet rs = s.executeQuery();
            PeerHasFile phf = null;
            if (rs.next()) {
                phf = this.getPeerHasFileRS(rs);
            }
            this.Pool.done(Con);
            return phf;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<PeerHasFile> getPeersHaveFile(BBytes networkid, BBytes dig) {
        LinkedList<PeerHasFile> r = new LinkedList<PeerHasFile>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeersHaveFile");
            s.setBytes(1, this.getBytes(networkid));
            s.setBytes(2, this.getBytes(dig));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getPeerHasFileRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getOrderedMostFilesMostPostsLastDate(BBytes networkid, Date lastupdate) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedMostFilesMostPostsLastDate");
            s.setTimestamp(1, this.getSqlDate(lastupdate));
            s.setBytes(2, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getOrderedMostPostsLastDate(BBytes networkid, Date lastupdate) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedMostPostsLastDate");
            s.setTimestamp(1, this.getSqlDate(lastupdate));
            s.setBytes(2, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPeer> getOrderedMostNetworksLastDate(Date lastupdate) {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedMostNetworksLastDate");
            s.setTimestamp(1, this.getSqlDate(lastupdate));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPeer> getOrderedMostPublicPostsLastDate(Date lastupdate) {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedMostPublicPostsLastDate");
            s.setTimestamp(1, this.getSqlDate(lastupdate));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPeer> getOrderedMostPeersLastDate(Date lastupdate) {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedMostPeersLastDate");
            s.setTimestamp(1, this.getSqlDate(lastupdate));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveMyPeerData(MyPeerDataSO mp) {
        this.MyData = mp;
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveMyPeerData");
            s.setTimestamp(1, this.getSqlDate(mp.getPeer().getLocalDate()));
            s.setLong(2, mp.getPeer().getConnectionAttempts());
            s.setLong(3, mp.getPeer().getSuccessfulConnectionAttempts());
            s.setTimestamp(4, this.getSqlDate(mp.getPeer().getLastConnectionTime()));
            s.setLong(5, mp.getPeer().getRequests());
            s.setLong(6, mp.getPeer().getSuccessfulRequests());
            s.setTimestamp(7, this.getSqlDate(mp.getPeer().getLastSuccessRequest()));
            s.setLong(8, mp.getPeer().getNumberOfNewPeers());
            s.setTimestamp(9, this.getSqlDate(mp.getPeer().getLastNewPeer()));
            s.setBoolean(10, mp.getPeer().isRequestPeers());
            if (mp.getPeer().getRequestPeersTime() == null) {
                s.setNull(11, 93);
            } else {
                s.setTimestamp(11, this.getSqlDate(mp.getPeer().getRequestPeersTime()));
            }
            s.setLong(12, mp.getPeer().getRequestPeersPriority());
            s.setLong(13, mp.getPeer().getNumberOfNewNetworks());
            s.setTimestamp(14, this.getSqlDate(mp.getPeer().getLastNewNetwork()));
            s.setBoolean(15, mp.getPeer().isRequestNetworks());
            s.setTimestamp(16, this.getSqlDate(mp.getPeer().getRequestNetworksTime()));
            s.setLong(17, mp.getPeer().getRequestNetworksPriority());
            s.setBoolean(18, mp.getPeer().isRequestNetworksDispatched());
            s.setTimestamp(19, this.getSqlDate(mp.getPeer().getRequestPublicPostsDispatchedTime()));
            s.setLong(20, mp.getPeer().getNumberOfNewPublicPosts());
            s.setTimestamp(21, this.getSqlDate(mp.getPeer().getLastNewPublicPost()));
            s.setBoolean(22, mp.getPeer().isRequestPublicPosts());
            s.setTimestamp(23, this.getSqlDate(mp.getPeer().getRequestPublicPostsTime()));
            s.setLong(24, mp.getPeer().getRequestPublicPostsPriority());
            s.setBoolean(25, mp.getPeer().isRequestPublicPostsDispatched());
            s.setTimestamp(26, this.getSqlDate(mp.getPeer().getRequestPublicPostsDispatchedTime()));
            s.setLong(27, mp.getPeer().getLastPublicPostNumber());
            s.setLong(28, mp.getPeer().getLastNetworkNumber());
            s.setBoolean(29, mp.getPeer().isPushRequested());
            s.setBytes(30, this.getBytes(mp.getPeer().getReceivedFromPeer()));
            s.setBytes(31, this.getBytes(mp.getPeer().getPeer().getIdentity()));
            s.setBytes(32, ((RSAKeyParameters)mp.getPeer().getPeer().getPeerKeys().getPublicSigningKey()).getExponent().toByteArray());
            s.setBytes(33, ((RSAKeyParameters)mp.getPeer().getPeer().getPeerKeys().getPublicSigningKey()).getModulus().toByteArray());
            s.setBytes(34, ((RSAKeyParameters)mp.getPeer().getPeer().getPeerKeys().getPublicEncryptionKey()).getExponent().toByteArray());
            s.setBytes(35, ((RSAKeyParameters)mp.getPeer().getPeer().getPeerKeys().getPublicEncryptionKey()).getModulus().toByteArray());
            s.setBytes(36, this.getBytes(mp.getPeer().getPeer().getLocationSignature().getDigest()));
            s.setBytes(37, this.getBytes(mp.getPeer().getPeer().getLocationSignature().getPeerIdentifier()));
            s.setBytes(38, this.getBytes(mp.getPeer().getPeer().getLocationSignature().getSignature()));
            s.setString(39, (String)mp.getPeer().getPeer().getLocation());
            s.setLong(40, mp.getPeer().getPeer().getUpdateCount());
            s.setString(41, mp.getPeer().getPeer().getNickname());
            s.setString(42, mp.getPeer().getPeer().getIntroduction());
            RSAPrivateCrtKeyParameters psign = (RSAPrivateCrtKeyParameters)mp.getKeySet().getPrivateSigningKey();
            s.setBytes(43, psign.getDP().toByteArray());
            s.setBytes(44, psign.getDQ().toByteArray());
            s.setBytes(45, psign.getExponent().toByteArray());
            s.setBytes(46, psign.getModulus().toByteArray());
            s.setBytes(47, psign.getP().toByteArray());
            s.setBytes(48, psign.getPublicExponent().toByteArray());
            s.setBytes(49, psign.getQ().toByteArray());
            s.setBytes(50, psign.getQInv().toByteArray());
            RSAPrivateCrtKeyParameters penc = (RSAPrivateCrtKeyParameters)mp.getKeySet().getPrivateEncryptionKey();
            s.setBytes(51, penc.getDP().toByteArray());
            s.setBytes(52, penc.getDQ().toByteArray());
            s.setBytes(53, penc.getExponent().toByteArray());
            s.setBytes(54, penc.getModulus().toByteArray());
            s.setBytes(55, penc.getP().toByteArray());
            s.setBytes(56, penc.getPublicExponent().toByteArray());
            s.setBytes(57, penc.getQ().toByteArray());
            s.setBytes(58, penc.getQInv().toByteArray());
            if (mp.getPeer().getPeer().getRDate() == null) {
                s.setNull(59, 93);
            } else {
                s.setTimestamp(59, this.getSqlDate(mp.getPeer().getPeer().getRDate()));
            }
            s.setInt(60, mp.getPeer().getRank());
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MyPeerDataSO getMyPeerData() {
        if (this.MyData != null) {
            return this.MyData;
        }
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getMyPeerData");
            ResultSet rs = s.executeQuery();
            if (rs.next()) {
                MyPeerDataSO mp = new MyPeerDataSO();
                LocalPeer lp = this.getLocalPeerRS(rs);
                mp.setPeer(lp);
                BigInteger privsigndp = new BigInteger(rs.getBytes("PRIVSIGNDP"));
                BigInteger privsigndq = new BigInteger(rs.getBytes("PRIVSIGNDQ"));
                BigInteger privsignexponent = new BigInteger(rs.getBytes("PRIVSIGNEXPONENT"));
                BigInteger privsignmodulus = new BigInteger(rs.getBytes("PRIVSIGNMODULUS"));
                BigInteger privsignp = new BigInteger(rs.getBytes("PRIVSIGNP"));
                BigInteger privsignpublicexponent = new BigInteger(rs.getBytes("PRIVSIGNPUBLICEXPONENT"));
                BigInteger privsignq = new BigInteger(rs.getBytes("PRIVSIGNQ"));
                BigInteger privsignqinv = new BigInteger(rs.getBytes("PRIVSIGNQINV"));
                RSAPrivateCrtKeyParameters privsign = new RSAPrivateCrtKeyParameters(privsignmodulus, privsignpublicexponent, privsignexponent, privsignp, privsignq, privsigndp, privsigndq, privsignqinv);
                BigInteger privencdp = new BigInteger(rs.getBytes("PRIVENCDP"));
                BigInteger privencdq = new BigInteger(rs.getBytes("PRIVENCDQ"));
                BigInteger privencexponent = new BigInteger(rs.getBytes("PRIVENCEXPONENT"));
                BigInteger privencmodulus = new BigInteger(rs.getBytes("PRIVENCMODULUS"));
                BigInteger privencp = new BigInteger(rs.getBytes("PRIVENCP"));
                BigInteger privencpublicexponent = new BigInteger(rs.getBytes("PRIVENCPUBLICEXPONENT"));
                BigInteger privencq = new BigInteger(rs.getBytes("PRIVENCQ"));
                BigInteger privencqinv = new BigInteger(rs.getBytes("PRIVENCQINV"));
                RSAPrivateCrtKeyParameters privenc = new RSAPrivateCrtKeyParameters(privencmodulus, privencpublicexponent, privencexponent, privencp, privencq, privencdp, privencdq, privencqinv);
                KeySet ks = new KeySet();
                ks.setPrivateEncryptionKey(privenc);
                ks.setPrivateSigningKey(privsign);
                ks.setPublicKeySet(lp.getPeer().getPeerKeys());
                mp.setKeySet(ks);
                this.MyData = mp;
                this.Pool.done(Con);
                return mp;
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<FileReference> getFiles(BBytes network, BBytes digest) {
        LinkedList<FileReference> r = new LinkedList<FileReference>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFiles");
            s.setBytes(1, this.getBytes(network));
            s.setBytes(2, this.getBytes(digest));
            ResultSet rl = s.executeQuery();
            while (rl.next()) {
                FileReference fr = new FileReference();
                fr.setUserRequested(rl.getBoolean("USERREQUESTED"));
                fr.setUserRequestTime(rl.getTimestamp("USERREQUESTTIME"));
                fr.setUserRequestPriority(rl.getLong("USERREQUESTPRIORITY"));
                fr.setUserRequestDispatched(rl.getBoolean("USERREQUESTDISPATCHED"));
                fr.setUserRequestDispatchTime(rl.getTimestamp("USERREQUESTDISPATCHTIME"));
                fr.setExists(rl.getBoolean("FILEEXISTS"));
                fr.setLocalDate(rl.getTimestamp("LOCALDATE"));
                fr.setNetworkId(new BBytes(rl.getBytes("NETWORKID")));
                fr.setUnsignedDigest(new BBytes(rl.getBytes("UNSIGNEDDIGEST")));
                fr.setFile(new File(rl.getString("FILE")));
                fr.setOffset(rl.getLong("OFFSET"));
                fr.setSize(rl.getLong("SIZE"));
                r.add(fr);
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public FileReference getFile(BBytes network, BBytes digest, File f, long offset, long size) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFile");
            s.setBytes(1, this.getBytes(network));
            s.setBytes(2, this.getBytes(digest));
            s.setString(3, f.getPath());
            s.setLong(4, offset);
            s.setLong(5, size);
            ResultSet rl = s.executeQuery();
            if (rl.next()) {
                FileReference fr = new FileReference();
                fr.setUserRequested(rl.getBoolean("USERREQUESTED"));
                fr.setUserRequestTime(rl.getTimestamp("USERREQUESTTIME"));
                fr.setUserRequestPriority(rl.getLong("USERREQUESTPRIORITY"));
                fr.setUserRequestDispatched(rl.getBoolean("USERREQUESTDISPATCHED"));
                fr.setUserRequestDispatchTime(rl.getTimestamp("USERREQUESTDISPATCHTIME"));
                fr.setExists(rl.getBoolean("FILEEXISTS"));
                fr.setLocalDate(rl.getTimestamp("LOCALDATE"));
                fr.setNetworkId(new BBytes(rl.getBytes("NETWORKID")));
                fr.setUnsignedDigest(new BBytes(rl.getBytes("UNSIGNEDDIGEST")));
                fr.setFile(new File(rl.getString("FILE")));
                fr.setOffset(rl.getLong("OFFSET"));
                fr.setSize(rl.getLong("SIZE"));
                this.Pool.done(Con);
                return fr;
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public List<FileReference> getFilesRequested(BBytes digest) {
        LinkedList<FileReference> r = new LinkedList<FileReference>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFilesRequested");
            s.setBytes(1, this.getBytes(digest));
            ResultSet rl = s.executeQuery();
            while (rl.next()) {
                FileReference fr = new FileReference();
                fr.setUserRequested(rl.getBoolean("USERREQUESTED"));
                fr.setUserRequestTime(rl.getTimestamp("USERREQUESTTIME"));
                fr.setUserRequestPriority(rl.getLong("USERREQUESTPRIORITY"));
                fr.setUserRequestDispatched(rl.getBoolean("USERREQUESTDISPATCHED"));
                fr.setUserRequestDispatchTime(rl.getTimestamp("USERREQUESTDISPATCHTIME"));
                fr.setExists(rl.getBoolean("FILEEXISTS"));
                fr.setLocalDate(rl.getTimestamp("LOCALDATE"));
                fr.setNetworkId(new BBytes(rl.getBytes("NETWORKID")));
                fr.setUnsignedDigest(new BBytes(rl.getBytes("UNSIGNEDDIGEST")));
                fr.setFile(new File(rl.getString("FILE")));
                fr.setOffset(rl.getLong("OFFSET"));
                fr.setSize(rl.getLong("SIZE"));
                r.add(fr);
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<FileReference> getFilesForFile(File f) {
        LinkedList<FileReference> r = new LinkedList<FileReference>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFilesForFile");
            s.setString(1, f.getPath());
            ResultSet rl = s.executeQuery();
            while (rl.next()) {
                FileReference fr = new FileReference();
                fr.setUserRequested(rl.getBoolean("USERREQUESTED"));
                fr.setUserRequestTime(rl.getTimestamp("USERREQUESTTIME"));
                fr.setUserRequestPriority(rl.getLong("USERREQUESTPRIORITY"));
                fr.setUserRequestDispatched(rl.getBoolean("USERREQUESTDISPATCHED"));
                fr.setUserRequestDispatchTime(rl.getTimestamp("USERREQUESTDISPATCHTIME"));
                fr.setExists(rl.getBoolean("FILEEXISTS"));
                fr.setLocalDate(rl.getTimestamp("LOCALDATE"));
                fr.setNetworkId(new BBytes(rl.getBytes("NETWORKID")));
                fr.setUnsignedDigest(new BBytes(rl.getBytes("UNSIGNEDDIGEST")));
                fr.setFile(new File(rl.getString("FILE")));
                fr.setOffset(rl.getLong("OFFSET"));
                fr.setSize(rl.getLong("SIZE"));
                r.add(fr);
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveFileReference(FileReference fr) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveFileReference");
            s.setBoolean(1, fr.isUserRequested());
            s.setTimestamp(2, this.getSqlDate(fr.getUserRequestTime()));
            s.setLong(3, fr.getUserRequestPriority());
            s.setBoolean(4, fr.isUserRequestDispatched());
            s.setTimestamp(5, this.getSqlDate(fr.getUserRequestDispatchTime()));
            s.setBoolean(6, fr.isExists());
            s.setTimestamp(7, this.getSqlDate(fr.getLocalDate()));
            s.setBytes(8, this.getBytes(fr.getNetworkId()));
            s.setBytes(9, this.getBytes(fr.getUnsignedDigest()));
            s.setString(10, fr.getFile().getPath());
            s.setLong(11, fr.getOffset());
            s.setLong(12, fr.getSize());
            s.execute();
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private FileReference getFileReferenceRS(ResultSet rl) throws SQLException {
        FileReference fr = new FileReference();
        fr.setUserRequested(rl.getBoolean("USERREQUESTED"));
        fr.setUserRequestTime(rl.getTimestamp("USERREQUESTTIME"));
        fr.setUserRequestPriority(rl.getLong("USERREQUESTPRIORITY"));
        fr.setUserRequestDispatched(rl.getBoolean("USERREQUESTDISPATCHED"));
        fr.setUserRequestDispatchTime(rl.getTimestamp("USERREQUESTDISPATCHTIME"));
        fr.setExists(rl.getBoolean("FILEEXISTS"));
        fr.setLocalDate(rl.getTimestamp("LOCALDATE"));
        fr.setNetworkId(new BBytes(rl.getBytes("NETWORKID")));
        fr.setUnsignedDigest(new BBytes(rl.getBytes("UNSIGNEDDIGEST")));
        fr.setFile(new File(rl.getString("FILE")));
        fr.setOffset(rl.getLong("OFFSET"));
        fr.setSize(rl.getLong("SIZE"));
        return fr;
    }

    @Override
    public List<FileReference> getOrderedFilesRequestedNotDispatched() {
        LinkedList<FileReference> r = new LinkedList<FileReference>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedFilesRequestedNotDispatched");
            ResultSet rl = s.executeQuery();
            while (rl.next()) {
                r.add(this.getFileReferenceRS(rl));
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return r;
    }

    public LocalPost getPost(BBytes dig) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPost0");
            s.setBytes(1, this.getBytes(dig));
            ResultSet rs = s.executeQuery();
            LocalPost lp = null;
            if (rs.next()) {
                lp = this.getLocalPostFromRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public LocalPost getPost(BBytes networkid, BBytes peerid, long pid) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPost1");
            s.setBytes(1, this.getBytes(networkid));
            s.setBytes(2, this.getBytes(peerid));
            s.setLong(3, pid);
            ResultSet rs = s.executeQuery();
            LocalPost lp = null;
            if (rs.next()) {
                lp = this.getLocalPostFromRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<FileReference> getOrderedFilesRequestedAndDispatched() {
        LinkedList<FileReference> r = new LinkedList<FileReference>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedFilesRequestedAndDispatched");
            ResultSet rl = s.executeQuery();
            while (rl.next()) {
                r.add(this.getFileReferenceRS(rl));
            }
            this.Pool.done(Con);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPeer> getOrderedPublicPostsRequestedAndDispatched() {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedPublicPostsRequestedAndDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getOrderedPostsRequestedAndDispatched() {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedPostsRequestedAndDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedNetworkAuthsRequestedAndDispatched() {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedNetworkAuthsRequestedAndDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPeer> getOrderedNetworksRequestedAndDispatched() {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedNetworksRequestedAndDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPeer> getNextPeerPush() {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNextPeerPush");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public List<LocalNetwork> getLocalNetworks(int max) {
        LinkedList<LocalNetwork> r = new LinkedList<LocalNetwork>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalNetworks");
            s.setInt(1, max);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetworkRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalNetwork> getNextNetworkPush() {
        LinkedList<LocalNetwork> r = new LinkedList<LocalNetwork>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNextNetworkPush");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetworkRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPublicPost> getNextPublicPostPush() {
        LinkedList<LocalPublicPost> r = new LinkedList<LocalPublicPost>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNextPublicPostPush");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPublicPostRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public List<LocalNetworkAuthorization> getNetworkAuthsForPeer(BBytes peerid) {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNetworkAuthsForPeer");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalNetworkAuthorization> getNextNetworkAuthPush(BBytes networkid) {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNextNetworkAuthPush");
            s.setBytes(1, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPost> getNextPostPush(BBytes networkid) {
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNextPostPush");
            s.setBytes(1, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPostFromRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public LocalPeer getPeer(BBytes id) {
        MyPeerDataSO mpid = this.getMyPeerData();
        if (mpid != null && mpid.getPeer().getPeer().getIdentity().equals(id)) {
            return mpid.getPeer();
        }
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeer");
            s.setBytes(1, this.getBytes(id));
            ResultSet rs = s.executeQuery();
            LocalPeer lp = null;
            if (rs.next()) {
                lp = this.getLocalPeerRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<LocalPeer> getLocalPeers() {
        LinkedList<LocalPeer> r = new LinkedList<LocalPeer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalPeers");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<Peer> getPeers() {
        LinkedList<Peer> r = new LinkedList<Peer>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeers");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPeerRS(rs).getPeer());
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveLocalPeer(LocalPeer lp) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveLocalPeer");
            byte[] signkeyexp = ((RSAKeyParameters)lp.getPeer().getPeerKeys().getPublicSigningKey()).getExponent().toByteArray();
            byte[] signkeymod = ((RSAKeyParameters)lp.getPeer().getPeerKeys().getPublicSigningKey()).getModulus().toByteArray();
            byte[] encexp = ((RSAKeyParameters)lp.getPeer().getPeerKeys().getPublicEncryptionKey()).getExponent().toByteArray();
            byte[] encmod = ((RSAKeyParameters)lp.getPeer().getPeerKeys().getPublicEncryptionKey()).getModulus().toByteArray();
            s.setTimestamp(1, this.getSqlDate(lp.getLocalDate()));
            s.setLong(2, lp.getConnectionAttempts());
            s.setLong(3, lp.getSuccessfulConnectionAttempts());
            s.setTimestamp(4, this.getSqlDate(lp.getLastConnectionTime()));
            s.setLong(5, lp.getRequests());
            s.setLong(6, lp.getSuccessfulRequests());
            s.setTimestamp(7, this.getSqlDate(lp.getLastSuccessRequest()));
            s.setLong(8, lp.getNumberOfNewPeers());
            s.setTimestamp(9, this.getSqlDate(lp.getLastNewPeer()));
            s.setBoolean(10, lp.isRequestPeers());
            this.saveDate(s, 11, lp.getRequestPeersTime());
            s.setLong(12, lp.getRequestPeersPriority());
            s.setLong(13, lp.getNumberOfNewNetworks());
            s.setTimestamp(14, this.getSqlDate(lp.getLastNewNetwork()));
            s.setBoolean(15, lp.isRequestNetworks());
            s.setTimestamp(16, this.getSqlDate(lp.getRequestNetworksTime()));
            s.setLong(17, lp.getRequestNetworksPriority());
            s.setBoolean(18, lp.isRequestNetworksDispatched());
            s.setTimestamp(19, this.getSqlDate(lp.getRequestNetworksDispatchedTime()));
            s.setLong(20, lp.getNumberOfNewPublicPosts());
            s.setTimestamp(21, this.getSqlDate(lp.getLastNewPublicPost()));
            s.setBoolean(22, lp.isRequestPublicPosts());
            s.setTimestamp(23, this.getSqlDate(lp.getRequestPublicPostsTime()));
            s.setLong(24, lp.getRequestPublicPostsPriority());
            s.setBoolean(25, lp.isRequestPublicPostsDispatched());
            s.setTimestamp(26, this.getSqlDate(lp.getRequestPublicPostsDispatchedTime()));
            s.setLong(27, lp.getLastPublicPostNumber());
            s.setLong(28, lp.getLastNetworkNumber());
            s.setBoolean(29, lp.isPushRequested());
            s.setBytes(30, this.getBytes(lp.getReceivedFromPeer()));
            s.setBytes(31, this.getBytes(lp.getPeer().getIdentity()));
            s.setBytes(32, signkeyexp);
            s.setBytes(33, signkeymod);
            s.setBytes(34, encexp);
            s.setBytes(35, encmod);
            s.setBytes(36, this.getBytes(lp.getPeer().getLocationSignature().getDigest()));
            s.setBytes(37, this.getBytes(lp.getPeer().getLocationSignature().getPeerIdentifier()));
            s.setBytes(38, this.getBytes(lp.getPeer().getLocationSignature().getSignature()));
            s.setString(39, (String)lp.getPeer().getLocation());
            s.setLong(40, lp.getPeer().getUpdateCount());
            s.setString(41, lp.getPeer().getNickname());
            s.setString(42, lp.getPeer().getIntroduction());
            this.saveDate(s, 43, lp.getPeer().getRDate());
            s.setInt(44, lp.getRank());
            s.executeUpdate();
            this.Pool.done(Con);
            this.Indexer.indexPeer(lp, true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private LocalPeer getLocalPeerRS(ResultSet rs) throws SQLException {
        Peer p = new Peer();
        LocalPeer lp = new LocalPeer();
        lp.setPeer(p);
        lp.setLocalDate(this.rsDate(rs, "LOCALDATE"));
        lp.setConnectionAttempts(rs.getLong("CONNECTIONATTEMPTS"));
        lp.setSuccessfulConnectionAttempts(rs.getLong("SUCCESSFULCONNECTIONATTEMPTS"));
        lp.setLastConnectionTime(this.rsDate(rs, "LASTCONNECTIONTIME"));
        lp.setRequests(rs.getLong("REQUESTS"));
        lp.setSuccessfulRequests(rs.getLong("SUCCESSFULREQUESTS"));
        lp.setLastSuccessRequest(this.rsDate(rs, "LASTSUCCESSREQUEST"));
        lp.setNumberOfNewPeers(rs.getLong("NUMBEROFNEWPEERS"));
        lp.setLastNewPeer(this.rsDate(rs, "LASTNEWPEER"));
        lp.setRequestPeers(rs.getBoolean("REQUESTPEERS"));
        lp.setRequestPeersTime(this.rsDate(rs, "REQUESTPEERSTIME"));
        lp.setRequestPeersPriority(rs.getLong("REQUESTPEERSPRIORITY"));
        lp.setNumberOfNewNetworks(rs.getLong("NUMBEROFNEWNETWORKS"));
        lp.setLastNewNetwork(this.rsDate(rs, "LASTNEWNETWORK"));
        lp.setRequestNetworks(rs.getBoolean("REQUESTNETWORKS"));
        lp.setRequestNetworksTime(this.rsDate(rs, "REQUESTNETWORKSTIME"));
        lp.setRequestNetworksPriority(rs.getLong("REQUESTNETWORKSPRIORITY"));
        lp.setRequestNetworksDispatched(rs.getBoolean("REQUESTNETWORKSDISPATCHED"));
        lp.setRequestNetworksDispatchedTime(this.rsDate(rs, "REQUESTNETWORKSDISPATCHEDTIME"));
        lp.setNumberOfNewPublicPosts(rs.getLong("NUMBEROFNEWPUBLICPOSTS"));
        lp.setLastNewPublicPost(this.rsDate(rs, "LASTNEWPUBLICPOST"));
        lp.setRequestPublicPosts(rs.getBoolean("REQUESTPUBLICPOSTS"));
        lp.setRequestPublicPostsTime(this.rsDate(rs, "REQUESTPUBLICPOSTSTIME"));
        lp.setRequestPublicPostsPriority(rs.getLong("REQUESTPUBLICPOSTSPRIORITY"));
        lp.setRequestPublicPostsDispatched(rs.getBoolean("REQUESTPUBLICPOSTSDISPATCHED"));
        lp.setRequestPublicPostsDispatchedTime(this.rsDate(rs, "REQUESTPUBLICPOSTSDISPATCHEDTIME"));
        lp.setLastPublicPostNumber(rs.getLong("LASTPUBLICPOSTNUMBER"));
        lp.setLastNetworkNumber(rs.getLong("LASTNETWORKNUMBER"));
        lp.setPushRequested(rs.getBoolean("PUSHREQUESTED"));
        lp.setReceivedFromPeer(this.rsBBytes(rs, "RECEIVEDFROMPEER"));
        lp.setRank(rs.getInt("RANK"));
        p.setIdentity(this.rsBBytes(rs, "IDENTITY"));
        p.setRDate(this.rsDate(rs, "RDATE"));
        BigInteger signexp = new BigInteger(rs.getBytes("SIGNEXP"));
        BigInteger signmod = new BigInteger(rs.getBytes("SIGNMOD"));
        RSAKeyParameters signpub = new RSAKeyParameters(false, signmod, signexp);
        BigInteger encexp = new BigInteger(rs.getBytes("ENCEXP"));
        BigInteger encmod = new BigInteger(rs.getBytes("ENCMOD"));
        RSAKeyParameters encpub = new RSAKeyParameters(false, encmod, encexp);
        p.setPeerKeys(new PublicKeySet());
        p.getPeerKeys().setPublicSigningKey(signpub);
        p.getPeerKeys().setPublicEncryptionKey(encpub);
        BBytes dig = this.rsBBytes(rs, "DIGEST");
        BBytes pident = this.rsBBytes(rs, "SEERIDENTIFIER");
        BBytes sig = this.rsBBytes(rs, "SIGNATURE");
        SignedDigest sg = new SignedDigest();
        sg.setDigest(dig);
        sg.setPeerIdentifier(pident);
        sg.setSignature(sig);
        p.setLocationSignature(sg);
        p.setLocation(rs.getString("LOCATION"));
        p.setUpdateCount(rs.getLong("UPDATECOUNT"));
        p.setNickname(rs.getString("NICKNAME"));
        p.setIntroduction(rs.getString("INTRODUCTION"));
        return lp;
    }

    @Override
    public void deletePeer(Peer p, boolean poststoo) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("deletePeer");
            s.setBytes(1, this.getBytes(p.getIdentity()));
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteReferencelessPosts(Date olderthan) {
    }

    @Override
    public void deletePublicPosts(Date olderthan) {
    }

    @Override
    public LocalPeer getHighestPriorityNeteworkRequest() {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getHighestPriorityNeteworkRequest");
            ResultSet rs = s.executeQuery();
            LocalPeer lp = null;
            if (rs.next()) {
                lp = this.getLocalPeerRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<NetworkHoles> getPeerNetworkHoles(BBytes peerid) {
        LinkedList<NetworkHoles> r = new LinkedList<NetworkHoles>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeerNetworkHoles");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                NetworkHolesExt enh = new NetworkHolesExt();
                enh.setId(rs.getLong("ID"));
                enh.setPeerId(this.rsBBytes(rs, "PEERID"));
                enh.setFirstNumber(rs.getLong("FIRSTNUMBER"));
                enh.setLastNumber(rs.getLong("LASTNUMBER"));
                r.add(enh);
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveNetworkHoles(NetworkHoles nh) {
        try {
            if (!(nh instanceof NetworkHolesExt)) {
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("saveNetworkHoles0");
                s.setBytes(1, this.getBytes(nh.getPeerId()));
                s.setLong(2, nh.getFirstNumber());
                s.setLong(3, nh.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            } else {
                NetworkHolesExt enh = (NetworkHolesExt)nh;
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("saveNetworkHoles1");
                s.setLong(1, enh.getId());
                s.setBytes(2, this.getBytes(enh.getPeerId()));
                s.setLong(3, enh.getFirstNumber());
                s.setLong(4, enh.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteNetworkHoles(NetworkHoles nh) {
        if (!(nh instanceof NetworkHolesExt)) {
            throw new RuntimeException("You can't delete NetworkHoles that aren't saved yet.");
        }
        NetworkHolesExt enh = (NetworkHolesExt)nh;
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("deleteNetworkHoles");
            s.setLong(1, enh.getId());
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public LocalPeer getHighestPriorityPublicPostRequest() {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getHighestPriorityPublicPostRequest");
            ResultSet rs = s.executeQuery();
            LocalPeer lp = null;
            if (rs.next()) {
                lp = this.getLocalPeerRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<PublicPostHoles> getPublicPostHoles(BBytes peerid) {
        LinkedList<PublicPostHoles> r = new LinkedList<PublicPostHoles>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPublicPostHoles0");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                PublicPostHolesExt phe = new PublicPostHolesExt();
                phe.setId(rs.getLong("ID"));
                phe.setPeerId(this.rsBBytes(rs, "PEERID"));
                phe.setFirstNumber(rs.getLong("FIRSTNUMBER"));
                phe.setLastNumber(rs.getLong("LASTNUMBER"));
                r.add(phe);
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void savePublicPostHoles(PublicPostHoles nh) {
        try {
            if (!(nh instanceof PublicPostHolesExt)) {
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("savePublicPostHoles0");
                s.setBytes(1, this.getBytes(nh.getPeerId()));
                s.setLong(2, nh.getFirstNumber());
                s.setLong(3, nh.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            } else {
                PublicPostHolesExt enh = (PublicPostHolesExt)nh;
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("savePublicPostHoles1");
                s.setLong(1, enh.getId());
                s.setBytes(2, this.getBytes(enh.getPeerId()));
                s.setLong(3, enh.getFirstNumber());
                s.setLong(4, enh.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deletePublicPostHoles(PublicPostHoles nh) {
        if (!(nh instanceof PublicPostHolesExt)) {
            throw new RuntimeException("You can't delete PublicPostHoles that aren't saved yet.");
        }
        PublicPostHolesExt enh = (PublicPostHolesExt)nh;
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("deletePublicPostHoles");
            s.setLong(1, enh.getId());
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public LocalPublicPost getLocalPublicPost(BBytes dig) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalPublicPost0");
            s.setBytes(1, this.getBytes(dig));
            ResultSet rs = s.executeQuery();
            LocalPublicPost lp = null;
            if (rs.next()) {
                lp = this.getLocalPublicPostRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public LocalPublicPost getLocalPublicPost(BBytes peerid, long postid) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalPublicPost1");
            s.setBytes(1, this.getBytes(peerid));
            s.setLong(2, postid);
            ResultSet rs = s.executeQuery();
            LocalPublicPost lp = null;
            if (rs.next()) {
                lp = this.getLocalPublicPostRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public LocalPeer getHighestPriorityPeerRequest() {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getHighestPriorityPeerRequest");
            ResultSet rs = s.executeQuery();
            LocalPeer lp = null;
            if (rs.next()) {
                lp = this.getLocalPeerRS(rs);
            }
            this.Pool.done(Con);
            return lp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public LocalNetworkAuthorization getNetworkAuth(BBytes networkid, BBytes peerid) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNetworkAuth");
            s.setBytes(1, this.getBytes(peerid));
            s.setBytes(2, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            LocalNetworkAuthorization ln = null;
            if (rs.next()) {
                ln = this.getLocalNetAuthRS(rs);
            }
            this.Pool.done(Con);
            return ln;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<LocalNetworkAuthorization> getNetworkAuths(BBytes networkid) {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNetworkAuths");
            s.setBytes(1, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalNetworkAuthorization> getPeerNetworkAuths(BBytes peerid) {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeerNetworkAuths");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalNetworkAuthorization> getNetworkAuthsSignedBy(BBytes networkid, BBytes peerid) {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNetworkAuthsSignedBy");
            s.setBytes(1, this.getBytes(networkid));
            s.setBytes(2, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public synchronized void saveLocalNetworkAuth(LocalNetworkAuthorization auth) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveLocalNetworkAuth");
            s.setTimestamp(1, this.getSqlDate(auth.getLocalDate()));
            s.setLong(2, auth.getNumberOfNewAuths());
            s.setTimestamp(3, this.getSqlDate(auth.getLastNewAuths()));
            s.setBoolean(4, auth.isRequestAuths());
            s.setTimestamp(5, this.getSqlDate(auth.getRequestAuthsTime()));
            s.setLong(6, auth.getRequestAuthsPriority());
            s.setBoolean(7, auth.isRequestAuthsDispatched());
            s.setTimestamp(8, this.getSqlDate(auth.getRequestAuthsDispatchedTime()));
            s.setLong(9, auth.getLastNetworkAuthNumber());
            s.setBoolean(10, auth.isPushRequested());
            s.setBytes(11, this.getBytes(auth.getReceivedFromPeer()));
            s.setString(12, auth.getNetworkTitle());
            s.setString(13, auth.getPeerNickSig());
            s.setString(14, auth.getSignerNickSig());
            s.setBytes(15, this.getBytes(auth.getNetworkAuthorization().getPeerId()));
            s.setBytes(16, this.getBytes(auth.getNetworkAuthorization().getNetworkId()));
            s.setLong(17, auth.getNetworkAuthorization().getSignatureNumber());
            s.setInt(18, auth.getNetworkAuthorization().getSignAuthority());
            s.setBytes(19, this.getBytes(auth.getNetworkAuthorization().getSignature().getDigest()));
            s.setBytes(20, this.getBytes(auth.getNetworkAuthorization().getSignature().getPeerIdentifier()));
            s.setBytes(21, this.getBytes(auth.getNetworkAuthorization().getSignature().getSignature()));
            if (auth.getNetworkAuthorization().getRDate() == null) {
                s.setNull(22, 93);
            } else {
                s.setTimestamp(22, this.getSqlDate(auth.getNetworkAuthorization().getRDate()));
            }
            s.execute();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LocalNetworkAuthorization getLocalNetAuthRS(ResultSet rs) throws SQLException {
        NetworkAuthorization a = new NetworkAuthorization();
        LocalNetworkAuthorization la = new LocalNetworkAuthorization();
        SignedDigest sg = new SignedDigest();
        a.setSignature(sg);
        la.setNetworkAuthorization(a);
        la.setLocalDate(this.rsDate(rs, "LOCALDATE"));
        la.setNumberOfNewAuths(rs.getLong("NUMBEROFNEWAUTHS"));
        la.setLastNewAuths(this.rsDate(rs, "LASTNEWAUTHS"));
        la.setRequestAuths(rs.getBoolean("REQUESTAUTHS"));
        la.setRequestAuthsTime(this.rsDate(rs, "REQUESTAUTHSTIME"));
        la.setRequestAuthsPriority(rs.getLong("REQUESTAUTHSPRIORITY"));
        la.setRequestAuthsDispatched(rs.getBoolean("REQUESTAUTHSDISPATCHED"));
        la.setRequestAuthsDispatchedTime(this.rsDate(rs, "REQUESTAUTHSDISPATCHEDTIME"));
        la.setLastNetworkAuthNumber(rs.getLong("LASTNETWORKAUTHNUMBER"));
        la.setPushRequested(rs.getBoolean("PUSHREQUESTED"));
        la.setReceivedFromPeer(this.rsBBytes(rs, "RECEIVEDFROMPEER"));
        la.setNetworkTitle(rs.getString("NETWORKTITLE"));
        la.setPeerNickSig(rs.getString("PEERNICKSIG"));
        la.setSignerNickSig(rs.getString("SIGNERNICKSIG"));
        a.setPeerId(this.rsBBytes(rs, "PEERID"));
        a.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
        a.setSignatureNumber(rs.getLong("SIGNATURENUMBER"));
        a.setSignAuthority(rs.getInt("SIGNAUTHORITY"));
        a.setRDate(this.rsDate(rs, "RDATE"));
        sg.setDigest(this.rsBBytes(rs, "DIGEST"));
        sg.setPeerIdentifier(this.rsBBytes(rs, "SEERIDENTIFIER"));
        sg.setSignature(this.rsBBytes(rs, "SIGNATURE"));
        return la;
    }

    private LocalSubscribe getLocalSubscribeRS(ResultSet rs) throws SQLException {
        Subscribe a = new Subscribe();
        LocalSubscribe la = new LocalSubscribe();
        SignedDigest sg = new SignedDigest();
        la.setSubscription(a);
        la.setLocalDate(this.rsDate(rs, "LOCALDATE"));
        la.setMarkedBad(rs.getBoolean("MARKEDBAD"));
        la.setMarkedBadDate(this.rsDate(rs, "MARKEDMADDATE"));
        la.setNumberOfNewPosts(rs.getLong("NUMBEROFNEWPOSTS"));
        la.setLastNewPost(this.rsDate(rs, "LASTNEWPOST"));
        la.setRequestPosts(rs.getBoolean("REQUESTPOSTS"));
        la.setRequestPostsTime(this.rsDate(rs, "REQUESTPOSTSTIME"));
        la.setRequestPostsPriority(rs.getLong("REQUESTPOSTSPRIORITY"));
        la.setRequestPostsDispatched(rs.getBoolean("REQUESTPOSTSDISPATCHED"));
        la.setRequestPostsDispatchedTime(this.rsDate(rs, "REQUESTPOSTSDISPATCHEDTIME"));
        la.setLastPostNumber(rs.getLong("LASTPOSTNUMBER"));
        la.setNumberOfNewSubs(rs.getLong("NUMBEROFNEWSUBS"));
        la.setLastNewSubs(this.rsDate(rs, "LASTNEWSUB"));
        la.setRequestSubs(rs.getBoolean("REQUESTSUB"));
        la.setRequestSubsTime(this.rsDate(rs, "REQUESTSUBTIME"));
        la.setRequestSubsPriority(rs.getLong("REQUESTSUBPRIORITY"));
        la.setRequestSubsDispatched(rs.getBoolean("REQUESTSUBDISPATCHED"));
        la.setRequestSubsDispatchedTime(this.rsDate(rs, "REQUESTSUBDISPATCHEDTIME"));
        la.setNumberOfFiles(rs.getLong("NUMBEROFFILES"));
        la.setLastNewFile(this.rsDate(rs, "LASTNEWFILE"));
        la.setPeerRank(rs.getLong("PEERRANK"));
        la.setPushRequested(rs.getBoolean("PUSHREQUESTED"));
        la.setReceivedFromPeer(this.rsBBytes(rs, "RECEIVEDFROMPEER"));
        la.setNetworkName(rs.getString("NETWORKTITLE"));
        la.setCreator(rs.getString("PEERNICKSIG"));
        a.setSignature(sg);
        a.setSubscribe(rs.getBoolean("SUBSCRIBED"));
        a.setNetworkID(this.rsBBytes(rs, "NETWORKID"));
        a.setRDate(this.rsDate(rs, "RDATE"));
        a.setSubNumber(rs.getLong("LASTSUBNUMBER"));
        sg.setDigest(this.rsBBytes(rs, "DIGEST"));
        sg.setPeerIdentifier(this.rsBBytes(rs, "SEERIDENTIFIER"));
        sg.setSignature(this.rsBBytes(rs, "SIGNATURE"));
        return la;
    }

    @Override
    public List<LocalNetworkAuthorization> getOrderedNetworkAuthsRequestedNotDispatched() {
        LinkedList<LocalNetworkAuthorization> r = new LinkedList<LocalNetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedNetworkAuthsRequestedNotDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveNetworkAuthHoles(NetworkAuthHoles h) {
        try {
            if (!(h instanceof NetworkAuthHolesExt)) {
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("saveNetworkAuthHoles0");
                s.setBytes(1, this.getBytes(h.getPeerId()));
                s.setBytes(2, this.getBytes(h.getNetworkId()));
                s.setLong(3, h.getFirstNumber());
                s.setLong(4, h.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            } else {
                NetworkAuthHolesExt enh = (NetworkAuthHolesExt)h;
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("saveNetworkAuthHoles1");
                s.setLong(1, enh.getId());
                s.setBytes(2, this.getBytes(enh.getPeerId()));
                s.setBytes(3, this.getBytes(enh.getNetworkId()));
                s.setLong(4, enh.getFirstNumber());
                s.setLong(5, enh.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteNetworkAuthHoles(NetworkAuthHoles h) {
        if (!(h instanceof NetworkAuthHolesExt)) {
            throw new RuntimeException("You can't delete NetworkAuthHoles that aren't saved yet.");
        }
        NetworkAuthHolesExt enh = (NetworkAuthHolesExt)h;
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("deleteNetworkAuthHoles");
            s.setLong(1, enh.getId());
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<NetworkAuthHoles> getPeerNetworkAuthHoles(BBytes networkid, BBytes peerid) {
        LinkedList<NetworkAuthHoles> r = new LinkedList<NetworkAuthHoles>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeerNetworkAuthHoles");
            s.setBytes(1, this.getBytes(networkid));
            s.setBytes(2, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                NetworkAuthHolesExt enh = new NetworkAuthHolesExt();
                enh.setId(rs.getLong("ID"));
                enh.setPeerId(this.rsBBytes(rs, "PEERID"));
                enh.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
                enh.setFirstNumber(rs.getLong("FIRSTNUMBER"));
                enh.setLastNumber(rs.getLong("LASTNUMBER"));
                r.add(enh);
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getOrderedPostsRequestedNotDispatched() {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedPostsRequestedNotDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void savePostHoles(PostHoles ph) {
        try {
            if (!(ph instanceof PostHolesExt)) {
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("savePostHoles0");
                s.setBytes(1, this.getBytes(ph.getPeerId()));
                s.setBytes(2, this.getBytes(ph.getNetworkId()));
                s.setLong(3, ph.getFirstNumber());
                s.setLong(4, ph.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            } else {
                PostHolesExt enh = (PostHolesExt)ph;
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("savePostHoles1");
                s.setLong(1, enh.getId());
                s.setBytes(2, this.getBytes(enh.getPeerId()));
                s.setBytes(3, this.getBytes(enh.getNetworkId()));
                s.setLong(4, enh.getFirstNumber());
                s.setLong(5, enh.getLastNumber());
                s.execute();
                this.Pool.done(Con);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deletePostHoles(PostHoles h) {
        if (!(h instanceof PostHolesExt)) {
            throw new RuntimeException("You can't delete NetworkHoles that aren't saved yet.");
        }
        PostHolesExt enh = (PostHolesExt)h;
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("deletePostHoles");
            s.setLong(1, enh.getId());
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<PostHoles> getPostHoles(BBytes networkid, BBytes peerid) {
        LinkedList<PostHoles> r = new LinkedList<PostHoles>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPostHoles");
            s.setBytes(1, this.getBytes(peerid));
            s.setBytes(2, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                PostHolesExt enh = new PostHolesExt();
                enh.setId(rs.getLong("ID"));
                enh.setPeerId(this.rsBBytes(rs, "PEERID"));
                enh.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
                enh.setFirstNumber(rs.getLong("FIRSTNUMBER"));
                enh.setLastNumber(rs.getLong("LASTNUMBER"));
                r.add(enh);
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<Network> getNetworks(BBytes peerid, long fromnum, long tonum) {
        LinkedList<Network> r = new LinkedList<Network>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNetworks");
            s.setBytes(1, this.getBytes(peerid));
            s.setLong(2, fromnum);
            s.setLong(3, tonum);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetworkRS(rs).getNetwork());
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<PublicPost> getPublicPosts(BBytes peerid, long fromnum, long tonum) {
        LinkedList<PublicPost> r = new LinkedList<PublicPost>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPublicPosts0");
            s.setBytes(1, this.getBytes(peerid));
            s.setLong(2, fromnum);
            s.setLong(3, tonum);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPublicPostRS(rs).getPublicPost());
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<NetworkAuthorization> getNetworkAuthorizations(BBytes peerid, BBytes netid, long fromnum, long tonum) {
        LinkedList<NetworkAuthorization> r = new LinkedList<NetworkAuthorization>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNetworkAuthorizations");
            s.setBytes(1, this.getBytes(peerid));
            s.setBytes(2, this.getBytes(netid));
            s.setLong(3, fromnum);
            s.setLong(4, tonum);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalNetAuthRS(rs).getNetworkAuthorization());
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<Post> getPosts(BBytes peerid, BBytes netid, long fromnum, long tonum) {
        LinkedList<Post> r = new LinkedList<Post>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPosts0");
            s.setBytes(1, this.getBytes(peerid));
            s.setBytes(2, this.getBytes(netid));
            s.setLong(3, fromnum);
            s.setLong(4, tonum);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPostFromRS(rs).getPost());
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveLocalPost(LocalPost p) {
        try {
            Object pe;
            Long messagekey = null;
            int messagetype = MESSAGE_POST_TYPE;
            ConnectionStatements Con = this.Pool.getCon();
            if (p.getPost().getMessage() instanceof PostMessageExt) {
                pe = (PostMessageExt)p.getPost().getMessage();
                messagekey = ((PostMessageExt)pe).getId();
                messagetype = MESSAGE_POST_TYPE;
            } else if (p.getPost().getMessage() instanceof PostMessage) {
                PostMessage pm = (PostMessage)p.getPost().getMessage();
                PreparedStatement s = Con.getStatement("saveLocalPost0");
                s.setBytes(1, this.getBytes(pm.getRef0()));
                s.setBytes(2, this.getBytes(pm.getRef1()));
                s.setBytes(3, this.getBytes(pm.getRef2()));
                s.setBytes(4, this.getBytes(pm.getUseTemplate()));
                s.setBoolean(5, pm.isBool0());
                s.setBoolean(6, pm.isBool1());
                s.setBoolean(7, pm.isBool2());
                s.setBoolean(8, pm.isBool3());
                s.setBoolean(9, pm.isBool4());
                s.setBoolean(10, pm.isBool5());
                s.setBoolean(11, pm.isBool6());
                s.setBoolean(12, pm.isBool7());
                s.setBoolean(13, pm.isBool8());
                s.setBoolean(14, pm.isBool9());
                s.setLong(15, pm.getNum0());
                s.setLong(16, pm.getNum1());
                s.setLong(17, pm.getNum2());
                s.setLong(18, pm.getNum3());
                s.setLong(19, pm.getNum4());
                s.setLong(20, pm.getNum5());
                s.setLong(21, pm.getNum6());
                s.setLong(22, pm.getNum7());
                s.setLong(23, pm.getNum8());
                s.setLong(24, pm.getNum9());
                s.setDouble(25, pm.getDouble0());
                s.setDouble(26, pm.getDouble1());
                s.setDouble(27, pm.getDouble2());
                s.setDouble(28, pm.getDouble3());
                s.setDouble(29, pm.getDouble4());
                s.setDouble(30, pm.getDouble5());
                s.setDouble(31, pm.getDouble6());
                s.setDouble(32, pm.getDouble7());
                s.setDouble(33, pm.getDouble8());
                s.setDouble(34, pm.getDouble9());
                s.setString(35, pm.getString0());
                s.setString(36, pm.getString1());
                s.setString(37, pm.getString2());
                s.setString(38, pm.getString3());
                s.setString(39, pm.getString4());
                s.setString(40, pm.getString5());
                s.setString(41, pm.getString6());
                s.setString(42, pm.getString7());
                s.setString(43, pm.getSubject());
                s.setString(44, pm.getFileName());
                s.setString(45, pm.getComment());
                s.executeUpdate();
                ResultSet rs = s.getGeneratedKeys();
                if (rs.next()) {
                    messagekey = rs.getLong(1);
                }
                messagetype = MESSAGE_POST_TYPE;
            } else if (p.getPost().getMessage() instanceof PostTemplateExt) {
                pe = (PostTemplateExt)p.getPost().getMessage();
                messagekey = ((PostTemplateExt)pe).getId();
                messagetype = MESSAGE_TEMPLATE_TYPE;
            } else if (p.getPost().getMessage() instanceof PostTemplate) {
                PostTemplate pt = (PostTemplate)p.getPost().getMessage();
                PreparedStatement s = Con.getStatement("saveLocalPost1");
                s.setString(1, pt.getTemplateName());
                s.setString(2, pt.getTemplateDescription());
                s.setString(3, pt.getRef0());
                s.setString(4, pt.getRef1());
                s.setString(5, pt.getRef2());
                s.setString(6, pt.getBool0());
                s.setString(7, pt.getBool1());
                s.setString(8, pt.getBool2());
                s.setString(9, pt.getBool3());
                s.setString(10, pt.getBool4());
                s.setString(11, pt.getBool5());
                s.setString(12, pt.getBool6());
                s.setString(13, pt.getBool7());
                s.setString(14, pt.getBool8());
                s.setString(15, pt.getBool9());
                s.setString(16, pt.getNum0());
                s.setString(17, pt.getNum1());
                s.setString(18, pt.getNum2());
                s.setString(19, pt.getNum3());
                s.setString(20, pt.getNum4());
                s.setString(21, pt.getNum5());
                s.setString(22, pt.getNum6());
                s.setString(23, pt.getNum7());
                s.setString(24, pt.getNum8());
                s.setString(25, pt.getNum9());
                s.setString(26, pt.getDouble0());
                s.setString(27, pt.getDouble1());
                s.setString(28, pt.getDouble2());
                s.setString(29, pt.getDouble3());
                s.setString(30, pt.getDouble4());
                s.setString(31, pt.getDouble5());
                s.setString(32, pt.getDouble6());
                s.setString(33, pt.getDouble7());
                s.setString(34, pt.getDouble8());
                s.setString(35, pt.getDouble9());
                s.setString(36, pt.getString0());
                s.setString(37, pt.getString1());
                s.setString(38, pt.getString2());
                s.setString(39, pt.getString3());
                s.setString(40, pt.getString4());
                s.setString(41, pt.getString5());
                s.setString(42, pt.getString6());
                s.setString(43, pt.getString7());
                s.executeUpdate();
                ResultSet rs = s.getGeneratedKeys();
                if (rs.next()) {
                    messagekey = rs.getLong(1);
                }
                messagetype = MESSAGE_TEMPLATE_TYPE;
            }
            PreparedStatement s = Con.getStatement("saveLocalPost2");
            s.setTimestamp(1, this.getSqlDate(p.getLocalDate()));
            s.setString(2, p.getCreator());
            s.setBoolean(3, p.isPushRequested());
            s.setBytes(4, this.getBytes(p.getReceivedFromPeer()));
            s.setLong(5, p.getPeerRank());
            s.setString(6, this.getFileString(p.getLocalFile()));
            s.setBytes(7, this.getBytes(p.getPost().getNetworkId()));
            s.setInt(8, messagetype);
            if (messagekey == null) {
                s.setNull(9, -5);
            } else {
                s.setLong(9, messagekey);
            }
            s.setBytes(10, this.getBytes(p.getPost().getFileReferenceDigest()));
            s.setBoolean(11, p.getPost().isPosterHasFile());
            s.setLong(12, p.getPost().getPostNumber());
            s.setBytes(13, this.getBytes(p.getPost().getSignedDigest().getDigest()));
            s.setBytes(14, this.getBytes(p.getPost().getSignedDigest().getPeerIdentifier()));
            s.setBytes(15, this.getBytes(p.getPost().getSignedDigest().getSignature()));
            if (p.getPost().getRDate() == null) {
                s.setNull(16, 93);
            } else {
                s.setTimestamp(16, this.getSqlDate(p.getPost().getRDate()));
            }
            s.executeUpdate();
            this.Pool.done(Con);
            this.Indexer.indexPost(p, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LocalPost getLocalPostFromRS(ResultSet rs) throws SQLException {
        Post p = new Post();
        LocalPost lp = new LocalPost();
        SignedDigest sg = new SignedDigest();
        p.setSignedDigest(sg);
        lp.setPost(p);
        lp.setLocalDate(this.rsDate(rs, "LOCALDATE"));
        lp.setCreator(rs.getString("CREATOR"));
        lp.setPushRequested(rs.getBoolean("PUSHREQUESTED"));
        lp.setReceivedFromPeer(this.rsBBytes(rs, "RECEIVEDFROMPEER"));
        lp.setPeerRank(rs.getLong("PEERRANK"));
        lp.setLocalFile(this.rsFile(rs, "LOCALFILE"));
        p.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
        int type = rs.getInt("MESSAGETYPE");
        long mid = rs.getLong("MESSAGEID");
        if (mid != 0L) {
            if (type == MESSAGE_POST_TYPE) {
                PostMessage pm = this.getPostMessage(mid);
                p.setMessage(pm);
            }
            if (type == MESSAGE_TEMPLATE_TYPE) {
                PostTemplate pt = this.getPostTemplate(mid);
                p.setMessage(pt);
            }
        }
        p.setFileReferenceDigest(this.rsBBytes(rs, "FILEREFERENCEDIGEST"));
        p.setPosterHasFile(rs.getBoolean("POSTERHASFILE"));
        p.setPostNumber(rs.getLong("POSTNUMBER"));
        p.setRDate(this.rsDate(rs, "RDATE"));
        sg.setDigest(this.rsBBytes(rs, "DIGEST"));
        sg.setPeerIdentifier(this.rsBBytes(rs, "SEERIDENTIFIER"));
        sg.setSignature(this.rsBBytes(rs, "SIGNATURE"));
        return lp;
    }

    private PostTemplate getPostTemplate(long id) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPostTemplate0");
            s.setLong(1, id);
            ResultSet rs = s.executeQuery();
            PostTemplateExt pt = null;
            if (rs.next()) {
                pt = new PostTemplateExt();
                pt.setId(rs.getLong("ID"));
                pt.setTemplateName(rs.getString("TEMPLATENAME"));
                pt.setTemplateDescription(rs.getString("TEMPLATEDESCRIPTION"));
                pt.setRef0(rs.getString("REF0"));
                pt.setRef1(rs.getString("REF1"));
                pt.setRef2(rs.getString("REF2"));
                pt.setBool0(rs.getString("BOOL0"));
                pt.setBool1(rs.getString("BOOL1"));
                pt.setBool2(rs.getString("BOOL2"));
                pt.setBool3(rs.getString("BOOL3"));
                pt.setBool4(rs.getString("BOOL4"));
                pt.setBool5(rs.getString("BOOL5"));
                pt.setBool6(rs.getString("BOOL6"));
                pt.setBool7(rs.getString("BOOL7"));
                pt.setBool8(rs.getString("BOOL8"));
                pt.setBool9(rs.getString("BOOL9"));
                pt.setNum0(rs.getString("NUM0"));
                pt.setNum1(rs.getString("NUM1"));
                pt.setNum2(rs.getString("NUM2"));
                pt.setNum3(rs.getString("NUM3"));
                pt.setNum4(rs.getString("NUM4"));
                pt.setNum5(rs.getString("NUM5"));
                pt.setNum6(rs.getString("NUM6"));
                pt.setNum7(rs.getString("NUM7"));
                pt.setNum8(rs.getString("NUM8"));
                pt.setNum9(rs.getString("NUM9"));
                pt.setDouble0(rs.getString("DOUBLE0"));
                pt.setDouble1(rs.getString("DOUBLE1"));
                pt.setDouble2(rs.getString("DOUBLE2"));
                pt.setDouble3(rs.getString("DOUBLE3"));
                pt.setDouble4(rs.getString("DOUBLE4"));
                pt.setDouble5(rs.getString("DOUBLE5"));
                pt.setDouble6(rs.getString("DOUBLE6"));
                pt.setDouble7(rs.getString("DOUBLE7"));
                pt.setDouble8(rs.getString("DOUBLE8"));
                pt.setDouble9(rs.getString("DOUBLE9"));
                pt.setString0(rs.getString("STRING0"));
                pt.setString1(rs.getString("STRING1"));
                pt.setString2(rs.getString("STRING2"));
                pt.setString3(rs.getString("STRING3"));
                pt.setString4(rs.getString("STRING4"));
                pt.setString5(rs.getString("STRING5"));
                pt.setString6(rs.getString("STRING6"));
                pt.setString7(rs.getString("STRING7"));
                this.Pool.done(Con);
                return pt;
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private PostMessage getPostMessage(long id) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPostMessage0");
            s.setLong(1, id);
            ResultSet rs = s.executeQuery();
            if (rs.next()) {
                PostMessage pm = new PostMessage();
                byte[] b = rs.getBytes("REF0");
                if (b != null) {
                    pm.setRef0(new BBytes(b));
                }
                if ((b = rs.getBytes("REF1")) != null) {
                    pm.setRef1(new BBytes(b));
                }
                if ((b = rs.getBytes("REF2")) != null) {
                    pm.setRef2(new BBytes(b));
                }
                if ((b = rs.getBytes("USETEMPLATE")) != null) {
                    pm.setUseTemplate(new BBytes(b));
                }
                pm.setBool0(rs.getBoolean("BOOL0"));
                pm.setBool1(rs.getBoolean("BOOL1"));
                pm.setBool2(rs.getBoolean("BOOL2"));
                pm.setBool3(rs.getBoolean("BOOL3"));
                pm.setBool4(rs.getBoolean("BOOL4"));
                pm.setBool5(rs.getBoolean("BOOL5"));
                pm.setBool6(rs.getBoolean("BOOL6"));
                pm.setBool7(rs.getBoolean("BOOL7"));
                pm.setBool8(rs.getBoolean("BOOL8"));
                pm.setBool9(rs.getBoolean("BOOL9"));
                pm.setNum0(rs.getLong("NUM0"));
                pm.setNum1(rs.getLong("NUM1"));
                pm.setNum2(rs.getLong("NUM2"));
                pm.setNum3(rs.getLong("NUM3"));
                pm.setNum4(rs.getLong("NUM4"));
                pm.setNum5(rs.getLong("NUM5"));
                pm.setNum6(rs.getLong("NUM6"));
                pm.setNum7(rs.getLong("NUM7"));
                pm.setNum8(rs.getLong("NUM8"));
                pm.setNum9(rs.getLong("NUM9"));
                pm.setDouble0(rs.getDouble("DOUBLE0"));
                pm.setDouble1(rs.getDouble("DOUBLE1"));
                pm.setDouble2(rs.getDouble("DOUBLE2"));
                pm.setDouble3(rs.getDouble("DOUBLE3"));
                pm.setDouble4(rs.getDouble("DOUBLE4"));
                pm.setDouble5(rs.getDouble("DOUBLE5"));
                pm.setDouble6(rs.getDouble("DOUBLE6"));
                pm.setDouble7(rs.getDouble("DOUBLE7"));
                pm.setDouble8(rs.getDouble("DOUBLE8"));
                pm.setDouble9(rs.getDouble("DOUBLE9"));
                pm.setString0(rs.getString("STRING0"));
                pm.setString1(rs.getString("STRING1"));
                pm.setString2(rs.getString("STRING2"));
                pm.setString3(rs.getString("STRING3"));
                pm.setString4(rs.getString("STRING4"));
                pm.setString5(rs.getString("STRING5"));
                pm.setString6(rs.getString("STRING6"));
                pm.setString7(rs.getString("STRING7"));
                pm.setSubject(rs.getString("SUBJECT"));
                pm.setFileName(rs.getString("FILENAME"));
                pm.setComment(rs.getString("COMMENT"));
                this.Pool.done(Con);
                return pm;
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<LocalPost> getPosts(int max) {
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPosts1");
            s.setInt(1, max);
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPostFromRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalPost> getPostsReferencingFile(BBytes netid, BBytes dig) {
        LinkedList<LocalPost> r = new LinkedList<LocalPost>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPostsReferencingFile");
            s.setBytes(1, this.getBytes(netid));
            s.setBytes(2, this.getBytes(dig));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalPostFromRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public void saveLocalNetwork(LocalNetwork nw) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveLocalNetwork0");
            s.setTimestamp(1, this.getSqlDate(nw.getLocalDate()));
            s.setBoolean(2, nw.isPushRequested());
            s.setBytes(3, this.getBytes(nw.getReceivedFromPeer()));
            s.setString(4, nw.getCreator());
            s.setBoolean(5, nw.isAuthorized());
            s.setInt(6, nw.getAuthorization());
            s.setString(7, nw.getNetwork().getTitle());
            s.setString(8, nw.getNetwork().getDescription());
            s.setLong(9, nw.getNetwork().getNetworkNumber());
            s.setBytes(10, this.getBytes(nw.getNetwork().getSignature().getDigest()));
            s.setBytes(11, this.getBytes(nw.getNetwork().getSignature().getPeerIdentifier()));
            s.setBytes(12, this.getBytes(nw.getNetwork().getSignature().getSignature()));
            this.saveDate(s, 13, nw.getNetwork().getRDate());
            s.setInt(14, nw.getPeerRank());
            if (nw.getNetwork().getPublic() == null) {
                s.setNull(15, 16);
            } else {
                s.setBoolean(15, nw.getNetwork().getPublic());
            }
            s.setBoolean(16, nw.isSubscribed());
            s.executeUpdate();
            this.Pool.done(Con);
            this.Indexer.indexNetwork(nw, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LocalNetwork getLocalNetworkRS(ResultSet rs) throws SQLException {
        Network n = new Network();
        LocalNetwork ln = new LocalNetwork();
        SignedDigest sg = new SignedDigest();
        n.setSignature(sg);
        ln.setNetwork(n);
        ln.setLocalDate(this.rsDate(rs, "LOCALDATE"));
        ln.setPushRequseted(rs.getBoolean("PUSHREQUESTED"));
        ln.setReceivedFromPeer(this.rsBBytes(rs, "RECEIVEDFROMPEER"));
        ln.setCreator(rs.getString("CREATOR"));
        ln.setAuthorized(rs.getBoolean("AUTHORIZED"));
        ln.setAuthorization(rs.getInt("AUTHORIZATION"));
        ln.setPeerRank(rs.getInt("PEERRANK"));
        n.setTitle(rs.getString("TITLE"));
        n.setDescription(rs.getString("DESCRIPTION"));
        n.setNetworkNumber(rs.getLong("NETWORKNUMBER"));
        n.setRDate(this.rsDate(rs, "RDATE"));
        sg.setDigest(this.rsBBytes(rs, "DIGEST"));
        sg.setPeerIdentifier(this.rsBBytes(rs, "SEERIDENTIFIER"));
        sg.setSignature(this.rsBBytes(rs, "SIGNATURE"));
        n.setPublic(rs.getBoolean("PUBLIC"));
        ln.setSubscribed(rs.getBoolean("SUBSCRIBED"));
        if (rs.wasNull()) {
            n.setPublic(null);
        }
        return ln;
    }

    @Override
    public LocalNetwork getLocalNetwork(BBytes id) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalNetwork");
            s.setBytes(1, this.getBytes(id));
            ResultSet rs = s.executeQuery();
            LocalNetwork ln = null;
            if (rs.next()) {
                ln = this.getLocalNetworkRS(rs);
            }
            this.Pool.done(Con);
            return ln;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void saveLocalPublicPost(LocalPublicPost pp) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveLocalPublicPost0");
            s.setTimestamp(1, this.getSqlDate(pp.getLocalDate()));
            s.setBoolean(2, pp.isPrivateMessage());
            s.setString(3, (String)pp.getDecodedMessage());
            if (pp.getPublicPost().getMessage() instanceof String) {
                s.setString(3, (String)pp.getPublicPost().getMessage());
                pp.setDecodedMessage((String)pp.getPublicPost().getMessage());
            }
            s.setBoolean(4, pp.isPushRequsted());
            s.setBytes(5, this.getBytes(pp.getReceivedFromPeer()));
            s.setString(6, pp.getCreator());
            s.setString(7, pp.getToPeer());
            s.setString(8, pp.getNetworkTitle());
            s.setBytes(9, this.getBytes(pp.getPublicPost().getNetworkId()));
            if (pp.getPublicPost().getMessage() instanceof BBytes) {
                s.setBytes(10, this.getBytes((BBytes)pp.getPublicPost().getMessage()));
            } else {
                s.setBytes(10, null);
            }
            s.setBoolean(11, pp.getPublicPost().isEncrypted());
            s.setLong(12, pp.getPublicPost().getPostNumber());
            s.setBytes(13, this.getBytes(pp.getPublicPost().getSignature().getDigest()));
            s.setBytes(14, this.getBytes(pp.getPublicPost().getSignature().getPeerIdentifier()));
            s.setBytes(15, this.getBytes(pp.getPublicPost().getSignature().getSignature()));
            if (pp.getPublicPost().getRDate() == null) {
                s.setNull(16, 93);
            } else {
                s.setTimestamp(16, this.getSqlDate(pp.getPublicPost().getRDate()));
            }
            s.setInt(17, pp.getPeerRank());
            s.executeUpdate();
            this.Pool.done(Con);
            this.Indexer.indexPublicPost(pp, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LocalPublicPost getLocalPublicPostRS(ResultSet rs) throws SQLException {
        PublicPost p = new PublicPost();
        LocalPublicPost lp = new LocalPublicPost();
        lp.setPublicPost(p);
        SignedDigest sg = new SignedDigest();
        p.setSignature(sg);
        lp.setLocalDate(this.rsDate(rs, "LOCALDATE"));
        lp.setPrivateMessage(rs.getBoolean("PRIVATEMESSAGE"));
        lp.setDecodedMessage(rs.getString("DECODEDMESSAGE"));
        lp.setPushRequsted(rs.getBoolean("PUSHREQUSTED"));
        lp.setReceivedFromPeer(this.rsBBytes(rs, "RECEIVEDFROMPEER"));
        lp.setCreator(rs.getString("CREATOR"));
        lp.setToPeer(rs.getString("TOPEER"));
        lp.setNetworkTitle(rs.getString("NETWORKTITLE"));
        lp.setPeerRank(rs.getInt("PEERRANK"));
        p.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
        p.setMessage(this.rsBBytes(rs, "ENCMESSAGE"));
        p.setRDate(this.rsDate(rs, "RDATE"));
        if (p.getMessage() == null) {
            p.setMessage(lp.getDecodedMessage());
        }
        p.setEncrypted(rs.getBoolean("ENCRYPTED"));
        p.setPostNumber(rs.getLong("POSTNUMBER"));
        sg.setDigest(this.rsBBytes(rs, "DIGEST"));
        sg.setPeerIdentifier(this.rsBBytes(rs, "SEERIDENTIFIER"));
        sg.setSignature(this.rsBBytes(rs, "SIGNATURE"));
        return lp;
    }

    @Override
    public void saveFileStatus(FileStatus f) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveFileStatus0");
            s.setBytes(1, this.getBytes(f.getNetworkId()));
            s.setString(2, this.getFileString(f.getFile()));
            s.setBytes(3, this.getBytes(f.getMetaFileDigest()));
            s.setLong(4, f.getMetaFileSize());
            s.setBytes(5, this.getBytes(f.getCompleteDigest()));
            s.setBytes(6, this.getBytes(f.getPeerId()));
            s.setLong(7, f.getTotalFileSize());
            s.setBytes(8, this.getBytes(f.getMasterPost()));
            s.setLong(9, f.getPriority());
            s.setLong(10, f.getNumberParts());
            s.setLong(11, f.getNumberPending());
            s.setLong(12, f.getNumberPartsPresent());
            s.setLong(13, f.getPiecePostsFound());
            s.setBoolean(14, f.isCorrupted());
            if (f.getRequestDate() == null) {
                s.setNull(15, 93);
            } else {
                s.setTimestamp(15, this.getSqlDate(f.getRequestDate()));
            }
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FileStatus getFileStatusRS(ResultSet rs) throws SQLException {
        FileStatus fs = new FileStatus();
        fs.setNetworkId(this.rsBBytes(rs, "NETWORKID"));
        fs.setFile(this.rsFile(rs, "FILE"));
        fs.setMetaFileDigest(this.rsBBytes(rs, "METAFILEDIGEST"));
        fs.setMetaFileSize(rs.getLong("METAFILESIZE"));
        fs.setCompleteDigest(this.rsBBytes(rs, "COMPLETEDIGEST"));
        fs.setPeerId(this.rsBBytes(rs, "PEERID"));
        fs.setTotalFileSize(rs.getLong("TOTALFILESIZE"));
        fs.setMasterPost(this.rsBBytes(rs, "MASTERPOST"));
        fs.setPriority(rs.getLong("PRIORITY"));
        fs.setNumberParts(rs.getLong("NUMBERPARTS"));
        fs.setNumberPending(rs.getLong("NUMBERPENDING"));
        fs.setNumberPartsPresent(rs.getLong("NUMBERPARTSPRESENT"));
        fs.setPiecePostsFound(rs.getLong("PIECEPOSTSFOUND"));
        fs.setCorrupted(rs.getBoolean("CORRUPTED"));
        fs.setRequestDate(this.rsDate(rs, "RDATE"));
        return fs;
    }

    @Override
    public List<FileStatus> getFileStatusList() {
        LinkedList<FileStatus> r = new LinkedList<FileStatus>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFileStatusList");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getFileStatusRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public FileStatus getFileStatus(File f) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFileStatus0");
            s.setString(1, this.getFileString(f));
            ResultSet rs = s.executeQuery();
            FileStatus fils = null;
            if (rs.next()) {
                fils = this.getFileStatusRS(rs);
            }
            this.Pool.done(Con);
            return fils;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public FileStatus getFileStatus(BBytes networkid, BBytes metafiledig) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getFileStatus0");
            s.setBytes(1, this.getBytes(networkid));
            s.setBytes(2, this.getBytes(metafiledig));
            ResultSet rs = s.executeQuery();
            FileStatus fils = null;
            if (rs.next()) {
                fils = this.getFileStatusRS(rs);
            }
            this.Pool.done(Con);
            return fils;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void deleteFileStatus(FileStatus fs) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("deleteFileStatus");
            s.setBytes(1, this.getBytes(fs.getNetworkId()));
            s.setBytes(2, this.getBytes(fs.getMetaFileDigest()));
            s.executeUpdate();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveSearchQuery(SearchQuery sq) {
        try {
            PreparedStatement s;
            ConnectionStatements Con = this.Pool.getCon();
            long id = 0L;
            if (sq instanceof SearchQueryExt) {
                SearchQueryExt sqe = (SearchQueryExt)sq;
                id = sqe.getId();
                PreparedStatement preparedStatement = Con.getStatement("saveSearchQuery0");
                preparedStatement.setString(1, sq.QueryName);
                preparedStatement.setInt(2, sq.MaxResults);
                preparedStatement.setString(3, sq.SortBy);
                preparedStatement.setBoolean(4, sq.SortReverse);
                preparedStatement.setString(5, sq.AdvancedQueryString);
                preparedStatement.setBytes(6, this.getBytes(sq.Network));
                preparedStatement.setBytes(7, this.getBytes(sq.PeerId));
                preparedStatement.setString(8, sq.Generalterms);
                if (sq.Template == null) {
                    preparedStatement.setNull(9, 16);
                } else {
                    preparedStatement.setBoolean(9, sq.Template);
                }
                preparedStatement.setBytes(10, this.getBytes(sq.Refs0));
                preparedStatement.setBytes(11, this.getBytes(sq.Refs1));
                preparedStatement.setBytes(12, this.getBytes(sq.Refs2));
                preparedStatement.setBytes(13, this.getBytes(sq.UseTemplate));
                preparedStatement.setBytes(14, this.getBytes(sq.Directref));
                preparedStatement.setBoolean(15, sq.Excludefilesreferencedbyothers0);
                preparedStatement.setBoolean(16, sq.Includefileswithreferences0);
                preparedStatement.setBoolean(17, sq.Excludefilesreferencedbyothers1);
                preparedStatement.setBoolean(18, sq.Includefileswithreferences1);
                preparedStatement.setBoolean(19, sq.Excludefilesreferencedbyothers2);
                preparedStatement.setBoolean(20, sq.Includefileswithreferences2);
                if (sq.Minpeerrank != null) {
                    preparedStatement.setLong(21, sq.Minpeerrank);
                } else {
                    preparedStatement.setNull(21, 4);
                }
                preparedStatement.setTimestamp(22, this.getSqlDate(sq.Fromdate));
                preparedStatement.setTimestamp(23, this.getSqlDate(sq.Todate));
                if (sq.DaysBack != null) {
                    preparedStatement.setInt(24, sq.DaysBack);
                } else {
                    preparedStatement.setNull(24, -5);
                }
                preparedStatement.setBoolean(25, sq.OnlyLocalFile);
                preparedStatement.setBoolean(26, sq.HideOpened);
                preparedStatement.setLong(27, id);
                preparedStatement.executeUpdate();
            } else {
                s = Con.getStatement("saveSearchQuery1");
                s.setString(1, sq.QueryName);
                s.setInt(2, sq.MaxResults);
                s.setString(3, sq.SortBy);
                s.setBoolean(4, sq.SortReverse);
                s.setString(5, sq.AdvancedQueryString);
                s.setBytes(6, this.getBytes(sq.Network));
                s.setBytes(7, this.getBytes(sq.PeerId));
                s.setString(8, sq.Generalterms);
                if (sq.Template == null) {
                    s.setNull(9, 16);
                } else {
                    s.setBoolean(9, sq.Template);
                }
                s.setBytes(10, this.getBytes(sq.Refs0));
                s.setBytes(11, this.getBytes(sq.Refs1));
                s.setBytes(12, this.getBytes(sq.Refs2));
                s.setBytes(13, this.getBytes(sq.UseTemplate));
                s.setBytes(14, this.getBytes(sq.Directref));
                s.setBoolean(15, sq.Excludefilesreferencedbyothers0);
                s.setBoolean(16, sq.Includefileswithreferences0);
                s.setBoolean(17, sq.Excludefilesreferencedbyothers1);
                s.setBoolean(18, sq.Includefileswithreferences1);
                s.setBoolean(19, sq.Excludefilesreferencedbyothers2);
                s.setBoolean(20, sq.Includefileswithreferences2);
                if (sq.Minpeerrank != null) {
                    s.setLong(21, sq.Minpeerrank);
                } else {
                    s.setNull(21, 4);
                }
                s.setTimestamp(22, this.getSqlDate(sq.Fromdate));
                s.setTimestamp(23, this.getSqlDate(sq.Todate));
                if (sq.DaysBack != null) {
                    s.setInt(24, sq.DaysBack);
                } else {
                    s.setNull(24, -5);
                }
                s.setBoolean(25, sq.OnlyLocalFile);
                s.setBoolean(26, sq.HideOpened);
                s.executeUpdate();
                ResultSet resultSet = s.getGeneratedKeys();
                if (resultSet.next()) {
                    id = resultSet.getLong(1);
                }
            }
            s = Con.getStatement("saveSearchQuery2");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Searchterms != null) {
                for (Map.Entry<String, String> entry : sq.Searchterms.entrySet()) {
                    s = Con.getStatement("saveSearchQuery3");
                    s.setLong(1, id);
                    s.setString(2, entry.getKey());
                    s.setString(3, entry.getValue());
                    s.executeUpdate();
                }
            }
            s = Con.getStatement("saveSearchQuery4");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Ortruebools != null) {
                for (String string : sq.Ortruebools) {
                    s = Con.getStatement("saveSearchQuery5");
                    s.setLong(1, id);
                    s.setString(2, string);
                    s.executeUpdate();
                }
            }
            s = Con.getStatement("saveSearchQuery6");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Andtruebools != null) {
                for (String string : sq.Andtruebools) {
                    s = Con.getStatement("saveSearchQuery7");
                    s.setLong(1, id);
                    s.setString(2, string);
                    s.executeUpdate();
                }
            }
            s = Con.getStatement("saveSearchQuery8");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Lessthan != null) {
                for (Map.Entry entry : sq.Lessthan.entrySet()) {
                    s = Con.getStatement("saveSearchQuery9");
                    s.setLong(1, id);
                    s.setString(2, (String)entry.getKey());
                    s.setLong(3, (Long)entry.getValue());
                    s.executeUpdate();
                }
            }
            s = Con.getStatement("saveSearchQuery10");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Greaterthan != null) {
                for (Map.Entry entry : sq.Greaterthan.entrySet()) {
                    s = Con.getStatement("saveSearchQuery11");
                    s.setLong(1, id);
                    s.setString(2, (String)entry.getKey());
                    s.setLong(3, (Long)entry.getValue());
                    s.executeUpdate();
                }
            }
            s = Con.getStatement("saveSearchQuery12");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Dlessthan != null) {
                for (Map.Entry entry : sq.Dlessthan.entrySet()) {
                    s = Con.getStatement("saveSearchQuery13");
                    s.setLong(1, id);
                    s.setString(2, (String)entry.getKey());
                    s.setDouble(3, (Double)entry.getValue());
                    s.executeUpdate();
                }
            }
            s = Con.getStatement("saveSearchQuery14");
            s.setLong(1, id);
            s.executeUpdate();
            if (sq.Dgreaterthan != null) {
                for (Map.Entry entry : sq.Dgreaterthan.entrySet()) {
                    s = Con.getStatement("saveSearchQuery15");
                    s.setLong(1, id);
                    s.setString(2, (String)entry.getKey());
                    s.setDouble(3, (Double)entry.getValue());
                    s.executeUpdate();
                }
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteSearchQuery(SearchQuery sq) {
        if (sq instanceof SearchQueryExt) {
            SearchQueryExt se = (SearchQueryExt)sq;
            try {
                ConnectionStatements Con = this.Pool.getCon();
                PreparedStatement s = Con.getStatement("deleteSearchQuery0");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery1");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery2");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery3");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery4");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery5");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery6");
                s.setLong(1, se.getId());
                s.executeUpdate();
                s = Con.getStatement("deleteSearchQuery7");
                s.setLong(1, se.getId());
                s.executeUpdate();
                this.Pool.done(Con);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("Cannot delete a search query not saved!");
        }
    }

    @Override
    public List<SearchQuery> getSearchQuerys(BBytes networkid) {
        LinkedList<SearchQuery> r = new LinkedList<SearchQuery>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getSearchQuerys0");
            s.setBytes(1, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                String k;
                SearchQueryExt sq = new SearchQueryExt();
                sq.setId(rs.getLong("ID"));
                sq.QueryName = rs.getString("QUERYNAME");
                sq.MaxResults = rs.getInt("MAXRESULTS");
                sq.SortBy = rs.getString("SORTBY");
                sq.SortReverse = rs.getBoolean("SORTREVERSE");
                sq.AdvancedQueryString = rs.getString("ADVANCEDQUERYSTRING");
                sq.Network = this.rsBBytes(rs, "NETWORK");
                sq.PeerId = this.rsBBytes(rs, "PEERID");
                sq.Generalterms = rs.getString("GENERALTERMS");
                sq.Template = rs.getBoolean("TEMPLATE");
                if (rs.wasNull()) {
                    sq.Template = null;
                }
                sq.Refs0 = this.rsBBytes(rs, "REFS0");
                sq.Refs1 = this.rsBBytes(rs, "REFS1");
                sq.Refs2 = this.rsBBytes(rs, "REFS2");
                sq.UseTemplate = this.rsBBytes(rs, "USETEMPLATE");
                sq.Directref = this.rsBBytes(rs, "DIRECTREF");
                sq.Excludefilesreferencedbyothers0 = rs.getBoolean("EXCLUDEFILESREFERENCEDBYOTHERS0");
                sq.Includefileswithreferences0 = rs.getBoolean("INCLUDEFILESWITHREFERENCES0");
                sq.Excludefilesreferencedbyothers1 = rs.getBoolean("EXCLUDEFILESREFERENCEDBYOTHERS1");
                sq.Includefileswithreferences1 = rs.getBoolean("INCLUDEFILESWITHREFERENCES1");
                sq.Excludefilesreferencedbyothers2 = rs.getBoolean("EXCLUDEFILESREFERENCEDBYOTHERS2");
                sq.Includefileswithreferences2 = rs.getBoolean("INCLUDEFILESWITHREFERENCES2");
                sq.Minpeerrank = rs.getLong("MINPEERRANK");
                if (rs.wasNull()) {
                    sq.Minpeerrank = null;
                }
                sq.Fromdate = this.rsDate(rs, "FROMDATE");
                sq.Todate = this.rsDate(rs, "TODATE");
                sq.DaysBack = rs.getInt("DAYSBACK");
                if (rs.wasNull()) {
                    sq.DaysBack = null;
                }
                sq.HideOpened = rs.getBoolean("HIDEOPENED");
                sq.OnlyLocalFile = rs.getBoolean("ONLYLOCAL");
                s = Con.getStatement("getSearchQuerys1");
                s.setLong(1, sq.getId());
                ResultSet rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Searchterms == null) {
                        sq.Searchterms = new HashMap();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    String v = rsn.getString("SEARCHSTRING");
                    sq.Searchterms.put(k, v);
                }
                s = Con.getStatement("getSearchQuerys2");
                s.setLong(1, sq.getId());
                rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Ortruebools == null) {
                        sq.Ortruebools = new HashSet();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    sq.Ortruebools.add(k);
                }
                s = Con.getStatement("getSearchQuerys3");
                s.setLong(1, sq.getId());
                rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Andtruebools == null) {
                        sq.Andtruebools = new HashSet();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    sq.Andtruebools.add(k);
                }
                s = Con.getStatement("getSearchQuerys4");
                s.setLong(1, sq.getId());
                rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Lessthan == null) {
                        sq.Lessthan = new HashMap();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    long v = rsn.getLong("NUMVALUE");
                    sq.Lessthan.put(k, v);
                }
                s = Con.getStatement("getSearchQuerys5");
                s.setLong(1, sq.getId());
                rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Greaterthan == null) {
                        sq.Greaterthan = new HashMap();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    long v = rsn.getLong("NUMVALUE");
                    sq.Greaterthan.put(k, v);
                }
                s = Con.getStatement("getSearchQuerys6");
                s.setLong(1, sq.getId());
                rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Dlessthan == null) {
                        sq.Dlessthan = new HashMap();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    double v = rsn.getDouble("NUMVALUE");
                    sq.Dlessthan.put(k, v);
                }
                s = Con.getStatement("getSearchQuerys7");
                s.setLong(1, sq.getId());
                rsn = s.executeQuery();
                while (rsn.next()) {
                    if (sq.Dgreaterthan == null) {
                        sq.Dgreaterthan = new HashMap();
                    }
                    k = rsn.getString("TEMPLATESTRING");
                    double v = rsn.getDouble("NUMVALUE");
                    sq.Dgreaterthan.put(k, v);
                }
                r.add(sq);
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<BBytes> getAllNetworksForUpgrade() {
        LinkedList<BBytes> r = new LinkedList<BBytes>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getAllNetworksForUpgrade");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.rsBBytes(rs, "DIGEST"));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<BBytes> getAllPublicPostsForUpgrade() {
        LinkedList<BBytes> r = new LinkedList<BBytes>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getAllPublicPostsForUpgrade");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.rsBBytes(rs, "DIGEST"));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<BBytes> getAllPostsForUpgrade() {
        LinkedList<BBytes> r = new LinkedList<BBytes>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getAllPostsForUpgrade");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.rsBBytes(rs, "DIGEST"));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<BBytes> getLocalNetworksFromPeer(BBytes peerid) {
        LinkedList<BBytes> r = new LinkedList<BBytes>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalNetworksFromPeer");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.rsBBytes(rs, "DIGEST"));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<BBytes> getLocalPublicPostsFromPeer(BBytes peerid) {
        LinkedList<BBytes> r = new LinkedList<BBytes>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getLocalPublicPostsFromPeer");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.rsBBytes(rs, "DIGEST"));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePost(LocalPost post) {
        try {
            DataBaseLuceneIndexer dataBaseLuceneIndexer = this.Indexer;
            synchronized (dataBaseLuceneIndexer) {
                this.Indexer.deletePostFromIndex(post);
            }
            ConnectionStatements Con = this.Pool.getCon();
            if (post.getPost().getMessage() != null) {
                PreparedStatement s;
                if (post.getPost().getMessage() instanceof PostMessageExt) {
                    PostMessageExt pm = (PostMessageExt)post.getPost().getMessage();
                    s = Con.getStatement("deletePost0");
                    s.setLong(1, pm.getId());
                    s.execute();
                }
                if (post.getPost().getMessage() instanceof PostTemplateExt) {
                    PostTemplateExt pt = (PostTemplateExt)post.getPost().getMessage();
                    s = Con.getStatement("deletePost1");
                    s.setLong(1, pt.getId());
                    s.execute();
                }
            }
            PreparedStatement s = Con.getStatement("deletePost2");
            s.setBytes(1, this.getBytes(post.getPost().getSignedDigest().getDigest()));
            s.execute();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveLocalSubscription(LocalSubscribe sub) {
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("saveLocalSubscription0");
            s.setTimestamp(1, this.getSqlDate(sub.getLocalDate()));
            s.setBoolean(2, sub.isMarkedBad());
            this.saveDate(s, 3, sub.getMarkedBadDate());
            s.setLong(4, sub.getNumberOfNewPosts());
            this.saveDate(s, 5, sub.getLastNewPost());
            s.setBoolean(6, sub.isRequestPosts());
            this.saveDate(s, 7, sub.getRequestPostsTime());
            s.setLong(8, sub.getRequestPostsPriority());
            s.setBoolean(9, sub.isRequestPostsDispatched());
            this.saveDate(s, 10, sub.getRequestPostsDispatchedTime());
            s.setLong(11, sub.getLastPostNumber());
            s.setLong(12, sub.getNumberOfNewSubs());
            this.saveDate(s, 13, sub.getLastNewSubs());
            s.setBoolean(14, sub.isRequestSubs());
            this.saveDate(s, 15, sub.getRequestSubsTime());
            s.setLong(16, sub.getRequestSubsPriority());
            s.setBoolean(17, sub.isRequestSubsDispatched());
            this.saveDate(s, 18, sub.getRequestSubsDispatchedTime());
            s.setLong(19, sub.getSubscription().getSubNumber());
            s.setLong(20, sub.getNumberOfFiles());
            this.saveDate(s, 21, sub.getLastNewFile());
            s.setLong(22, sub.getPeerRank());
            s.setBoolean(23, sub.isPushRequested());
            s.setBoolean(24, sub.getSubscription().isSubscribe());
            s.setBytes(25, this.getBytes(sub.getReceivedFromPeer()));
            s.setString(26, sub.getNetworkName());
            s.setString(27, sub.getCreator());
            this.saveBBytes(s, 28, sub.getSubscription().getNetworkID());
            this.saveBBytes(s, 29, sub.getSubscription().getSignature().getDigest());
            this.saveBBytes(s, 30, sub.getSubscription().getSignature().getPeerIdentifier());
            this.saveBBytes(s, 31, sub.getSubscription().getSignature().getSignature());
            this.saveDate(s, 32, sub.getSubscription().getRDate());
            s.execute();
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<LocalSubscribe> getOrderedSubsRequestedNotDispatched() {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedSubsRequestedNotDispatched");
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getPeerPossibleNetworkSubscriptions(BBytes peerid) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeerPossibleNetworkSubscriptions");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getPeerNetworkSubscriptions(BBytes peerid) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getPeerNetworkSubscriptions");
            s.setBytes(1, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getAllNetworkSubscriptions(BBytes networkid) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getAllNetworkSubscriptions");
            s.setBytes(1, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getNextSubscribePush(BBytes networkid) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getNextSubscribePush");
            s.setBytes(1, this.getBytes(networkid));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public LocalSubscribe getSubscription(BBytes networkid, BBytes peerid) {
        LocalSubscribe r = null;
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getSubscription");
            s.setBytes(1, this.getBytes(networkid));
            s.setBytes(2, this.getBytes(peerid));
            ResultSet rs = s.executeQuery();
            if (rs.next()) {
                r = this.getLocalSubscribeRS(rs);
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    @Override
    public List<LocalSubscribe> getOrderedMostSubsLastDate(BBytes netid, Date lastdate) {
        LinkedList<LocalSubscribe> r = new LinkedList<LocalSubscribe>();
        try {
            ConnectionStatements Con = this.Pool.getCon();
            PreparedStatement s = Con.getStatement("getOrderedMostSubsLastDate");
            s.setBytes(1, this.getBytes(netid));
            s.setTimestamp(2, this.getSqlDate(lastdate));
            ResultSet rs = s.executeQuery();
            while (rs.next()) {
                r.add(this.getLocalSubscribeRS(rs));
            }
            this.Pool.done(Con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public class NetworkAuthHolesExt
    extends NetworkAuthHoles {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public class NetworkHolesExt
    extends NetworkHoles {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public class PostHolesExt
    extends PostHoles {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public class PostMessageExt
    extends PostMessage {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public class PostTemplateExt
    extends PostTemplate {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public class PublicPostHolesExt
    extends PublicPostHoles {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public class SearchQueryExt
    extends SearchQuery {
        private long id;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }
}

