/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.ourfilesystem.com.ComConnectionInterface;
import org.ourfilesystem.core.CoreComInterface;
import org.ourfilesystem.core.CoreUserInterface;
import org.ourfilesystem.core.EventInterface;
import org.ourfilesystem.db.DataBaseCoreInterface;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.TimeInterface;
import org.ourfilesystem.db.so.FileReference;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.db.so.LocalPublicPost;
import org.ourfilesystem.db.so.LocalSubscribe;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.db.so.Network;
import org.ourfilesystem.db.so.NetworkAuthorization;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.db.so.PeerHasFile;
import org.ourfilesystem.db.so.Post;
import org.ourfilesystem.db.so.PostHoles;
import org.ourfilesystem.db.so.PostTemplate;
import org.ourfilesystem.db.so.PublicPost;
import org.ourfilesystem.db.so.SearchQuery;
import org.ourfilesystem.db.so.Subscribe;
import org.ourfilesystem.security.CryptoDataBaseInterface;
import org.ourfilesystem.security.KeySet;
import org.ourfilesystem.security.SignedDigest;
import org.ourfilesystem.utilities.BBytes;
import org.ourfilesystem.utilities.DumbMIME;
import org.ourfilesystem.utilities.FileUtils;

public class CoreUserImpl
implements CoreUserInterface {
    public static final Logger Log = Logger.getLogger(CoreUserImpl.class.getName());
    public static int MY_RANK = 100;
    private DataBaseCoreInterface CoreDB;
    private CryptoDataBaseInterface Crypto;
    private TimeInterface Time;
    private EventInterface Event;
    private CoreComInterface CoreCom;
    private File TemplateDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(BBytes network, BBytes digest, File f, long offset, long size, boolean template, long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            FileReference fr = this.CoreDB.getFile(network, digest, f, offset, size);
            if (fr == null) {
                Log.info("FileReference did not already exist.  Creating.");
                fr = new FileReference();
                fr.setNetworkId(new BBytes(network));
                fr.setUnsignedDigest(new BBytes(digest));
                fr.setLocalDate(this.Time.getTime());
                fr.setOffset(offset);
                fr.setSize(size);
                fr.setFile(new File(f.getPath()));
            } else {
                Log.info("FileReference already existed.");
            }
            File of = fr.getFile();
            if (of != null && of.exists()) {
                Log.info("File already existed.  Checking if it's already got the correct data.");
                BBytes tdig = this.Crypto.digestFile(of, offset, size);
                if (tdig.equals(digest)) {
                    Log.info("The existing file already had the correct data.");
                    if (this.Event != null) {
                        this.Event.newFileDownloaded(fr);
                    }
                    return;
                }
            }
            List<FileReference> fr2 = this.CoreDB.getFiles(network, digest);
            for (FileReference of2 : fr2) {
                BBytes tdig;
                File tf2 = of2.getFile();
                if (!tf2.exists() || !(tdig = this.Crypto.digestFile(tf2, of2.getOffset(), of2.getSize())).equals(digest) || of2.getSize() != size) continue;
                try {
                    FileUtils.copyFile(tf2, of, of2.getOffset(), offset, size);
                    Log.info("Copied from another file already in the network.");
                    if (this.Event != null) {
                        this.Event.newFileDownloaded(fr);
                    }
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Log.info("The file does not exist, or the data is not correct.  Request download.");
            fr.setUserRequested(true);
            fr.setUserRequestDispatched(false);
            fr.setUserRequestTime(this.Time.getTime());
            fr.setUserRequestPriority(priority);
            this.CoreDB.saveFileReference(fr);
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeers(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalPeer> plst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : plst) {
                if (lp.getPeer().getIdentity().equals(me)) continue;
                lp.setRequestPeers(true);
                lp.setRequestPeersPriority(priority);
                lp.setRequestPeersTime(this.Time.getTime());
                this.CoreDB.saveLocalPeer(lp);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNetworks(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalPeer> lst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : lst) {
                if (lp.getPeer().getIdentity().equals(me)) continue;
                lp.setRequestNetworks(true);
                lp.setRequestNetworksDispatched(false);
                lp.setRequestNetworksPriority(priority);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePublicPosts(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalPeer> lst = this.CoreDB.getLocalPeers();
            for (LocalPeer lp : lst) {
                if (lp.getPeer().getIdentity().equals(me)) continue;
                lp.setRequestPublicPosts(true);
                lp.setRequestPublicPostsDispatched(false);
                lp.setRequestPublicPostsPriority(priority);
                this.CoreDB.saveLocalPeer(lp);
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNetworkAuths(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
            List<LocalSubscribe> lslst = this.CoreDB.getPeerNetworkSubscriptions(me);
            for (LocalSubscribe ls : lslst) {
                BBytes networkid = ls.getSubscription().getNetworkID();
                LocalNetworkAuthorization myauth = this.CoreDB.getNetworkAuth(networkid, me);
                if (myauth == null) continue;
                List<LocalSubscribe> allpeers = this.CoreDB.getAllNetworkSubscriptions(networkid);
                for (LocalSubscribe op : allpeers) {
                    BBytes pid;
                    LocalNetworkAuthorization l;
                    if (op.isMarkedBad() || (l = this.CoreDB.getNetworkAuth(networkid, pid = op.getSubscription().getSignature().getPeerIdentifier())) == null || l.getNetworkAuthorization().getPeerId().equals(me)) continue;
                    l.setRequestAuths(true);
                    l.setRequestAuthsDispatched(false);
                    l.setRequestAuthsPriority(priority);
                    this.CoreDB.saveLocalNetworkAuth(l);
                }
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePosts(long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mydata = this.CoreDB.getMyPeerData();
            BBytes myid = mydata.getPeer().getPeer().getIdentity();
            List<LocalSubscribe> mysubs = this.CoreDB.getPeerNetworkSubscriptions(myid);
            Log.info("mysubs.size(): " + mysubs.size());
            for (LocalSubscribe ls : mysubs) {
                Log.info("ls.getSubscription().isSubscribe(): " + ls.getSubscription().isSubscribe());
                if (!ls.getSubscription().isSubscribe()) continue;
                BBytes netid = ls.getSubscription().getNetworkID();
                List<LocalSubscribe> othersubs = this.CoreDB.getAllNetworkSubscriptions(netid);
                Log.info("othersubs.size(): " + othersubs.size());
                for (LocalSubscribe os : othersubs) {
                    BBytes opeer;
                    if (os.isMarkedBad() || myid.equals(opeer = os.getSubscription().getSignature().getPeerIdentifier())) continue;
                    Log.info("Set requestPosts");
                    os.setRequestPosts(true);
                    os.setRequestPostsDispatched(false);
                    os.setRequestPostsPriority(priority);
                    this.CoreDB.saveLocalSubscription(os);
                }
            }
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LocalPost addLocalPost(BBytes networkid, Object message, BBytes fileref) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            Post p;
            LocalPost lp;
            LocalSubscribe na;
            BBytes peerid;
            MyPeerDataSO mp;
            block19: {
                block18: {
                    mp = this.getMyPeerData();
                    peerid = mp.getPeer().getPeer().getIdentity();
                    na = null;
                    lp = null;
                    na = this.CoreDB.getSubscription(networkid, peerid);
                    if (na != null) break block18;
                    return null;
                }
                p = new Post();
                if (fileref != null) {
                    p.setFileReferenceDigest(new BBytes(fileref));
                }
                p.setMessage(message);
                p.setNetworkId(new BBytes(networkid));
                p.setPosterHasFile(false);
                p.setRDate(this.Time.getTime());
                if (FileUtils.validatePost(p)) break block19;
                return null;
            }
            long number = na.getLastPostNumber();
            na.setLastPostNumber(++number);
            this.CoreDB.saveLocalSubscription(na);
            p.setPostNumber(number);
            if (fileref != null) {
                PeerHasFile ph;
                List<FileReference> frl = this.CoreDB.getFiles(networkid, fileref);
                Iterator<FileReference> i = frl.iterator();
                boolean filefound = false;
                while (i.hasNext() && !filefound) {
                    FileReference fr = i.next();
                    if (fr.getFile() != null && fr.getFile().exists()) {
                        if (this.Crypto.digestFile(fr.getFile(), fr.getOffset(), fr.getSize()).equals(fileref)) {
                            filefound = true;
                            if (fr.isExists()) continue;
                            fr.setExists(true);
                            this.CoreDB.saveFileReference(fr);
                            continue;
                        }
                        if (!fr.isExists()) continue;
                        fr.setExists(false);
                        this.CoreDB.saveFileReference(fr);
                        continue;
                    }
                    if (!fr.isExists()) continue;
                    fr.setExists(false);
                    this.CoreDB.saveFileReference(fr);
                }
                if (filefound) {
                    p.setPosterHasFile(true);
                    ph = this.CoreDB.getPeerHasFile(networkid, peerid, fileref);
                    if (ph == null) {
                        ph = new PeerHasFile();
                        ph.setDigest(new BBytes(fileref));
                        ph.setNetworkId(new BBytes(networkid));
                        ph.setPeerId(new BBytes(peerid));
                        ph.setPeerHasFile(true);
                        ph.setLastMessage(p.getPostNumber());
                        this.CoreDB.savePeerHasFile(ph);
                    } else if (!ph.isPeerHasFile()) {
                        ph.setPeerHasFile(true);
                        ph.setLastMessage(p.getPostNumber());
                        this.CoreDB.savePeerHasFile(ph);
                    }
                } else {
                    ph = this.CoreDB.getPeerHasFile(networkid, peerid, fileref);
                    if (ph != null) {
                        ph.setPeerHasFile(false);
                        ph.setLastMessage(p.getPostNumber());
                        this.CoreDB.savePeerHasFile(ph);
                    }
                }
            }
            this.Crypto.signPost(p, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
            lp = new LocalPost();
            lp.setPeerRank(na.getPeerRank());
            lp.setCreator(mp.getPeer().getPeer().getNickSig());
            lp.setLocalDate(this.Time.getTime());
            lp.setPeerRank(na.getPeerRank());
            lp.setPost(p);
            lp.setPeerRank(na.getPeerRank());
            if (p.getNetworkId() != null && p.getFileReferenceDigest() != null) {
                List<LocalPost> lpl = this.CoreDB.getPostsReferencingFile(p.getNetworkId(), p.getFileReferenceDigest());
                boolean fnd = false;
                Iterator<LocalPost> i = lpl.iterator();
                while (i.hasNext() && !fnd) {
                    LocalPost tp = i.next();
                    if (tp.getLocalFile() == null || !tp.getLocalFile().exists()) continue;
                    lp.setLocalFile(tp.getLocalFile());
                    fnd = true;
                }
            }
            this.CoreDB.saveLocalPost(lp);
            this.CoreCom.pushPost(p);
            return lp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPost addLocalFile(BBytes networkid, File f, long offset, long size, Object message) {
        if (f != null && f.exists()) {
            BBytes dig = this.Crypto.digestFile(f, offset, size);
            FileReference fr = new FileReference();
            fr.setFile(new File(f.getPath()));
            fr.setLocalDate(this.Time.getTime());
            fr.setNetworkId(new BBytes(networkid));
            fr.setOffset(offset);
            fr.setSize(size);
            fr.setUnsignedDigest(dig);
            fr.setExists(true);
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                this.CoreDB.saveFileReference(fr);
            }
            LocalPost lp = this.addLocalPost(networkid, message, dig);
            return lp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized LocalNetwork addLocalNetwork(String title, String description, boolean pub) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp;
            Network n;
            block7: {
                block6: {
                    n = new Network();
                    n.setDescription(description);
                    n.setTitle(title);
                    n.setRDate(this.Time.getTime());
                    n.setPublic(pub);
                    if (FileUtils.validateNetwork(n)) break block6;
                    return null;
                }
                mp = this.getMyPeerData();
                if (mp != null) break block7;
                return null;
            }
            long netnum = mp.getPeer().getLastNetworkNumber();
            n.setNetworkNumber(++netnum);
            this.Crypto.signNetwork(n, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
            mp.getPeer().setLastNetworkNumber(netnum);
            BBytes myid = mp.getPeer().getPeer().getIdentity();
            NetworkAuthorization newa = new NetworkAuthorization();
            newa.setNetworkId(new BBytes(n.getSignature().getDigest()));
            newa.setPeerId(new BBytes(myid));
            newa.setSignAuthority(NetworkAuthorization.CANGIVESIGNAUTH);
            newa.setRDate(this.Time.getTime());
            this.Crypto.signNetworkAuthorization(newa, myid, mp.getKeySet().getPrivateSigningKey());
            LocalNetwork ln = null;
            this.CoreDB.saveMyPeerData(mp);
            ln = new LocalNetwork();
            ln.setLocalDate(this.Time.getTime());
            ln.setNetwork(n);
            ln.setCreator(mp.getPeer().getPeer().getNickSig());
            ln.setAuthorization(NetworkAuthorization.CANGIVESIGNAUTH);
            ln.setAuthorized(true);
            ln.setPeerRank(MY_RANK);
            this.CoreDB.saveLocalNetwork(ln);
            if (ln.getNetwork().getPublic() == null || !ln.getNetwork().getPublic().booleanValue()) {
                LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                lna.setNetworkAuthorization(newa);
                lna.setLocalDate(this.Time.getTime());
                lna.setLastNewAuths(this.Time.getTime());
                lna.setLocalDate(this.Time.getTime());
                lna.setNetworkTitle(n.getTitleSig());
                lna.setPeerNickSig(mp.getPeer().getPeer().getNickSig());
                lna.setSignerNickSig(mp.getPeer().getPeer().getNickSig());
                this.CoreDB.saveLocalNetworkAuth(lna);
                this.CoreCom.pushNetworkAuth(newa);
            }
            this.CoreCom.pushNetwork(n);
            this.subscribe(ln.getNetwork().getSignature().getDigest());
            return ln;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized LocalPublicPost addLocalPublicPost(BBytes network, Object message, BBytes encode4peer) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp;
            PublicPost pp = new PublicPost();
            pp.setRDate(this.Time.getTime());
            pp.setMessage(message);
            if (network != null) {
                pp.setNetworkId(new BBytes(network));
            }
            if ((mp = this.getMyPeerData()) == null) {
                return null;
            }
            long pubnum = mp.getPeer().getLastPublicPostNumber();
            mp.getPeer().setLastPublicPostNumber(++pubnum);
            LocalPublicPost lpp = null;
            pp.setPostNumber(pubnum);
            lpp = new LocalPublicPost();
            lpp.setLocalDate(this.Time.getTime());
            lpp.setPublicPost(pp);
            lpp.setCreator(mp.getPeer().getPeer().getNickSig());
            lpp.setPrivateMessage(false);
            lpp.setPeerRank(MY_RANK);
            if (network != null) {
                LocalNetwork ln = this.CoreDB.getLocalNetwork(network);
                lpp.setNetworkTitle(ln.getNetwork().getTitleSig());
            }
            if (encode4peer != null) {
                LocalPeer ep = this.CoreDB.getPeer(encode4peer);
                if (ep == null) {
                    this.CoreDB.saveMyPeerData(mp);
                    return null;
                }
                Object encmsg = this.Crypto.encodePublicPost(message, ep.getPeer().getPeerKeys());
                Log.info("Encrypted public post message.");
                pp.setEncrypted(true);
                pp.setMessage(encmsg);
                pp.setNetworkId(null);
                lpp.setDecodedMessage(message);
                lpp.setToPeer(ep.getPeer().getNickSig());
                lpp.setPrivateMessage(true);
                this.Crypto.signPublicPost(pp, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
                if (!FileUtils.validatePublicPost(pp)) {
                    return null;
                }
                this.CoreDB.saveLocalPublicPost(lpp);
                this.CoreCom.pushPublicPost(pp);
                this.CoreDB.saveMyPeerData(mp);
                return lpp;
            }
            pp.setEncrypted(false);
            this.Crypto.signPublicPost(pp, mp.getPeer().getPeer().getIdentity(), mp.getKeySet().getPrivateSigningKey());
            if (!FileUtils.validatePublicPost(pp)) {
                return null;
            }
            this.CoreDB.saveLocalPublicPost(lpp);
            this.CoreCom.pushPublicPost(pp);
            this.CoreDB.saveMyPeerData(mp);
            return lpp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalNetworkAuthorization signPeer(BBytes network, LocalPeer peerdata, int authority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp;
            block8: {
                mp = this.getMyPeerData();
                if (mp != null) break block8;
                return null;
            }
            BBytes networkid = network;
            BBytes myid = mp.getPeer().getPeer().getIdentity();
            LocalNetworkAuthorization na = this.CoreDB.getNetworkAuth(networkid, myid);
            LocalNetwork net = this.CoreDB.getLocalNetwork(networkid);
            Log.info("Existing NetworkAuthorization: " + na);
            if (net != null && na != null && na.getNetworkAuthorization().getSignAuthority() > 0 && this.CoreCom.verifyNetworkAuthChain(na.getNetworkAuthorization())) {
                int myauth = na.getNetworkAuthorization().getSignAuthority();
                if (myauth == NetworkAuthorization.CANGIVESIGNAUTH || myauth > authority) {
                    NetworkAuthorization newa = new NetworkAuthorization();
                    Log.info("Signing peer: " + peerdata.getPeer().getIdentity() + " for network: " + networkid);
                    newa.setNetworkId(new BBytes(networkid));
                    newa.setPeerId(new BBytes(peerdata.getPeer().getIdentity()));
                    newa.setSignAuthority(authority);
                    newa.setRDate(this.Time.getTime());
                    long lnum = na.getLastNetworkAuthNumber();
                    na.setLastNetworkAuthNumber(++lnum);
                    this.CoreDB.saveLocalNetworkAuth(na);
                    this.Crypto.signNetworkAuthorization(newa, myid, mp.getKeySet().getPrivateSigningKey());
                    LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                    lna.setNetworkAuthorization(newa);
                    lna.setLocalDate(this.Time.getTime());
                    lna.setLastNewAuths(this.Time.getTime());
                    lna.setNetworkTitle(net.getNetwork().getTitleSig());
                    lna.setPeerNickSig(peerdata.getPeer().getNickSig());
                    lna.setSignerNickSig(mp.getPeer().getPeer().getNickSig());
                    this.CoreDB.saveLocalNetworkAuth(lna);
                    this.CoreCom.pushNetworkAuth(na.getNetworkAuthorization());
                    this.CoreCom.pushNetworkAuth(newa);
                    return lna;
                }
            } else {
                LocalNetwork n = this.CoreDB.getLocalNetwork(network);
                Log.info("Existing network found: " + n);
                if (n != null && n.getNetwork().getSignature().getPeerIdentifier().equals(myid)) {
                    Log.info("Signing for my own network.");
                    NetworkAuthorization newa = new NetworkAuthorization();
                    newa.setNetworkId(new BBytes(networkid));
                    newa.setPeerId(new BBytes(peerdata.getPeer().getIdentity()));
                    newa.setSignAuthority(authority);
                    long lnum = na.getLastNetworkAuthNumber();
                    na.setLastNetworkAuthNumber(++lnum);
                    this.CoreDB.saveLocalNetworkAuth(na);
                    this.Crypto.signNetworkAuthorization(newa, myid, mp.getKeySet().getPrivateSigningKey());
                    LocalNetworkAuthorization lna = new LocalNetworkAuthorization();
                    lna.setNetworkAuthorization(newa);
                    lna.setLocalDate(this.Time.getTime());
                    this.CoreDB.saveLocalNetworkAuth(lna);
                    this.CoreCom.pushNetworkAuth(newa);
                    return lna;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMyLocation(Object location) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp = this.getMyPeerData();
            if (mp == null) {
                return;
            }
            Peer p = mp.getPeer().getPeer();
            p.setLocation(location);
            p.setUpdateCount(p.getUpdateCount() + 1L);
            if (!FileUtils.validatePeer(p)) {
                return;
            }
            this.Crypto.signLocation(p, mp.getKeySet().getPrivateSigningKey());
            this.CoreDB.saveMyPeerData(mp);
            this.CoreCom.pushPeer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMyNickname(String nn) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp = this.getMyPeerData();
            if (mp == null) {
                return;
            }
            Peer p = mp.getPeer().getPeer();
            p.setNickname(nn);
            p.setUpdateCount(p.getUpdateCount() + 1L);
            if (!FileUtils.validatePeer(p)) {
                return;
            }
            this.Crypto.signLocation(p, mp.getKeySet().getPrivateSigningKey());
            this.CoreDB.saveMyPeerData(mp);
            this.CoreCom.pushPeer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMyIntroduction(String intro) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp = this.getMyPeerData();
            if (mp == null) {
                return;
            }
            Peer p = mp.getPeer().getPeer();
            p.setIntroduction(intro);
            p.setUpdateCount(p.getUpdateCount() + 1L);
            if (!FileUtils.validatePeer(p)) {
                return;
            }
            this.Crypto.signLocation(p, mp.getKeySet().getPrivateSigningKey());
            this.CoreDB.saveMyPeerData(mp);
            this.CoreCom.pushPeer(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateNewKeys() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO mp = this.getMyPeerData();
            if (mp == null) {
                mp = new MyPeerDataSO();
            }
            KeySet ks = this.Crypto.generateNewKeys();
            mp.setKeySet(ks);
            if (mp.getPeer() == null) {
                mp.setPeer(new LocalPeer());
            }
            Date curtime = this.Time.getTime();
            if (mp.getPeer().getPeer() == null) {
                mp.getPeer().setPeer(new Peer());
                mp.getPeer().getPeer().setRDate(curtime);
            }
            mp.getPeer().getPeer().setPeerKeys(ks.getPublicKeySet());
            mp.getPeer().setLastConnectionTime(curtime);
            mp.getPeer().setLastNewNetwork(curtime);
            mp.getPeer().setLastNewPeer(curtime);
            mp.getPeer().setLastNewPublicPost(curtime);
            mp.getPeer().setLastSuccessRequest(curtime);
            mp.getPeer().setLocalDate(curtime);
            mp.getPeer().setRank(MY_RANK);
            this.Crypto.signLocation(mp.getPeer().getPeer(), ks.getPrivateSigningKey());
            this.CoreDB.saveMyPeerData(mp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MyPeerDataSO getMyPeerData() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            return this.CoreDB.getMyPeerData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBadPeer(LocalPeer id) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            if (id != null && id.getPeer() != null) {
                List<LocalNetworkAuthorization> nalst = this.CoreDB.getPeerNetworkAuths(id.getPeer().getIdentity());
                for (LocalNetworkAuthorization na : nalst) {
                    this.setBadPeer(na);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBadPeer(BBytes network, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(network, peerid);
            this.setBadPeer(lna);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsetBadPeer(BBytes network, BBytes peerid) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe ls = this.CoreDB.getSubscription(network, peerid);
            if (ls != null) {
                ls.setMarkedBad(false);
                this.CoreDB.saveLocalSubscription(ls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBadPeer(LocalNetworkAuthorization lna) {
        Object object;
        LocalPost lp;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            if (lna != null) {
                BBytes me = this.CoreDB.getMyPeerData().getPeer().getPeer().getIdentity();
                if (!lna.getNetworkAuthorization().getPeerId().equals(me)) {
                    BBytes netid = lna.getNetworkAuthorization().getNetworkId();
                    BBytes peerid = lna.getNetworkAuthorization().getPeerId();
                    LocalSubscribe ls = this.CoreDB.getSubscription(lna.getNetworkAuthorization().getNetworkId(), lna.getNetworkAuthorization().getPeerId());
                    if (ls != null) {
                        ls.setMarkedBad(true);
                        ls.setLastPostNumber(0L);
                        this.CoreDB.saveLocalSubscription(ls);
                    }
                    List<LocalNetworkAuthorization> ml = this.CoreDB.getNetworkAuthsSignedBy(netid, peerid);
                    for (LocalNetworkAuthorization na : ml) {
                        this.setBadPeer(na);
                    }
                }
            }
        }
        SearchQuery sq = new SearchQuery();
        sq.PeerId = lna.getNetworkAuthorization().getPeerId();
        sq.Network = lna.getNetworkAuthorization().getNetworkId();
        sq.MaxResults = Integer.MAX_VALUE;
        sq.Template = true;
        QueryResultsInterface qr = this.CoreDB.getDBQuery().searchPosts(sq);
        int c = 0;
        while (c < qr.size()) {
            lp = (LocalPost)qr.get(c);
            object = this.CoreDB;
            synchronized (object) {
                this.CoreDB.deletePost(lp);
            }
            ++c;
        }
        qr.Close();
        sq = new SearchQuery();
        sq.PeerId = lna.getNetworkAuthorization().getPeerId();
        sq.Network = lna.getNetworkAuthorization().getNetworkId();
        sq.MaxResults = Integer.MAX_VALUE;
        sq.Template = false;
        qr = this.CoreDB.getDBQuery().searchPosts(sq);
        c = 0;
        while (c < qr.size()) {
            lp = (LocalPost)qr.get(c);
            object = this.CoreDB;
            synchronized (object) {
                this.CoreDB.deletePost(lp);
            }
            ++c;
        }
        qr.Close();
        List<PostHoles> hlst = this.CoreDB.getPostHoles(lna.getNetworkAuthorization().getNetworkId(), lna.getNetworkAuthorization().getPeerId());
        for (PostHoles p : hlst) {
            DataBaseCoreInterface dataBaseCoreInterface2 = this.CoreDB;
            synchronized (dataBaseCoreInterface2) {
                this.CoreDB.deletePostHoles(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDownloadPriority(File f, long priority) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> flst = this.CoreDB.getFilesForFile(f);
            for (FileReference fr : flst) {
                fr.setUserRequestPriority(priority);
                this.CoreDB.saveFileReference(fr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(File f) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            f.delete();
            MyPeerDataSO myp = this.CoreDB.getMyPeerData();
            BBytes pid = myp.getPeer().getPeer().getIdentity();
            List<FileReference> files = this.CoreDB.getFilesForFile(f);
            for (FileReference fr : files) {
                this.CoreCom.requestFile(pid, fr.getNetworkId(), fr.getUnsignedDigest());
            }
        }
    }

    public void setCoreDB(DataBaseCoreInterface coreDB) {
        this.CoreDB = coreDB;
    }

    public void setCrypto(CryptoDataBaseInterface crypto) {
        this.Crypto = crypto;
    }

    public void setTime(TimeInterface time) {
        this.Time = time;
    }

    public void setCoreCom(CoreComInterface coreCom) {
        this.CoreCom = coreCom;
    }

    public void setCom(ComConnectionInterface com) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalPeer addLocalPeer(Peer p) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            if (this.Crypto.verifyIdentity(p)) {
                LocalPeer olp = this.CoreDB.getPeer(p.getIdentity());
                if (olp != null) {
                    if (olp.getPeer().getUpdateCount() < p.getUpdateCount() && this.Crypto.verifyLocation(p, olp.getPeer().getPeerKeys())) {
                        this.CoreDB.deletePeer(olp.getPeer(), false);
                        olp.setPeer(p);
                        olp.setPushRequested(false);
                        olp.setReceivedFromPeer(null);
                        this.CoreDB.saveLocalPeer(olp);
                        if (this.Event != null) {
                            this.Event.newPeerReceived(olp);
                        }
                    }
                } else if (this.Crypto.verifyLocation(p, p.getPeerKeys())) {
                    LocalPeer lp = new LocalPeer();
                    lp.setConnectionAttempts(0L);
                    lp.setLastConnectionTime(this.Time.getTime());
                    lp.setLastNetworkNumber(0L);
                    lp.setLastNewNetwork(this.Time.getTime());
                    lp.setLastNewPeer(this.Time.getTime());
                    lp.setLastNewPublicPost(this.Time.getTime());
                    lp.setLastPublicPostNumber(0L);
                    lp.setLastSuccessRequest(this.Time.getTime());
                    lp.setNumberOfNewNetworks(0L);
                    lp.setNumberOfNewPeers(0L);
                    lp.setNumberOfNewPublicPosts(0L);
                    lp.setRequestNetworks(false);
                    lp.setRequestNetworksDispatched(false);
                    lp.setRequestNetworksDispatchedTime(this.Time.getTime());
                    lp.setRequestNetworksPriority(0L);
                    lp.setRequestNetworksTime(this.Time.getTime());
                    lp.setRequestPeers(false);
                    lp.setRequestPeersPriority(0L);
                    lp.setRequestPeersTime(this.Time.getTime());
                    lp.setRequestPublicPosts(false);
                    lp.setRequestPublicPostsDispatched(false);
                    lp.setRequestPublicPostsDispatchedTime(this.Time.getTime());
                    lp.setRequestPublicPostsPriority(0L);
                    lp.setRequestPublicPostsTime(this.Time.getTime());
                    lp.setRequests(0L);
                    lp.setSuccessfulConnectionAttempts(0L);
                    lp.setSuccessfulRequests(0L);
                    lp.setPushRequested(false);
                    lp.setReceivedFromPeer(null);
                    lp.setPeer(p);
                    lp.setLocalDate(this.Time.getTime());
                    this.CoreDB.saveLocalPeer(lp);
                    if (this.Event != null) {
                        this.Event.newPeerReceived(lp);
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            List<FileReference> l = this.CoreDB.getOrderedFilesRequestedAndDispatched();
            for (FileReference r : l) {
                r.setUserRequestDispatched(false);
                this.CoreDB.saveFileReference(r);
            }
            List<LocalPeer> lpl = this.CoreDB.getOrderedNetworksRequestedAndDispatched();
            for (LocalPeer lp : lpl) {
                lp.setRequestNetworksDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            lpl = this.CoreDB.getOrderedPublicPostsRequestedAndDispatched();
            for (LocalPeer lp : lpl) {
                lp.setRequestPublicPostsDispatched(false);
                this.CoreDB.saveLocalPeer(lp);
            }
            List<LocalNetworkAuthorization> lll = this.CoreDB.getOrderedNetworkAuthsRequestedAndDispatched();
            for (LocalNetworkAuthorization ll : lll) {
                ll.setRequestAuthsDispatched(false);
                this.CoreDB.saveLocalNetworkAuth(ll);
            }
            List<LocalSubscribe> lls = this.CoreDB.getOrderedPostsRequestedAndDispatched();
            for (LocalSubscribe ll : lls) {
                ll.setRequestPostsDispatched(false);
                this.CoreDB.saveLocalSubscription(ll);
            }
        }
    }

    @Override
    public void addPostTemplate(BBytes netid, PostTemplate pt) {
        this.addLocalPost(netid, pt, null);
    }

    public File getTemplateDir() {
        return this.TemplateDir;
    }

    public void setTemplateDir(File templateDir) {
        this.TemplateDir = templateDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeerRank(BBytes peerid, int rank) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalPeer lp = this.CoreDB.getPeer(peerid);
            if (lp != null) {
                lp.setRank(rank);
                this.CoreDB.saveLocalPeer(lp);
                List<BBytes> netlist = this.CoreDB.getLocalNetworksFromPeer(peerid);
                for (BBytes pid : netlist) {
                    LocalNetwork ln = this.CoreDB.getLocalNetwork(pid);
                    if (ln == null) continue;
                    ln.setPeerRank(rank);
                    this.CoreDB.saveLocalNetwork(ln);
                }
                netlist = this.CoreDB.getLocalPublicPostsFromPeer(peerid);
                for (BBytes pid : netlist) {
                    LocalPublicPost pst = this.CoreDB.getLocalPublicPost(pid);
                    if (pst == null) continue;
                    pst.setPeerRank(rank);
                    this.CoreDB.saveLocalPublicPost(pst);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePeerNetworkRank(BBytes networkid, BBytes peerid, long rank) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalSubscribe ls = this.CoreDB.getSubscription(networkid, peerid);
            if (ls != null) {
                LocalPost lp;
                ls.setPeerRank(rank);
                this.CoreDB.saveLocalSubscription(ls);
                SearchQuery sq = new SearchQuery();
                sq.PeerId = peerid;
                sq.Network = networkid;
                QueryResultsInterface qr = this.CoreDB.getDBQuery().searchPosts(sq);
                int c = 0;
                while (c < qr.size()) {
                    lp = (LocalPost)qr.get(c);
                    if (lp != null) {
                        lp.setPeerRank(rank);
                        this.CoreDB.saveLocalPost(lp);
                    }
                    ++c;
                }
                qr.Close();
                sq = new SearchQuery();
                sq.PeerId = peerid;
                sq.Network = networkid;
                sq.Template = true;
                qr = this.CoreDB.getDBQuery().searchPosts(sq);
                c = 0;
                while (c < qr.size()) {
                    lp = (LocalPost)qr.get(c);
                    if (lp != null) {
                        lp.setPeerRank(rank);
                        this.CoreDB.saveLocalPost(lp);
                    }
                    ++c;
                }
                qr.Close();
            }
        }
    }

    @Override
    public void setEventInterface(EventInterface e) {
        this.Event = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePeerFile(String outputfile) {
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            try {
                File outfile = new File(outputfile);
                PrintWriter pw = new PrintWriter(outfile);
                MyPeerDataSO me = this.CoreDB.getMyPeerData();
                DumbMIME.writePeer2MIME(me.getPeer().getPeer(), pw);
                List<Peer> pl = this.CoreDB.getPeers();
                for (Peer p : pl) {
                    DumbMIME.writePeer2MIME(p, pw);
                }
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private LocalSubscribe genMySubscribe(BBytes networkid, MyPeerDataSO me) {
        Subscribe s = new Subscribe();
        s.setNetworkID(networkid);
        s.setRDate(this.Time.getTime());
        LocalSubscribe ls = new LocalSubscribe();
        ls.setLastNewFile(new Date(0L));
        ls.setLastNewPost(new Date(0L));
        ls.setLastNewSubs(new Date(0L));
        ls.setSubscription(s);
        ls.setCreator(me.getPeer().getPeer().getNickSig());
        ls.setLocalDate(this.Time.getTime());
        ls.setReceivedFromPeer(me.getPeer().getPeer().getIdentity());
        ls.setPeerRank(MY_RANK);
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(BBytes networkid) {
        LocalSubscribe ls = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO me = this.CoreDB.getMyPeerData();
            BBytes myid = me.getPeer().getPeer().getIdentity();
            LocalNetwork ln = this.CoreDB.getLocalNetwork(networkid);
            if (ln != null) {
                LocalNetworkAuthorization lna;
                boolean ok = true;
                if (!(ln.getNetwork().getPublic() != null && ln.getNetwork().getPublic().booleanValue() || (lna = this.CoreDB.getNetworkAuth(networkid, myid)) != null)) {
                    ok = false;
                }
                if (ok) {
                    ls = this.CoreDB.getSubscription(networkid, myid);
                    if (ls == null) {
                        ls = this.genMySubscribe(networkid, me);
                    }
                    long lastnum = ls.getSubscription().getSubNumber();
                    ls.setNetworkName(ln.getNetwork().getTitleSig());
                    ls.getSubscription().setSubscribe(true);
                    ls.getSubscription().setSubNumber(++lastnum);
                    ls.setPushRequested(true);
                    this.Crypto.signSubscribe(ls.getSubscription(), myid, me.getKeySet().getPrivateSigningKey());
                    this.CoreDB.saveLocalSubscription(ls);
                    ln.setSubscribed(true);
                    this.CoreDB.saveLocalNetwork(ln);
                }
            }
        }
        if (ls != null) {
            this.CoreCom.pushSubscription(ls.getSubscription());
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(BBytes networkid) {
        LocalSubscribe ls = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            MyPeerDataSO me = this.CoreDB.getMyPeerData();
            BBytes myid = me.getPeer().getPeer().getIdentity();
            LocalNetwork ln = this.CoreDB.getLocalNetwork(networkid);
            Log.info("unsubscribe: ln: " + ln);
            if (ln != null) {
                boolean ok = true;
                Log.info("unsubscribe ln.getNetwork().getPublic(): " + ln.getNetwork().getPublic() + " ln number: " + ln.getNetwork().getTitleSig());
                if (ln.getNetwork().getPublic() == null || !ln.getNetwork().getPublic().booleanValue()) {
                    LocalNetworkAuthorization lna = this.CoreDB.getNetworkAuth(networkid, myid);
                    Log.info("unsubscribe lna: " + lna);
                    if (lna == null) {
                        ok = false;
                    }
                }
                Log.info("unsubscribe ok: " + ok);
                if (ok) {
                    ls = this.CoreDB.getSubscription(networkid, myid);
                    Log.info("unsubscribe subscription: " + ls);
                    if (ls == null) {
                        ls = this.genMySubscribe(networkid, me);
                    }
                    long lastnum = ls.getSubscription().getSubNumber();
                    ls.setNetworkName(ln.getNetwork().getTitleSig());
                    ls.getSubscription().setSubscribe(false);
                    ls.getSubscription().setSubNumber(++lastnum);
                    ls.setPushRequested(true);
                    this.Crypto.signSubscribe(ls.getSubscription(), myid, me.getKeySet().getPrivateSigningKey());
                    this.CoreDB.saveLocalSubscription(ls);
                    ln.setSubscribed(false);
                    this.CoreDB.saveLocalNetwork(ln);
                    Log.info("unsubscribe save.");
                }
            }
        }
        if (ls != null) {
            this.CoreCom.pushSubscription(ls.getSubscription());
        }
        this.CoreCom.requestReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalSubscribe genSubscribe(BBytes networkid, LocalPeer peer) {
        String netname = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            LocalNetwork lw = this.CoreDB.getLocalNetwork(networkid);
            if (lw != null) {
                netname = lw.getNetwork().getTitleSig();
            }
        }
        SignedDigest sg = new SignedDigest();
        sg.setPeerIdentifier(peer.getPeer().getIdentity());
        Subscribe s = new Subscribe();
        s.setSignature(sg);
        s.setNetworkID(networkid);
        s.setRDate(this.Time.getTime());
        LocalSubscribe ls = new LocalSubscribe();
        ls.setNetworkName(netname);
        ls.setLastNewFile(new Date(0L));
        ls.setLastNewPost(new Date(0L));
        ls.setLastNewSubs(new Date(0L));
        ls.setSubscription(s);
        ls.setCreator(peer.getPeer().getNickSig());
        ls.setLocalDate(this.Time.getTime());
        ls.setPeerRank(10L);
        return ls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrivateSubs(BBytes myid, BBytes netid, long prority) {
        LocalNetworkAuthorization myauth = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            myauth = this.CoreDB.getNetworkAuth(netid, myid);
        }
        if (myauth != null) {
            List<LocalNetworkAuthorization> authlst = null;
            DataBaseCoreInterface dataBaseCoreInterface2 = this.CoreDB;
            synchronized (dataBaseCoreInterface2) {
                authlst = this.CoreDB.getNetworkAuths(netid);
            }
            if (authlst != null) {
                for (LocalNetworkAuthorization oln : authlst) {
                    LocalPeer lp = null;
                    LocalSubscribe ols = null;
                    BBytes opeer = oln.getNetworkAuthorization().getPeerId();
                    DataBaseCoreInterface dataBaseCoreInterface3 = this.CoreDB;
                    synchronized (dataBaseCoreInterface3) {
                        ols = this.CoreDB.getSubscription(netid, opeer);
                        lp = this.CoreDB.getPeer(oln.getNetworkAuthorization().getPeerId());
                    }
                    if (ols == null && lp != null) {
                        ols = this.genSubscribe(netid, lp);
                    }
                    if (ols == null) continue;
                    ols.setRequestSubs(true);
                    ols.setRequestSubsDispatched(false);
                    ols.setRequestSubsPriority(prority);
                    dataBaseCoreInterface3 = this.CoreDB;
                    synchronized (dataBaseCoreInterface3) {
                        this.CoreDB.saveLocalSubscription(ols);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePublicSubs(BBytes myid, BBytes netid, List<LocalPeer> peers, long prority) {
        for (LocalPeer peer : peers) {
            LocalSubscribe ls = null;
            BBytes opeer = peer.getPeer().getIdentity();
            DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                ls = this.CoreDB.getSubscription(netid, opeer);
            }
            if (ls == null) {
                ls = this.genSubscribe(netid, peer);
            }
            if (ls == null) continue;
            ls.setRequestSubs(true);
            ls.setRequestSubsDispatched(false);
            ls.setRequestSubsPriority(prority);
            dataBaseCoreInterface = this.CoreDB;
            synchronized (dataBaseCoreInterface) {
                this.CoreDB.saveLocalSubscription(ls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptions(long priority) {
        MyPeerDataSO me = null;
        BBytes myid = null;
        List<LocalSubscribe> mysubs = null;
        List<LocalPeer> peers = null;
        DataBaseCoreInterface dataBaseCoreInterface = this.CoreDB;
        synchronized (dataBaseCoreInterface) {
            me = this.CoreDB.getMyPeerData();
            myid = me.getPeer().getPeer().getIdentity();
            mysubs = this.CoreDB.getPeerPossibleNetworkSubscriptions(myid);
            peers = this.CoreDB.getLocalPeers();
        }
        if (mysubs != null) {
            for (LocalSubscribe ls : mysubs) {
                BBytes netid = ls.getSubscription().getNetworkID();
                LocalNetwork ln = null;
                DataBaseCoreInterface dataBaseCoreInterface2 = this.CoreDB;
                synchronized (dataBaseCoreInterface2) {
                    ln = this.CoreDB.getLocalNetwork(netid);
                }
                if (ln == null) continue;
                if (ln.getNetwork().getPublic() == null || !ln.getNetwork().getPublic().booleanValue()) {
                    this.updatePrivateSubs(myid, netid, priority);
                    continue;
                }
                this.updatePublicSubs(myid, netid, peers, priority);
            }
        }
        this.CoreCom.requestReady();
    }
}

