/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.ourfilesystem.db.DataBaseLuceneIndexer;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalPost;
import org.ourfilesystem.ui.DateRenderer;
import org.ourfilesystem.ui.FileSizeRenderer;
import org.ourfilesystem.ui.OpenedCellRenderer;
import org.ourfilesystem.ui.OpenedInterface;
import org.ourfilesystem.ui.SubjectCellRenderer;

public class PostTableModel
extends AbstractTableModel
implements OpenedInterface {
    private static final long serialVersionUID = 1L;
    private QueryResultsInterface Posts;
    private HashSet<Integer> Opened;
    private String[] Columnnames = new String[]{"Creator", "Peer Rank", "Subject", "File Name", "Local File", "Size", "Date Created", "Date Received"};

    public PostTableModel() {
        this.Opened = new HashSet();
    }

    @Override
    public String getColumnName(int col) {
        return this.Columnnames[col];
    }

    public Class getColumnClass(int col) {
        if (col == 1 || col == 5) {
            return Long.class;
        }
        if (col == 3) {
            return String.class;
        }
        if (col == 6 || col == 7) {
            return Date.class;
        }
        return String.class;
    }

    public void insertDateRenderer(JTable t) {
        OpenedCellRenderer.insertOpenedIntoTable(t, 0, this);
        OpenedCellRenderer.insertOpenedIntoTable(t, 1, this);
        SubjectCellRenderer.insertSubjectIntoTable(t, 2, this);
        OpenedCellRenderer.insertOpenedIntoTable(t, 3, this);
        OpenedCellRenderer.insertOpenedIntoTable(t, 4, this);
        FileSizeRenderer.insertFileSizeIntoTable(t, 5, this);
        DateRenderer.insertDateIntoTable(t, 6, this);
        DateRenderer.insertDateIntoTable(t, 7, this);
    }

    @Override
    public int getColumnCount() {
        return this.Columnnames.length;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.Posts != null) {
            return this.Posts.size();
        }
        return 0;
    }

    public synchronized LocalPost getPost(int r) {
        if (this.Posts != null && r < this.Posts.size()) {
            return (LocalPost)this.Posts.get(r);
        }
        return null;
    }

    public synchronized Map<String, Object> getTableFields(int r) {
        if (this.Posts != null && r < this.Posts.size()) {
            return this.Posts.getTableFields(r);
        }
        return null;
    }

    public synchronized void setOpened(int r) {
        this.Opened.add(r);
        this.fireTableRowsUpdated(r, r);
    }

    public String getSortKey(int c) {
        if (c == 0) {
            return DataBaseLuceneIndexer.POST_PEERNICK_STR;
        }
        if (c == 1) {
            return DataBaseLuceneIndexer.POST_PEERRANK;
        }
        if (c == 2) {
            return DataBaseLuceneIndexer.POST_SUBJECT_STR;
        }
        if (c == 3) {
            return DataBaseLuceneIndexer.POST_FILENAME_STR;
        }
        if (c == 4) {
            return DataBaseLuceneIndexer.POST_LOCAL_FILENAME_STR;
        }
        if (c == 5) {
            return DataBaseLuceneIndexer.POST_FILE_SIZE;
        }
        if (c == 6) {
            return DataBaseLuceneIndexer.POST_CDATE;
        }
        if (c == 7) {
            return DataBaseLuceneIndexer.POST_DATE;
        }
        return "";
    }

    @Override
    public Object getValueAt(int r, int c) {
        Map<String, Object> data = this.getTableFields(r);
        if (data != null) {
            if (((Boolean)data.get(DataBaseLuceneIndexer.POST_OPENED)).booleanValue()) {
                this.Opened.add(r);
            }
            if (c == 0) {
                return data.get(DataBaseLuceneIndexer.POST_PEERNICK_STR);
            }
            if (c == 1) {
                return data.get(DataBaseLuceneIndexer.POST_PEERRANK);
            }
            if (c == 2) {
                return data.get(DataBaseLuceneIndexer.POST_SUBJECT_STR);
            }
            if (c == 3) {
                return data.get(DataBaseLuceneIndexer.POST_FILENAME_STR);
            }
            if (c == 4) {
                return data.get(DataBaseLuceneIndexer.POST_LOCAL_FILENAME_STR);
            }
            if (c == 5) {
                return data.get(DataBaseLuceneIndexer.POST_FILE_SIZE);
            }
            if (c == 6) {
                return data.get(DataBaseLuceneIndexer.POST_CDATE);
            }
            if (c == 7) {
                return data.get(DataBaseLuceneIndexer.POST_DATE);
            }
        }
        return null;
    }

    public synchronized void setPosts(QueryResultsInterface p) {
        if (this.Posts != null) {
            this.Posts.Close();
        }
        this.Posts = p;
        this.Opened.clear();
        this.fireTableDataChanged();
    }

    @Override
    public boolean isOpened(int row) {
        return this.Opened.contains(row);
    }
}

