/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.utilities.BBytes;

public class PeerRankDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JPanel contentPanel = new JPanel();
    private JSpinner spinner;
    private Main Mn;
    private List<BBytes> Peers;

    public PeerRankDialog(Main m) {
        this.Mn = m;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("resources/ofs2_wiki.png"));
            this.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 400, 150);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new MigLayout("", "[][]", "[][]"));
        JLabel lblSelectTheDesired = new JLabel("Select the desired rank for the selected peers");
        this.contentPanel.add((Component)lblSelectTheDesired, "cell 0 0");
        SpinnerNumberModel model = new SpinnerNumberModel(5, 0, 999, 1);
        this.spinner = new JSpinner(model);
        this.contentPanel.add((Component)this.spinner, "cell 1 0");
        JLabel lblHigherNumbersAre = new JLabel("Higher numbers are better peers");
        this.contentPanel.add((Component)lblHigherNumbersAre, "cell 0 1");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int r = (Integer)PeerRankDialog.this.spinner.getValue();
                List prs = PeerRankDialog.this.Peers;
                if (prs != null) {
                    for (BBytes b : prs) {
                        PeerRankDialog.this.Mn.getCoreUser().updatePeerRank(b, r);
                    }
                }
                PeerRankDialog.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeerRankDialog.this.setVisible(false);
            }
        });
    }

    public void showDialog(List<BBytes> peers) {
        this.Peers = peers;
        this.setVisible(true);
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }
}

