/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.so.MyPeerDataSO;
import org.ourfilesystem.ui.I2POptionsDialog;
import org.ourfilesystem.ui.Main;

public class PeerIdentityPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JTextField textField_1;
    private JTextField textField_2;
    private JTextField textField_3;
    private JTextField textField_4;
    private JTextField textField_5;
    private JRadioButton rdbtnUseIp;
    private JRadioButton rdbtnUseProxy;
    private JRadioButton rdbtnOpen;
    private Main Mn;
    private JLabel lblIdent;
    private JTextField textField_6;
    private JTextField textField_7;
    private JTextField textField_8;
    private JTextField textField_9;
    private JTextField textField_10;
    private JTextField textField_11;
    private PeerIdentityPanel ThisPanel;
    private I2POptionsDialog I2PDialog;
    private File FileDir;

    public PeerIdentityPanel(Main m) {
        this.Mn = m;
        this.ThisPanel = this;
        this.I2PDialog = new I2POptionsDialog(this.Mn);
        this.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][][][][][][][][][][]"));
        JLabel lblNickname = new JLabel("Nickname");
        this.add((Component)lblNickname, "cell 0 0,alignx trailing");
        this.textField = new JTextField();
        this.add((Component)this.textField, "cell 1 0,growx");
        this.textField.setColumns(10);
        JLabel lblIntroduction = new JLabel("Introduction");
        this.add((Component)lblIntroduction, "cell 0 1,alignx trailing");
        this.textField_1 = new JTextField();
        this.add((Component)this.textField_1, "cell 1 1,growx");
        this.textField_1.setColumns(10);
        JLabel lblIdentity = new JLabel("Identity");
        this.add((Component)lblIdentity, "cell 0 2,alignx trailing");
        this.lblIdent = new JLabel("ident");
        this.add((Component)this.lblIdent, "cell 1 2");
        JLabel lblConnectivity = new JLabel("Connectivity");
        this.add((Component)lblConnectivity, "cell 0 3,alignx trailing");
        ButtonGroup group = new ButtonGroup();
        this.rdbtnUseIp = new JRadioButton("Use I2P");
        group.add(this.rdbtnUseIp);
        this.add((Component)this.rdbtnUseIp, "flowx,cell 1 3");
        this.rdbtnUseProxy = new JRadioButton("Use Proxy");
        group.add(this.rdbtnUseProxy);
        this.add((Component)this.rdbtnUseProxy, "cell 1 3");
        this.rdbtnOpen = new JRadioButton("Open");
        group.add(this.rdbtnOpen);
        this.add((Component)this.rdbtnOpen, "cell 1 3");
        JLabel lblHostnameip = new JLabel("Hostname/IP");
        this.add((Component)lblHostnameip, "cell 0 4,alignx trailing");
        this.textField_2 = new JTextField();
        this.add((Component)this.textField_2, "cell 1 4,growx");
        this.textField_2.setColumns(10);
        this.rdbtnUseIp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PeerIdentityPanel.this.updateHostEdittable();
            }
        });
        JLabel lblPort = new JLabel("Port");
        this.add((Component)lblPort, "cell 0 5,alignx trailing");
        this.textField_3 = new JTextField();
        this.add((Component)this.textField_3, "cell 1 5,growx");
        this.textField_3.setColumns(10);
        JLabel lblExternalPort = new JLabel("External Port");
        this.add((Component)lblExternalPort, "cell 0 6,alignx trailing");
        this.textField_6 = new JTextField();
        this.add((Component)this.textField_6, "cell 1 6,growx");
        this.textField_6.setColumns(10);
        JLabel lblProxyAddress = new JLabel("Proxy address");
        this.add((Component)lblProxyAddress, "cell 0 7,alignx trailing");
        this.textField_4 = new JTextField();
        this.add((Component)this.textField_4, "cell 1 7,growx");
        this.textField_4.setColumns(10);
        JLabel lblProxyPort = new JLabel("Proxy port");
        this.add((Component)lblProxyPort, "cell 0 8,alignx trailing");
        this.textField_5 = new JTextField();
        this.add((Component)this.textField_5, "cell 1 8,growx");
        this.textField_5.setColumns(10);
        JLabel lblPostUpdatePeriod = new JLabel("Post update (hours)");
        this.add((Component)lblPostUpdatePeriod, "cell 0 9,alignx trailing");
        this.textField_7 = new JTextField();
        this.add((Component)this.textField_7, "cell 1 9,growx");
        this.textField_7.setColumns(10);
        JLabel lblNetworkUpdatehours = new JLabel("Net update (hours)");
        this.add((Component)lblNetworkUpdatehours, "cell 0 10,alignx trailing");
        this.textField_8 = new JTextField();
        this.add((Component)this.textField_8, "cell 1 10,growx");
        this.textField_8.setColumns(10);
        JLabel lblNetauthUpdatehours = new JLabel("NetAuth update (hours)");
        this.add((Component)lblNetauthUpdatehours, "cell 0 11,alignx trailing");
        this.textField_9 = new JTextField();
        this.add((Component)this.textField_9, "cell 1 11,growx");
        this.textField_9.setColumns(10);
        JLabel lblPubprivUpdatehours = new JLabel("Pub/Priv update (hours)");
        this.add((Component)lblPubprivUpdatehours, "cell 0 12,alignx trailing");
        this.textField_10 = new JTextField();
        this.add((Component)this.textField_10, "cell 1 12,growx");
        this.textField_10.setColumns(10);
        JLabel lblPeerUpdatehours = new JLabel("Peer update (hours)");
        this.add((Component)lblPeerUpdatehours, "cell 0 13,alignx trailing");
        this.textField_11 = new JTextField();
        this.add((Component)this.textField_11, "cell 1 13,growx");
        this.textField_11.setColumns(10);
        JButton btnEditIpProperties = new JButton("Edit I2P Properties");
        this.add((Component)btnEditIpProperties, "cell 1 14");
        btnEditIpProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PeerIdentityPanel.this.I2PDialog.showDialog();
            }
        });
        JButton btnSaveChanges = new JButton("Save Changes");
        this.add((Component)btnSaveChanges, "flowx,cell 1 15");
        btnSaveChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PeerIdentityPanel.this.saveToProperties();
            }
        });
        JButton btnUndoChanges = new JButton("Undo Changes");
        this.add((Component)btnUndoChanges, "cell 1 15");
        btnUndoChanges.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PeerIdentityPanel.this.setFromProperties();
            }
        });
        JButton btnSavePeerData = new JButton("Save Peer Data");
        this.add((Component)btnSavePeerData, "flowx,cell 1 16");
        btnSavePeerData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser chooser = null;
                chooser = PeerIdentityPanel.this.FileDir != null ? new JFileChooser(PeerIdentityPanel.this.FileDir) : new JFileChooser();
                int returnVal = chooser.showSaveDialog(PeerIdentityPanel.this.ThisPanel);
                if (returnVal == 0) {
                    File savefile = chooser.getSelectedFile();
                    if (PeerIdentityPanel.this.Mn != null) {
                        PeerIdentityPanel.this.Mn.savePeerData();
                        PeerIdentityPanel.this.Mn.getCoreUser().writePeerFile(savefile.getPath());
                    }
                }
            }
        });
        JButton btnLoadPeersFrom = new JButton("Load Peers");
        this.add((Component)btnLoadPeersFrom, "cell 1 16");
        JLabel lblVersion = new JLabel("Version: " + Main.CURRENT_VERSION);
        this.add((Component)lblVersion, "cell 1 17");
        btnLoadPeersFrom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = null;
                chooser = PeerIdentityPanel.this.FileDir != null ? new JFileChooser(PeerIdentityPanel.this.FileDir) : new JFileChooser();
                int returnVal = chooser.showOpenDialog(PeerIdentityPanel.this.ThisPanel);
                if (returnVal == 0) {
                    File peerfile = chooser.getSelectedFile();
                    if (PeerIdentityPanel.this.Mn != null && peerfile != null && peerfile.exists()) {
                        PeerIdentityPanel.this.Mn.loadPeerSeeds(peerfile);
                    }
                }
            }
        });
        this.setFromProperties();
    }

    private void saveToProperties() {
        if (this.Mn != null) {
            Properties p = this.Mn.getNetProperties();
            if (this.rdbtnUseIp.isSelected()) {
                p.setProperty(Main.NETWORKMODE, Main.NETWORK_I2P);
            }
            if (this.rdbtnUseProxy.isSelected()) {
                p.setProperty(Main.NETWORKMODE, Main.NETWORK_SOCKS);
            }
            if (this.rdbtnOpen.isSelected()) {
                p.setProperty(Main.NETWORKMODE, Main.NETWORK_NAKED);
            }
            p.setProperty(Main.NETWORK_HOST, this.textField_2.getText());
            p.setProperty(Main.NETWORK_PORT, this.textField_3.getText());
            p.setProperty(Main.SOCKS_HOST, this.textField_4.getText());
            p.setProperty(Main.SOCKS_PORT, this.textField_5.getText());
            p.setProperty(Main.NETWORK_EXTERNAL_PORT, this.textField_6.getText());
            p.setProperty(Main.PEER_NICKNAME, this.textField.getText());
            p.setProperty(Main.PEER_INTRO, this.textField_1.getText());
            p.setProperty(Main.POST_UPDATE_PERIOD, this.textField_7.getText());
            p.setProperty(Main.NETWORK_UPDATE_PERIOD, this.textField_8.getText());
            p.setProperty(Main.NETWORKAUTH_UPDATE_PERIOD, this.textField_9.getText());
            p.setProperty(Main.PUBLICPOST_UPDATE_PERIOD, this.textField_10.getText());
            p.setProperty(Main.PEER_UPDATE_PERIOD, this.textField_11.getText());
            int v = JOptionPane.showConfirmDialog(this, "Are you sure you want to save?", "Save Changes", 0);
            if (v == 0) {
                this.Mn.saveProperties();
                this.Mn.savePeerData();
                JOptionPane.showMessageDialog(this, "You must restart for changes to take effect.", "Restart Required", 2);
            }
        }
    }

    private void setFromProperties() {
        MyPeerDataSO mp = null;
        if (this.Mn != null) {
            mp = this.Mn.getCoreDB().getMyPeerData();
        }
        if (mp != null) {
            this.textField.setText(mp.getPeer().getPeer().getNickname());
            this.textField_1.setText(mp.getPeer().getPeer().getIntroduction());
            this.lblIdent.setText(mp.getPeer().getPeer().getIdentity().toString());
        }
        if (this.Mn != null) {
            String s;
            String port;
            String host;
            String mode = this.Mn.getNetProperties().getProperty(Main.NETWORKMODE);
            if (mode != null) {
                if (mode.equals(Main.NETWORK_I2P)) {
                    this.rdbtnUseIp.setSelected(true);
                }
                if (mode.equals(Main.NETWORK_SOCKS)) {
                    this.rdbtnUseProxy.setSelected(true);
                }
                if (mode.equals(Main.NETWORK_NAKED)) {
                    this.rdbtnOpen.setSelected(true);
                }
            }
            if ((host = this.Mn.getNetProperties().getProperty(Main.NETWORK_HOST)) != null) {
                this.textField_2.setText(host);
            }
            if ((port = this.Mn.getNetProperties().getProperty(Main.NETWORK_PORT)) != null) {
                this.textField_3.setText(port);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.SOCKS_HOST)) != null) {
                this.textField_4.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.SOCKS_PORT)) != null) {
                this.textField_5.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.NETWORK_EXTERNAL_PORT)) != null) {
                this.textField_6.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.POST_UPDATE_PERIOD)) != null) {
                this.textField_7.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.NETWORK_UPDATE_PERIOD)) != null) {
                this.textField_8.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.NETWORKAUTH_UPDATE_PERIOD)) != null) {
                this.textField_9.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.PUBLICPOST_UPDATE_PERIOD)) != null) {
                this.textField_10.setText(s);
            }
            if ((s = this.Mn.getNetProperties().getProperty(Main.PEER_UPDATE_PERIOD)) != null) {
                this.textField_11.setText(s);
            }
        }
        if (this.rdbtnUseIp.isSelected()) {
            this.textField_2.setEditable(false);
        } else {
            this.textField_2.setEditable(true);
        }
    }

    private void updateHostEdittable() {
        if (this.rdbtnUseIp.isSelected()) {
            if (this.Mn != null) {
                this.textField_2.setText(this.Mn.getNetProperties().getProperty(Main.NETWORK_HOST));
            }
            this.textField_2.setEditable(false);
        } else {
            if (this.Mn != null) {
                this.textField_2.setText(this.Mn.getNetProperties().getProperty(Main.NETWORK_HOST));
            }
            this.textField_2.setEditable(true);
        }
    }

    public JRadioButton getRdbtnUseIp() {
        return this.rdbtnUseIp;
    }

    public JTextField getTextField_2() {
        return this.textField_2;
    }

    public JRadioButton getRdbtnUseProxy() {
        return this.rdbtnUseProxy;
    }

    public JRadioButton getRdbtnOpen() {
        return this.rdbtnOpen;
    }

    public JLabel getLblIdent() {
        return this.lblIdent;
    }
}

