/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.QueryResultsInterface;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.db.so.LocalPeer;
import org.ourfilesystem.db.so.Peer;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NetworkTableModel;
import org.ourfilesystem.ui.NewNetworkDialog;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.NewPublicPostDialog;
import org.ourfilesystem.ui.PeerRankDialog;
import org.ourfilesystem.ui.ViewPeerDialog;
import org.ourfilesystem.utilities.BBytes;

public class NetworkPanel
extends JPanel
implements NetworkSelectInterface,
RowSorterListener {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JTextField textField;
    private JTextField textMax;
    private NetworkTableModel Model;
    private JLabel lblSelected;
    private NewNetworkDialog Dialog;
    private NewPeerMessageDialog MessageDialog;
    private NewPublicPostDialog PublicMessageDialog;
    private ViewPeerDialog PeerDialog;
    private PeerRankDialog rankDialog;
    private Main Mn;
    private JSpinner spinner;
    private String SortKeyWord;
    private boolean SortAsc;

    public void doSearch() {
        int max = 1000;
        try {
            max = Integer.valueOf(this.textMax.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String s = this.textField.getText();
        int r = (Integer)this.spinner.getValue();
        QueryResultsInterface qr = this.Mn.getCoreDB().getDBQuery().searchNetworks(s, this.SortKeyWord, max, !this.SortAsc, r);
        this.Model.setNetworks(qr);
    }

    public NetworkPanel(Main m) {
        this.Mn = m;
        this.rankDialog = new PeerRankDialog(this.Mn);
        this.SortKeyWord = null;
        this.SortAsc = true;
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        JScrollPane scrollPane = new JScrollPane();
        splitPane.setRightComponent(scrollPane);
        this.Model = new NetworkTableModel();
        this.table = new JTable(this.Model);
        this.Model.insertDateRenderer(this.table);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().addRowSorterListener(this);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    int row = NetworkPanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                    NetworkPanel.this.openGroup(row);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        scrollPane.setViewportView(this.table);
        JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][]"));
        JLabel lblCurrentlySelected = new JLabel("Currently Selected:");
        panel.add((Component)lblCurrentlySelected, "cell 0 0,alignx trailing");
        this.lblSelected = new JLabel("none");
        panel.add((Component)this.lblSelected, "flowx,cell 1 0,growx");
        JLabel lblSearch = new JLabel("Search");
        panel.add((Component)lblSearch, "cell 0 1,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 1 1,growx");
        this.textField.setColumns(10);
        JLabel lblMinPeerRank = new JLabel("Min peer rank");
        panel.add((Component)lblMinPeerRank, "cell 1 1");
        SpinnerNumberModel model = new SpinnerNumberModel(5, 0, 999, 1);
        this.spinner = new JSpinner(model);
        panel.add((Component)this.spinner, "cell 1 1");
        JLabel lblmax = new JLabel("Max results");
        panel.add((Component)lblmax, "cell 1 1");
        this.textMax = new JTextField("1000");
        this.textMax.setColumns(6);
        panel.add((Component)this.textMax, "cell 1 1");
        this.Dialog = new NewNetworkDialog(this.Mn);
        this.Dialog.setNewPeerMessageDialog(this.MessageDialog);
        JButton btnUpdate = new JButton("Update Groups");
        btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkPanel.this.Mn.getUpdater().updateNetworksNow();
            }
        });
        panel.add((Component)btnUpdate, "cell 1 0");
        JButton btnCreateNewNework = new JButton("Create New Group");
        panel.add((Component)btnCreateNewNework, "cell 1 0");
        btnCreateNewNework.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkPanel.this.Dialog.showDialog();
            }
        });
        JButton btnSearch = new JButton("Search");
        panel.add((Component)btnSearch, "cell 1 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NetworkPanel.this.doSearch();
            }
        });
        JPopupMenu netmenu = new JPopupMenu();
        JMenuItem view = new JMenuItem("View");
        netmenu.add(view);
        view.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NetworkPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = NetworkPanel.this.table.getSelectedRow();
                    NetworkPanel.this.openGroup(r);
                }
            }
        });
        JMenuItem msg = new JMenuItem("Send Message to creator");
        netmenu.add(msg);
        msg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NetworkPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = NetworkPanel.this.table.getSelectedRow();
                    r = NetworkPanel.this.table.convertRowIndexToModel(r);
                    LocalNetwork ln = NetworkPanel.this.Model.getNetwork(r);
                    if (ln != null) {
                        NetworkPanel.this.MessageDialog.showDialog(ln.getNetwork().getSignature().getPeerIdentifier(), ln.getCreator(), ln.getNetwork().getSignature().getDigest(), ln.getNetwork().getTitleSig());
                    }
                }
            }
        });
        JMenuItem pub = new JMenuItem("Send Public Message");
        pub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!NetworkPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = NetworkPanel.this.table.getSelectedRow();
                    r = NetworkPanel.this.table.convertRowIndexToModel(r);
                    LocalNetwork ln = NetworkPanel.this.Model.getNetwork(r);
                    if (ln != null) {
                        NetworkPanel.this.PublicMessageDialog.showDialog(ln);
                    }
                }
            }
        });
        netmenu.add(pub);
        JMenuItem sel = new JMenuItem("Select Group");
        sel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!NetworkPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = NetworkPanel.this.table.getSelectedRow();
                    r = NetworkPanel.this.table.convertRowIndexToModel(r);
                    LocalNetwork ln = NetworkPanel.this.Model.getNetwork(r);
                    if (ln != null) {
                        Peer mp = NetworkPanel.this.Mn.getCoreDB().getMyPeerData().getPeer().getPeer();
                        LocalNetworkAuthorization lna = NetworkPanel.this.Mn.getCoreDB().getNetworkAuth(ln.getNetwork().getSignature().getDigest(), mp.getIdentity());
                        if (lna != null) {
                            NetworkPanel.this.Mn.getGui().setNewNetwork(ln, lna);
                        } else {
                            JOptionPane.showMessageDialog(NetworkPanel.this.table, "You are not authorized for that network.", "Not authorized", 2);
                        }
                    }
                }
            }
        });
        netmenu.add(sel);
        JMenuItem viewpeer = new JMenuItem("View peer info");
        netmenu.add(viewpeer);
        viewpeer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!NetworkPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    LocalPeer mp;
                    int r = NetworkPanel.this.table.getSelectedRow();
                    r = NetworkPanel.this.table.convertRowIndexToModel(r);
                    LocalNetwork ln = NetworkPanel.this.Model.getNetwork(r);
                    if (ln != null && (mp = NetworkPanel.this.Mn.getCoreDB().getPeer(ln.getNetwork().getSignature().getPeerIdentifier())) != null) {
                        NetworkPanel.this.PeerDialog.showPeer(mp);
                    }
                }
            }
        });
        JMenuItem rnk = new JMenuItem("Set Peer Rank");
        netmenu.add(rnk);
        rnk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!NetworkPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int[] selr = NetworkPanel.this.table.getSelectedRows();
                    LinkedList<BBytes> plst = new LinkedList<BBytes>();
                    int i = 0;
                    while (i < selr.length) {
                        LocalPeer peer;
                        int r = selr[i];
                        r = NetworkPanel.this.table.convertRowIndexToModel(r);
                        LocalNetwork lp = NetworkPanel.this.Model.getNetwork(r);
                        if (lp != null && (peer = NetworkPanel.this.Mn.getCoreDB().getPeer(lp.getNetwork().getSignature().getPeerIdentifier())) != null) {
                            plst.add(peer.getPeer().getIdentity());
                        }
                        ++i;
                    }
                    NetworkPanel.this.rankDialog.showDialog(plst);
                }
            }
        });
        this.table.setComponentPopupMenu(netmenu);
        this.table.setSelectionMode(0);
        this.doSearch();
    }

    private void openGroup(int r) {
        LocalNetwork ln = this.Model.getNetwork(r = this.table.convertRowIndexToModel(r));
        if (ln != null) {
            this.Dialog.viewNetwork(ln);
        }
    }

    @Override
    public void setSelectedNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        this.lblSelected.setText(network.getNetwork().getTitleSig());
    }

    public NewPeerMessageDialog getMessageDialog() {
        return this.MessageDialog;
    }

    public void setMessageDialog(NewPeerMessageDialog messageDialog) {
        this.MessageDialog = messageDialog;
        this.Dialog.setNewPeerMessageDialog(this.MessageDialog);
    }

    public NewPublicPostDialog getPublicMessageDialog() {
        return this.PublicMessageDialog;
    }

    public void setPublicMessageDialog(NewPublicPostDialog publicMessageDialog) {
        this.PublicMessageDialog = publicMessageDialog;
    }

    public ViewPeerDialog getPeerDialog() {
        return this.PeerDialog;
    }

    public void setPeerDialog(ViewPeerDialog peerDialog) {
        this.PeerDialog = peerDialog;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        List<RowSorter.SortKey> sl = ((RowSorter)e.getSource()).getSortKeys();
        if (sl.size() > 0) {
            RowSorter.SortKey sk = sl.get(0);
            this.SortKeyWord = this.Model.getSortKey(sk.getColumn());
            this.SortAsc = sk.getSortOrder().equals((Object)SortOrder.ASCENDING);
        }
    }
}

