/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import org.ourfilesystem.db.so.LocalNetwork;
import org.ourfilesystem.db.so.LocalNetworkAuthorization;
import org.ourfilesystem.ui.AuthorizationPanel;
import org.ourfilesystem.ui.ConnectionPanel;
import org.ourfilesystem.ui.FileStatusPanel;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.NetworkPanel;
import org.ourfilesystem.ui.NetworkSelectInterface;
import org.ourfilesystem.ui.NewPeerMessageDialog;
import org.ourfilesystem.ui.NewPublicPostDialog;
import org.ourfilesystem.ui.PeerIdentityPanel;
import org.ourfilesystem.ui.PeerPanel;
import org.ourfilesystem.ui.PostPanel;
import org.ourfilesystem.ui.PrivatePanel;
import org.ourfilesystem.ui.ProgramPanel;
import org.ourfilesystem.ui.PublicPostPanel;
import org.ourfilesystem.ui.ViewPeerDialog;

public class Gui {
    private Main Main;
    private List<NetworkSelectInterface> NetworkListeners;
    private NewPeerMessageDialog NewPeerMessageDialog;
    private NewPublicPostDialog NewPublicMessageDialog;

    public Gui(Main m) throws Exception {
        this.Main = m;
        this.NetworkListeners = new LinkedList<NetworkSelectInterface>();
        this.NewPublicMessageDialog = new NewPublicPostDialog(this.Main.getCoreUser());
        this.NewPeerMessageDialog = new NewPeerMessageDialog(this.Main.getCoreUser());
        ViewPeerDialog viewpeerdialog = new ViewPeerDialog(this.NewPeerMessageDialog);
        JFrame frame = new JFrame("OurFileSystem");
        frame = new JFrame();
        frame.setBounds(100, 100, 980, 700);
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        frame.getContentPane().add(tabbedPane);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("resources/ofs2_wiki.png"));
            frame.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PublicPostPanel pubpost = new PublicPostPanel(this.Main);
        pubpost.setDialog(this.NewPublicMessageDialog);
        pubpost.setPeerDialog(viewpeerdialog);
        pubpost.setPeerMsgDialog(this.NewPeerMessageDialog);
        NetworkPanel netpan = new NetworkPanel(this.Main);
        netpan.setMessageDialog(this.NewPeerMessageDialog);
        netpan.setPublicMessageDialog(this.NewPublicMessageDialog);
        netpan.setPeerDialog(viewpeerdialog);
        AuthorizationPanel authpan = new AuthorizationPanel(this.Main);
        authpan.setMessageDialog(this.NewPeerMessageDialog);
        authpan.setPeerDialog(viewpeerdialog);
        PeerPanel peerpan = new PeerPanel(this.Main);
        peerpan.setPeerMessageDialog(this.NewPeerMessageDialog);
        peerpan.setPeerDialog(viewpeerdialog);
        PostPanel postpan = new PostPanel(this.Main);
        postpan.setMessageDialog(this.NewPeerMessageDialog);
        postpan.setPeerDialog(viewpeerdialog);
        PrivatePanel privpan = new PrivatePanel(this.Main);
        privpan.setDialog(this.NewPeerMessageDialog);
        privpan.setPeerDialog(viewpeerdialog);
        this.addNetworkSelectListener(netpan);
        this.addNetworkSelectListener(peerpan);
        this.addNetworkSelectListener(postpan);
        this.addNetworkSelectListener(authpan);
        ProgramPanel progpan = new ProgramPanel(this.Main.getNodeDir().getPath());
        postpan.setManager(progpan.getManager());
        FileStatusPanel fspan = new FileStatusPanel(this.Main);
        fspan.setManager(progpan.getManager());
        tabbedPane.add("", new PeerIdentityPanel(this.Main));
        tabbedPane.add("", peerpan);
        tabbedPane.add("", pubpost);
        tabbedPane.add("", privpan);
        tabbedPane.add("", netpan);
        tabbedPane.add("", authpan);
        tabbedPane.add("", postpan);
        tabbedPane.add("", new ConnectionPanel(this.Main));
        tabbedPane.add("", fspan);
        tabbedPane.add("", progpan);
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResource("resources/settings.png"));
            tabbedPane.setIconAt(0, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(0, "Settings");
            img = ImageIO.read(this.getClass().getResource("resources/peers.png"));
            tabbedPane.setIconAt(1, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(1, "Peers");
            img = ImageIO.read(this.getClass().getResource("resources/public.png"));
            tabbedPane.setIconAt(2, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(2, "Public Messages");
            img = ImageIO.read(this.getClass().getResource("resources/private.png"));
            tabbedPane.setIconAt(3, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(3, "Private Messages");
            img = ImageIO.read(this.getClass().getResource("resources/groups.png"));
            tabbedPane.setIconAt(4, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(4, "Groups");
            img = ImageIO.read(this.getClass().getResource("resources/authorizations.png"));
            tabbedPane.setIconAt(5, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(5, "Group Authorizations");
            img = ImageIO.read(this.getClass().getResource("resources/posts.png"));
            tabbedPane.setIconAt(6, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(6, "Group Posts");
            img = ImageIO.read(this.getClass().getResource("resources/connections.png"));
            tabbedPane.setIconAt(7, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(7, "Connections");
            img = ImageIO.read(this.getClass().getResource("resources/fileprogress.png"));
            tabbedPane.setIconAt(8, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(8, "File Progress");
            img = ImageIO.read(this.getClass().getResource("resources/programs.png"));
            tabbedPane.setIconAt(9, new ImageIcon(img));
            tabbedPane.setToolTipTextAt(9, "Programs");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JFrame f2 = frame;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                f2.setVisible(true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkSelectListener(NetworkSelectInterface i) {
        List<NetworkSelectInterface> list = this.NetworkListeners;
        synchronized (list) {
            this.NetworkListeners.add(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewNetwork(LocalNetwork network, LocalNetworkAuthorization auth) {
        LinkedList<NetworkSelectInterface> r = new LinkedList<NetworkSelectInterface>();
        List<NetworkSelectInterface> list = this.NetworkListeners;
        synchronized (list) {
            r.addAll(this.NetworkListeners);
        }
        for (NetworkSelectInterface n : r) {
            n.setSelectedNetwork(network, auth);
        }
    }

    public NewPeerMessageDialog getNewPeerMessageDialog() {
        return this.NewPeerMessageDialog;
    }

    public NewPublicPostDialog getNewPublicMessageDialog() {
        return this.NewPublicMessageDialog;
    }
}

