/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.ourfilesystem.db.so.FileStatus;
import org.ourfilesystem.ui.FileStatusTableModel;
import org.ourfilesystem.ui.Main;
import org.ourfilesystem.ui.ProgramManager;
import org.ourfilesystem.ui.ProgramRunner;

public class FileStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblDownloadDir;
    private JTextField textField;
    private JTable table;
    private Main Mn;
    private FileStatusTableModel Model;
    private JButton btnRemoveCompleted;
    private JMenuItem OpenItem;
    private ProgramManager Manager;

    public FileStatusPanel(Main m) {
        this.Mn = m;
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add((Component)splitPane, "Center");
        final JPanel panel = new JPanel();
        splitPane.setLeftComponent(panel);
        panel.setLayout((LayoutManager)new MigLayout("", "[][][][][grow]", "[]"));
        JButton btnSetDownloadDir = new JButton("Set Download Dir");
        panel.add((Component)btnSetDownloadDir, "cell 0 0");
        btnSetDownloadDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                int v = chooser.showOpenDialog(panel);
                if (v == 0) {
                    File f = chooser.getSelectedFile();
                    FileStatusPanel.this.Mn.getFileHandler().setDefaultDownloadDir(f);
                    FileStatusPanel.this.Mn.getNetProperties().setProperty(Main.DOWNLOAD_DEFAULT_DIR, f.getPath());
                    FileStatusPanel.this.Mn.saveProperties();
                }
            }
        });
        this.lblDownloadDir = new JLabel(this.Mn.getFileHandler().getDefaultDownloadDir().getPath());
        panel.add((Component)this.lblDownloadDir, "cell 1 0");
        JLabel lblDefaultPriority = new JLabel("Default Priority");
        panel.add((Component)lblDefaultPriority, "cell 3 0,alignx trailing");
        this.textField = new JTextField();
        panel.add((Component)this.textField, "flowx,cell 4 0");
        this.textField.setColumns(10);
        this.textField.setText(Long.toString(this.Mn.getFileHandler().getDefaultPriority()));
        JButton btnSetPriority = new JButton("Set Priority");
        panel.add((Component)btnSetPriority, "cell 4 0");
        btnSetPriority.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    long pr = Long.valueOf(FileStatusPanel.this.textField.getText());
                    FileStatusPanel.this.Mn.getFileHandler().setDefaultPriority(pr);
                    FileStatusPanel.this.Mn.getNetProperties().setProperty(Main.DOWNLOAD_DEFAULT_PRIORITY, Long.toString(pr));
                    FileStatusPanel.this.Mn.saveProperties();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        JPanel panel_1 = new JPanel();
        splitPane.setRightComponent(panel_1);
        panel_1.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel_1.add((Component)scrollPane, "Center");
        this.Model = new FileStatusTableModel(this.Mn);
        this.table = new JTable(this.Model);
        this.Model.insertDateRenderer(this.table);
        this.Mn.getFileHandler().addEventListener(this.Model);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(2);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    int row = FileStatusPanel.this.table.rowAtPoint(new Point(e.getX(), e.getY()));
                    FileStatusPanel.this.openFile(row);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.Model.insertProgressIntoTable(this.table);
        scrollPane.setViewportView(this.table);
        this.btnRemoveCompleted = new JButton("Remove Complete");
        panel.add((Component)this.btnRemoveCompleted, "cell 4 0");
        this.btnRemoveCompleted.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FileStatusPanel.this.Model.removeCompleted();
            }
        });
        JPopupMenu mn = new JPopupMenu();
        this.OpenItem = new JMenuItem("Open");
        mn.add(this.OpenItem);
        this.OpenItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!FileStatusPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    int r = FileStatusPanel.this.table.getSelectedRow();
                    FileStatusPanel.this.openFile(r);
                }
            }
        });
        JMenuItem prior = new JMenuItem("Change Priorities");
        mn.add(prior);
        prior.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = FileStatusPanel.this.table.getSelectedRows();
                if (selr.length > 0) {
                    Object[] options = new Object[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
                    Object v = JOptionPane.showInputDialog(FileStatusPanel.this.table, "Select new priority.\nLarger number means downloaded first.\nZero will pause.", "Change Priority", 2, null, options, options[1]);
                    if (v != null) {
                        long vl = ((Integer)v).longValue();
                        FileStatus[] fsl = new FileStatus[selr.length];
                        int c = 0;
                        while (c < selr.length) {
                            int r = selr[c];
                            r = FileStatusPanel.this.table.convertRowIndexToModel(r);
                            fsl[c] = FileStatusPanel.this.Model.getFileStatus(r);
                            ++c;
                        }
                        c = 0;
                        while (c < selr.length) {
                            if (fsl[c] != null) {
                                FileStatusPanel.this.Mn.getFileHandler().changePriority(fsl[c].getFile(), vl);
                            }
                            ++c;
                        }
                    }
                }
            }
        });
        JMenuItem pause = new JMenuItem("Pause Downloads");
        mn.add(pause);
        pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int v;
                int[] selr = FileStatusPanel.this.table.getSelectedRows();
                if (selr.length > 0 && (v = JOptionPane.showConfirmDialog(FileStatusPanel.this.table, "Pause Download?\nTo resume change the priority.", "Pause", 0, 2)) == 0) {
                    FileStatus[] fsl = new FileStatus[selr.length];
                    int c = 0;
                    while (c < selr.length) {
                        int r = selr[c];
                        r = FileStatusPanel.this.table.convertRowIndexToModel(r);
                        fsl[c] = FileStatusPanel.this.Model.getFileStatus(r);
                        ++c;
                    }
                    c = 0;
                    while (c < selr.length) {
                        if (fsl[c] != null) {
                            FileStatusPanel.this.Mn.getFileHandler().changePriority(fsl[c].getFile(), 0L);
                        }
                        ++c;
                    }
                }
            }
        });
        JMenuItem re = new JMenuItem("Reset downloads");
        mn.add(re);
        re.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int[] selr = FileStatusPanel.this.table.getSelectedRows();
                if (selr.length > 0) {
                    FileStatus[] fsl = new FileStatus[selr.length];
                    int c = 0;
                    while (c < selr.length) {
                        int r = selr[c];
                        r = FileStatusPanel.this.table.convertRowIndexToModel(r);
                        fsl[c] = FileStatusPanel.this.Model.getFileStatus(r);
                        ++c;
                    }
                    c = 0;
                    while (c < selr.length) {
                        if (fsl[c] != null) {
                            FileStatusPanel.this.Mn.getFileHandler().reDownloadFile(fsl[c]);
                        }
                        ++c;
                    }
                }
            }
        });
        JMenuItem delete = new JMenuItem("Delete Files");
        mn.add(delete);
        delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int v;
                int[] selr = FileStatusPanel.this.table.getSelectedRows();
                if (selr.length > 0 && (v = JOptionPane.showConfirmDialog(FileStatusPanel.this.table, "FILE WILL REALLY BE\n!!DELETED!!\nARE YOU SURE?", "DELETE", 0, 2)) == 0) {
                    FileStatus[] fsl = new FileStatus[selr.length];
                    int c = 0;
                    while (c < selr.length) {
                        int r = selr[c];
                        r = FileStatusPanel.this.table.convertRowIndexToModel(r);
                        fsl[c] = FileStatusPanel.this.Model.getFileStatus(r);
                        ++c;
                    }
                    c = 0;
                    while (c < fsl.length) {
                        if (fsl[c] != null) {
                            FileStatusPanel.this.Model.removeFile(fsl[c].getFile());
                        }
                        ++c;
                    }
                }
            }
        });
        this.table.setComponentPopupMenu(mn);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (!FileStatusPanel.this.table.getSelectionModel().isSelectionEmpty()) {
                    ProgramManager.Program prog;
                    File f;
                    int r = FileStatusPanel.this.table.getSelectedRow();
                    r = FileStatusPanel.this.table.convertRowIndexToModel(r);
                    FileStatus fs = FileStatusPanel.this.Model.getFileStatus(r);
                    boolean setup = false;
                    if (fs != null && (f = fs.getFile()) != null && f.exists() && (prog = FileStatusPanel.this.Manager.findProgramForFile(f.getPath())) != null && FileStatusPanel.this.OpenItem != null) {
                        FileStatusPanel.this.OpenItem.setText("Open file with " + prog.Name);
                        setup = true;
                    }
                    if (!setup) {
                        FileStatusPanel.this.OpenItem.setText("Open");
                    }
                }
            }
        });
    }

    private void openFile(int r) {
        ProgramManager.Program prog;
        FileStatus fs = this.Model.getFileStatus(r = this.table.convertRowIndexToModel(r));
        if (fs != null && fs.getFile() != null && fs.getFile().exists() && (prog = this.Manager.findProgramForFile(fs.getFile().getPath())) != null) {
            new ProgramRunner(prog.Program, fs.getFile().getPath(), this.Mn.getNodeDir().getPath());
        }
    }

    public JLabel getLblDownloadDir() {
        return this.lblDownloadDir;
    }

    public void setManager(ProgramManager manager) {
        this.Manager = manager;
    }
}

