/*
 * Decompiled with CFR 0.152.
 */
package org.ourfilesystem.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConnectionPoolHSQLDB {
    public static int MAXCONS = 3;
    private String DBURL;
    private ConcurrentLinkedQueue<Connection> ConList;
    private long NumCons;

    public ConnectionPoolHSQLDB(String url) {
        this.DBURL = url;
        this.ConList = new ConcurrentLinkedQueue();
        this.NumCons = 0L;
    }

    private synchronized Connection getNewCon() throws SQLException {
        ++this.NumCons;
        return DriverManager.getConnection(this.DBURL, "SA", "");
    }

    public synchronized Connection getCon() throws SQLException {
        Connection con = this.ConList.poll();
        if (con == null) {
            if (this.NumCons >= (long)MAXCONS) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                con = this.ConList.poll();
            } else {
                con = this.getNewCon();
            }
        }
        return con;
    }

    public synchronized void done(Connection c) {
        try {
            c.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ConList.size() > MAXCONS) {
            throw new RuntimeException("This should not happen!");
        }
        this.ConList.add(c);
        this.notifyAll();
    }

    public synchronized void close() {
        Connection c = this.ConList.poll();
        while (c != null) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            c = this.ConList.poll();
        }
        this.notifyAll();
    }
}

